/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.view.CyNetworkView;
import cytoscape.view.CytoscapeDesktop;
import cytoscape.view.cytopanels.CytoPanel;
import cytoscape.view.cytopanels.CytoPanelState;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapInputPanel;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.OverlappingGenesPanel;
import org.baderlab.csplugins.enrichmentmap.ParametersPanel;
import org.baderlab.csplugins.enrichmentmap.PostAnalysisInputPanel;
import org.baderlab.csplugins.enrichmentmap.PostAnalysisParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnrichmentMapManager
implements PropertyChangeListener {
    private static EnrichmentMapManager manager = null;
    private HashMap<String, EnrichmentMapParameters> cyNetworkList = new HashMap();
    private HashMap<String, PostAnalysisParameters> cyNetworkListPostAnalysis = new HashMap();
    private ParametersPanel parameterPanel;
    private OverlappingGenesPanel nodesOverlapPanel;
    private OverlappingGenesPanel edgesOverlapPanel;
    private EnrichmentMapInputPanel inputWindow;
    private PostAnalysisInputPanel analysisWindow;

    public static EnrichmentMapManager getInstance() {
        if (manager == null) {
            manager = new EnrichmentMapManager();
        }
        return manager;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        boolean relevantEventFlag = false;
        if (event.getPropertyName().equals(Cytoscape.NETWORK_DESTROYED)) {
            this.networkDestroyed((String)event.getNewValue());
            relevantEventFlag = true;
        } else if (event.getPropertyName().equals("NETWORK_VIEW_DESTROYED")) {
            relevantEventFlag = true;
        } else if (event.getPropertyName().equals("NETWORK_VIEW_CREATED")) {
            this.networkFocusEvent(event, false);
        } else if (event.getPropertyName().equals("NETWORK_VIEW_FOCUSED")) {
            this.networkFocusEvent(event, false);
        } else if (event.getPropertyName().equals("NETWORK_TITLE_MODIFIED")) {
            CyNetwork cyNetwork = Cytoscape.getCurrentNetwork();
            String networkId = cyNetwork.getIdentifier();
            EnrichmentMapParameters currentNetworkParams = this.cyNetworkList.get(networkId);
            currentNetworkParams.setNetworkName(cyNetwork.getTitle());
        }
        if (relevantEventFlag && !this.networkViewsRemain()) {
            this.onZeroNetworkViewsRemain();
        }
    }

    private EnrichmentMapManager() {
        Cytoscape.getSwingPropertyChangeSupport().addPropertyChangeListener(this);
        Cytoscape.getDesktop().getNetworkViewManager().getSwingPropertyChangeSupport().addPropertyChangeListener(this);
        CytoscapeDesktop desktop = Cytoscape.getDesktop();
        CytoPanel cytoPanel = desktop.getCytoPanel(5);
        CytoPanel cytoSidePanel = desktop.getCytoPanel(3);
        this.parameterPanel = new ParametersPanel();
        cytoSidePanel.add("Parameters", (Component)this.parameterPanel);
        cytoSidePanel.setSelectedIndex(cytoSidePanel.indexOfComponent((Component)this.parameterPanel));
        cytoSidePanel.setState(CytoPanelState.DOCK);
        this.nodesOverlapPanel = new OverlappingGenesPanel(true);
        this.edgesOverlapPanel = new OverlappingGenesPanel(false);
        cytoPanel.add("EM Overlap Expression viewer", (Component)this.edgesOverlapPanel);
        cytoPanel.add("EM Geneset Expression viewer", (Component)this.nodesOverlapPanel);
    }

    public void registerNetwork(CyNetwork cyNetwork, EnrichmentMapParameters params) {
        if (!this.cyNetworkList.containsKey(cyNetwork.getIdentifier())) {
            this.cyNetworkList.put(cyNetwork.getIdentifier(), params);
        }
    }

    public void registerNetwork(CyNetwork cyNetwork, PostAnalysisParameters paParams) {
        if (!this.cyNetworkListPostAnalysis.containsKey(cyNetwork.getIdentifier())) {
            this.cyNetworkListPostAnalysis.put(cyNetwork.getIdentifier(), paParams);
        }
    }

    private void networkFocusEvent(PropertyChangeEvent event, boolean sessionLoaded) {
        String networkId = null;
        CyNetwork cyNetwork = null;
        Object newValue = event.getNewValue();
        CytoscapeDesktop desktop = Cytoscape.getDesktop();
        CytoPanel cytoPanel = desktop.getCytoPanel(5);
        CytoPanel cytoSidePanel = desktop.getCytoPanel(3);
        if (event.getPropertyName().equals(Cytoscape.SESSION_LOADED)) {
            cyNetwork = Cytoscape.getCurrentNetwork();
            networkId = cyNetwork.getIdentifier();
        } else if (newValue instanceof CyNetwork) {
            cyNetwork = (CyNetwork)newValue;
            networkId = cyNetwork.getIdentifier();
        } else if (newValue instanceof String) {
            networkId = (String)newValue;
            cyNetwork = Cytoscape.getNetwork((String)networkId);
        } else if (newValue instanceof CyNetworkView) {
            cyNetwork = ((CyNetworkView)newValue).getNetwork();
            networkId = cyNetwork.getIdentifier();
        }
        if (networkId != null && !sessionLoaded) {
            if (this.cyNetworkList.containsKey(networkId)) {
                this.nodesOverlapPanel.clearPanel();
                this.edgesOverlapPanel.clearPanel();
                EnrichmentMapParameters currentNetworkParams = this.cyNetworkList.get(networkId);
                PostAnalysisParameters currentPaParams = this.cyNetworkListPostAnalysis.get(networkId);
                this.parameterPanel.updatePanel(currentNetworkParams);
                if (this.inputWindow != null) {
                    this.inputWindow.updateContents(currentNetworkParams);
                }
                if (this.analysisWindow != null) {
                    this.analysisWindow.updateContents(currentPaParams);
                }
                this.nodesOverlapPanel.updatePanel(currentNetworkParams);
                this.edgesOverlapPanel.updatePanel(currentNetworkParams);
                this.nodesOverlapPanel.revalidate();
                this.edgesOverlapPanel.revalidate();
            } else if (event.getPropertyName().equals("NETWORK_VIEW_CREATED")) {
                this.nodesOverlapPanel.clearPanel();
                this.edgesOverlapPanel.clearPanel();
                this.nodesOverlapPanel.revalidate();
                this.edgesOverlapPanel.revalidate();
            }
        }
    }

    private void networkDestroyed(String networkId) {
        if (this.cyNetworkList.containsKey(networkId)) {
            EnrichmentMapParameters currentNetworkParams = this.cyNetworkList.get(networkId);
            this.cyNetworkList.remove(networkId);
        }
        if (this.cyNetworkListPostAnalysis.containsKey(networkId)) {
            PostAnalysisParameters currentPaParams = this.cyNetworkListPostAnalysis.get(networkId);
            this.cyNetworkListPostAnalysis.remove(networkId);
        }
    }

    private boolean networkViewsRemain() {
        for (String id : this.cyNetworkList.keySet()) {
            CyNetworkView cyNetworkView = Cytoscape.getNetworkView((String)id);
            if (cyNetworkView == null) continue;
            return true;
        }
        return false;
    }

    protected void onZeroNetworkViewsRemain() {
    }

    public ParametersPanel getParameterPanel() {
        return this.parameterPanel;
    }

    public OverlappingGenesPanel getNodesOverlapPanel() {
        return this.nodesOverlapPanel;
    }

    public OverlappingGenesPanel getEdgesOverlapPanel() {
        return this.edgesOverlapPanel;
    }

    public HashMap<String, EnrichmentMapParameters> getCyNetworkList() {
        return this.cyNetworkList;
    }

    public EnrichmentMapParameters getParameters(String name) {
        if (this.cyNetworkList.containsKey(name)) {
            return this.cyNetworkList.get(name);
        }
        return null;
    }

    public EnrichmentMapInputPanel getInputWindow() {
        return this.inputWindow;
    }

    public void setInputWindow(EnrichmentMapInputPanel inputWindow) {
        this.inputWindow = inputWindow;
    }

    public PostAnalysisInputPanel getAnalysisWindow() {
        return this.analysisWindow;
    }

    public void setAnalysisWindow(PostAnalysisInputPanel analysisWindow) {
        this.analysisWindow = analysisWindow;
    }
}

