/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.layout.CyLayouts;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import cytoscape.view.CyNetworkView;
import cytoscape.view.CytoscapeDesktop;
import cytoscape.view.cytopanels.CytoPanel;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.VisualMappingManager;
import cytoscape.visual.VisualStyle;
import giny.model.Edge;
import giny.model.Node;
import giny.view.GraphViewChangeListener;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapActionListener;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapInputPanel;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapVisualStyle;
import org.baderlab.csplugins.enrichmentmap.EnrichmentResult;
import org.baderlab.csplugins.enrichmentmap.GSEAResult;
import org.baderlab.csplugins.enrichmentmap.GeneSet;
import org.baderlab.csplugins.enrichmentmap.GenericResult;
import org.baderlab.csplugins.enrichmentmap.GenesetSimilarity;
import org.baderlab.csplugins.enrichmentmap.ParametersPanel;

public class VisualizeEnrichmentMapTask
implements Task {
    private EnrichmentMapParameters params;
    private HashMap<String, GenesetSimilarity> geneset_similarities;
    private String mapName;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;

    public VisualizeEnrichmentMapTask(EnrichmentMapParameters params, TaskMonitor taskMonitor) {
        this(params);
        this.taskMonitor = taskMonitor;
    }

    public VisualizeEnrichmentMapTask(EnrichmentMapParameters params) {
        this.params = params;
        this.geneset_similarities = params.getGenesetSimilarity();
        this.mapName = "Enrichment Map";
    }

    public boolean computeMap() {
        if (this.taskMonitor == null) {
            throw new IllegalStateException("Task Monitor is not set");
        }
        try {
            String vs_name;
            String gene;
            CyAttributes nodeAttrs;
            GeneSet gs;
            CyNode node;
            CyNetwork network;
            String prefix;
            Set networks = Cytoscape.getNetworkSet();
            if (networks == null) {
                prefix = "EM1_";
                this.params.setAttributePrefix(prefix);
                this.params.setNetworkName(prefix + this.mapName);
                network = Cytoscape.createNetwork((String)(prefix + this.mapName));
            } else {
                int num_networks = 1;
                int max_prefix = 0;
                EnrichmentMapManager manager = EnrichmentMapManager.getInstance();
                for (CyNetwork current_network : networks) {
                    String networkId = current_network.getIdentifier();
                    if (!manager.isEnrichmentMap(networkId)) continue;
                    ++num_networks;
                    EnrichmentMapParameters tmpParams = manager.getParameters(networkId);
                    String tmpPrefix = tmpParams.getAttributePrefix();
                    tmpPrefix = tmpPrefix.replace("EM", "");
                    int tmpNum = Integer.parseInt(tmpPrefix = tmpPrefix.replace("_", ""));
                    if (tmpNum <= max_prefix) continue;
                    max_prefix = tmpNum;
                }
                prefix = "EM" + (max_prefix + 1) + "_";
                this.params.setAttributePrefix(prefix);
                this.params.setNetworkName(prefix + this.mapName);
                network = Cytoscape.createNetwork((String)(prefix + this.mapName));
            }
            if (this.params.isGSEA()) {
                CyAttributes networkAttributes = Cytoscape.getNetworkAttributes();
                if (this.params.getGseaHtmlReportFileDataset1() != null) {
                    String report1Path = this.params.getGseaHtmlReportFileDataset1();
                    report1Path = report1Path.replaceAll("\\\\", "/");
                    report1Path = report1Path.substring(0, report1Path.lastIndexOf(47));
                    networkAttributes.setAttribute(network.getIdentifier(), EnrichmentMapVisualStyle.NETW_REPORT1_DIR, report1Path);
                }
                if (this.params.getGseaHtmlReportFileDataset2() != null) {
                    String report2Path = this.params.getGseaHtmlReportFileDataset1();
                    report2Path = report2Path.replaceAll("\\\\", "/");
                    report2Path = report2Path.substring(0, report2Path.lastIndexOf(47));
                    networkAttributes.setAttribute(network.getIdentifier(), EnrichmentMapVisualStyle.NETW_REPORT2_DIR, report2Path);
                }
            }
            HashMap<String, EnrichmentResult> enrichmentResults1OfInterest = this.params.getEnrichmentResults1OfInterest();
            HashMap<String, EnrichmentResult> enrichmentResults2OfInterest = this.params.getEnrichmentResults2OfInterest();
            HashMap<String, EnrichmentResult> enrichmentResults1 = this.params.getEnrichmentResults1();
            HashMap<String, EnrichmentResult> enrichmentResults2 = this.params.getEnrichmentResults2();
            HashMap<String, GeneSet> genesetsOfInterest = this.params.getGenesetsOfInterest();
            int currentProgress = 0;
            int maxValue = enrichmentResults1OfInterest.size();
            for (String current_name : enrichmentResults1OfInterest.keySet()) {
                EnrichmentResult current_result;
                node = Cytoscape.getCyNode((String)current_name, (boolean)true);
                network.addNode((Node)node);
                gs = genesetsOfInterest.get(current_name);
                nodeAttrs = Cytoscape.getNodeAttributes();
                nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.GS_DESCR, gs.getDescription());
                if (this.params.getHashkey2gene() != null) {
                    ArrayList<String> gene_list = new ArrayList<String>();
                    HashSet<Integer> genes_hash = gs.getGenes();
                    for (Integer current : genes_hash) {
                        gene = this.params.getGeneFromHashKey(current);
                        if (gene_list == null) continue;
                        gene_list.add(gene);
                    }
                    nodeAttrs.setListAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.GENES, gene_list);
                }
                if (this.params.isGSEA()) {
                    current_result = (GSEAResult)enrichmentResults1OfInterest.get(current_name);
                    this.setGSEAResultDataset1Attributes((Node)node, (GSEAResult)current_result, prefix);
                } else {
                    current_result = (GenericResult)enrichmentResults1OfInterest.get(current_name);
                    this.setGenericResultDataset1Attributes((Node)node, (GenericResult)current_result, prefix);
                }
                if (this.params.isTwoDatasets()) {
                    EnrichmentResult second_result;
                    if (this.params.isGSEA()) {
                        if (enrichmentResults2.containsKey(current_name)) {
                            second_result = (GSEAResult)enrichmentResults2.get(current_name);
                            this.setGSEAResultDataset2Attributes((Node)node, (GSEAResult)second_result, prefix);
                        }
                    } else if (enrichmentResults2.containsKey(current_name)) {
                        second_result = (GenericResult)enrichmentResults2.get(current_name);
                        this.setGenericResultDataset2Attributes((Node)node, (GenericResult)second_result, prefix);
                    }
                }
                int percentComplete = (int)((double)currentProgress / (double)maxValue * 100.0);
                long timeRemaining = maxValue - currentProgress;
                if (this.taskMonitor != null) {
                    this.taskMonitor.setPercentCompleted(percentComplete);
                    this.taskMonitor.setStatus("Building Enrichment Map " + currentProgress + " of " + maxValue);
                    this.taskMonitor.setEstimatedTimeRemaining(timeRemaining);
                }
                ++currentProgress;
            }
            if (this.params.isTwoDatasets()) {
                for (String current_name : enrichmentResults2OfInterest.keySet()) {
                    EnrichmentResult second_result;
                    EnrichmentResult result;
                    if (enrichmentResults1OfInterest.containsKey(current_name)) continue;
                    node = Cytoscape.getCyNode((String)current_name, (boolean)true);
                    network.addNode((Node)node);
                    gs = genesetsOfInterest.get(current_name);
                    nodeAttrs = Cytoscape.getNodeAttributes();
                    nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.GS_DESCR, gs.getDescription());
                    if (this.params.getHashkey2gene() != null) {
                        ArrayList<String> gene_list = new ArrayList<String>();
                        HashSet<Integer> genes_hash = gs.getGenes();
                        for (Integer current : genes_hash) {
                            gene = this.params.getGeneFromHashKey(current);
                            if (gene_list == null) continue;
                            gene_list.add(gene);
                        }
                        nodeAttrs.setListAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.GENES, gene_list);
                    }
                    if (this.params.isGSEA()) {
                        if (enrichmentResults1.containsKey(current_name)) {
                            result = (GSEAResult)enrichmentResults1.get(current_name);
                            this.setGSEAResultDataset1Attributes((Node)node, (GSEAResult)result, prefix);
                        }
                        second_result = (GSEAResult)enrichmentResults2OfInterest.get(current_name);
                        this.setGSEAResultDataset2Attributes((Node)node, (GSEAResult)second_result, prefix);
                        continue;
                    }
                    if (enrichmentResults1.containsKey(current_name)) {
                        result = (GenericResult)enrichmentResults1.get(current_name);
                        this.setGenericResultDataset1Attributes((Node)node, (GenericResult)result, prefix);
                    }
                    second_result = (GenericResult)enrichmentResults2OfInterest.get(current_name);
                    this.setGenericResultDataset2Attributes((Node)node, (GenericResult)second_result, prefix);
                }
            }
            boolean k = false;
            Iterator<String> j = this.geneset_similarities.keySet().iterator();
            while (j.hasNext()) {
                String current_name = j.next().toString();
                GenesetSimilarity current_result = this.geneset_similarities.get(current_name);
                if (!(current_result.getSimilarity_coeffecient() > this.params.getSimilarityCutOff())) continue;
                CyNode node1 = Cytoscape.getCyNode((String)current_result.getGeneset1_Name(), (boolean)false);
                CyNode node2 = Cytoscape.getCyNode((String)current_result.getGeneset2_Name(), (boolean)false);
                CyEdge edge = Cytoscape.getCyEdge((Node)node1, (Node)node2, (String)"interaction", (Object)"Geneset_Overlap", (boolean)true);
                network.addEdge((Edge)edge);
                CyAttributes edgeAttrs = Cytoscape.getEdgeAttributes();
                edgeAttrs.setAttribute(edge.getIdentifier(), prefix + EnrichmentMapVisualStyle.SIMILARITY_COEFFECIENT, Double.valueOf(current_result.getSimilarity_coeffecient()));
                edgeAttrs.setAttribute(edge.getIdentifier(), prefix + EnrichmentMapVisualStyle.OVERLAP_SIZE, Integer.valueOf(current_result.getSizeOfOverlap()));
                if (this.params.getHashkey2gene() == null) continue;
                ArrayList<String> gene_list = new ArrayList<String>();
                HashSet<Integer> genes_hash = current_result.getOverlapping_genes();
                for (Integer current : genes_hash) {
                    String gene2 = this.params.getGeneFromHashKey(current);
                    if (gene_list == null) continue;
                    gene_list.add(gene2);
                }
                edgeAttrs.setListAttribute(edge.getIdentifier(), prefix + EnrichmentMapVisualStyle.OVERLAP_GENES, gene_list);
            }
            CyNetworkView view = Cytoscape.createNetworkView((CyNetwork)network);
            VisualMappingManager manager = Cytoscape.getVisualMappingManager();
            CalculatorCatalog catalog = manager.getCalculatorCatalog();
            VisualStyle vs = catalog.getVisualStyle(vs_name = prefix + "Enrichment_map_style");
            if (vs == null) {
                EnrichmentMapVisualStyle em_vs = new EnrichmentMapVisualStyle(vs_name, this.params);
                vs = em_vs.createVisualStyle(network, prefix);
                catalog.addVisualStyle(vs);
            }
            view.setVisualStyle(vs.getName());
            manager.setVisualStyle(vs);
            view.redrawGraph(true, true);
            view.applyLayout(CyLayouts.getLayout((String)"force-directed"));
            EnrichmentMapManager EMmanager = EnrichmentMapManager.getInstance();
            EMmanager.registerNetwork(network, this.params);
            ParametersPanel parametersPanel = EMmanager.getParameterPanel();
            parametersPanel.updatePanel(this.params);
            CytoscapeDesktop desktop = Cytoscape.getDesktop();
            CytoPanel cytoSidePanel = desktop.getCytoPanel(3);
            cytoSidePanel.setSelectedIndex(cytoSidePanel.indexOfComponent((Component)parametersPanel));
            EnrichmentMapInputPanel emInputPanel = EMmanager.getInputWindow();
            CytoPanel cytoControlPanel = desktop.getCytoPanel(7);
            cytoControlPanel.setSelectedIndex(cytoControlPanel.indexOfComponent((Component)emInputPanel));
            view.addGraphViewChangeListener((GraphViewChangeListener)new EnrichmentMapActionListener(this.params));
            Cytoscape.firePropertyChange((String)"NETWORK_VIEW_CREATED", (Object)network, (Object)view);
        }
        catch (IllegalThreadStateException e) {
            this.taskMonitor.setException((Throwable)e, "Unable to compute similarity coeffecients");
            return false;
        }
        return true;
    }

    private void setGenericResultDataset1Attributes(Node node, GenericResult result, String prefix) {
        CyAttributes nodeAttrs = Cytoscape.getNodeAttributes();
        String formattedName = VisualizeEnrichmentMapTask.formatLabel(result.getName());
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.FORMATTED_NAME, formattedName);
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.NAME, result.getName());
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.PVALUE_DATASET1, Double.valueOf(result.getPvalue()));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.FDR_QVALUE_DATASET1, Double.valueOf(result.getFdrqvalue()));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.GS_SIZE_DATASET1, Integer.valueOf(result.getGsSize()));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.GS_TYPE, EnrichmentMapVisualStyle.GS_TYPE_ENRICHMENT);
        if (result.getNES() >= 0.0) {
            nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.COLOURING_DATASET1, Double.valueOf(1.0 - result.getPvalue()));
        } else {
            nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.COLOURING_DATASET1, Double.valueOf(-1.0 * (1.0 - result.getPvalue())));
        }
    }

    private void setGenericResultDataset2Attributes(Node node, GenericResult result, String prefix) {
        CyAttributes nodeAttrs = Cytoscape.getNodeAttributes();
        String formattedName = VisualizeEnrichmentMapTask.formatLabel(result.getName());
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.FORMATTED_NAME, formattedName);
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.NAME, result.getName());
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.PVALUE_DATASET2, Double.valueOf(result.getPvalue()));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.FDR_QVALUE_DATASET2, Double.valueOf(result.getFdrqvalue()));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.GS_SIZE_DATASET2, Integer.valueOf(result.getGsSize()));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.GS_TYPE, EnrichmentMapVisualStyle.GS_TYPE_ENRICHMENT);
        if (result.getNES() >= 0.0) {
            nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.COLOURING_DATASET2, Double.valueOf(1.0 - result.getPvalue()));
        } else {
            nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.COLOURING_DATASET2, Double.valueOf(-1.0 * (1.0 - result.getPvalue())));
        }
    }

    private void setGSEAResultDataset1Attributes(Node node, GSEAResult result, String prefix) {
        CyAttributes nodeAttrs = Cytoscape.getNodeAttributes();
        String formattedName = VisualizeEnrichmentMapTask.formatLabel(result.getName());
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.FORMATTED_NAME, formattedName);
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.NAME, result.getName());
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.PVALUE_DATASET1, Double.valueOf(result.getPvalue()));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.FDR_QVALUE_DATASET1, Double.valueOf(result.getFdrqvalue()));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.FWER_QVALUE_DATASET1, Double.valueOf(result.getFwerqvalue()));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.GS_SIZE_DATASET1, Integer.valueOf(result.getGsSize()));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.ES_DATASET1, Double.valueOf(result.getES()));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.NES_DATASET1, Double.valueOf(result.getNES()));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.GS_TYPE, EnrichmentMapVisualStyle.GS_TYPE_ENRICHMENT);
        if (result.getNES() >= 0.0) {
            nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.COLOURING_DATASET1, Double.valueOf(1.0 - result.getPvalue()));
        } else {
            nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.COLOURING_DATASET1, Double.valueOf(-1.0 * (1.0 - result.getPvalue())));
        }
    }

    private void setGSEAResultDataset2Attributes(Node node, GSEAResult result, String prefix) {
        CyAttributes nodeAttrs = Cytoscape.getNodeAttributes();
        String formattedName = VisualizeEnrichmentMapTask.formatLabel(result.getName());
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.FORMATTED_NAME, formattedName);
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.NAME, result.getName());
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.PVALUE_DATASET2, Double.valueOf(result.getPvalue()));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.FDR_QVALUE_DATASET2, Double.valueOf(result.getFdrqvalue()));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.FWER_QVALUE_DATASET2, Double.valueOf(result.getFwerqvalue()));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.GS_SIZE_DATASET2, Integer.valueOf(result.getGsSize()));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.ES_DATASET2, Double.valueOf(result.getES()));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.NES_DATASET2, Double.valueOf(result.getNES()));
        nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.GS_TYPE, EnrichmentMapVisualStyle.GS_TYPE_ENRICHMENT);
        if (result.getNES() >= 0.0) {
            nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.COLOURING_DATASET2, Double.valueOf(1.0 - result.getPvalue()));
        } else {
            nodeAttrs.setAttribute(node.getIdentifier(), prefix + EnrichmentMapVisualStyle.COLOURING_DATASET2, Double.valueOf(-1.0 * (1.0 - result.getPvalue())));
        }
    }

    static String formatLabel(String label) {
        String formattedLabel;
        block7: {
            String[] tokens;
            int k;
            int i;
            block8: {
                block6: {
                    formattedLabel = "";
                    i = 0;
                    k = 1;
                    tokens = label.split(" ");
                    if (tokens.length <= 1) break block6;
                    int current_count = 0;
                    for (int j = 0; j < tokens.length; ++j) {
                        if (current_count + tokens[j].length() <= 15) {
                            formattedLabel = formattedLabel + tokens[j] + " ";
                            current_count += tokens[j].length();
                            continue;
                        }
                        if (current_count + tokens[j].length() <= 15) continue;
                        formattedLabel = formattedLabel + "\n" + tokens[j] + " ";
                        current_count = tokens[j].length();
                    }
                    break block7;
                }
                tokens = label.split("_");
                if (tokens.length <= 1) break block8;
                int current_count = 0;
                for (int j = 0; j < tokens.length; ++j) {
                    if (j != 0) {
                        formattedLabel = formattedLabel + "_";
                    }
                    if (current_count + tokens[j].length() <= 15) {
                        formattedLabel = formattedLabel + tokens[j];
                        current_count += tokens[j].length();
                        continue;
                    }
                    if (current_count + tokens[j].length() <= 15) continue;
                    formattedLabel = formattedLabel + "\n" + tokens[j];
                    current_count = tokens[j].length();
                }
                break block7;
            }
            if (tokens.length != 1) break block7;
            while (i <= label.length()) {
                formattedLabel = i + 15 > label.length() ? formattedLabel + label.substring(i, label.length()) + "\n" : formattedLabel + label.substring(i, k * 15) + "\n";
                i = k * 15;
                ++k;
            }
        }
        return formattedLabel;
    }

    public void run() {
        this.computeMap();
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Building Enrichment Map");
    }
}

