/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.util.FileUtil;
import giny.model.Edge;
import giny.model.Node;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.baderlab.csplugins.brainlib.AvgLinkHierarchicalClustering;
import org.baderlab.csplugins.brainlib.DistanceMatrix;
import org.baderlab.csplugins.enrichmentmap.CellHighlightRenderer;
import org.baderlab.csplugins.enrichmentmap.ColorRenderer;
import org.baderlab.csplugins.enrichmentmap.ColumnHeaderVerticalRenderer;
import org.baderlab.csplugins.enrichmentmap.CosineDistance;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapVisualStyle;
import org.baderlab.csplugins.enrichmentmap.EnrichmentResult;
import org.baderlab.csplugins.enrichmentmap.EnrichmentResultFileReaderTask;
import org.baderlab.csplugins.enrichmentmap.EuclideanDistance;
import org.baderlab.csplugins.enrichmentmap.GSEAResult;
import org.baderlab.csplugins.enrichmentmap.GeneExpression;
import org.baderlab.csplugins.enrichmentmap.GeneExpressionMatrix;
import org.baderlab.csplugins.enrichmentmap.GeneSet;
import org.baderlab.csplugins.enrichmentmap.GenesetSimilarity;
import org.baderlab.csplugins.enrichmentmap.HeatMapParameters;
import org.baderlab.csplugins.enrichmentmap.HeatMapTableActionListener;
import org.baderlab.csplugins.enrichmentmap.HeatMapTableModel;
import org.baderlab.csplugins.enrichmentmap.PearsonCorrelation;
import org.baderlab.csplugins.enrichmentmap.Ranking;
import org.baderlab.csplugins.enrichmentmap.RowNumberTable;
import org.baderlab.csplugins.enrichmentmap.SignificantGene;
import org.baderlab.csplugins.enrichmentmap.TableHeader;
import org.baderlab.csplugins.enrichmentmap.TableSort;
import org.mskcc.colorgradient.ColorGradientMapper;
import org.mskcc.colorgradient.ColorGradientRange;
import org.mskcc.colorgradient.ColorGradientTheme;
import org.mskcc.colorgradient.ColorGradientWidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeatMapPanel
extends JPanel {
    private static final long serialVersionUID = 1903063204304411983L;
    private Object[] columnNames;
    private Object[] columnNames2;
    private String[] phenotypes;
    private String[] phenotypes2;
    private Object[][] expValue;
    private int numConditions = 0;
    private int numConditions2 = 0;
    private String[] hRow1;
    private String[] hRow2;
    private String[] rowGeneName;
    private int[] rowLength;
    private ColorGradientTheme[] rowTheme;
    private ColorGradientRange[] rowRange;
    private int[] halfRow1Length;
    private int[] halfRow2Length;
    private ColorGradientTheme[] themeHalfRow1;
    private ColorGradientTheme[] themeHalfRow2;
    private ColorGradientRange[] rangeHalfRow1;
    private ColorGradientRange[] rangeHalfRow2;
    private final Insets insets = new Insets(0, 0, 0, 0);
    private HashMap<Integer, GeneExpression> currentExpressionSet;
    private HashMap<Integer, GeneExpression> currentExpressionSet2;
    private boolean node = true;
    private String Dataset1phenotype1;
    private String Dataset1phenotype2;
    private String Dataset2phenotype1;
    private String Dataset2phenotype2;
    private HeatMapParameters hmParams;
    private EnrichmentMapParameters params;
    private JPopupMenu rightClickPopupMenu;
    private Map<String, Map<String, String>> linkoutProps;
    private boolean displayLeadingEdge = false;
    private double leadingEdgeScoreAtMax1 = 0.0;
    private double leadingEdgeScoreAtMax2 = 0.0;
    private int leadingEdgeRankAtMax1 = 0;
    private int leadingEdgeRankAtMax2 = 0;

    public HeatMapPanel(boolean node) {
        this.node = node;
        this.setLayout(new BorderLayout());
        this.initialize_linkouts();
        this.rightClickPopupMenu = new JPopupMenu();
    }

    public void resetVariables(EnrichmentMapParameters params) {
        this.params = params;
        if (params.isData() || params.isData2()) {
            GeneExpressionMatrix expression = params.getExpression();
            this.numConditions = expression.getNumConditions();
            this.columnNames = expression.getColumnNames();
            this.phenotypes = expression.getPhenotypes();
            this.Dataset1phenotype1 = params.getDataset1Phenotype1();
            this.Dataset1phenotype2 = params.getDataset1Phenotype2();
            this.hmParams = params.getHmParams();
            boolean[] ascending = new boolean[this.columnNames.length + params.getRanks().size()];
            for (int k = ascending.length; k > ascending.length - params.getRanks().size(); --k) {
                ascending[k - 1] = true;
            }
            this.hmParams.setAscending(ascending);
            this.displayLeadingEdge = false;
            this.leadingEdgeScoreAtMax1 = 0.0;
            this.leadingEdgeScoreAtMax2 = 0.0;
            this.leadingEdgeRankAtMax1 = 0;
            this.leadingEdgeRankAtMax2 = 0;
            if (this.node) {
                this.setNodeExpressionSet(params);
            } else {
                this.setEdgeExpressionSet(params);
            }
            if (params.isData2()) {
                GeneExpressionMatrix expression2 = params.getExpression2();
                this.numConditions2 = expression2.getNumConditions();
                this.columnNames2 = expression2.getColumnNames();
                boolean[] ascending2 = new boolean[this.columnNames.length + (this.columnNames2.length - 2) + params.getRanks().size()];
                for (int k = ascending2.length; k > ascending2.length - params.getRanks().size(); --k) {
                    ascending2[k - 1] = true;
                }
                this.hmParams.setAscending(ascending2);
                this.phenotypes2 = expression2.getPhenotypes();
                this.Dataset2phenotype1 = params.getDataset2Phenotype1();
                this.Dataset2phenotype2 = params.getDataset2Phenotype2();
            }
        }
    }

    public void updatePanel(EnrichmentMapParameters params) {
        this.resetVariables(params);
        this.updatePanel();
    }

    public void updatePanel() {
        if (this.currentExpressionSet != null) {
            int i;
            HeatMapTableModel OGT;
            Object[][] data;
            Object[] mergedcolumnNames = null;
            JPanel mainPanel = new JPanel();
            mainPanel.setLayout(new BorderLayout());
            if (this.params.isData2()) {
                this.expValue = this.createSortedMergedTableData();
                data = this.createSortedMergedTableData(this.getExpValue());
                mergedcolumnNames = new String[this.columnNames.length + this.columnNames2.length - 2];
                System.arraycopy(this.columnNames, 0, mergedcolumnNames, 0, this.columnNames.length);
                System.arraycopy(this.columnNames2, 2, mergedcolumnNames, this.columnNames.length, this.columnNames2.length - 2);
                OGT = new HeatMapTableModel(mergedcolumnNames, data, this.expValue);
            } else {
                this.expValue = this.createSortedTableData();
                data = this.createSortedTableData(this.getExpValue());
                OGT = new HeatMapTableModel(this.columnNames, data, this.expValue);
            }
            CellHighlightRenderer highlightCellRenderer = new CellHighlightRenderer();
            TableSort sort = new TableSort(OGT);
            JTable jTable1 = new JTable(sort);
            jTable1.addMouseListener(new HeatMapTableActionListener(jTable1, OGT, this.rightClickPopupMenu, this.linkoutProps));
            TableHeader header = new TableHeader(sort, jTable1, this.hmParams);
            JTableHeader tableHdr = jTable1.getTableHeader();
            tableHdr.addMouseListener(header);
            if (this.hmParams.getSort() == HeatMapParameters.Sort.COLUMN) {
                boolean ascending = this.hmParams.isAscending(this.hmParams.getSortIndex());
                if (this.hmParams.getSortIndex() >= this.columnNames.length) {
                    this.hmParams.setSortbycolumnName((String)this.columnNames2[this.hmParams.getSortIndex() - this.columnNames.length + 2]);
                } else {
                    this.hmParams.setSortbycolumnName((String)this.columnNames[this.hmParams.getSortIndex()]);
                }
                header.sortByColumn(this.hmParams.getSortIndex(), ascending);
            }
            jTable1.setDefaultRenderer(Color.class, new ColorRenderer());
            jTable1.setDefaultRenderer(String.class, highlightCellRenderer);
            jTable1.setDefaultRenderer(SignificantGene.class, highlightCellRenderer);
            TableColumnModel tcModel = jTable1.getColumnModel();
            jTable1.setDragEnabled(false);
            jTable1.setCellSelectionEnabled(true);
            ColumnHeaderVerticalRenderer pheno1_renderer = new ColumnHeaderVerticalRenderer();
            pheno1_renderer.setBackground(EnrichmentMapVisualStyle.lightest_phenotype1);
            ColumnHeaderVerticalRenderer pheno2_renderer = new ColumnHeaderVerticalRenderer();
            pheno2_renderer.setBackground(EnrichmentMapVisualStyle.lightest_phenotype2);
            ColumnHeaderVerticalRenderer default_renderer = new ColumnHeaderVerticalRenderer();
            default_renderer.setBackground(Color.white);
            if (this.params.isData2()) {
                for (i = 0; i < this.columnNames.length; ++i) {
                    if (i == 0 || this.columnNames[i].equals("Name")) {
                        tcModel.getColumn(i).setPreferredWidth(50);
                        continue;
                    }
                    if (i == 1 || this.columnNames[i].equals("Description")) {
                        tcModel.getColumn(i).setPreferredWidth(50);
                        continue;
                    }
                    tcModel.getColumn(i).setPreferredWidth(10);
                    if (this.phenotypes != null) {
                        if (this.phenotypes[i - 2].equalsIgnoreCase(this.Dataset1phenotype1)) {
                            tcModel.getColumn(i).setHeaderRenderer(pheno1_renderer);
                            continue;
                        }
                        if (this.phenotypes[i - 2].equalsIgnoreCase(this.Dataset1phenotype2)) {
                            tcModel.getColumn(i).setHeaderRenderer(pheno2_renderer);
                            continue;
                        }
                        tcModel.getColumn(i).setHeaderRenderer(default_renderer);
                        continue;
                    }
                    tcModel.getColumn(i).setHeaderRenderer(default_renderer);
                }
                for (i = this.columnNames.length; i < this.columnNames.length + this.columnNames2.length - 2; ++i) {
                    tcModel.getColumn(i).setPreferredWidth(10);
                    if (this.phenotypes2 != null) {
                        if (this.phenotypes2[i - this.columnNames.length].equalsIgnoreCase(this.Dataset2phenotype1)) {
                            tcModel.getColumn(i).setHeaderRenderer(pheno1_renderer);
                            continue;
                        }
                        if (this.phenotypes2[i - this.columnNames.length].equalsIgnoreCase(this.Dataset2phenotype2)) {
                            tcModel.getColumn(i).setHeaderRenderer(pheno2_renderer);
                            continue;
                        }
                        tcModel.getColumn(i).setHeaderRenderer(default_renderer);
                        continue;
                    }
                    tcModel.getColumn(i).setHeaderRenderer(default_renderer);
                }
            } else {
                for (i = 0; i < this.columnNames.length; ++i) {
                    if (i == 0 || this.columnNames[i].equals("Name")) {
                        tcModel.getColumn(i).setPreferredWidth(50);
                        continue;
                    }
                    if (i == 1 || this.columnNames[i].equals("Description")) {
                        tcModel.getColumn(i).setPreferredWidth(50);
                        continue;
                    }
                    tcModel.getColumn(i).setPreferredWidth(10);
                    if (this.phenotypes != null) {
                        if (this.phenotypes[i - 2].equalsIgnoreCase(this.Dataset1phenotype1)) {
                            tcModel.getColumn(i).setHeaderRenderer(pheno1_renderer);
                            continue;
                        }
                        if (this.phenotypes[i - 2].equalsIgnoreCase(this.Dataset1phenotype2)) {
                            tcModel.getColumn(i).setHeaderRenderer(pheno2_renderer);
                            continue;
                        }
                        tcModel.getColumn(i).setHeaderRenderer(default_renderer);
                        continue;
                    }
                    tcModel.getColumn(i).setHeaderRenderer(default_renderer);
                }
            }
            jTable1.setColumnModel(tcModel);
            JScrollPane jScrollPane = new JScrollPane(jTable1);
            RowNumberTable rowTable = new RowNumberTable(jTable1);
            jScrollPane.setRowHeaderView(rowTable);
            if (this.columnNames.length > 20) {
                jTable1.setAutoResizeMode(0);
            }
            mainPanel.add(jScrollPane);
            mainPanel.revalidate();
            this.add((Component)this.createNorthPanel(), "North");
            this.add((Component)jScrollPane, "Center");
        }
        this.revalidate();
    }

    private Object[][] createSortedTableData(Object[][] expValue2) {
        this.expValue = expValue2;
        int[] HRow = this.getRowLength();
        ColorGradientTheme[] RowCRT = this.getRowTheme();
        ColorGradientRange[] RowCRR = this.getRowRange();
        String[] RowGene = this.getRowGeneName();
        int kValue = this.currentExpressionSet.size();
        Object[][] data = new Object[this.currentExpressionSet.size()][this.numConditions];
        for (int k = 0; k < kValue; ++k) {
            data[k][0] = this.expValue[k][0];
            data[k][1] = this.expValue[k][1];
            for (int j = 0; j < HRow[k]; ++j) {
                data[k][j + 2] = ColorGradientMapper.getColorGradient(RowCRT[k], RowCRR[k], RowGene[k], (Double)this.expValue[k][j + 2]);
            }
        }
        return data;
    }

    private Object[][] createSortedMergedTableData(Object[][] expValue) {
        this.expValue = expValue;
        int[] HRow1 = this.getHalfRow1Length();
        int[] HRow2 = this.getHalfRow2Length();
        ColorGradientTheme[] Row1CRT = this.getThemeHalfRow1();
        ColorGradientTheme[] Row2CRT = this.getThemeHalfRow2();
        ColorGradientRange[] Row1CRR = this.getRangeHalfRow1();
        ColorGradientRange[] Row2CRR = this.getRangeHalfRow2();
        String[] Row1gene = this.gethRow1();
        String[] Row2gene = this.gethRow2();
        int kValue = Math.max(this.currentExpressionSet.size(), this.currentExpressionSet2.size());
        int totalConditions = this.numConditions + this.numConditions2 - 2;
        Object[][] data = new Object[Math.max(this.currentExpressionSet.size(), this.currentExpressionSet2.size())][totalConditions];
        for (int k = 0; k < kValue; ++k) {
            int j;
            data[k][0] = expValue[k][0];
            data[k][1] = expValue[k][1];
            for (j = 0; j < HRow1[k]; ++j) {
                data[k][j + 2] = ColorGradientMapper.getColorGradient(Row1CRT[k], Row1CRR[k], Row1gene[k], (Double)expValue[k][j + 2]);
            }
            for (j = HRow1[k]; j < HRow2[k]; ++j) {
                data[k][j + 2] = ColorGradientMapper.getColorGradient(Row2CRT[k], Row2CRR[k], Row2gene[k], (Double)expValue[k][j + 2]);
            }
        }
        return data;
    }

    private Object[][] createSortedTableData() {
        this.expValue = new Object[this.currentExpressionSet.size()][this.numConditions];
        this.rowLength = new int[this.currentExpressionSet.size()];
        this.rowTheme = new ColorGradientTheme[this.currentExpressionSet.size()];
        this.rowGeneName = new String[this.currentExpressionSet.size()];
        this.rowRange = new ColorGradientRange[this.currentExpressionSet.size()];
        Object[] ranks_subset = new Integer[this.currentExpressionSet.size()];
        HashMap rank2keys = new HashMap();
        HashMap<Integer, Ranking> ranks = this.getRanks();
        int topRank = -1;
        boolean isNegative = false;
        if (this.displayLeadingEdge && this.params.haveRanks() && (this.hmParams.getSort() == HeatMapParameters.Sort.RANK || this.params.getDefaultSortMethod().equalsIgnoreCase(this.hmParams.getSort().toString()))) {
            topRank = this.getTopRank();
            if (this.hmParams.getRankFileIndex().equalsIgnoreCase("Dataset 1 Ranking")) {
                isNegative = this.isNegativeGS(1);
            } else if (this.hmParams.getRankFileIndex().equalsIgnoreCase("Dataset 2 Ranking")) {
                isNegative = this.isNegativeGS(2);
            }
        }
        int n = 0;
        for (Integer key : this.currentExpressionSet.keySet()) {
            ranks_subset[n] = ranks.containsKey(key) ? ranks.get(key).getRank() : Integer.valueOf(-1);
            if (!rank2keys.containsKey(ranks_subset[n])) {
                ArrayList<Integer> temp = new ArrayList<Integer>();
                temp.add(key);
                rank2keys.put(ranks_subset[n], temp);
            } else {
                ((ArrayList)rank2keys.get(ranks_subset[n])).add(key);
            }
            ++n;
        }
        boolean ascending = this.hmParams.isAscending(this.hmParams.getSortIndex());
        if (ascending && isNegative && this.displayLeadingEdge) {
            this.hmParams.changeAscendingValue(this.hmParams.getSortIndex());
            ascending = false;
        } else if (!ascending && !isNegative && this.displayLeadingEdge) {
            this.hmParams.changeAscendingValue(this.hmParams.getSortIndex());
            ascending = true;
        }
        if (ascending) {
            Arrays.sort(ranks_subset);
        } else {
            Arrays.sort(ranks_subset, Collections.reverseOrder());
        }
        int k = 0;
        int previous = -1;
        boolean significant_gene = false;
        for (int m = 0; m < ranks_subset.length; ++m) {
            if ((Integer)ranks_subset[m] == -1 || (Integer)ranks_subset[m] == previous) continue;
            previous = (Integer)ranks_subset[m];
            significant_gene = false;
            if ((Integer)ranks_subset[m] <= topRank && !isNegative && topRank != 0 && topRank != -1) {
                significant_gene = true;
            } else if ((Integer)ranks_subset[m] >= topRank && isNegative && topRank != 0 && topRank != -1) {
                significant_gene = true;
            }
            ArrayList keys = (ArrayList)rank2keys.get(ranks_subset[m]);
            for (Integer key : keys) {
                GeneExpression row = this.currentExpressionSet.get(key);
                Double[] expression_values = this.getExpression(row);
                try {
                    this.expValue[k][0] = significant_gene ? new SignificantGene(Integer.parseInt(row.getName())) : Integer.valueOf(Integer.parseInt(row.getName()));
                }
                catch (NumberFormatException v) {
                    this.expValue[k][0] = significant_gene ? new SignificantGene(row.getName()) : row.getName();
                }
                this.expValue[k][1] = row.getDescription();
                this.rowLength[k] = row.getExpression().length;
                this.rowTheme[k] = this.hmParams.getTheme();
                this.rowRange[k] = this.hmParams.getRange();
                this.rowGeneName[k] = row.getName();
                for (int j = 0; j < row.getExpression().length; ++j) {
                    this.expValue[k][j + 2] = expression_values[j];
                }
                ++k;
            }
        }
        this.setRowTheme(this.rowTheme);
        this.setRowGeneName(this.rowGeneName);
        this.setRowRange(this.rowRange);
        this.setExpValue(this.expValue);
        return this.expValue;
    }

    private Object[][] createSortedMergedTableData() {
        int totalConditions = this.numConditions + this.numConditions2 - 2;
        int kValue = Math.max(this.currentExpressionSet.size(), this.currentExpressionSet2.size());
        this.expValue = new Object[Math.max(this.currentExpressionSet.size(), this.currentExpressionSet2.size())][totalConditions];
        this.hRow1 = new String[kValue];
        this.hRow2 = new String[kValue];
        this.halfRow1Length = new int[kValue];
        this.halfRow2Length = new int[kValue];
        this.rangeHalfRow1 = new ColorGradientRange[kValue];
        this.rangeHalfRow2 = new ColorGradientRange[kValue];
        this.themeHalfRow1 = new ColorGradientTheme[kValue];
        this.themeHalfRow2 = new ColorGradientTheme[kValue];
        Object[] ranks_subset = new Integer[this.currentExpressionSet.size()];
        HashMap rank2keys = new HashMap();
        HashMap<Integer, Ranking> ranks = this.getRanks();
        int topRank = this.getTopRank();
        boolean isNegative = false;
        if (this.hmParams.getRankFileIndex().equalsIgnoreCase("Dataset 1 Ranking")) {
            isNegative = this.isNegativeGS(1);
        } else if (this.hmParams.getRankFileIndex().equalsIgnoreCase("Dataset 2 Ranking")) {
            isNegative = this.isNegativeGS(2);
        }
        int n = 0;
        for (Integer key : this.currentExpressionSet.keySet()) {
            ranks_subset[n] = ranks.containsKey(key) ? ranks.get(key).getRank() : Integer.valueOf(-1);
            if (!rank2keys.containsKey(ranks_subset[n])) {
                ArrayList<Integer> temp = new ArrayList<Integer>();
                temp.add(key);
                rank2keys.put(ranks_subset[n], temp);
            } else {
                ((ArrayList)rank2keys.get(ranks_subset[n])).add(key);
            }
            ++n;
        }
        boolean ascending = this.hmParams.isAscending(this.hmParams.getSortIndex());
        if (ascending) {
            Arrays.sort(ranks_subset);
        } else {
            Arrays.sort(ranks_subset, Collections.reverseOrder());
        }
        int k = 0;
        int previous = -1;
        boolean significant_gene = false;
        for (int m = 0; m < ranks_subset.length; ++m) {
            if ((Integer)ranks_subset[m] == -1 || (Integer)ranks_subset[m] == previous) continue;
            previous = (Integer)ranks_subset[m];
            significant_gene = false;
            if ((Integer)ranks_subset[m] <= topRank && !isNegative && topRank != 0 && topRank != -1) {
                significant_gene = true;
            } else if ((Integer)ranks_subset[m] >= topRank && isNegative && topRank != 0 && topRank != -1) {
                significant_gene = true;
            }
            ArrayList keys = (ArrayList)rank2keys.get(ranks_subset[m]);
            for (Integer currentKey : keys) {
                int j;
                GeneExpression halfRow1 = this.currentExpressionSet.get(currentKey);
                GeneExpression halfRow2 = this.currentExpressionSet2.get(currentKey);
                Double[] expression_values1 = this.getExpression(halfRow1);
                Double[] expression_values2 = this.getExpression(halfRow2);
                if (halfRow1 != null) {
                    try {
                        this.expValue[k][0] = significant_gene ? new SignificantGene(Integer.parseInt(halfRow1.getName())) : Integer.valueOf(Integer.parseInt(halfRow1.getName()));
                    }
                    catch (NumberFormatException v) {
                        this.expValue[k][0] = significant_gene ? new SignificantGene(halfRow1.getName()) : halfRow1.getName();
                    }
                    this.expValue[k][1] = halfRow1.getDescription();
                } else if (halfRow2 != null) {
                    try {
                        this.expValue[k][0] = significant_gene ? new SignificantGene(Integer.parseInt(halfRow2.getName())) : Integer.valueOf(Integer.parseInt(halfRow2.getName()));
                    }
                    catch (NumberFormatException v) {
                        this.expValue[k][0] = significant_gene ? new SignificantGene(halfRow2.getName()) : halfRow2.getName();
                    }
                    this.expValue[k][1] = halfRow2.getDescription();
                }
                this.halfRow1Length[k] = halfRow1.getExpression().length;
                this.themeHalfRow1[k] = this.hmParams.getTheme();
                this.rangeHalfRow1[k] = this.hmParams.getRange();
                this.hRow1[k] = halfRow1.getName();
                for (j = 0; j < halfRow1.getExpression().length; ++j) {
                    this.expValue[k][j + 2] = expression_values1[j];
                }
                this.halfRow2Length[k] = halfRow1.getExpression().length + halfRow2.getExpression().length;
                this.themeHalfRow2[k] = this.hmParams.getTheme();
                this.rangeHalfRow2[k] = this.hmParams.getRange();
                this.hRow2[k] = halfRow1.getName();
                for (j = halfRow1.getExpression().length; j < halfRow1.getExpression().length + halfRow2.getExpression().length; ++j) {
                    this.expValue[k][j + 2] = expression_values2[j - halfRow1.getExpression().length];
                }
                ++k;
            }
        }
        this.setThemeHalfRow1(this.themeHalfRow1);
        this.setRangeHalfRow1(this.rangeHalfRow1);
        this.setHalfRow1Length(this.halfRow1Length);
        this.sethRow1(this.hRow1);
        this.setThemeHalfRow2(this.themeHalfRow2);
        this.setRangeHalfRow2(this.rangeHalfRow2);
        this.setHalfRow2Length(this.halfRow2Length);
        this.sethRow2(this.hRow2);
        this.setExpValue(this.expValue);
        return this.expValue;
    }

    private Double[] getExpression(GeneExpression row) {
        Double[] expression_values1 = null;
        if (this.hmParams.getTransformation() == HeatMapParameters.Transformation.ROWNORM) {
            if (row != null) {
                expression_values1 = row.rowNormalize();
            }
        } else if (this.hmParams.getTransformation() == HeatMapParameters.Transformation.LOGTRANSFORM) {
            if (row != null) {
                expression_values1 = row.rowLogTransform();
            }
        } else if (row != null) {
            expression_values1 = row.getExpression();
        }
        if (expression_values1 == null) {
            expression_values1 = new Double[this.columnNames.length - 2];
            for (int q = 0; q < expression_values1.length; ++q) {
                expression_values1[q] = null;
            }
        }
        return expression_values1;
    }

    private JPanel emptyPanel() {
        JPanel empty = new JPanel();
        empty.setMaximumSize(new Dimension(50, 50));
        empty.setMinimumSize(new Dimension(50, 50));
        return empty;
    }

    private JPanel expressionLegendPanel() {
        JPanel expLegendPanel = new JPanel();
        TitledBorder expBorder = BorderFactory.createTitledBorder("Expression legend");
        expBorder.setTitleJustification(1);
        expLegendPanel.setBorder(expBorder);
        ColorGradientWidget new_legend = ColorGradientWidget.getInstance("", 200, 30, 5, 5, this.hmParams.getTheme(), this.hmParams.getRange(), true, ColorGradientWidget.LEGEND_POSITION.LEFT);
        expLegendPanel.add(new_legend);
        expLegendPanel.revalidate();
        return expLegendPanel;
    }

    private JPanel createNorthPanel() {
        JPanel northPanel = new JPanel();
        JPanel buttonPanel = new JPanel();
        northPanel.setLayout(new GridBagLayout());
        JButton SaveExpressionSet = new JButton("Save Expression Set");
        SaveExpressionSet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HeatMapPanel.this.saveExpressionSetActionPerformed(evt);
            }
        });
        buttonPanel.add(SaveExpressionSet);
        this.addComponent(northPanel, this.expressionLegendPanel(), 0, 0, 1, 1, 17, 0);
        this.addComponent(northPanel, this.emptyPanel(), 1, 0, 1, 1, 17, 0);
        this.addComponent(northPanel, this.hmParams.createDataTransformationOptionsPanel(this.params), 2, 0, 1, 1, 10, 0);
        this.addComponent(northPanel, this.hmParams.createSortOptionsPanel(this.params), 3, 0, 2, 1, 10, 0);
        this.addComponent(northPanel, buttonPanel, 5, 0, 1, 1, 10, 0);
        northPanel.revalidate();
        return northPanel;
    }

    private void addComponent(Container container, Component component, int gridx, int gridy, int gridwidth, int gridheight, int anchor, int fill) {
        GridBagConstraints gbc = new GridBagConstraints(gridx, gridy, gridwidth, gridheight, 1.0, 1.0, anchor, fill, this.insets, 0, 0);
        container.add(component, gbc);
    }

    private void saveExpressionSetActionPerformed(ActionEvent evt) {
        File file = FileUtil.getFile((String)"Export Heatmap as txt File", (int)FileUtil.SAVE);
        if (file != null && file.toString() != null) {
            String fileName = file.toString();
            if (!fileName.endsWith(".txt")) {
                fileName = fileName + ".txt";
                file = new File(fileName);
            }
            int response = 0;
            if (file.exists()) {
                response = JOptionPane.showConfirmDialog(this, "The file already exists.  Would you like to overwrite it?");
            }
            if (response != 1 && response != 2 && (response == 0 || response == 0)) {
                try {
                    String[] currentColumns;
                    BufferedWriter output = new BufferedWriter(new FileWriter(file));
                    if (this.params.isData2()) {
                        currentColumns = new String[this.columnNames.length + this.columnNames2.length - 2];
                        System.arraycopy(this.columnNames, 0, currentColumns, 0, this.columnNames.length);
                        System.arraycopy(this.columnNames2, 2, currentColumns, this.columnNames.length, this.columnNames2.length - 2);
                    } else {
                        currentColumns = (String[])this.columnNames;
                    }
                    for (int j = 0; j < currentColumns.length; ++j) {
                        if (j == currentColumns.length - 1) {
                            output.write(currentColumns[j] + "\n");
                            continue;
                        }
                        output.write(currentColumns[j] + "\t");
                    }
                    Object[][] sortedExpression = this.params.isData2() ? this.createSortedMergedTableData() : this.createSortedTableData();
                    for (int k = 0; k < sortedExpression.length; ++k) {
                        for (int l = 0; l < sortedExpression[k].length; ++l) {
                            output.write(sortedExpression[k][l].toString() + "\t");
                        }
                        output.write("\n");
                    }
                    output.flush();
                    output.close();
                    JOptionPane.showMessageDialog(this, "File " + fileName + " saved.");
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(this, "unable to write to file " + fileName);
                }
            }
        }
    }

    private void setNodeExpressionSet(EnrichmentMapParameters params) {
        Object[] nodes = params.getSelectedNodes().toArray();
        HashMap<String, GeneSet> genesets = params.getGenesetsOfInterest();
        if (nodes.length > 0) {
            HashSet<Integer> union = new HashSet<Integer>();
            for (Object node1 : nodes) {
                Node current_node = (Node)node1;
                String nodename = current_node.getIdentifier();
                GeneSet current_geneset = genesets.get(nodename);
                if (nodes.length == 1) {
                    this.displayLeadingEdge = true;
                    if (params.isGSEA()) {
                        HashMap<String, EnrichmentResult> results2;
                        HashMap<String, EnrichmentResult> results1 = params.getEnrichmentResults1();
                        if (results1.containsKey(nodename)) {
                            GSEAResult current_result = (GSEAResult)results1.get(nodename);
                            this.leadingEdgeScoreAtMax1 = current_result.getScoreAtMax();
                            if (this.leadingEdgeScoreAtMax1 == EnrichmentResultFileReaderTask.DefaultScoreAtMax) {
                                this.leadingEdgeScoreAtMax1 = current_result.getNES();
                            }
                            this.leadingEdgeRankAtMax1 = current_result.getRankAtMax();
                        }
                        if ((results2 = params.getEnrichmentResults2()).containsKey(nodename)) {
                            GSEAResult current_result = (GSEAResult)results2.get(nodename);
                            this.leadingEdgeScoreAtMax2 = current_result.getScoreAtMax();
                            if (this.leadingEdgeScoreAtMax2 == EnrichmentResultFileReaderTask.DefaultScoreAtMax) {
                                this.leadingEdgeScoreAtMax2 = current_result.getNES();
                            }
                            this.leadingEdgeRankAtMax2 = current_result.getRankAtMax();
                        }
                    }
                }
                if (current_geneset == null) continue;
                HashSet<Integer> current_set = current_geneset.getGenes();
                if (union == null) {
                    union = new HashSet<Integer>(current_set);
                    continue;
                }
                union.addAll(current_set);
            }
            HashSet<Integer> genes = union;
            this.currentExpressionSet = params.getExpression().getExpressionMatrix(genes);
            if (params.isData2()) {
                this.currentExpressionSet2 = params.getExpression2().getExpressionMatrix(genes);
            }
        } else {
            this.currentExpressionSet = null;
            this.currentExpressionSet2 = null;
        }
    }

    private void setEdgeExpressionSet(EnrichmentMapParameters params) {
        Object[] edges = params.getSelectedEdges().toArray();
        if (edges.length > 0) {
            HashSet<Integer> intersect = null;
            for (int i = 0; i < edges.length; ++i) {
                Edge current_edge = (Edge)edges[i];
                String edgename = current_edge.getIdentifier();
                GenesetSimilarity similarity = params.getGenesetSimilarity().get(edgename);
                if (similarity == null) continue;
                HashSet<Integer> current_set = similarity.getOverlapping_genes();
                if (intersect == null) {
                    intersect = new HashSet<Integer>(current_set);
                } else {
                    intersect.retainAll(current_set);
                }
                if (intersect.size() < 1) break;
            }
            this.currentExpressionSet = params.getExpression().getExpressionMatrix(intersect);
            if (params.isData2()) {
                this.currentExpressionSet2 = params.getExpression2().getExpressionMatrix(intersect);
            }
        } else {
            this.currentExpressionSet = null;
            this.currentExpressionSet2 = null;
        }
    }

    private HashMap<Integer, Ranking> getRanks() {
        HashMap<Integer, Ranking> ranks = null;
        if (this.hmParams.getSort() == HeatMapParameters.Sort.DEFAULT) {
            if (this.params.getDefaultSortMethod().equalsIgnoreCase(HeatMapParameters.sort_hierarchical_cluster)) {
                this.hmParams.setSort(HeatMapParameters.Sort.CLUSTER);
            }
            if (this.params.getDefaultSortMethod().equalsIgnoreCase(HeatMapParameters.sort_rank)) {
                this.hmParams.setSort(HeatMapParameters.Sort.RANK);
                if (!this.params.getRanks().isEmpty()) {
                    this.hmParams.setRankFileIndex(this.params.getRanks().keySet().iterator().next());
                } else {
                    this.hmParams.setSort(HeatMapParameters.Sort.NONE);
                }
            }
            if (this.params.getDefaultSortMethod().equalsIgnoreCase(HeatMapParameters.sort_none)) {
                this.hmParams.setSort(HeatMapParameters.Sort.NONE);
            }
            if (this.params.getDefaultSortMethod().equalsIgnoreCase(HeatMapParameters.sort_column)) {
                this.hmParams.setSort(HeatMapParameters.Sort.COLUMN);
                this.hmParams.setSortIndex(0);
            }
        }
        HashMap<String, HashMap<Integer, Ranking>> all_ranks = this.params.getRanks();
        if (this.hmParams.getSort() == HeatMapParameters.Sort.RANK) {
            Iterator<String> j = all_ranks.keySet().iterator();
            while (j.hasNext()) {
                String ranks_name = j.next().toString();
                if (!ranks_name.equalsIgnoreCase(this.hmParams.getRankFileIndex())) continue;
                ranks = all_ranks.get(ranks_name);
            }
            if (ranks == null) {
                throw new IllegalThreadStateException("invalid sort index for rank files.");
            }
        } else if (this.hmParams.getSort() == HeatMapParameters.Sort.COLUMN || this.hmParams.getSort() == HeatMapParameters.Sort.NONE) {
            ranks = new HashMap<Integer, Ranking>();
            for (Integer key : this.currentExpressionSet.keySet()) {
                Ranking temp = new Ranking(this.currentExpressionSet.get(key).getName(), 0.0, 0);
                ranks.put(key, temp);
            }
            if (this.hmParams.getSort() == HeatMapParameters.Sort.COLUMN) {
                this.hmParams.setSortbycolumn_event_triggered(true);
            }
        } else if (this.hmParams.getSort() == HeatMapParameters.Sort.CLUSTER) {
            ranks = this.getRanksByClustering();
        }
        return ranks;
    }

    private HashMap<Integer, Ranking> getRanksByClustering() {
        HashMap<Integer, Ranking> ranks = null;
        int numdatacolumns = 0;
        int numdatacolumns2 = 0;
        boolean cluster = true;
        if (this.numConditions > 0) {
            numdatacolumns = this.numConditions - 2;
        }
        if (this.numConditions2 > 0) {
            numdatacolumns2 = this.numConditions2 - 2;
        }
        if (this.currentExpressionSet.keySet().size() > 1 && numdatacolumns + numdatacolumns2 > 1) {
            int answer;
            int hieracical_clustering_threshold = Integer.parseInt(CytoscapeInit.getProperties().getProperty("EnrichmentMap.hieracical_clustering_threshold", "1000"));
            if (this.currentExpressionSet.keySet().size() > hieracical_clustering_threshold && (answer = JOptionPane.showConfirmDialog((Component)Cytoscape.getDesktop(), " The combination of these gene sets contain " + this.currentExpressionSet.keySet().size() + " genes and " + "\nClustering a set this size may take several " + "minutes.\n" + "Do you wish to proceed with the clustering?" + "\n\n(Choosing 'No' will switch the heatmap-sorting to 'No sort'.)", "Cluster large set of genes", 0)) == 1) {
                cluster = false;
                this.hmParams.changeSortComboBoxToNoSort();
            }
            if (cluster) {
                try {
                    this.hmParams.setSort(HeatMapParameters.Sort.CLUSTER);
                    ArrayList<Double[]> clustering_expressionset = new ArrayList<Double[]>();
                    ArrayList<Integer> labels = new ArrayList<Integer>();
                    int j = 0;
                    for (Integer key : this.currentExpressionSet.keySet()) {
                        Double[] z;
                        Double[] x = this.currentExpressionSet.get(key).getExpression();
                        if (this.params.isData2()) {
                            Double[] y = this.currentExpressionSet2.get(key).getExpression();
                            z = new Double[x.length + y.length];
                            System.arraycopy(x, 0, z, 0, x.length);
                            System.arraycopy(y, 0, z, x.length, y.length);
                        } else {
                            z = x;
                        }
                        clustering_expressionset.add(j, z);
                        labels.add(j, key);
                        ++j;
                    }
                    DistanceMatrix distanceMatrix = new DistanceMatrix(this.currentExpressionSet.keySet().size());
                    if (this.params.getDefaultDistanceMetric().equalsIgnoreCase(HeatMapParameters.pearson_correlation)) {
                        try {
                            distanceMatrix.calcDistances(clustering_expressionset, new PearsonCorrelation());
                        }
                        catch (RuntimeException e) {
                            try {
                                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "Unable to compute Pearson Correlation for this expression Set.\n  Cosine distance used for this set instead.\n To switch distance metric used for all hierarchical clustering \nPlease change setting under Advance Preferences in the Results Panel.");
                                distanceMatrix.calcDistances(clustering_expressionset, new CosineDistance());
                            }
                            catch (RuntimeException ex) {
                                distanceMatrix.calcDistances(clustering_expressionset, new EuclideanDistance());
                            }
                        }
                    } else if (this.params.getDefaultDistanceMetric().equalsIgnoreCase(HeatMapParameters.cosine)) {
                        distanceMatrix.calcDistances(clustering_expressionset, new CosineDistance());
                    } else if (this.params.getDefaultDistanceMetric().equalsIgnoreCase(HeatMapParameters.euclidean)) {
                        distanceMatrix.calcDistances(clustering_expressionset, new EuclideanDistance());
                    }
                    distanceMatrix.setLabels(labels);
                    AvgLinkHierarchicalClustering cluster_result = new AvgLinkHierarchicalClustering(distanceMatrix);
                    if (this.currentExpressionSet.keySet().size() > 1000) {
                        cluster_result.setOptimalLeafOrdering(false);
                    } else {
                        cluster_result.setOptimalLeafOrdering(true);
                    }
                    cluster_result.run();
                    int[] order = cluster_result.getLeafOrder();
                    ranks = new HashMap();
                    for (int i = 0; i < order.length; ++i) {
                        Integer label = (Integer)labels.get(order[i]);
                        Ranking temp = new Ranking(this.currentExpressionSet.get(label).getName(), 0.0, i);
                        ranks.put(label, temp);
                    }
                }
                catch (OutOfMemoryError e) {
                    JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "Unable to complete clustering of genes due to insufficient memory.", "Out of memory", 1);
                    cluster = false;
                }
            }
        }
        if (this.currentExpressionSet.keySet().size() == 1 || numdatacolumns + numdatacolumns2 <= 1 || !cluster) {
            this.hmParams.setSort(HeatMapParameters.Sort.NONE);
            ranks = new HashMap<Integer, Ranking>();
            for (Integer key : this.currentExpressionSet.keySet()) {
                Ranking temp = new Ranking(this.currentExpressionSet.get(key).getName(), 0.0, 0);
                ranks.put(key, temp);
            }
        }
        return ranks;
    }

    private void initialize_linkouts() {
        Properties props = CytoscapeInit.getProperties();
        Class<?> linkout = null;
        try {
            linkout = Class.forName("linkout.LinkOut");
        }
        catch (ClassNotFoundException e1) {
            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "Could't create LinkOut class", "Could't create LinkOut class", 2);
            return;
        }
        ClassLoader cl = linkout.getClassLoader();
        try {
            props.load(cl.getResource("linkout.props").openStream());
        }
        catch (IOException e1) {
            JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "Could't read LinkOut class", "Could't read LinkOut class", 2);
        }
        this.linkoutProps = new HashMap<String, Map<String, String>>();
        String nodeLink = "nodelinkouturl";
        String[] parts = null;
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            Map<String, String> pair = null;
            if (!entry.getKey().toString().startsWith("nodelinkouturl") || (parts = entry.getKey().toString().split("\\.")).length != 3) continue;
            pair = this.linkoutProps.get(parts[1]);
            if (pair == null) {
                pair = new HashMap<String, String>();
                this.linkoutProps.put(parts[1], pair);
            }
            pair.put(parts[2], entry.getValue().toString());
        }
    }

    private int getTopRank() {
        int topRank = 0;
        if (this.displayLeadingEdge && this.params.haveRanks() && (this.hmParams.getSort() == HeatMapParameters.Sort.RANK || this.params.getDefaultSortMethod().equalsIgnoreCase(this.hmParams.getSort().toString()))) {
            if (this.hmParams.getRankFileIndex().equalsIgnoreCase("Dataset 1 Ranking")) {
                topRank = this.leadingEdgeRankAtMax1;
                if (this.leadingEdgeScoreAtMax1 > 0.0) {
                    topRank += 3;
                }
            } else if (this.hmParams.getRankFileIndex().equalsIgnoreCase("Dataset 2 Ranking")) {
                topRank = this.leadingEdgeRankAtMax2;
                if (this.leadingEdgeScoreAtMax2 > 0.0) {
                    topRank += 3;
                }
            }
        }
        return topRank;
    }

    private boolean isNegativeGS(int dataset) {
        boolean isNegative = false;
        if (dataset == 1) {
            isNegative = this.leadingEdgeScoreAtMax1 < 0.0;
        } else if (dataset == 2) {
            isNegative = this.leadingEdgeScoreAtMax2 < 0.0;
        }
        return isNegative;
    }

    Object[][] getExpValue() {
        return this.expValue;
    }

    private String[] gethRow1() {
        return this.hRow1;
    }

    private void sethRow1(String[] hRow1) {
        this.hRow1 = hRow1;
    }

    private String[] gethRow2() {
        return this.hRow2;
    }

    private void sethRow2(String[] hRow2) {
        this.hRow2 = hRow2;
    }

    private void setExpValue(Object[][] expValue) {
        this.expValue = expValue;
    }

    public void clearPanel() {
        this.removeAll();
        this.revalidate();
    }

    public void setHalfRow1Length(int[] halfRow1Length) {
        this.halfRow1Length = halfRow1Length;
    }

    public int[] getHalfRow1Length() {
        return this.halfRow1Length;
    }

    public void setHalfRow2Length(int[] hRow2Length) {
        this.halfRow2Length = hRow2Length;
    }

    public int[] getHalfRow2Length() {
        return this.halfRow2Length;
    }

    public void setThemeHalfRow1(ColorGradientTheme[] themeHalfRow1) {
        this.themeHalfRow1 = themeHalfRow1;
    }

    public ColorGradientTheme[] getThemeHalfRow1() {
        return this.themeHalfRow1;
    }

    public void setThemeHalfRow2(ColorGradientTheme[] themeHalfRow2) {
        this.themeHalfRow2 = themeHalfRow2;
    }

    public ColorGradientTheme[] getThemeHalfRow2() {
        return this.themeHalfRow2;
    }

    public void setRangeHalfRow1(ColorGradientRange[] rangeHalfRow1) {
        this.rangeHalfRow1 = rangeHalfRow1;
    }

    public ColorGradientRange[] getRangeHalfRow1() {
        return this.rangeHalfRow1;
    }

    public void setRangeHalfRow2(ColorGradientRange[] rangeHalfRow2) {
        this.rangeHalfRow2 = rangeHalfRow2;
    }

    public ColorGradientRange[] getRangeHalfRow2() {
        return this.rangeHalfRow2;
    }

    public void setRowGeneName(String[] rowGeneName) {
        this.rowGeneName = rowGeneName;
    }

    public String[] getRowGeneName() {
        return this.rowGeneName;
    }

    public void setRowLength(int[] rowLength) {
        this.rowLength = rowLength;
    }

    public int[] getRowLength() {
        return this.rowLength;
    }

    private ColorGradientRange[] getRowRange() {
        return this.rowRange;
    }

    private void setRowRange(ColorGradientRange[] rowRange) {
        this.rowRange = rowRange;
    }

    public void setRowTheme(ColorGradientTheme[] rowTheme) {
        this.rowTheme = rowTheme;
    }

    public ColorGradientTheme[] getRowTheme() {
        return this.rowTheme;
    }
}

