/**
 **                       EnrichmentMap Cytoscape Plugin
 **
 ** Copyright (c) 2008-2009 Bader Lab, Donnelly Centre for Cellular and Biomolecular 
 ** Research, University of Toronto
 **
 ** Contact: http://www.baderlab.org
 **
 ** Code written by: Ruth Isserlin
 ** Authors: Daniele Merico, Ruth Isserlin, Oliver Stueker, Gary D. Bader
 **
 ** This library is free software; you can redistribute it and/or modify it
 ** under the terms of the GNU Lesser General Public License as published
 ** by the Free Software Foundation; either version 2.1 of the License, or
 ** (at your option) any later version.
 **
 ** This library is distributed in the hope that it will be useful, but
 ** WITHOUT ANY WARRANTY, WITHOUT EVEN THE IMPLIED WARRANTY OF
 ** MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  The software and
 ** documentation provided hereunder is on an "as is" basis, and
 ** University of Toronto
 ** has no obligations to provide maintenance, support, updates, 
 ** enhancements or modifications.  In no event shall the
 ** University of Toronto
 ** be liable to any party for direct, indirect, special,
 ** incidental or consequential damages, including lost profits, arising
 ** out of the use of this software and its documentation, even if
 ** University of Toronto
 ** has been advised of the possibility of such damage.  
 ** See the GNU Lesser General Public License for more details.
 **
 ** You should have received a copy of the GNU Lesser General Public License
 ** along with this library; if not, write to the Free Software Foundation,
 ** Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 **
 **/

// $Id: ColumnHeaderVerticalRenderer.java 393 2009-10-15 20:15:01Z risserlin $
// $LastChangedDate: 2009-10-15 16:15:01 -0400 (Thu, 15 Oct 2009) $
// $LastChangedRevision: 393 $
// $LastChangedBy: risserlin $
// $HeadURL: svn+ssh://risserlin@server1.baderlab.med.utoronto.ca/svn/EnrichmentMap/tags/v1.00_cytoscape2.7.0/EnrichmentMapPlugin/src/org/baderlab/csplugins/enrichmentmap/ColumnHeaderVerticalRenderer.java $

package org.baderlab.csplugins.enrichmentmap;

import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.*;
import java.awt.*;
import java.awt.image.BufferedImage;

/**
 * Created by
 * User: risserlin
 * Date: Feb 12, 2009
 * Time: 12:22:50 PM
 * <p>
 * Flips column headers to vertical position
 */
public class ColumnHeaderVerticalRenderer extends DefaultTableCellRenderer {


    @Override
    public Component getTableCellRendererComponent(JTable table,
                                                   Object value, boolean isSelected, boolean hasFocus,
                                                   int row, int column) {

        JLabel label = new JLabel();

        label.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        label.setBackground(this.getBackground());
        label.setForeground(UIManager.getColor("TableHeader.foreground"));
        label.setFont(UIManager.getFont("TableHeader.font"));

        Icon icon = VerticalCaption.getVerticalCaption(label, value.toString(), false);

        label.setIcon(icon);
        label.setVerticalAlignment(JLabel.BOTTOM);
        label.setHorizontalAlignment(JLabel.CENTER);

        return label;
    }
}

class VerticalCaption {

    static Icon getVerticalCaption(JComponent component, String caption, boolean clockwise) {
        Font f = component.getFont();
        FontMetrics fm = component.getFontMetrics(f);
        int captionHeight = fm.getHeight();
        int captionWidth = fm.stringWidth(caption);
        BufferedImage bi = new BufferedImage(captionHeight + 4,
                captionWidth + 4, BufferedImage.TYPE_INT_ARGB);
        Graphics2D g = (Graphics2D) bi.getGraphics();

        g.setColor(component.getBackground()); // transparent
        g.fillRect(0, 0, bi.getWidth(), bi.getHeight());

        g.setColor(component.getForeground());
        g.setFont(f);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING,
                RenderingHints.VALUE_TEXT_ANTIALIAS_ON);

        if (clockwise) {
            g.rotate(Math.PI / 2);
        } else {

            g.rotate(-Math.PI / 2);
            g.translate(-bi.getHeight(), bi.getWidth());
        }
        g.drawString(caption, 2, -6);


        Icon icon = new ImageIcon(bi);
        return icon;
    }
}