// $Id: ValuedRangeModel.java 271 2009-06-27 22:42:27Z revilo $
/*
 Copyright (c) 2006, 2007, The Cytoscape Consortium (www.cytoscape.org)

 The Cytoscape Consortium is:
 - Institute for Systems Biology
 - University of California San Diego
 - Memorial Sloan-Kettering Cancer Center
 - Institut Pasteur
 - Agilent Technologies

 This library is free software; you can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published
 by the Free Software Foundation; either version 2.1 of the License, or
 any later version.

 This library is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY, WITHOUT EVEN THE IMPLIED WARRANTY OF
 MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  The software and
 documentation provided hereunder is on an "as is" basis, and the
 Institute for Systems Biology and the Whitehead Institute
 have no obligations to provide maintenance, support,
 updates, enhancements or modifications.  In no event shall the
 Institute for Systems Biology and the Whitehead Institute
 be liable to any party for direct, indirect, special,
 incidental or consequential damages, including lost profits, arising
 out of the use of this software and its documentation, even if the
 Institute for Systems Biology and the Whitehead Institute
 have been advised of the possibility of such damage.  See
 the GNU Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public License
 along with this library; if not, write to the Free Software Foundation,
 Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
*/

package prefuse.util.ui;

import javax.swing.BoundedRangeModel;


/**
 * BoundedRangeModel that additionally supports a mapping between the integer
 * range used by interface components and a richer range of values, such
 * as numbers or arbitrary objects.
 *
 * @author <a href="http://jheer.org">jeffrey heer</a>
 * @see javax.swing.BoundedRangeModel
 */
public interface ValuedRangeModel extends BoundedRangeModel {
	/**
	 * Get the minimum value backing the range model. This is
	 * the absolute minimum value possible for the range span.
	 * @return the minimum value
	 */
	public Object getMinValue();

	/**
	 * Get the maximum value backing the range model. This is
	 * the absolute maximum value possible for the range span.
	 * @return the maximum value
	 */
	public Object getMaxValue();

	/**
	 * Get the value at the low point of the range span.
	 * @return the lowest value of the current range
	 */
	public Object getLowValue();

	/**
	 * Get the value at the high point of the range span.
	 * @return the highest value of the current range
	 */
	public Object getHighValue();
} // end of interface ValuedRangeModel
