/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.task;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.writers.CytoscapeSessionWriter;
import cytoscape.data.writers.XGMMLWriter;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import cytoscape.task.ui.JTaskConfig;
import cytoscape.view.CyNetworkView;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URISyntaxException;
import javax.swing.JOptionPane;
import javax.xml.bind.JAXBException;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.task.BuildEnrichmentMapTask;

public class BuildBulkEnrichmentMapTask
implements Task {
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;
    private JTaskConfig config;
    private EnrichmentMapParameters params;

    public BuildBulkEnrichmentMapTask(EnrichmentMapParameters params) {
        this.params = params;
    }

    public BuildBulkEnrichmentMapTask(TaskMonitor taskMonitor, EnrichmentMapParameters params) {
        this.taskMonitor = taskMonitor;
        this.params = params;
    }

    public void buildBulkEnrichmentMap() {
        String mainDirectory = this.params.getGSEAResultsDirName();
        String[] gsea_results = new File(mainDirectory).list();
        int lower = this.params.getLowerlimit();
        int upper = this.params.getUpperlimit();
        if (lower == 1 && upper == 1) {
            upper = gsea_results.length;
        }
        int counter = 0;
        int num_bulk_em_created = 0;
        if (this.params.getMethod().equalsIgnoreCase("GSEA")) {
            for (int i = 0; i < gsea_results.length; ++i) {
                File current = new File(mainDirectory, gsea_results[i]);
                if (!current.isDirectory()) continue;
                String[] children = current.list();
                boolean foundRpt = false;
                for (int k = 0; k < children.length; ++k) {
                    if (!children[k].endsWith(".rpt")) continue;
                    foundRpt = true;
                    if (++counter < lower || counter >= upper) continue;
                    File rpt_file = new File(current, children[k]);
                    EnrichmentMapParameters current_params = new EnrichmentMapParameters();
                    current_params.copyInputParameters(this.params);
                    current_params.populateFieldsFromRpt(rpt_file);
                    this.params = current_params;
                    String rpt_name = rpt_file.getName();
                    String[] tokens = rpt_name.split("\\.");
                    String name = tokens[0];
                    BuildEnrichmentMapTask new_map = new BuildEnrichmentMapTask(this.params, name, this.taskMonitor);
                    new_map.run();
                    Cytoscape.getCurrentNetworkView().fitContent();
                    Cytoscape.getCurrentNetworkView().setZoom(0.5);
                    Cytoscape.getCurrentNetworkView().updateView();
                    try {
                        File outputFile = new File(mainDirectory, name + ".xgmml");
                        CyNetworkView view = Cytoscape.getCurrentNetworkView();
                        CyNetwork nw = Cytoscape.getCurrentNetwork();
                        FileWriter writer = new FileWriter(outputFile);
                        XGMMLWriter exporter = new XGMMLWriter(nw, view);
                        exporter.write((Writer)writer);
                        writer.close();
                        CytoscapeSessionWriter session = new CytoscapeSessionWriter(mainDirectory + File.separator + name + ".cys");
                        System.out.println(mainDirectory + File.separator + name + ".cys");
                        session.writeSessionToDisk();
                        Cytoscape.destroyNetwork((String)name);
                        System.gc();
                        Cytoscape.createNewSession();
                        ++num_bulk_em_created;
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        System.out.println("Can't export network " + name + " .");
                        continue;
                    }
                    catch (IOException e2) {
                        System.out.println("Can't export network " + name + " to xgmml.");
                        continue;
                    }
                    catch (URISyntaxException e3) {
                        System.out.println("Can't export network " + name + " to xgmml.");
                        continue;
                    }
                    catch (JAXBException e4) {
                        System.out.println("Can't export network " + name + " to xgmml.");
                        continue;
                    }
                    catch (Exception eRest) {
                        System.out.println("Can't export network " + name + ".cys");
                    }
                }
            }
        } else if (this.params.getMethod().equalsIgnoreCase("generic")) {
            File current;
            int i;
            String gmtfile = "";
            for (i = 0; i < gsea_results.length; ++i) {
                if (!gsea_results[i].endsWith("gmt")) continue;
                if (gmtfile.equalsIgnoreCase("")) {
                    current = new File(mainDirectory, gsea_results[i]);
                    gmtfile = current.getAbsolutePath();
                    this.params.getFiles().get("Dataset 1").setGMTFileName(gmtfile);
                    continue;
                }
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "There are multiple gmt files defined." + gsea_results + ", " + gmtfile, "Too many gmt files", 2);
            }
            if (gmtfile.equalsIgnoreCase("")) {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "There are no gmt files defined.  In order to run bulk EM with generic outputs a gmt file needs to be in the same directory with all the enrichment results", "No gmt file found", 2);
            }
            for (i = 0; i < gsea_results.length; ++i) {
                String run_name;
                current = new File(mainDirectory, gsea_results[i]);
                if (!gsea_results[i].endsWith(".txt")) continue;
                this.params.getFiles().get("Dataset 1").setEnrichmentFileName1(current.getAbsolutePath());
                String name = run_name = current.getName();
                BuildEnrichmentMapTask new_map = new BuildEnrichmentMapTask(this.params, name, this.taskMonitor);
                new_map.run();
                Cytoscape.getCurrentNetworkView().fitContent();
                Cytoscape.getCurrentNetworkView().setZoom(0.5);
                Cytoscape.getCurrentNetworkView().updateView();
                if (!this.params.isSessions()) continue;
                try {
                    File outputFile = new File(mainDirectory, name + ".xgmml");
                    CyNetworkView view = Cytoscape.getCurrentNetworkView();
                    CyNetwork nw = Cytoscape.getCurrentNetwork();
                    FileWriter writer = new FileWriter(outputFile);
                    XGMMLWriter exporter = new XGMMLWriter(nw, view);
                    exporter.write((Writer)writer);
                    writer.close();
                    CytoscapeSessionWriter session = new CytoscapeSessionWriter(mainDirectory + File.separator + name + ".cys");
                    System.out.println(mainDirectory + File.separator + name + ".cys");
                    session.writeSessionToDisk();
                    Cytoscape.destroyNetwork((String)name);
                    System.gc();
                    Cytoscape.createNewSession();
                    ++num_bulk_em_created;
                    continue;
                }
                catch (FileNotFoundException e) {
                    System.out.println("Can't export network " + name + " .");
                    continue;
                }
                catch (IOException e2) {
                    System.out.println("Can't export network " + name + " to xgmml.");
                    continue;
                }
                catch (URISyntaxException e3) {
                    System.out.println("Can't export network " + name + " to xgmml.");
                    continue;
                }
                catch (JAXBException e4) {
                    System.out.println("Can't export network " + name + " to xgmml.");
                    continue;
                }
                catch (Exception eRest) {
                    System.out.println("Can't export network " + name + ".cys");
                }
            }
        }
        JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "EM Bulk Build Complete. \n" + num_bulk_em_created + " enrichments maps were created.\n all results session and xgmml files can be found in:\n" + mainDirectory, "Bulk Build Finished", 1);
    }

    public void run() {
        this.buildBulkEnrichmentMap();
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Building Bulk Enrichment Maps based on GSEA or generic results");
    }
}

