/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.task;

import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.DefaultListModel;
import org.baderlab.csplugins.enrichmentmap.PostAnalysisParameters;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.model.GeneSet;
import org.baderlab.csplugins.enrichmentmap.parsers.GMTFileReaderTask;

public class LoadSignatureGMTFilesTask
implements Task {
    private PostAnalysisParameters paParams = null;
    private EnrichmentMap map = null;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;

    public LoadSignatureGMTFilesTask(EnrichmentMap map, PostAnalysisParameters paParams, TaskMonitor taskMonitor) {
        this(map, paParams);
        this.taskMonitor = taskMonitor;
    }

    public LoadSignatureGMTFilesTask(EnrichmentMap map, PostAnalysisParameters paParams) {
        this.paParams = paParams;
        this.map = map;
    }

    public String getTitle() {
        return new String("Loading Geneset Files...");
    }

    public void halt() {
        this.interrupted = true;
    }

    public void run() {
        try {
            try {
                GMTFileReaderTask gmtFile_2 = new GMTFileReaderTask(this.map, this.paParams, this.taskMonitor, 2);
                gmtFile_2.run();
            }
            catch (OutOfMemoryError e) {
                this.taskMonitor.setException((Throwable)e, "Out of Memory. Please increase memory allotment for Cytoscape.");
                return;
            }
            catch (Exception e) {
                this.taskMonitor.setException((Throwable)e, "unable to load GMT files");
                return;
            }
            DefaultListModel signatureSetNames = this.paParams.getSignatureSetNames();
            DefaultListModel selectedSignatureSetNames = this.paParams.getSelectedSignatureSetNames();
            signatureSetNames.clear();
            HashMap<String, GeneSet> genesets_in_map = this.map.getAllGenesets();
            Object[] setsOfInterest = genesets_in_map.keySet().toArray();
            Object[] setNamesArray = this.paParams.getSignatureGenesets().getGenesets().keySet().toArray();
            Arrays.sort(setNamesArray);
            for (int i = 0; i < setNamesArray.length; ++i) {
                if (this.interrupted) {
                    throw new InterruptedException();
                }
                if (selectedSignatureSetNames.contains(setNamesArray[i])) continue;
                if (this.paParams.isFilter()) {
                    boolean matchfound = false;
                    for (int j = 0; j < setsOfInterest.length; ++j) {
                        Double relative_per;
                        HashSet<Integer> mapset = new HashSet<Integer>(genesets_in_map.get(setsOfInterest[j]).getGenes());
                        Integer original_size = mapset.size();
                        HashSet<Integer> paset = new HashSet<Integer>(this.paParams.getSignatureGenesets().getGenesets().get(setNamesArray[i]).getGenes());
                        mapset.retainAll(paset);
                        if (this.paParams.getSignature_filterMetric() == 0) {
                            relative_per = (double)mapset.size() / original_size.doubleValue();
                            if (!(relative_per >= Double.valueOf((double)this.paParams.getFilterValue() / 100.0))) continue;
                            matchfound = true;
                            break;
                        }
                        if (this.paParams.getSignature_filterMetric() == 1) {
                            if (mapset.size() < this.paParams.getFilterValue()) continue;
                            matchfound = true;
                            break;
                        }
                        if (this.paParams.getSignature_filterMetric() != 2 || !((relative_per = Double.valueOf((double)mapset.size() / Integer.valueOf(paset.size()).doubleValue())) >= Double.valueOf((double)this.paParams.getFilterValue() / 100.0))) continue;
                        matchfound = true;
                        break;
                    }
                    if (!matchfound || signatureSetNames.contains(setNamesArray[i])) continue;
                    signatureSetNames.addElement(setNamesArray[i]);
                    continue;
                }
                signatureSetNames.addElement(setNamesArray[i]);
            }
        }
        catch (InterruptedException e) {
            this.taskMonitor.setException((Throwable)e, "loading of GMT files cancelled");
        }
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }
}

