/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.data.readers.TextFileReader;
import giny.model.Edge;
import giny.model.Node;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapVisualStyle;
import org.baderlab.csplugins.enrichmentmap.heatmap.HeatMapParameters;
import org.baderlab.csplugins.enrichmentmap.model.DataSetFiles;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.model.GSEAResult;
import org.baderlab.csplugins.enrichmentmap.model.GeneSet;
import org.baderlab.csplugins.enrichmentmap.model.GenericResult;
import org.baderlab.csplugins.enrichmentmap.model.Rank;
import org.baderlab.csplugins.enrichmentmap.view.ParametersPanel;
import org.baderlab.csplugins.enrichmentmap.view.SliderBarPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnrichmentMapParameters {
    private String attributePrefix = null;
    private String GMTDirName = null;
    private String GCTDirName = null;
    private String GSEAResultsDirName = null;
    private int lowerlimit = 1;
    private int upperlimit = 1;
    private boolean BulkEM = false;
    private boolean sessions = true;
    private HashMap<String, DataSetFiles> files = new HashMap();
    private boolean Data = false;
    private boolean Data2 = false;
    private boolean twoDatasets = false;
    private boolean FDR = false;
    private boolean EMgmt = false;
    private boolean twoDistinctExpressionSets = false;
    private String method = "GSEA";
    private String similarityMetric;
    private String enrichment_edge_type;
    private double pvalue;
    private double qvalue;
    private double similarityCutOff;
    private double combinedConstant;
    private SliderBarPanel pvalueSlider;
    private SliderBarPanel qvalueSlider;
    private SliderBarPanel similaritySlider;
    private ArrayList<Node> selectedNodes;
    private ArrayList<Edge> selectedEdges;
    private HeatMapParameters hmParams;
    private Properties cyto_prop = CytoscapeInit.getProperties();
    private double defaultJaccardCutOff = Double.parseDouble(this.cyto_prop.getProperty("EnrichmentMap.default_jaccard", "0.25"));
    private double defaultOverlapCutOff = Double.parseDouble(this.cyto_prop.getProperty("EnrichmentMap.default_overlap", "0.50"));
    private String defaultSimilarityMetric = this.cyto_prop.getProperty("EnrichmentMap.default_similarity_metric", this.cyto_prop.getProperty("EnrichmentMap.default_overlap_metric", "overlap"));
    private Boolean disable_heatmap_autofocus = Boolean.parseBoolean(this.cyto_prop.getProperty("EnrichmentMap.disable_heatmap_autofocus", "false"));
    private String defaultSortMethod = this.cyto_prop.getProperty("EnrichmentMap.default_sort_method", HeatMapParameters.sort_hierarchical_cluster);
    private String defaultDistanceMetric = this.cyto_prop.getProperty("EnrichmentMap.default_distance_metric", HeatMapParameters.pearson_correlation);
    public static final String ENRICHMENT_INTERACTION_TYPE = "Geneset_Overlap";
    public static final String ENRICHMENT_INTERACTION_TYPE_SET1 = "Geneset_Overlap_set1";
    public static final String ENRICHMENT_INTERACTION_TYPE_SET2 = "Geneset_Overlap_set2";
    public static final String method_GSEA = "GSEA";
    public static final String method_generic = "generic";
    public static final String method_DAVID = "DAVID/BiNGO";
    public static final String SM_JACCARD = "JACCARD";
    public static final String SM_OVERLAP = "OVERLAP";
    public static final String SM_COMBINED = "COMBINED";
    HashMap<String, String> props;

    public EnrichmentMapParameters() {
        this.pvalue = Double.parseDouble(this.cyto_prop.getProperty("EnrichmentMap.default_pvalue", "0.005"));
        this.qvalue = Double.parseDouble(this.cyto_prop.getProperty("EnrichmentMap.default_qvalue", "0.1"));
        this.combinedConstant = Double.parseDouble(this.cyto_prop.getProperty("EnrichmentMap.default_combinedConstant", "0.50"));
        if (this.defaultSimilarityMetric.equalsIgnoreCase(SM_OVERLAP)) {
            this.similarityCutOff = this.defaultOverlapCutOff;
            this.similarityMetric = SM_OVERLAP;
        } else if (this.defaultSimilarityMetric.equalsIgnoreCase(SM_JACCARD)) {
            this.similarityCutOff = this.defaultJaccardCutOff;
            this.similarityMetric = SM_JACCARD;
        } else if (this.defaultSimilarityMetric.equalsIgnoreCase(SM_COMBINED)) {
            this.similarityCutOff = this.defaultJaccardCutOff;
            this.similarityMetric = SM_COMBINED;
        }
        this.enrichment_edge_type = ENRICHMENT_INTERACTION_TYPE;
        this.setFDR(false);
        this.setData(false);
        this.setData2(false);
        this.setTwoDatasets(false);
        this.setTwoDistinctExpressionSets(false);
        this.selectedNodes = new ArrayList();
        this.selectedEdges = new ArrayList();
        this.pvalueSlider = new SliderBarPanel(0.0, this.pvalue, "P-value Cutoff", this, EnrichmentMapVisualStyle.PVALUE_DATASET1, EnrichmentMapVisualStyle.PVALUE_DATASET2, ParametersPanel.summaryPanelWidth, false, this.pvalue);
        this.qvalueSlider = new SliderBarPanel(0.0, this.qvalue, "Q-value Cutoff", this, EnrichmentMapVisualStyle.FDR_QVALUE_DATASET1, EnrichmentMapVisualStyle.FDR_QVALUE_DATASET2, ParametersPanel.summaryPanelWidth, false, this.qvalue);
        this.similaritySlider = new SliderBarPanel(this.similarityCutOff, 1.0, "Similarity Cutoff", this, EnrichmentMapVisualStyle.SIMILARITY_COEFFECIENT, EnrichmentMapVisualStyle.SIMILARITY_COEFFECIENT, ParametersPanel.summaryPanelWidth, true, this.similarityCutOff);
        this.files.put("Dataset 1", new DataSetFiles());
    }

    public EnrichmentMapParameters(String propFile) {
        this();
        this.props = new HashMap();
        String[] lines = propFile.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            String[] tokens = line.split("\t");
            if (tokens.length != 2) continue;
            this.props.put(tokens[0], tokens[1]);
        }
        this.attributePrefix = this.props.get("attributePrefix");
        this.enrichment_edge_type = this.props.containsKey("enrichment_edge_type") ? this.props.get("enrichment_edge_type") : "pp";
        if (this.props.get("twoDatasets").equalsIgnoreCase("true")) {
            this.twoDatasets = true;
        }
        if (this.props.get("jaccard").equalsIgnoreCase("false")) {
            this.similarityMetric = SM_JACCARD;
        } else if (this.props.get("jaccard").equalsIgnoreCase("true")) {
            this.similarityMetric = SM_OVERLAP;
        } else if (this.props.get("jaccard").equalsIgnoreCase(SM_JACCARD)) {
            this.similarityMetric = SM_JACCARD;
        } else if (this.props.get("jaccard").equalsIgnoreCase(SM_OVERLAP)) {
            this.similarityMetric = SM_OVERLAP;
        } else if (this.props.get("jaccard").equalsIgnoreCase(SM_COMBINED)) {
            this.similarityMetric = SM_COMBINED;
        }
        if (this.props.get("CombinedConstant") != null) {
            this.setCombinedConstant(Double.parseDouble(this.props.get("CombinedConstant")));
        } else {
            this.setCombinedConstant(0.5);
        }
        if (this.props.get(method_GSEA) != null) {
            this.method = this.props.get(method_GSEA).equalsIgnoreCase("false") ? method_generic : method_GSEA;
        }
        if (this.props.get("Data").equalsIgnoreCase("true")) {
            this.Data = true;
        }
        if (this.props.get("Data2").equalsIgnoreCase("true")) {
            this.Data2 = true;
        }
        if (this.props.get("FDR").equalsIgnoreCase("true")) {
            this.FDR = true;
        }
        if (this.props.get("method") != null) {
            this.method = this.props.get("method");
        }
        this.setPvalue(Double.parseDouble(this.props.get("pvalue")));
        this.setQvalue(Double.parseDouble(this.props.get("qvalue")));
        String cutoff = this.props.get("jaccardCutOff") != null ? this.props.get("jaccardCutOff") : this.props.get("similarityCutOff");
        if (cutoff != null) {
            this.similarityCutOff = Double.parseDouble(cutoff);
        }
        if (!this.props.containsKey("Version")) {
            this.reconstruct_ver1(this.props);
        } else if (Double.parseDouble(this.props.get("Version")) >= 2.0) {
            this.reconstruct_ver2(this.props);
        }
        this.pvalueSlider = new SliderBarPanel(0.0, this.pvalue, "P-value Cutoff", this, EnrichmentMapVisualStyle.PVALUE_DATASET1, EnrichmentMapVisualStyle.PVALUE_DATASET2, ParametersPanel.summaryPanelWidth, false, this.pvalue);
        this.qvalueSlider = new SliderBarPanel(0.0, this.qvalue, "Q-value Cutoff", this, EnrichmentMapVisualStyle.FDR_QVALUE_DATASET1, EnrichmentMapVisualStyle.FDR_QVALUE_DATASET2, ParametersPanel.summaryPanelWidth, false, this.pvalue);
        this.similaritySlider = new SliderBarPanel(this.similarityCutOff, 1.0, "Similarity Cutoff", this, EnrichmentMapVisualStyle.SIMILARITY_COEFFECIENT, EnrichmentMapVisualStyle.SIMILARITY_COEFFECIENT, ParametersPanel.summaryPanelWidth, true, this.similarityCutOff);
    }

    private void reconstruct_ver1(HashMap<String, String> props) {
        DataSetFiles files1 = new DataSetFiles();
        files1.setGMTFileName(this.checkForNull(props, "GMTFileName"));
        if (props.get("expressionFileName1") != null) {
            files1.setExpressionFileName(this.checkForNull(props, "expressionFileName1"));
        } else {
            files1.setExpressionFileName(this.checkForNull(props, "GCTFileName1"));
        }
        files1.setEnrichmentFileName1(this.checkForNull(props, "enerichmentDataset1FileName1"));
        files1.setEnrichmentFileName2(this.checkForNull(props, "enrichmentDataset1FileName2"));
        files1.setGseaHtmlReportFile(this.checkForNull(props, "gseaHtmlReportFileDataset1"));
        files1.setPhenotype1(this.checkForNull(props, "dataset1Phenotype1"));
        files1.setPhenotype2(this.checkForNull(props, "dataset1Phenotype2"));
        files1.setRankedFile(this.checkForNull(props, "rankFile1"));
        files1.setClassFile(this.checkForNull(props, "classFile1"));
        this.files.put("Dataset 1", files1);
        if (this.twoDatasets) {
            DataSetFiles files2 = new DataSetFiles();
            if (this.Data2) {
                if (props.get("expressionFileName2") != null) {
                    files2.setExpressionFileName(this.checkForNull(props, "expressionFileName2"));
                } else {
                    files2.setExpressionFileName(this.checkForNull(props, "GCTFileName2"));
                }
            }
            files2.setEnrichmentFileName1(this.checkForNull(props, "enerichmentDataset2FileName1"));
            files2.setEnrichmentFileName2(this.checkForNull(props, "enrichmentDataset2FileName2"));
            files2.setRankedFile(this.checkForNull(props, "rankFile2"));
            files2.setGseaHtmlReportFile(this.checkForNull(props, "gseaHtmlReportFileDataset2"));
            files2.setClassFile(this.checkForNull(props, "classFile2"));
            files2.setPhenotype1(this.checkForNull(props, "dataset2Phenotype1"));
            files2.setPhenotype2(this.checkForNull(props, "dataset2Phenotype2"));
            if (!this.files.containsKey("Dataset 2")) {
                this.files.put("Dataset 2", files2);
            }
        }
    }

    private String checkForNull(HashMap<String, String> props, String key) {
        if (props.get(key) != null) {
            if (props.get(key).equalsIgnoreCase("null")) {
                return null;
            }
            return props.get(key);
        }
        return null;
    }

    private void reconstruct_ver2(HashMap<String, String> props) {
        if (props.containsKey("Datasets")) {
            String list_ds = props.get("Datasets");
            String list_db_replaced = list_ds.replaceAll("\\[", "");
            list_db_replaced = list_db_replaced.replaceAll("\\]", "");
            String[] datasets = list_db_replaced.split(",");
            for (int i = 0; i < datasets.length; ++i) {
                String current_ds = datasets[i].trim();
                DataSetFiles new_dsf = new DataSetFiles();
                String temp = current_ds + "%" + DataSetFiles.class.getSimpleName() + "%GMTFileName";
                if (props.containsKey(current_ds + "%" + DataSetFiles.class.getSimpleName() + "%GMTFileName")) {
                    new_dsf.setGMTFileName(this.checkForNull(props, current_ds + "%" + DataSetFiles.class.getSimpleName() + "%GMTFileName"));
                }
                if (props.containsKey(current_ds + "%" + DataSetFiles.class.getSimpleName() + "%expressionFileName")) {
                    new_dsf.setExpressionFileName(this.checkForNull(props, current_ds + "%" + DataSetFiles.class.getSimpleName() + "%expressionFileName"));
                }
                if (props.containsKey(current_ds + "%" + DataSetFiles.class.getSimpleName() + "%enrichmentFileName1")) {
                    new_dsf.setEnrichmentFileName1(this.checkForNull(props, current_ds + "%" + DataSetFiles.class.getSimpleName() + "%enrichmentFileName1"));
                }
                if (props.containsKey(current_ds + "%" + DataSetFiles.class.getSimpleName() + "%enrichmentFileName2")) {
                    new_dsf.setEnrichmentFileName2(this.checkForNull(props, current_ds + "%" + DataSetFiles.class.getSimpleName() + "%enrichmentFileName2"));
                }
                if (props.containsKey(current_ds + "%" + DataSetFiles.class.getSimpleName() + "%gseaHtmlReportFileDataset")) {
                    new_dsf.setGseaHtmlReportFile(this.checkForNull(props, current_ds + "%" + DataSetFiles.class.getSimpleName() + "%gseaHtmlReportFileDataset"));
                }
                if (props.containsKey(current_ds + "%" + DataSetFiles.class.getSimpleName() + "%classFile")) {
                    new_dsf.setClassFile(this.checkForNull(props, current_ds + "%" + DataSetFiles.class.getSimpleName() + "%classFile"));
                }
                if (props.containsKey(current_ds + "%" + DataSetFiles.class.getSimpleName() + "%RankedFile")) {
                    new_dsf.setRankedFile(this.checkForNull(props, current_ds + "%" + DataSetFiles.class.getSimpleName() + "%RankedFile"));
                }
                this.files.put(current_ds, new_dsf);
            }
        }
    }

    public void populateFieldsFromRpt(File rptFile) {
        String filename;
        File temp;
        TextFileReader reader = new TextFileReader(rptFile.getAbsolutePath());
        reader.read();
        String fullText = reader.getText();
        HashMap<String, String> rpt = new HashMap<String, String>();
        String[] lines = fullText.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            String[] tokens = line.split("\t");
            if (tokens.length == 2) {
                rpt.put(tokens[0], tokens[1]);
                continue;
            }
            if (tokens.length != 3) continue;
            rpt.put(tokens[0] + " " + tokens[1], tokens[2]);
        }
        String timestamp = (String)rpt.get("producer_timestamp");
        String method = (String)rpt.get("producer_class");
        method = method.split("\\p{Punct}")[2];
        String out_dir = (String)rpt.get("param out");
        String job_dir_name = null;
        String data = (String)rpt.get("param res");
        String label = (String)rpt.get("param rpt_label");
        String classes = (String)rpt.get("param cls");
        String gmt = (String)rpt.get("param gmx");
        String gmt_nopath = gmt.substring(gmt.lastIndexOf(File.separator) + 1, gmt.length() - 1);
        String gseaHtmlReportFile = (String)rpt.get("file");
        String phenotype1 = "na";
        String phenotype2 = "na";
        if (classes != null && method.equalsIgnoreCase("Gsea")) {
            String[] classes_split = classes.split("#");
            String phenotypes = classes_split[1];
            String[] phenotypes_split = phenotypes.split("_versus_");
            phenotype1 = phenotypes_split[0];
            phenotype2 = phenotypes_split[1];
            this.getFiles().get("Dataset 1").setClassFile(classes_split[0]);
            this.getFiles().get("Dataset 1").setPhenotype1(phenotype1);
            this.getFiles().get("Dataset 1").setPhenotype2(phenotype2);
        } else if (method.equalsIgnoreCase("GseaPreranked")) {
            data = (String)rpt.get("param rnk");
            phenotype1 = "na_pos";
            phenotype2 = "na_neg";
            this.getFiles().get("Dataset 1").setPhenotype1(phenotype1);
            this.getFiles().get("Dataset 1").setPhenotype2(phenotype2);
            if (rpt.containsKey("param phenotypes")) {
                String phenotypes = (String)rpt.get("param phenotypes");
                String[] phenotypes_split = phenotypes.split("_versus_");
                this.getFiles().get("Dataset 1").setPhenotype1(phenotypes_split[0]);
                this.getFiles().get("Dataset 1").setPhenotype2(phenotypes_split[1]);
            }
            if (rpt.containsKey("param expressionMatrix")) {
                data = (String)rpt.get("param expressionMatrix");
            }
        } else {
            System.out.println("The class field in the rpt file has been modified or doesn't specify a class file\n but the analysis is a classic GSEA not PreRanked.  ");
        }
        String results1 = "";
        String results2 = "";
        String ranks = "";
        job_dir_name = label + "." + method + "." + timestamp;
        results1 = "" + out_dir + File.separator + job_dir_name + File.separator + "gsea_report_for_" + phenotype1 + "_" + timestamp + ".xls";
        results2 = "" + out_dir + File.separator + job_dir_name + File.separator + "gsea_report_for_" + phenotype2 + "_" + timestamp + ".xls";
        ranks = "" + out_dir + File.separator + job_dir_name + File.separator + "ranked_gene_list_" + phenotype1 + "_versus_" + phenotype2 + "_" + timestamp + ".xls";
        if (!(new File(results1).exists() && new File(results2).exists() && new File(ranks).exists())) {
            String out_dir_new = rptFile.getAbsolutePath();
            out_dir_new = out_dir_new.substring(0, out_dir_new.lastIndexOf(File.separator));
            if (!(out_dir_new = out_dir_new.substring(0, out_dir_new.lastIndexOf(File.separator))).equalsIgnoreCase(out_dir)) {
                results1 = out_dir_new + File.separator + job_dir_name + File.separator + "gsea_report_for_" + phenotype1 + "_" + timestamp + ".xls";
                results2 = out_dir_new + File.separator + job_dir_name + File.separator + "gsea_report_for_" + phenotype2 + "_" + timestamp + ".xls";
                ranks = out_dir_new + File.separator + job_dir_name + File.separator + "ranked_gene_list_" + phenotype1 + "_versus_" + phenotype2 + "_" + timestamp + ".xls";
                if (!(new File(results1).exists() && new File(results2).exists() && new File(ranks).exists())) {
                    results1 = "" + out_dir + File.separator + job_dir_name + File.separator + label + "." + method + "." + timestamp + File.separator + "gsea_report_for_" + phenotype1 + "_" + timestamp + ".xls";
                    results2 = "" + out_dir + File.separator + job_dir_name + File.separator + label + "." + method + "." + timestamp + File.separator + "gsea_report_for_" + phenotype2 + "_" + timestamp + ".xls";
                    ranks = "" + out_dir + File.separator + job_dir_name + File.separator + label + "." + method + "." + timestamp + File.separator + "ranked_gene_list_" + phenotype1 + "_versus_" + phenotype2 + "_" + timestamp + ".xls";
                } else {
                    out_dir = out_dir_new;
                    gseaHtmlReportFile = "" + out_dir + File.separator + job_dir_name + File.separator + "index.html";
                }
            }
        }
        if (this.getGMTDirName() != null) {
            temp = new File(gmt);
            filename = temp.getName();
            gmt = this.getGMTDirName() + File.separator + filename;
        }
        if (this.getGCTDirName() != null) {
            temp = new File(data);
            filename = temp.getName();
            data = this.getGCTDirName() + File.separator + filename;
        }
        this.getFiles().get("Dataset 1").setGMTFileName(gmt);
        this.getFiles().get("Dataset 1").setExpressionFileName(data);
        this.setData(true);
        this.getFiles().get("Dataset 1").setRankedFile(ranks);
        this.getFiles().get("Dataset 1").setEnrichmentFileName1(results1);
        this.getFiles().get("Dataset 1").setEnrichmentFileName2(results2);
        this.getFiles().get("Dataset 1").setGseaHtmlReportFile(gseaHtmlReportFile);
    }

    public void copyInputParameters(EnrichmentMapParameters copy) {
        if (copy.isBulkEM()) {
            this.BulkEM = copy.isBulkEM();
        }
        for (String ds : copy.getFiles().keySet()) {
            DataSetFiles new_ds = new DataSetFiles();
            new_ds.copy(copy.getFiles().get(ds));
            this.files.put(ds, new_ds);
        }
        this.pvalue = copy.getPvalue();
        this.pvalueSlider = new SliderBarPanel(0.0, this.pvalue, "P-value Cutoff", this, EnrichmentMapVisualStyle.PVALUE_DATASET1, EnrichmentMapVisualStyle.PVALUE_DATASET2, ParametersPanel.summaryPanelWidth, false, this.pvalue);
        this.qvalue = copy.getQvalue();
        this.qvalueSlider = new SliderBarPanel(0.0, this.qvalue, "Q-value Cutoff", this, EnrichmentMapVisualStyle.FDR_QVALUE_DATASET1, EnrichmentMapVisualStyle.FDR_QVALUE_DATASET2, ParametersPanel.summaryPanelWidth, false, this.qvalue);
        this.similarityCutOff = copy.getSimilarityCutOff();
        this.similaritySlider = new SliderBarPanel(this.similarityCutOff, 1.0, "Similarity Cutoff", this, EnrichmentMapVisualStyle.SIMILARITY_COEFFECIENT, EnrichmentMapVisualStyle.SIMILARITY_COEFFECIENT, ParametersPanel.summaryPanelWidth, true, this.similarityCutOff);
        this.Data = copy.isData();
        this.Data2 = copy.isData2();
        this.twoDatasets = copy.isTwoDatasets();
        this.method = copy.getMethod();
        this.similarityMetric = copy.getSimilarityMetric();
        this.FDR = copy.isFDR();
        this.GMTDirName = copy.getGMTDirName();
        this.GCTDirName = copy.getGCTDirName();
        this.GSEAResultsDirName = copy.getGSEAResultsDirName();
        this.upperlimit = copy.getUpperlimit();
        this.lowerlimit = copy.getLowerlimit();
    }

    public void copy(EnrichmentMapParameters copy) {
        for (String ds : copy.getFiles().keySet()) {
            DataSetFiles new_ds = new DataSetFiles();
            new_ds.copy(copy.getFiles().get(ds));
            this.files.put(ds, new_ds);
        }
        this.pvalue = copy.getPvalue();
        this.pvalueSlider = copy.getPvalueSlider();
        this.qvalue = copy.getQvalue();
        this.qvalueSlider = copy.getQvalueSlider();
        this.similarityCutOff = copy.getSimilarityCutOff();
        this.similaritySlider = copy.getSimilaritySlider();
        this.Data = copy.isData();
        this.Data2 = copy.isData2();
        this.twoDatasets = copy.isTwoDatasets();
        this.method = copy.getMethod();
        this.FDR = copy.isFDR();
        this.similarityMetric = copy.getSimilarityMetric();
        this.combinedConstant = copy.getCombinedConstant();
        this.twoDistinctExpressionSets = copy.isTwoDistinctExpressionSets();
        this.selectedEdges = copy.getSelectedEdges();
        this.selectedNodes = copy.getSelectedNodes();
        this.hmParams = copy.getHmParams();
        this.enrichment_edge_type = copy.getEnrichment_edge_type();
        this.GMTDirName = copy.getGMTDirName();
        this.GCTDirName = copy.getGCTDirName();
        this.GSEAResultsDirName = copy.getGSEAResultsDirName();
        this.upperlimit = copy.getUpperlimit();
        this.lowerlimit = copy.getLowerlimit();
        this.EMgmt = copy.isEMgmt();
        this.attributePrefix = copy.getAttributePrefix();
    }

    public String checkMinimalRequirements() {
        String errors = "";
        for (String ds : this.getFiles().keySet()) {
            DataSetFiles dsFiles = this.getFiles().get(ds);
            if (!(dsFiles.getEnrichmentFileName1() != null && !dsFiles.getEnrichmentFileName1().equalsIgnoreCase("") || dsFiles.getEnrichmentFileName2() != null && !dsFiles.getEnrichmentFileName2().equalsIgnoreCase("") || dsFiles.getGMTFileName() == null || dsFiles.getGMTFileName().equalsIgnoreCase(""))) {
                errors = "GMTONLY";
                continue;
            }
            if (dsFiles.getEnrichmentFileName1() == null || dsFiles.getEnrichmentFileName1().equalsIgnoreCase("") || !this.checkFile(dsFiles.getEnrichmentFileName1())) {
                errors = errors + "Dataset 1, enrichment file 1 can not be found\n";
            }
            if (!(this.method.equalsIgnoreCase(method_DAVID) || dsFiles.getGMTFileName() != null && !dsFiles.getGMTFileName().equalsIgnoreCase("") && this.checkFile(dsFiles.getGMTFileName()))) {
                errors = errors + "GMT file can not be found \n";
            }
            if (!this.method.equalsIgnoreCase(method_GSEA) || dsFiles.getEnrichmentFileName2() == null || !dsFiles.getEnrichmentFileName2().equalsIgnoreCase("") && this.checkFile(dsFiles.getEnrichmentFileName2())) continue;
            errors = errors + "Dataset 1, enrichment file 2 can not be found\n";
        }
        if (this.twoDatasets && this.method.equalsIgnoreCase(method_DAVID) && this.files.get("Dataset 1").getExpressionFileName() != null && this.files.get("Dataset 2").getExpressionFileName() != null) {
            this.setTwoDistinctExpressionSets(true);
        }
        return errors;
    }

    protected boolean checkFile(String filename) {
        File tempfile;
        return filename == null || (tempfile = new File(filename)).canRead();
    }

    public String toString() {
        StringBuffer paramVariables = new StringBuffer();
        paramVariables.append("enrichment_edge_type\t" + this.enrichment_edge_type + "\n");
        paramVariables.append("attributePrefix\t" + this.attributePrefix + "\n");
        paramVariables.append("method\t" + this.method + "\n");
        paramVariables.append("twoDatasets\t" + this.twoDatasets + "\n");
        paramVariables.append("jaccard\t" + this.similarityMetric + "\n");
        paramVariables.append("CombinedConstant" + this.combinedConstant + "\n");
        paramVariables.append("Data\t" + this.Data + "\n");
        paramVariables.append("Data2\t" + this.Data2 + "\n");
        paramVariables.append("FDR\t" + this.FDR + "\n");
        paramVariables.append("pvalue\t" + this.pvalue + "\n");
        paramVariables.append("qvalue\t" + this.qvalue + "\n");
        paramVariables.append("similarityCutOff\t" + this.similarityCutOff + "\n");
        for (String ds : this.files.keySet()) {
            paramVariables.append(this.files.get(ds).toString(ds));
        }
        return paramVariables.toString();
    }

    public String printHashmap(HashMap map) {
        StringBuffer result = new StringBuffer();
        if (map != null) {
            for (Object key : map.keySet()) {
                result.append(key.toString() + "\t" + map.get(key).toString() + "\n");
            }
            return result.toString();
        }
        return null;
    }

    public HashMap repopulateHashmap(String fileInput, int type) {
        String[] tokens;
        String line;
        int i;
        HashMap<Object, Object> newMap;
        boolean incrementRank = false;
        String[] lines = fileInput.split("\n");
        if (type == 1) {
            newMap = new HashMap<Object, Object>();
        } else if (type == 2) {
            newMap = new HashMap();
        } else if (type == 3) {
            newMap = new HashMap();
        } else if (type == 4) {
            newMap = new HashMap();
        } else if (type == 5) {
            newMap = new HashMap();
        } else if (type == 6) {
            newMap = new HashMap();
            for (i = 0; i < lines.length; ++i) {
                line = lines[i];
                tokens = line.split("\t");
                if (Integer.parseInt(tokens[3]) >= 0) continue;
                incrementRank = true;
            }
        } else {
            newMap = type == 7 ? new HashMap() : new HashMap();
        }
        for (i = 0; i < lines.length; ++i) {
            line = lines[i];
            tokens = line.split("\t");
            if (type == 1 && tokens.length >= 3) {
                newMap.put(tokens[0], new GeneSet(tokens));
            }
            if (type == 2) {
                if (tokens.length > 1) {
                    newMap.put(tokens[0], Integer.parseInt(tokens[1]));
                } else {
                    System.out.println(tokens.toString());
                }
            }
            if (type == 3) {
                newMap.put(tokens[0], new GSEAResult(tokens));
            }
            if (type == 4 && tokens.length > 3) {
                newMap.put(tokens[0], new GenericResult(tokens));
            }
            if (type == 5) {
                if (tokens.length > 1) {
                    newMap.put(Integer.parseInt(tokens[0]), tokens[1]);
                } else {
                    System.out.println(tokens.toString());
                }
            }
            if (type == 6) {
                if (incrementRank) {
                    Integer newRank = Integer.parseInt(tokens[3]) + 1;
                    tokens[3] = newRank.toString();
                }
                newMap.put(Integer.parseInt(tokens[0]), new Rank(tokens));
            }
            if (type != 7) continue;
            newMap.put(Integer.parseInt(tokens[0]), Integer.parseInt(tokens[1]));
        }
        return newMap;
    }

    public String getSimilarityMetric() {
        return this.similarityMetric;
    }

    public String getAttributePrefix() {
        return this.attributePrefix;
    }

    public void setAttributePrefix() {
        Set networks = Cytoscape.getNetworkSet();
        if (networks == null || networks.isEmpty()) {
            this.attributePrefix = "EM1_";
        } else {
            int num_networks = 1;
            int max_prefix = 0;
            EnrichmentMapManager manager = EnrichmentMapManager.getInstance();
            for (CyNetwork current_network : networks) {
                String networkId = current_network.getIdentifier();
                if (!manager.isEnrichmentMap(networkId)) continue;
                ++num_networks;
                EnrichmentMap tmpMap = manager.getMap(networkId);
                String tmpPrefix = tmpMap.getParams().getAttributePrefix();
                tmpPrefix = tmpPrefix.replace("EM", "");
                int tmpNum = Integer.parseInt(tmpPrefix = tmpPrefix.replace("_", ""));
                if (tmpNum <= max_prefix) continue;
                max_prefix = tmpNum;
            }
            this.attributePrefix = "EM" + (max_prefix + 1) + "_";
        }
    }

    public void setAttributePrefix(String attributePrefix) {
        this.attributePrefix = attributePrefix;
    }

    public void setSimilarityMetric(String similarityMetric) {
        this.similarityMetric = similarityMetric;
    }

    public double getPvalue() {
        return this.pvalue;
    }

    public void setPvalue(double pvalue) {
        this.pvalue = pvalue;
    }

    public double getQvalue() {
        return this.qvalue;
    }

    public void setQvalue(double qvalue) {
        this.qvalue = qvalue;
    }

    public double getSimilarityCutOff() {
        return this.similarityCutOff;
    }

    public void setSimilarityCutOff(double similarityCutOff) {
        this.similarityCutOff = similarityCutOff;
    }

    public boolean isTwoDatasets() {
        return this.twoDatasets;
    }

    public void setTwoDatasets(boolean twoDatasets) {
        this.twoDatasets = twoDatasets;
    }

    public boolean isData() {
        return this.Data;
    }

    public void setData(boolean data) {
        this.Data = data;
    }

    public boolean isData2() {
        return this.Data2;
    }

    public void setData2(boolean data2) {
        this.Data2 = data2;
    }

    public boolean isFDR() {
        return this.FDR;
    }

    public void setFDR(boolean FDR) {
        this.FDR = FDR;
    }

    public SliderBarPanel getPvalueSlider() {
        return this.pvalueSlider;
    }

    public SliderBarPanel getQvalueSlider() {
        return this.qvalueSlider;
    }

    public SliderBarPanel getSimilaritySlider() {
        return this.similaritySlider;
    }

    public ArrayList<Node> getSelectedNodes() {
        return this.selectedNodes;
    }

    public ArrayList<Edge> getSelectedEdges() {
        return this.selectedEdges;
    }

    public void setSelectedNodes(ArrayList<Node> selectedNodes) {
        this.selectedNodes = selectedNodes;
    }

    public void setSelectedEdges(ArrayList<Edge> selectedEdges) {
        this.selectedEdges = selectedEdges;
    }

    public HeatMapParameters getHmParams() {
        return this.hmParams;
    }

    public void setHmParams(HeatMapParameters hmParams) {
        this.hmParams = hmParams;
    }

    public HashMap<Integer, Integer> getRank2geneDataset(HashMap<Integer, Rank> gene2rank) {
        HashMap<Integer, Integer> rank2gene = new HashMap<Integer, Integer>();
        for (Integer cur : gene2rank.keySet()) {
            rank2gene.put(gene2rank.get(cur).getRank(), cur);
        }
        return rank2gene;
    }

    public void setDefaultJaccardCutOff(double defaultJaccardCutOff) {
        this.defaultJaccardCutOff = defaultJaccardCutOff;
    }

    public double getDefaultJaccardCutOff() {
        return this.defaultJaccardCutOff;
    }

    public void setDefaultOverlapCutOff(double defaultOverlapCutOff) {
        this.defaultOverlapCutOff = defaultOverlapCutOff;
    }

    public double getDefaultOverlapCutOff() {
        return this.defaultOverlapCutOff;
    }

    public boolean isDisableHeatmapAutofocus() {
        return this.disable_heatmap_autofocus;
    }

    public void setDisableHeatmapAutofocus(boolean disable_heatmap_autofocus) {
        this.disable_heatmap_autofocus = disable_heatmap_autofocus;
    }

    public String getDefaultSortMethod() {
        return this.defaultSortMethod;
    }

    public void setDefaultSortMethod(String defaultSortMethod) {
        this.defaultSortMethod = defaultSortMethod;
        this.cyto_prop = CytoscapeInit.getProperties();
        this.cyto_prop.setProperty("EnrichmentMap.default_sort_method", defaultSortMethod);
    }

    public void setEnrichment_edge_type(String enrichment_edge_type) {
        this.enrichment_edge_type = enrichment_edge_type;
    }

    public String getEnrichment_edge_type() {
        return this.enrichment_edge_type;
    }

    public String getDefaultDistanceMetric() {
        return this.defaultDistanceMetric;
    }

    public void setDefaultDistanceMetric(String defaultDistanceMetric) {
        this.defaultDistanceMetric = defaultDistanceMetric;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public boolean isTwoDistinctExpressionSets() {
        return this.twoDistinctExpressionSets;
    }

    public String getGMTDirName() {
        return this.GMTDirName;
    }

    public void setTwoDistinctExpressionSets(boolean twoDistinctExpressionSets) {
        this.twoDistinctExpressionSets = twoDistinctExpressionSets;
    }

    public void setGMTDirName(String GMTDirName) {
        this.GMTDirName = GMTDirName;
    }

    public String getGCTDirName() {
        return this.GCTDirName;
    }

    public void setGCTDirName(String GCTDirName) {
        this.GCTDirName = GCTDirName;
    }

    public int getLowerlimit() {
        return this.lowerlimit;
    }

    public void setLowerlimit(int lowerlimit) {
        this.lowerlimit = lowerlimit;
    }

    public int getUpperlimit() {
        return this.upperlimit;
    }

    public void setUpperlimit(int upperlimit) {
        this.upperlimit = upperlimit;
    }

    public String getGSEAResultsDirName() {
        return this.GSEAResultsDirName;
    }

    public void setGSEAResultsDirName(String GSEAResultsDirName) {
        this.GSEAResultsDirName = GSEAResultsDirName;
    }

    public double getCombinedConstant() {
        return this.combinedConstant;
    }

    public void setCombinedConstant(double combinedConstant) {
        this.combinedConstant = combinedConstant;
    }

    public boolean isBulkEM() {
        return this.BulkEM;
    }

    public void setBulkEM(boolean bulkEM) {
        this.BulkEM = bulkEM;
    }

    public boolean isEMgmt() {
        return this.EMgmt;
    }

    public void setEMgmt(boolean flag) {
        this.EMgmt = flag;
    }

    public String getGMTFileName() {
        String gmt = "";
        for (String current : this.files.keySet()) {
            if (gmt == null || gmt.equalsIgnoreCase("")) {
                gmt = this.files.get(current).getGMTFileName();
                continue;
            }
            if (gmt.equalsIgnoreCase(this.files.get(current).getGMTFileName())) continue;
            gmt = null;
        }
        return gmt;
    }

    public void setGMTFileName(String name) {
        this.files.get("Dataset 1").setGMTFileName(name);
    }

    public HashMap<String, String> getProps() {
        return this.props;
    }

    public void setProps(HashMap<String, String> props) {
        this.props = props;
    }

    public HashMap<String, DataSetFiles> getFiles() {
        return this.files;
    }

    public void setFiles(HashMap<String, DataSetFiles> files) {
        this.files = files;
    }

    public void addFiles(String name, DataSetFiles files) {
        this.files.put(name, files);
    }

    public boolean isSessions() {
        return this.sessions;
    }

    public void setSessions(boolean sessions) {
        this.sessions = sessions;
    }
}

