/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.parsers;

import cytoscape.data.readers.TextFileReader;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import org.baderlab.csplugins.enrichmentmap.model.DataSet;
import org.baderlab.csplugins.enrichmentmap.model.GeneExpression;
import org.baderlab.csplugins.enrichmentmap.model.GeneExpressionMatrix;

public class ExpressionFileReaderTask
implements Task {
    private String expressionFileName;
    private DataSet dataset;
    private int maxValue;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;

    public ExpressionFileReaderTask(DataSet dataset, TaskMonitor taskMonitor) {
        this(dataset);
        this.taskMonitor = taskMonitor;
    }

    public ExpressionFileReaderTask(DataSet dataset) {
        this.dataset = dataset;
        if (dataset.getExpressionSets() != null) {
            this.expressionFileName = dataset.getExpressionSets().getFilename();
        }
    }

    public void parse() {
        if (this.expressionFileName == null || this.expressionFileName.isEmpty()) {
            this.createDummyExpressionFile();
        } else {
            boolean twoColumns = false;
            HashSet<Integer> datasetGenes = this.dataset.getDatasetGenes();
            HashMap<String, Integer> genes = this.dataset.getMap().getGenes();
            TextFileReader reader = new TextFileReader(this.expressionFileName);
            reader.read();
            String fullText = reader.getText();
            String[] lines = fullText.split("\n");
            int currentProgress = 0;
            this.maxValue = lines.length;
            if (lines.length <= 1) {
                this.createDummyExpressionFile();
                lines = new String[]{};
            }
            GeneExpressionMatrix expressionMatrix = this.dataset.getExpressionSets();
            HashMap<Integer, GeneExpression> expression = expressionMatrix.getExpressionMatrix();
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                String[] tokens = line.split("\t");
                String Name = tokens[0].toUpperCase().trim();
                if (i == 0 && (expressionMatrix == null || expressionMatrix.getExpressionMatrix().isEmpty()) && expressionMatrix.getColumnNames() == null) {
                    if (Name.equalsIgnoreCase("#1.2")) {
                        line = lines[2];
                        i = 2;
                    } else {
                        line = lines[0];
                        int k = 0;
                        while (line.startsWith("#")) {
                            line = lines[++k];
                        }
                        i = k;
                    }
                    tokens = line.split("\t");
                    if (tokens.length == 2) {
                        twoColumns = true;
                        try {
                            int temp = Integer.parseInt(tokens[1]);
                            i = -1;
                            tokens[0] = "Name";
                            tokens[1] = "Rank/Score";
                        }
                        catch (NumberFormatException v) {
                            try {
                                double temp2 = Double.parseDouble(tokens[1]);
                                i = -1;
                                tokens[0] = "Name";
                                tokens[1] = "Rank/Score";
                            }
                            catch (NumberFormatException v2) {
                                // empty catch block
                            }
                        }
                    }
                    expressionMatrix.setColumnNames(tokens);
                    expressionMatrix.setNumConditions(tokens.length);
                    expressionMatrix.setExpressionMatrix(expression);
                    if (!tokens[tokens.length - 1].equalsIgnoreCase("Dummy Expression")) continue;
                    this.createDummyExpressionFile();
                    break;
                }
                if (genes.containsKey(Name)) {
                    double newMin;
                    Integer genekey = genes.get(Name);
                    datasetGenes.add(genes.get(Name));
                    String description = "";
                    if (twoColumns) {
                        try {
                            Double.parseDouble(tokens[1]);
                        }
                        catch (NumberFormatException e) {
                            description = tokens[1];
                        }
                    } else {
                        description = tokens[1];
                    }
                    GeneExpression expres = new GeneExpression(Name, description);
                    expres.setExpression(tokens);
                    double newMax = expres.newMax(expressionMatrix.getMaxExpression());
                    if (newMax != -100.0) {
                        expressionMatrix.setMaxExpression(newMax);
                    }
                    if ((newMin = expres.newMin(expressionMatrix.getMinExpression())) != -100.0) {
                        expressionMatrix.setMinExpression(newMin);
                    }
                    expression.put(genekey, expres);
                }
                int percentComplete = (int)((double)currentProgress / (double)this.maxValue * 100.0);
                long timeRemaining = this.maxValue - currentProgress;
                if (this.taskMonitor != null) {
                    this.taskMonitor.setPercentCompleted(percentComplete);
                    this.taskMonitor.setStatus("Parsing GCT file " + currentProgress + " of " + this.maxValue);
                    this.taskMonitor.setEstimatedTimeRemaining(timeRemaining);
                }
                ++currentProgress;
            }
            expressionMatrix.setNumGenes(expressionMatrix.getExpressionMatrix().size());
            expressionMatrix.rowNormalizeMatrix();
        }
    }

    private String[] setClasses(String classFile) {
        File f = new File(classFile);
        if (!f.exists()) {
            return null;
        }
        if (!classFile.equalsIgnoreCase(null)) {
            TextFileReader reader2 = new TextFileReader(classFile);
            reader2.read();
            String fullText2 = reader2.getText();
            String[] lines2 = fullText2.split("\n");
            String[] classes = lines2[2].split("\\s");
            return classes;
        }
        String[] def_pheno = new String[]{"Na_pos", "NA_neg"};
        return def_pheno;
    }

    private void createDummyExpressionFile() {
        HashMap<String, Integer> genes = this.dataset.getMap().getGenesetsGenes(this.dataset.getSetofgenesets().getGenesets());
        HashSet<Integer> datasetGenes = this.dataset.getDatasetGenes();
        String[] titletokens = new String[]{"Name", "Description", "Dummy Expression"};
        GeneExpressionMatrix expressionMatrix = this.dataset.getExpressionSets();
        expressionMatrix.setColumnNames(titletokens);
        HashMap<Integer, GeneExpression> expression = expressionMatrix.getExpressionMatrix();
        expressionMatrix.setExpressionMatrix(expression);
        expressionMatrix.setFilename(this.dataset.getName() + "_DummyExpression.txt");
        String[] tokens = new String[]{"tmp", "tmp", "0.25"};
        for (String currentGene : genes.keySet()) {
            double newMin;
            int genekey = genes.get(currentGene);
            if (datasetGenes != null) {
                datasetGenes.add(genekey);
            }
            GeneExpression expres = new GeneExpression(currentGene, currentGene);
            expres.setExpression(tokens);
            double newMax = expres.newMax(expressionMatrix.getMaxExpression());
            if (newMax != -100.0) {
                expressionMatrix.setMaxExpression(newMax);
            }
            if ((newMin = expres.newMin(expressionMatrix.getMinExpression())) != -100.0) {
                expressionMatrix.setMinExpression(newMin);
            }
            expression.put(genekey, expres);
        }
        expressionMatrix.setNumGenes(expressionMatrix.getExpressionMatrix().size());
        expressionMatrix.setNumConditions(3);
        this.dataset.getMap().getParams().setData(true);
    }

    public void run() {
        this.parse();
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Parsing GCT file");
    }
}

