/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.actions;

import java.awt.Component;
import java.util.List;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapUtils;
import org.baderlab.csplugins.enrichmentmap.heatmap.HeatMapParameters;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.view.HeatMapPanel;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.application.swing.CytoPanelState;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.model.events.RowsSetListener;
import org.cytoscape.util.swing.FileUtil;

public class EnrichmentMapActionListener
implements RowsSetListener {
    private EnrichmentMap map;
    private HeatMapPanel edgeOverlapPanel;
    private HeatMapPanel nodeOverlapPanel;
    private List<CyNode> Nodes;
    private List<CyEdge> Edges;
    private CyApplicationManager applicationManager;
    private final CytoPanel cytoPanelSouth;
    private FileUtil fileUtil;
    private StreamUtil streamUtil;

    public EnrichmentMapActionListener(HeatMapPanel heatMapPanel_node, HeatMapPanel heatMapPanel_edge, CyApplicationManager applicationManager, CySwingApplication application, FileUtil fileUtil, StreamUtil streamUtil) {
        this.applicationManager = applicationManager;
        this.fileUtil = fileUtil;
        this.streamUtil = streamUtil;
        this.edgeOverlapPanel = heatMapPanel_edge;
        this.nodeOverlapPanel = heatMapPanel_node;
        this.cytoPanelSouth = application.getCytoPanel(CytoPanelName.SOUTH);
    }

    private void initialize(CyNetwork network) {
        EnrichmentMapManager manager = EnrichmentMapManager.getInstance();
        this.map = manager.getMap(network.getSUID());
        if (this.map.getParams().isData()) {
            HeatMapParameters hmParams = new HeatMapParameters(this.edgeOverlapPanel, this.nodeOverlapPanel, this.fileUtil, this.streamUtil);
            hmParams.initColorGradients(this.map.getDataset("Dataset 1").getExpressionSets());
            this.map.getParams().setHmParams(hmParams);
        }
        this.Nodes = this.map.getParams().getSelectedNodes();
        this.Edges = this.map.getParams().getSelectedEdges();
    }

    public void handleEvent(RowsSetEvent e) {
        boolean override_revalidate_heatmap = EnrichmentMapUtils.isOverrideHeatmapRevalidation();
        CyNetwork network = this.applicationManager.getCurrentNetwork();
        if (e.getSource() == network.getDefaultEdgeTable() || e.getSource() == network.getDefaultNodeTable()) {
            this.initialize(network);
            if (!override_revalidate_heatmap) {
                List selectedEdges = CyTableUtil.getEdgesInState((CyNetwork)network, (String)"selected", (boolean)true);
                this.Edges.clear();
                this.Edges.addAll(selectedEdges);
                if (this.Edges.size() > 0) {
                    this.createEdgesData();
                }
                List selectedNodes = CyTableUtil.getNodesInState((CyNetwork)network, (String)"selected", (boolean)true);
                this.Nodes.clear();
                this.Nodes.addAll(selectedNodes);
                if (this.Nodes.size() > 0) {
                    this.createNodesData();
                }
                if (this.Nodes.isEmpty() && this.Edges.isEmpty()) {
                    this.clearPanels();
                }
            }
        }
    }

    public void createEdgesData() {
        if (this.map.getParams().isData()) {
            this.edgeOverlapPanel.updatePanel(this.map);
            if (!this.map.getParams().isDisableHeatmapAutofocus()) {
                int index;
                if (this.cytoPanelSouth.getState() == CytoPanelState.HIDE) {
                    this.cytoPanelSouth.setState(CytoPanelState.DOCK);
                }
                if ((index = this.cytoPanelSouth.indexOfComponent((Component)this.edgeOverlapPanel)) == -1) {
                    return;
                }
                this.cytoPanelSouth.setSelectedIndex(index);
            }
            this.edgeOverlapPanel.revalidate();
        }
    }

    private void createNodesData() {
        if (this.map.getParams().isData()) {
            this.nodeOverlapPanel.updatePanel(this.map);
            if (!this.map.getParams().isDisableHeatmapAutofocus()) {
                int index;
                if (this.cytoPanelSouth.getState() == CytoPanelState.HIDE) {
                    this.cytoPanelSouth.setState(CytoPanelState.DOCK);
                }
                if ((index = this.cytoPanelSouth.indexOfComponent((Component)this.nodeOverlapPanel)) == -1) {
                    return;
                }
                this.cytoPanelSouth.setSelectedIndex(index);
            }
            this.nodeOverlapPanel.revalidate();
        }
    }

    public void clearPanels() {
        if (this.map.getParams().isData()) {
            this.nodeOverlapPanel.clearPanel();
            this.edgeOverlapPanel.clearPanel();
            if (!this.map.getParams().isDisableHeatmapAutofocus()) {
                this.cytoPanelSouth.setSelectedIndex(this.cytoPanelSouth.indexOfComponent((Component)this.nodeOverlapPanel));
                this.cytoPanelSouth.setSelectedIndex(this.cytoPanelSouth.indexOfComponent((Component)this.edgeOverlapPanel));
            }
        }
    }
}

