/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import java.awt.Color;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.NodeShapeVisualProperty;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.mappings.BoundaryRangeValues;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;
import org.cytoscape.view.vizmap.mappings.DiscreteMapping;
import org.cytoscape.view.vizmap.mappings.PassthroughMapping;

public class EnrichmentMapVisualStyle {
    private EnrichmentMapParameters params;
    private VisualMappingFunctionFactory vmfFactoryContinuous;
    private VisualMappingFunctionFactory vmfFactoryDiscrete;
    private VisualMappingFunctionFactory vmfFactoryPassthrough;
    public static final int maxNodeLabelLength = 15;
    public static String NAME = "Name";
    public static String GS_DESCR = "GS_DESCR";
    public static String FORMATTED_NAME = "Formatted_name";
    public static String GS_SOURCE = "GS_Source";
    public static String GENES = "Genes";
    public static String ENR_GENES = "Enrichment_Genes";
    public static String GS_TYPE = "GS_Type";
    public static String ES_DATASET1 = "ES_dataset1";
    public static String NES_DATASET1 = "NES_dataset1";
    public static String GS_SIZE_DATASET1 = "gs_size_dataset1";
    public static String PVALUE_DATASET1 = "pvalue_dataset1";
    public static String FDR_QVALUE_DATASET1 = "fdr_qvalue_dataset1";
    public static String FWER_QVALUE_DATASET1 = "fwer_qvalue_dataset1";
    public static String COLOURING_DATASET1 = "Colouring_dataset1";
    public static String ES_DATASET2 = "ES_dataset2";
    public static String NES_DATASET2 = "NES_dataset2";
    public static String GS_SIZE_DATASET2 = "gs_size_dataset2";
    public static String PVALUE_DATASET2 = "pvalue_dataset2";
    public static String FDR_QVALUE_DATASET2 = "fdr_qvalue_dataset2";
    public static String FWER_QVALUE_DATASET2 = "fwer_qvalue_dataset2";
    public static String COLOURING_DATASET2 = "Colouring_dataset2";
    public static String GS_SIZE_SIGNATURE = "gs_size_signature";
    public static String GS_TYPE_ENRICHMENT = "ENR";
    public static String GS_TYPE_SIGNATURE = "SIG";
    public static String OVERLAP_SIZE = "Overlap_size";
    public static String SIMILARITY_COEFFECIENT = "similarity_coefficient";
    public static String OVERLAP_GENES = "Overlap_genes";
    public static String HYPERGEOM_PVALUE = "Overlap_Hypergeom_pVal";
    public static String ENRICHMENT_SET = "ENRICHMENT_SET";
    public static String HYPERGEOM_N = "HyperGeom_N_Universe";
    public static String HYPERGEOM_n = "HyperGeom_n_Sig_Universe";
    public static String HYPERGEOM_k = "k_Intersection";
    public static String HYPERGEOM_m = "m_Enr_Genes";
    public static String NUMBER_OF_ENRICHMENT_GENES = "# of Enrichment Genes";
    public static String NETW_REPORT1_DIR = "GSEA_Report_Dataset1_folder";
    public static String NETW_REPORT2_DIR = "GSEA_Report_Dataset2_folder";
    public static Color max_phenotype1 = new Color(255, 0, 0);
    public static Color lighter_phenotype1 = new Color(255, 102, 102);
    public static Color lightest_phenotype1 = new Color(255, 179, 179);
    public static Color max_phenotype2 = new Color(0, 100, 255);
    public static Color lighter_phenotype2 = new Color(102, 162, 255);
    public static Color lightest_phenotype2 = new Color(179, 208, 255);
    public static Color overColor = Color.WHITE;

    public EnrichmentMapVisualStyle(EnrichmentMapParameters params, VisualMappingFunctionFactory vmfFactoryContinuous, VisualMappingFunctionFactory vmfFactoryDiscrete, VisualMappingFunctionFactory vmfFactoryPassthrough) {
        this.params = params;
        this.vmfFactoryContinuous = vmfFactoryContinuous;
        this.vmfFactoryDiscrete = vmfFactoryDiscrete;
        this.vmfFactoryPassthrough = vmfFactoryPassthrough;
    }

    public VisualStyle createVisualStyle(VisualStyle vs, String prefix) {
        vs.setDefaultValue(BasicVisualLexicon.NETWORK_BACKGROUND_PAINT, (Object)new Color(205, 205, 235));
        vs = this.createEdgeAppearance(vs, prefix);
        vs = this.createNodeAppearance(vs, prefix);
        return vs;
    }

    private VisualStyle createEdgeAppearance(VisualStyle vs, String prefix) {
        DiscreteMapping disMapping_edge2 = (DiscreteMapping)this.vmfFactoryDiscrete.createVisualMappingFunction(prefix + ENRICHMENT_SET, Integer.class, BasicVisualLexicon.EDGE_UNSELECTED_PAINT);
        disMapping_edge2.putMapValue((Object)new Integer(0), (Object)new Color(100, 200, 0));
        disMapping_edge2.putMapValue((Object)new Integer(1), (Object)new Color(100, 200, 0));
        disMapping_edge2.putMapValue((Object)new Integer(2), (Object)new Color(100, 149, 237));
        vs.addVisualMappingFunction((VisualMappingFunction)disMapping_edge2);
        DiscreteMapping disMapping_edge4 = (DiscreteMapping)this.vmfFactoryDiscrete.createVisualMappingFunction(prefix + ENRICHMENT_SET, Integer.class, BasicVisualLexicon.EDGE_STROKE_UNSELECTED_PAINT);
        disMapping_edge4.putMapValue((Object)new Integer(0), (Object)new Color(100, 200, 0));
        disMapping_edge4.putMapValue((Object)new Integer(1), (Object)new Color(100, 200, 0));
        disMapping_edge4.putMapValue((Object)new Integer(2), (Object)new Color(100, 149, 237));
        vs.addVisualMappingFunction((VisualMappingFunction)disMapping_edge4);
        ContinuousMapping conmapping_edgewidth = (ContinuousMapping)this.vmfFactoryContinuous.createVisualMappingFunction(prefix + SIMILARITY_COEFFECIENT, Double.class, BasicVisualLexicon.EDGE_WIDTH);
        Double under_width = 0.5;
        Double min_width = 1.0;
        Double max_width = 5.0;
        Double over_width = 6.0;
        BoundaryRangeValues bv4 = new BoundaryRangeValues((Object)under_width, (Object)min_width, (Object)min_width);
        BoundaryRangeValues bv5 = new BoundaryRangeValues((Object)max_width, (Object)max_width, (Object)over_width);
        conmapping_edgewidth.addPoint((Object)this.params.getSimilarityCutOff(), bv4);
        conmapping_edgewidth.addPoint((Object)1.0, bv5);
        vs.addVisualMappingFunction((VisualMappingFunction)conmapping_edgewidth);
        return vs;
    }

    private VisualStyle createNodeAppearance(VisualStyle vs, String prefix) {
        BoundaryRangeValues bv3a = new BoundaryRangeValues((Object)max_phenotype2, (Object)max_phenotype2, (Object)max_phenotype2);
        BoundaryRangeValues bv3b = new BoundaryRangeValues((Object)lighter_phenotype2, (Object)lighter_phenotype2, (Object)max_phenotype2);
        BoundaryRangeValues bv3c = new BoundaryRangeValues((Object)lightest_phenotype2, (Object)lightest_phenotype2, (Object)lighter_phenotype2);
        BoundaryRangeValues bv3d = new BoundaryRangeValues((Object)lightest_phenotype2, (Object)overColor, (Object)overColor);
        BoundaryRangeValues bv3e = new BoundaryRangeValues((Object)overColor, (Object)overColor, (Object)overColor);
        BoundaryRangeValues bv3f = new BoundaryRangeValues((Object)overColor, (Object)overColor, (Object)lightest_phenotype1);
        BoundaryRangeValues bv3g = new BoundaryRangeValues((Object)lightest_phenotype1, (Object)lightest_phenotype1, (Object)lighter_phenotype1);
        BoundaryRangeValues bv3h = new BoundaryRangeValues((Object)lighter_phenotype1, (Object)lighter_phenotype1, (Object)max_phenotype1);
        BoundaryRangeValues bv3i = new BoundaryRangeValues((Object)max_phenotype1, (Object)max_phenotype1, (Object)max_phenotype1);
        vs.setDefaultValue(BasicVisualLexicon.NODE_FILL_COLOR, (Object)new Color(190, 190, 190));
        vs.setDefaultValue(BasicVisualLexicon.NODE_BORDER_PAINT, (Object)new Color(190, 190, 190));
        vs.setDefaultValue(BasicVisualLexicon.NODE_SHAPE, (Object)NodeShapeVisualProperty.ELLIPSE);
        if (this.params.isTwoDistinctExpressionSets()) {
            vs.setDefaultValue(BasicVisualLexicon.NODE_SIZE, (Object)new Double(15.0));
            vs.setDefaultValue(BasicVisualLexicon.NODE_BORDER_WIDTH, (Object)new Double(15.0));
        } else {
            vs.setDefaultValue(BasicVisualLexicon.NODE_SIZE, (Object)new Double(20.0));
            vs.setDefaultValue(BasicVisualLexicon.NODE_BORDER_WIDTH, (Object)new Double(4.0));
        }
        PassthroughMapping pm = (PassthroughMapping)this.vmfFactoryPassthrough.createVisualMappingFunction(prefix + FORMATTED_NAME, String.class, BasicVisualLexicon.NODE_LABEL);
        if (this.params.isEMgmt()) {
            pm = (PassthroughMapping)this.vmfFactoryPassthrough.createVisualMappingFunction(prefix + GS_DESCR, String.class, BasicVisualLexicon.NODE_LABEL);
        }
        vs.addVisualMappingFunction((VisualMappingFunction)pm);
        ContinuousMapping continuousMapping_size = (ContinuousMapping)this.vmfFactoryContinuous.createVisualMappingFunction(prefix + GS_SIZE_DATASET1, Integer.class, BasicVisualLexicon.NODE_SIZE);
        Double min = 20.0;
        Double max = 65.0;
        BoundaryRangeValues bv0 = new BoundaryRangeValues((Object)min, (Object)min, (Object)min);
        BoundaryRangeValues bv1 = new BoundaryRangeValues((Object)max, (Object)max, (Object)max);
        continuousMapping_size.addPoint((Object)10, bv0);
        continuousMapping_size.addPoint((Object)474, bv1);
        vs.addVisualMappingFunction((VisualMappingFunction)continuousMapping_size);
        if (this.params.isTwoDatasets()) {
            ContinuousMapping continuousMapping_size_dataset2 = (ContinuousMapping)this.vmfFactoryContinuous.createVisualMappingFunction(prefix + GS_SIZE_DATASET2, Integer.class, BasicVisualLexicon.NODE_SIZE);
            Double min_line = 4.0;
            Double max_line = 15.0;
            BoundaryRangeValues bv0a = new BoundaryRangeValues((Object)min_line, (Object)min_line, (Object)min_line);
            BoundaryRangeValues bv1a = new BoundaryRangeValues((Object)max_line, (Object)max_line, (Object)max_line);
            continuousMapping_size_dataset2.addPoint((Object)10, bv0a);
            continuousMapping_size_dataset2.addPoint((Object)474, bv1a);
            vs.addVisualMappingFunction((VisualMappingFunction)continuousMapping_size_dataset2);
            ContinuousMapping continuousMapping_width_col = (ContinuousMapping)this.vmfFactoryContinuous.createVisualMappingFunction(prefix + COLOURING_DATASET2, Double.class, BasicVisualLexicon.NODE_BORDER_PAINT);
            continuousMapping_width_col.addPoint((Object)-1.0, bv3a);
            continuousMapping_width_col.addPoint((Object)-0.995, bv3b);
            continuousMapping_width_col.addPoint((Object)-0.95, bv3c);
            continuousMapping_width_col.addPoint((Object)-0.9, bv3d);
            continuousMapping_width_col.addPoint((Object)0.0, bv3e);
            continuousMapping_width_col.addPoint((Object)0.9, bv3f);
            continuousMapping_width_col.addPoint((Object)0.95, bv3g);
            continuousMapping_width_col.addPoint((Object)0.995, bv3h);
            continuousMapping_width_col.addPoint((Object)1.0, bv3i);
            vs.addVisualMappingFunction((VisualMappingFunction)continuousMapping_width_col);
        }
        ContinuousMapping continuousMapping = (ContinuousMapping)this.vmfFactoryContinuous.createVisualMappingFunction(prefix + COLOURING_DATASET1, Double.class, BasicVisualLexicon.NODE_FILL_COLOR);
        continuousMapping.addPoint((Object)-1.0, bv3a);
        continuousMapping.addPoint((Object)-0.995, bv3b);
        continuousMapping.addPoint((Object)-0.95, bv3c);
        continuousMapping.addPoint((Object)-0.9, bv3d);
        continuousMapping.addPoint((Object)0.0, bv3e);
        continuousMapping.addPoint((Object)0.9, bv3f);
        continuousMapping.addPoint((Object)0.95, bv3g);
        continuousMapping.addPoint((Object)0.995, bv3h);
        continuousMapping.addPoint((Object)1.0, bv3i);
        vs.addVisualMappingFunction((VisualMappingFunction)continuousMapping);
        return vs;
    }
}

