/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.task;

import cern.jet.stat.Gamma;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapVisualStyle;
import org.baderlab.csplugins.enrichmentmap.PostAnalysisParameters;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.model.GeneSet;
import org.baderlab.csplugins.enrichmentmap.model.GenesetSimilarity;
import org.baderlab.csplugins.enrichmentmap.task.CreateEnrichmentMapNetworkTask;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.session.CySessionManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class BuildDiseaseSignatureTask
extends AbstractTask {
    private PostAnalysisParameters paParams;
    private EnrichmentMap map;
    private CyApplicationManager applicationManager;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;
    private HashMap<String, GeneSet> EnrichmentGenesets;
    private HashMap<String, GeneSet> SignatureGenesets;
    private HashMap<String, GeneSet> SelectedSignatureGenesets;
    private HashSet<Integer> EnrichmentGenes;
    private HashSet<Integer> SignatureGenes;
    private HashMap<String, GenesetSimilarity> geneset_similarities;

    public BuildDiseaseSignatureTask(EnrichmentMap map, PostAnalysisParameters paParams, CySessionManager manager, StreamUtil streamUtil, CyApplicationManager applicationManager) {
        this.map = map;
        this.applicationManager = applicationManager;
        this.paParams = new PostAnalysisParameters(manager, streamUtil, applicationManager);
        this.paParams.copyFrom(paParams);
        this.EnrichmentGenesets = map.getAllGenesets();
        this.SignatureGenesets = this.getPaParams().getSignatureGenesets().getGenesets();
        this.geneset_similarities = map.getGenesetSimilarity() == null ? new HashMap() : map.getGenesetSimilarity();
        if (this.paParams.getSignatureGenesets() == null) {
            new HashMap();
        } else {
            map.getAllGenesetsOfInterest();
        }
        this.SelectedSignatureGenesets = new HashMap();
        for (int i = 0; i < paParams.getSelectedSignatureSetNames().getSize(); ++i) {
            this.SelectedSignatureGenesets.put(paParams.getSelectedSignatureSetNames().get(i).toString(), this.SignatureGenesets.get(paParams.getSelectedSignatureSetNames().get(i)));
        }
        this.EnrichmentGenes = new HashSet();
        for (String setName : this.EnrichmentGenesets.keySet()) {
            this.EnrichmentGenes.addAll(this.EnrichmentGenesets.get(setName).getGenes());
        }
        this.SignatureGenes = new HashSet();
        for (String setName : this.SignatureGenesets.keySet()) {
            this.SignatureGenes.addAll(this.SignatureGenesets.get(setName).getGenes());
        }
    }

    public void buildDiseaseSignature() {
        int maxValue = this.SelectedSignatureGenesets.size() * this.EnrichmentGenesets.size();
        int currentProgress = 0;
        double currentNodeY_offset = this.paParams.getCurrentNodePlacementY_Offset();
        double currentNodeY_increment = 150.0;
        try {
            CyNetwork current_network = this.applicationManager.getCurrentNetwork();
            CyNetworkView current_view = this.applicationManager.getCurrentNetworkView();
            String prefix = this.paParams.getAttributePrefix();
            if (prefix == null) {
                prefix = "EM1_";
                this.paParams.setAttributePrefix(prefix);
            }
            CyTable cyEdgeAttrs = this.createEdgeAttributes(current_network, "", prefix);
            CyTable cyNodeAttrs = this.createNodeAttributes(current_network, "", prefix);
            HashMap<Object, CyNode> nodesMap = new HashMap<Object, CyNode>();
            List nodesList = current_network.getNodeList();
            for (CyNode aNode : nodesList) {
                nodesMap.put(cyNodeAttrs.getRow((Object)aNode.getSUID()).get(prefix + EnrichmentMapVisualStyle.NAME, String.class), aNode);
            }
            HashSet<Integer> geneUniverse = new HashSet<Integer>();
            geneUniverse.addAll(this.EnrichmentGenes);
            int universeSize = geneUniverse.size();
            Iterator<String> i = this.SelectedSignatureGenesets.keySet().iterator();
            while (i.hasNext()) {
                String hub_name = i.next().toString();
                GeneSet sigGeneSet = this.SelectedSignatureGenesets.get(hub_name);
                HashSet<Integer> sigGenes = sigGeneSet.getGenes();
                HashSet<Integer> sigGenesInUniverse = new HashSet<Integer>(sigGenes);
                sigGenesInUniverse.retainAll(geneUniverse);
                EnrichmentMapManager.getInstance().getMap(current_network.getSUID()).getSignatureGenesets().put(hub_name, sigGeneSet);
                Iterator<String> j = this.EnrichmentGenesets.keySet().iterator();
                while (j.hasNext()) {
                    String geneset_name = j.next().toString();
                    int percentComplete = (int)((double)currentProgress / (double)maxValue * 100.0);
                    long timeRemaining = maxValue - currentProgress;
                    if (this.taskMonitor != null) {
                        this.taskMonitor.setProgress((double)percentComplete);
                        this.taskMonitor.setStatusMessage("Computing Geneset similarity " + currentProgress + " of " + maxValue);
                        this.taskMonitor.setTitle("Post Analysis");
                    }
                    ++currentProgress;
                    if (this.interrupted) {
                        throw new InterruptedException();
                    }
                    String similarity_key1 = hub_name + " (" + "sig" + ") " + geneset_name;
                    String similarity_key2 = geneset_name + " (" + "sig" + ") " + hub_name;
                    if (hub_name.equalsIgnoreCase(geneset_name) || !nodesMap.containsKey(geneset_name) || ((String)cyNodeAttrs.getRow((Object)((CyNode)nodesMap.get(geneset_name)).getSUID()).get(prefix + EnrichmentMapVisualStyle.GS_TYPE, String.class)).equalsIgnoreCase(EnrichmentMapVisualStyle.GS_TYPE_SIGNATURE)) continue;
                    GeneSet enrGeneset = this.EnrichmentGenesets.get(geneset_name);
                    HashSet<Integer> enrGenes = enrGeneset.getGenes();
                    enrGenes.retainAll(geneUniverse);
                    HashSet<Integer> intersection = new HashSet<Integer>(sigGenes);
                    intersection.retainAll(enrGenes);
                    HashSet<Integer> union = new HashSet<Integer>(sigGenes);
                    union.addAll(enrGenes);
                    double coeffecient = this.paParams.getSignature_CutoffMetric() == 4 ? (double)intersection.size() / (double)enrGenes.size() : (this.paParams.getSignature_CutoffMetric() == 2 ? (double)intersection.size() / (double)union.size() : (this.paParams.getSignature_CutoffMetric() == 3 ? (double)intersection.size() / Math.min((double)sigGenes.size(), (double)enrGenes.size()) : (double)intersection.size() / (double)enrGenes.size()));
                    GenesetSimilarity comparison = new GenesetSimilarity(hub_name, geneset_name, coeffecient, "sig", intersection);
                    int N = universeSize;
                    int n = sigGenesInUniverse.size();
                    int m = enrGenes.size();
                    int k = intersection.size();
                    double hyperPval = k > 0 ? BuildDiseaseSignatureTask.hyperGeomPvalue_sum(N, n, m, k, 0) : 1.0;
                    comparison.setHypergeom_pvalue(hyperPval);
                    comparison.setHypergeom_N(N);
                    comparison.setHypergeom_n(n);
                    comparison.setHypergeom_m(m);
                    comparison.setHypergeom_k(k);
                    this.geneset_similarities.put(similarity_key1, comparison);
                }
                CyNode hub_node = current_network.addNode();
                current_network.getRow((CyIdentifiable)hub_node).set("name", (Object)hub_name);
                current_view.updateView();
                View hubNodeView = current_view.getNodeView(hub_node);
                double hubNodeY = (Double)hubNodeView.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
                hubNodeView.setLockedValue(BasicVisualLexicon.NODE_Y_LOCATION, (Object)(hubNodeY + currentNodeY_offset));
                currentNodeY_offset += currentNodeY_increment;
                String formatted_label = CreateEnrichmentMapNetworkTask.formatLabel(hub_name);
                CyRow current_row = cyNodeAttrs.getRow((Object)hub_node.getSUID());
                current_row.set(prefix + EnrichmentMapVisualStyle.FORMATTED_NAME, (Object)formatted_label);
                if (this.map.getHashkey2gene() != null) {
                    ArrayList<String> gene_list = new ArrayList<String>();
                    HashSet<Integer> genes_hash = sigGeneSet.getGenes();
                    for (Integer current : genes_hash) {
                        String gene = this.map.getGeneFromHashKey(current);
                        if (gene_list == null) continue;
                        gene_list.add(gene);
                    }
                    Collections.sort(gene_list);
                    ArrayList<String> enr_gene_list = new ArrayList<String>();
                    HashSet<Integer> enr_genes_hash = sigGeneSet.getGenes();
                    enr_genes_hash.retainAll(geneUniverse);
                    for (Integer current : enr_genes_hash) {
                        String gene = this.map.getGeneFromHashKey(current);
                        if (enr_gene_list == null) continue;
                        enr_gene_list.add(gene);
                    }
                    Collections.sort(enr_gene_list);
                    current_row.set(prefix + EnrichmentMapVisualStyle.GENES, gene_list);
                    current_row.set(prefix + EnrichmentMapVisualStyle.ENR_GENES, enr_gene_list);
                    current_row.set(prefix + EnrichmentMapVisualStyle.GS_DESCR, (Object)sigGeneSet.getDescription());
                    current_row.set(prefix + EnrichmentMapVisualStyle.GS_TYPE, (Object)EnrichmentMapVisualStyle.GS_TYPE_SIGNATURE);
                    current_row.set(prefix + EnrichmentMapVisualStyle.NAME, (Object)sigGeneSet.getName());
                    current_row.set(prefix + EnrichmentMapVisualStyle.GS_SIZE_SIGNATURE, (Object)sigGeneSet.getGenes().size());
                }
                sigGeneSet.getGenes().retainAll(this.map.getDataset("Dataset 1").getDatasetGenes());
                this.map.getDataset("Dataset 1").getGenesetsOfInterest().getGenesets().put(hub_name, sigGeneSet);
                hubNodeView.setLockedValue(BasicVisualLexicon.NODE_SHAPE, (Object)this.paParams.getSignatureHub_nodeShape());
                hubNodeView.setLockedValue(BasicVisualLexicon.NODE_FILL_COLOR, (Object)this.paParams.getSignatureHub_nodeColor());
                hubNodeView.setLockedValue(BasicVisualLexicon.NODE_BORDER_PAINT, (Object)this.paParams.getSignatureHub_borderColor());
            }
            this.paParams.setCurrentNodePlacementY_Offset(currentNodeY_offset);
            i = this.geneset_similarities.keySet().iterator();
            while (i.hasNext()) {
                if (this.interrupted) {
                    throw new InterruptedException();
                }
                String edge_name = i.next().toString();
                if (!this.geneset_similarities.get(edge_name).getInteractionType().equals("sig") || !this.SelectedSignatureGenesets.containsKey(this.geneset_similarities.get(edge_name).getGeneset1_Name()) && !this.SelectedSignatureGenesets.containsKey(this.geneset_similarities.get(edge_name).getGeneset2_Name())) continue;
                boolean passed_cutoff = false;
                if (this.paParams.getSignature_CutoffMetric() == 1 && this.geneset_similarities.get(edge_name).getSizeOfOverlap() >= this.paParams.getSignature_absNumber_Cutoff()) {
                    passed_cutoff = true;
                } else if (this.paParams.getSignature_CutoffMetric() == 2 && this.geneset_similarities.get(edge_name).getSimilarity_coeffecient() >= this.paParams.getSignature_Jaccard_Cutoff()) {
                    passed_cutoff = true;
                } else if (this.paParams.getSignature_CutoffMetric() == 3 && this.geneset_similarities.get(edge_name).getSimilarity_coeffecient() >= this.paParams.getSignature_Overlap_Cutoff()) {
                    passed_cutoff = true;
                } else if (this.paParams.getSignature_CutoffMetric() == 4 && this.geneset_similarities.get(edge_name).getSimilarity_coeffecient() >= this.paParams.getSignature_DirOverlap_Cutoff()) {
                    passed_cutoff = true;
                } else if (this.paParams.getSignature_CutoffMetric() == 0 && this.geneset_similarities.get(edge_name).getHypergeom_pvalue() != -1.0 && this.geneset_similarities.get(edge_name).getHypergeom_pvalue() <= this.paParams.getSignature_Hypergeom_Cutoff()) {
                    passed_cutoff = true;
                }
                if (!passed_cutoff) continue;
                CyNode hub_node = this.getNodeWithValue(current_network, cyNodeAttrs, "name", this.geneset_similarities.get(edge_name).getGeneset1_Name());
                CyNode gene_set = this.getNodeWithValue(current_network, cyNodeAttrs, "name", this.geneset_similarities.get(edge_name).getGeneset2_Name());
                CyEdge edge = current_network.addEdge(hub_node, gene_set, false);
                current_view.updateView();
                CyRow current_edgerow = cyEdgeAttrs.getRow((Object)edge.getSUID());
                current_edgerow.set("name", (Object)edge_name);
                View edgeView = current_view.getEdgeView(edge);
                if (this.map.getHashkey2gene() != null) {
                    ArrayList<String> gene_list = new ArrayList<String>();
                    HashSet<Integer> genes_hash = this.geneset_similarities.get(edge_name).getOverlapping_genes();
                    for (Integer current : genes_hash) {
                        String gene = this.map.getGeneFromHashKey(current);
                        if (gene_list == null) continue;
                        gene_list.add(gene);
                    }
                    Collections.sort(gene_list);
                    current_edgerow.set(prefix + EnrichmentMapVisualStyle.OVERLAP_GENES, gene_list);
                }
                current_edgerow.set(prefix + EnrichmentMapVisualStyle.OVERLAP_SIZE, (Object)this.geneset_similarities.get(edge_name).getSizeOfOverlap());
                current_edgerow.set(prefix + EnrichmentMapVisualStyle.SIMILARITY_COEFFECIENT, (Object)this.geneset_similarities.get(edge_name).getSimilarity_coeffecient());
                current_edgerow.set(prefix + EnrichmentMapVisualStyle.HYPERGEOM_PVALUE, (Object)this.geneset_similarities.get(edge_name).getHypergeom_pvalue());
                current_edgerow.set(prefix + EnrichmentMapVisualStyle.ENRICHMENT_SET, (Object)this.geneset_similarities.get(edge_name).getEnrichment_set());
                edgeView.setLockedValue(BasicVisualLexicon.EDGE_UNSELECTED_PAINT, (Object)this.paParams.getSignatureHub_edgeColor());
                edgeView.setLockedValue(BasicVisualLexicon.EDGE_STROKE_UNSELECTED_PAINT, (Object)this.paParams.getSignatureHub_edgeColor());
                if (this.geneset_similarities.get(edge_name).getHypergeom_pvalue() <= this.paParams.getSignature_Hypergeom_Cutoff() / 100.0) {
                    edgeView.setLockedValue(BasicVisualLexicon.EDGE_WIDTH, (Object)8.0);
                    continue;
                }
                if (this.geneset_similarities.get(edge_name).getHypergeom_pvalue() <= this.paParams.getSignature_Hypergeom_Cutoff() / 10.0) {
                    edgeView.setLockedValue(BasicVisualLexicon.EDGE_WIDTH, (Object)4.5);
                    continue;
                }
                edgeView.setLockedValue(BasicVisualLexicon.EDGE_WIDTH, (Object)1.0);
            }
            current_view.updateView();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    private CyNode getNodeWithValue(CyNetwork net, CyTable table, String colname, String value) {
        Collection matchingRows = table.getMatchingRows(colname, (Object)value);
        CyNode node = null;
        if (matchingRows.size() == 1) {
            for (CyRow row : matchingRows) {
                Long nodeId = (Long)row.get("SUID", Long.class);
                if (nodeId != null && (node = net.getNode(nodeId.longValue())) != null) continue;
            }
        }
        return node;
    }

    public static double hyperGeomPvalue(int N, int n, int m, int k) {
        double log_p = BuildDiseaseSignatureTask.binomialLog(m, k) + BuildDiseaseSignatureTask.binomialLog(N - m, n - k) - BuildDiseaseSignatureTask.binomialLog(N, n);
        return Math.exp(log_p);
    }

    public static double hyperGeomPvalue_sum(int N, int n, int m, int k, int mode) {
        double sum = 0.0;
        switch (mode) {
            case 0: {
                int kMax = Math.min(n, m);
                for (int k_prime = k; k_prime <= kMax; ++k_prime) {
                    sum += BuildDiseaseSignatureTask.hyperGeomPvalue(N, n, m, k_prime);
                }
                break;
            }
            case 1: {
                int kMax = Math.min(n, m);
                for (int k_prime = k + 1; k_prime <= kMax; ++k_prime) {
                    sum += BuildDiseaseSignatureTask.hyperGeomPvalue(N, n, m, k_prime);
                }
                break;
            }
            case 2: {
                for (int k_prime = k; k_prime >= 0; --k_prime) {
                    sum += BuildDiseaseSignatureTask.hyperGeomPvalue(N, n, m, k_prime);
                }
                break;
            }
            case 3: {
                for (int k_prime = k - 1; k_prime >= 0; --k_prime) {
                    sum += BuildDiseaseSignatureTask.hyperGeomPvalue(N, n, m, k_prime);
                }
                break;
            }
        }
        return sum;
    }

    public static double hyperGeomPvalue_sum(int N, int n, int m, int k) {
        return BuildDiseaseSignatureTask.hyperGeomPvalue_sum(N, n, m, k, 0);
    }

    public static double binomialLog(int n, int k) {
        return Gamma.logGamma((double)((double)n + 1.0)) - Gamma.logGamma((double)((double)k + 1.0)) - Gamma.logGamma((double)((double)(n - k) + 1.0));
    }

    public void setPaParams(PostAnalysisParameters paParams) {
        this.paParams = paParams;
    }

    public PostAnalysisParameters getPaParams() {
        return this.paParams;
    }

    public CyTable createNodeAttributes(CyNetwork network, String name, String prefix) {
        CyTable nodeTable = network.getDefaultNodeTable();
        if (nodeTable.getColumn(prefix + EnrichmentMapVisualStyle.ENR_GENES) == null) {
            nodeTable.createListColumn(prefix + EnrichmentMapVisualStyle.ENR_GENES, String.class, false);
        }
        if (nodeTable.getColumn(prefix + EnrichmentMapVisualStyle.GS_SIZE_SIGNATURE) == null) {
            nodeTable.createColumn(prefix + EnrichmentMapVisualStyle.GS_SIZE_SIGNATURE, Integer.class, false);
        }
        return nodeTable;
    }

    public CyTable createEdgeAttributes(CyNetwork network, String name, String prefix) {
        CyTable edgeTable = network.getDefaultEdgeTable();
        if (edgeTable.getColumn(prefix + EnrichmentMapVisualStyle.HYPERGEOM_PVALUE) == null) {
            edgeTable.createColumn(prefix + EnrichmentMapVisualStyle.HYPERGEOM_PVALUE, Double.class, false);
        }
        return edgeTable;
    }

    public String getTitle() {
        return new String("Generating Signature Hubs");
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.taskMonitor = taskMonitor;
        taskMonitor.setTitle("Generating Signature Hubs");
        this.buildDiseaseSignature();
    }
}

