/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.baderlab.csplugins.enrichmentmap.PostAnalysisParameters;
import org.baderlab.csplugins.enrichmentmap.model.DataSet;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.model.GeneSet;
import org.baderlab.csplugins.enrichmentmap.model.SetOfGeneSets;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class GMTFileReaderTask
extends AbstractTask {
    private EnrichmentMap map;
    private String GMTFileName;
    private HashMap<String, Integer> genes;
    private HashMap<Integer, String> hashkey2gene;
    private SetOfGeneSets setOfgenesets;
    private int maxValue;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;
    public static final int ENRICHMENT_GMT = 1;
    public static final int SIGNATURE_GMT = 2;
    private StreamUtil streamUtil;

    public GMTFileReaderTask(DataSet dataset, StreamUtil streamUtil) {
        this.GMTFileName = dataset.getSetofgenesets().getFilename();
        this.genes = dataset.getMap().getGenes();
        this.hashkey2gene = dataset.getMap().getHashkey2gene();
        this.setOfgenesets = dataset.getSetofgenesets();
        this.map = dataset.getMap();
        this.streamUtil = streamUtil;
    }

    public GMTFileReaderTask(EnrichmentMap map, PostAnalysisParameters params, TaskMonitor taskMonitor, int genesets_file, StreamUtil streamUtil) {
        this(map, params, genesets_file, streamUtil);
        this.taskMonitor = taskMonitor;
    }

    public GMTFileReaderTask(EnrichmentMap map, PostAnalysisParameters params, int genesets_file, StreamUtil streamUtil) {
        this.map = map;
        this.streamUtil = streamUtil;
        this.genes = map.getGenes();
        this.hashkey2gene = map.getHashkey2gene();
        if (genesets_file != 1) {
            if (genesets_file == 2) {
                this.GMTFileName = params.getSignatureGMTFileName();
                this.setOfgenesets = params.getSignatureGenesets();
            } else {
                throw new IllegalArgumentException("argument not allowed:" + genesets_file);
            }
        }
    }

    public String deAccent(String str) {
        String nfdNormalizedString = Normalizer.normalize(str, Normalizer.Form.NFD);
        Pattern pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        return pattern.matcher(nfdNormalizedString).replaceAll("");
    }

    public void parse() throws IOException {
        HashMap<String, GeneSet> genesets = this.setOfgenesets.getGenesets();
        InputStream reader = this.streamUtil.getInputStream(this.GMTFileName);
        String fullText = new Scanner(reader, "UTF-8").useDelimiter("\\A").next();
        String[] lines = fullText.split("\r\n?|\n");
        int currentProgress = 0;
        this.maxValue = lines.length;
        try {
            for (int i = 0; i < lines.length; ++i) {
                if (this.interrupted) {
                    throw new InterruptedException();
                }
                String line = lines[i];
                String[] tokens = line.split("\t");
                if (tokens.length < 2) continue;
                String Name = tokens[0].toUpperCase().trim();
                String description = tokens[1].trim();
                GeneSet gs = new GeneSet(Name, description);
                int percentComplete = (int)((double)currentProgress / (double)this.maxValue * 100.0);
                long timeRemaining = this.maxValue - currentProgress;
                if (this.taskMonitor != null) {
                    this.taskMonitor.setProgress((double)percentComplete);
                    this.taskMonitor.setStatusMessage("Parsing GMT file " + currentProgress + " of " + this.maxValue);
                }
                ++currentProgress;
                for (int j = 2; j < tokens.length; ++j) {
                    if (this.genes.containsKey(tokens[j].toUpperCase())) {
                        gs.addGene(this.genes.get(tokens[j].toUpperCase()));
                        continue;
                    }
                    if (tokens[j].equalsIgnoreCase("")) continue;
                    int value = this.map.getNumberOfGenes();
                    this.genes.put(tokens[j].toUpperCase(), value);
                    this.hashkey2gene.put(value, tokens[j].toUpperCase());
                    this.map.setNumberOfGenes(value + 1);
                    gs.addGene(this.genes.get(tokens[j].toUpperCase()));
                }
                genesets.put(Name, gs);
                this.setOfgenesets.addGenesetType(gs.getSource());
            }
        }
        catch (InterruptedException e) {
            this.taskMonitor.setStatusMessage("Loading of GMT file cancelled");
        }
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.taskMonitor = taskMonitor;
        taskMonitor.setTitle("parsing GMT file");
        this.parse();
    }
}

