/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.task;

import org.baderlab.csplugins.enrichmentmap.model.DataSet;
import org.baderlab.csplugins.enrichmentmap.parsers.EnrichmentResultFileReaderTask;
import org.baderlab.csplugins.enrichmentmap.parsers.ExpressionFileReaderTask;
import org.baderlab.csplugins.enrichmentmap.parsers.GMTFileReaderTask;
import org.baderlab.csplugins.enrichmentmap.parsers.RanksFileReaderTask;
import org.baderlab.csplugins.enrichmentmap.task.CreateDummyExpressionTask;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.TaskIterator;

public class LoadDataSetTask
implements TaskFactory {
    private DataSet dataset;
    private TaskIterator loadDataTaskIterator;
    private StreamUtil streamUtil;

    public LoadDataSetTask(DataSet dataset, StreamUtil streamUtil) {
        this.dataset = dataset;
        this.streamUtil = streamUtil;
    }

    public void load() {
        RanksFileReaderTask ranking1;
        if (this.dataset.getSetofgenesets().getFilename() != null && !this.dataset.getSetofgenesets().getFilename().isEmpty()) {
            GMTFileReaderTask gmtFileTask = new GMTFileReaderTask(this.dataset, this.streamUtil);
            this.loadDataTaskIterator.append((Task)gmtFileTask);
        }
        EnrichmentResultFileReaderTask enrichmentResultsFilesTask = new EnrichmentResultFileReaderTask(this.dataset, this.streamUtil);
        this.loadDataTaskIterator.append((Task)enrichmentResultsFilesTask);
        if (this.dataset.getDatasetFiles().getExpressionFileName() == null || this.dataset.getDatasetFiles().getExpressionFileName().isEmpty()) {
            CreateDummyExpressionTask dummyExpressionTask = new CreateDummyExpressionTask(this.dataset);
            this.loadDataTaskIterator.append((Task)dummyExpressionTask);
        } else {
            ExpressionFileReaderTask expressionFileTask = new ExpressionFileReaderTask(this.dataset, this.streamUtil);
            this.loadDataTaskIterator.append((Task)expressionFileTask);
        }
        if (this.dataset.getMap().getParams().getMethod().equalsIgnoreCase("GSEA")) {
            if (this.dataset.getExpressionSets().getRanksByName("GSEARanking") != null) {
                ranking1 = new RanksFileReaderTask(this.dataset.getExpressionSets().getRanksByName("GSEARanking").getFilename(), this.dataset, "GSEARanking", false, this.streamUtil);
                this.loadDataTaskIterator.append((Task)ranking1);
            }
        } else {
            if (this.dataset.getExpressionSets().getRanksByName("Dataset 1") != null) {
                ranking1 = new RanksFileReaderTask(this.dataset.getExpressionSets().getRanksByName("Dataset 1").getFilename(), this.dataset, "Dataset 1", false, this.streamUtil);
                this.loadDataTaskIterator.append((Task)ranking1);
            }
            if (this.dataset.getExpressionSets().getRanksByName("Dataset 2") != null) {
                ranking1 = new RanksFileReaderTask(this.dataset.getExpressionSets().getRanksByName("Dataset 2").getFilename(), this.dataset, "Dataset 2", false, this.streamUtil);
                this.loadDataTaskIterator.append((Task)ranking1);
            }
        }
    }

    public TaskIterator createTaskIterator() {
        this.loadDataTaskIterator = new TaskIterator(new Task[0]);
        this.load();
        return this.loadDataTaskIterator;
    }

    public TaskIterator getIterator() {
        if (this.loadDataTaskIterator == null) {
            this.createTaskIterator();
        }
        return this.loadDataTaskIterator;
    }

    public boolean isReady() {
        return true;
    }
}

