/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.task;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.DefaultListModel;
import org.baderlab.csplugins.enrichmentmap.PostAnalysisParameters;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.model.GeneSet;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class FilterSignatureGSTask
extends AbstractTask {
    private EnrichmentMap map;
    private PostAnalysisParameters paParams = null;
    private int maxValue;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;

    public FilterSignatureGSTask(EnrichmentMap map, PostAnalysisParameters paParams) {
        this.map = map;
        this.paParams = paParams;
    }

    public void filterSignatureGS() {
        DefaultListModel signatureSetNames = this.paParams.getSignatureSetNames();
        DefaultListModel selectedSignatureSetNames = this.paParams.getSelectedSignatureSetNames();
        signatureSetNames.clear();
        HashMap<String, GeneSet> genesets_in_map = this.map.getAllGenesets();
        Object[] setsOfInterest = genesets_in_map.keySet().toArray();
        Object[] setNamesArray = this.paParams.getSignatureGenesets().getGenesets().keySet().toArray();
        Arrays.sort(setNamesArray);
        for (int i = 0; i < setNamesArray.length; ++i) {
            if (selectedSignatureSetNames.contains(setNamesArray[i])) continue;
            if (this.paParams.isFilter()) {
                boolean matchfound = false;
                for (int j = 0; j < setsOfInterest.length; ++j) {
                    Double relative_per;
                    HashSet<Integer> mapset = new HashSet<Integer>(genesets_in_map.get(setsOfInterest[j]).getGenes());
                    Integer original_size = mapset.size();
                    HashSet<Integer> paset = new HashSet<Integer>(this.paParams.getSignatureGenesets().getGenesets().get(setNamesArray[i]).getGenes());
                    mapset.retainAll(paset);
                    if (this.paParams.getSignature_filterMetric() == 0) {
                        relative_per = (double)mapset.size() / original_size.doubleValue();
                        if (!(relative_per >= Double.valueOf((double)this.paParams.getFilterValue() / 100.0))) continue;
                        matchfound = true;
                        break;
                    }
                    if (this.paParams.getSignature_filterMetric() == 1) {
                        if (mapset.size() < this.paParams.getFilterValue()) continue;
                        matchfound = true;
                        break;
                    }
                    if (this.paParams.getSignature_filterMetric() != 2 || !((relative_per = Double.valueOf((double)mapset.size() / Integer.valueOf(paset.size()).doubleValue())) >= Double.valueOf((double)this.paParams.getFilterValue() / 100.0))) continue;
                    matchfound = true;
                    break;
                }
                if (!matchfound || signatureSetNames.contains(setNamesArray[i])) continue;
                signatureSetNames.addElement(setNamesArray[i]);
                continue;
            }
            signatureSetNames.addElement(setNamesArray[i]);
        }
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.taskMonitor = taskMonitor;
        taskMonitor.setTitle("filtering Signature Gene set file");
        this.filterSignatureGS();
    }
}

