/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.parsers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Scanner;
import org.baderlab.csplugins.enrichmentmap.model.DataSet;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentResult;
import org.baderlab.csplugins.enrichmentmap.model.GSEAResult;
import org.baderlab.csplugins.enrichmentmap.model.GeneSet;
import org.baderlab.csplugins.enrichmentmap.model.GenericResult;
import org.baderlab.csplugins.enrichmentmap.model.SetOfEnrichmentResults;
import org.baderlab.csplugins.enrichmentmap.parsers.ParseEDBEnrichmentResults;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class EnrichmentResultFileReaderTask
extends AbstractTask {
    public static final Double DefaultScoreAtMax = -1000000.0;
    private DataSet dataset;
    private String EnrichmentResultFileName1;
    private String EnrichmentResultFileName2;
    private SetOfEnrichmentResults enrichments;
    private HashMap<String, EnrichmentResult> results;
    private String upPhenotype;
    private String downPhenotype;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;
    private StreamUtil streamUtil;

    public EnrichmentResultFileReaderTask(DataSet dataset, StreamUtil streamUtil) {
        this.dataset = dataset;
        this.streamUtil = streamUtil;
        this.EnrichmentResultFileName1 = dataset.getEnrichments().getFilename1();
        this.EnrichmentResultFileName2 = dataset.getEnrichments().getFilename2();
        this.enrichments = dataset.getEnrichments();
        this.results = this.enrichments.getEnrichments();
        this.upPhenotype = this.enrichments.getPhenotype1();
        this.downPhenotype = this.enrichments.getPhenotype2();
    }

    public void parse() throws IOException {
        if (this.EnrichmentResultFileName1 != null && !this.EnrichmentResultFileName1.isEmpty()) {
            this.readFile(this.EnrichmentResultFileName1);
        }
        if (this.EnrichmentResultFileName2 != null && !this.EnrichmentResultFileName2.isEmpty()) {
            this.readFile(this.EnrichmentResultFileName2);
        }
    }

    public void readFile(String EnrichmentResultFileName) throws IOException {
        if (EnrichmentResultFileName.endsWith(".edb")) {
            ParseEDBEnrichmentResults edbparser = new ParseEDBEnrichmentResults(new File(EnrichmentResultFileName));
            try {
                this.results = edbparser.parseDocument();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            this.dataset.getEnrichments().setEnrichments(this.results);
        } else {
            InputStream reader = this.streamUtil.getInputStream(EnrichmentResultFileName);
            String fullText = new Scanner(reader, "UTF-8").useDelimiter("\\A").next();
            String[] lines = fullText.split("\r\n?|\n");
            String header_line = lines[0];
            String[] tokens = header_line.split("\t");
            if (tokens.length == 11) {
                if (tokens[4].equalsIgnoreCase("ES") && tokens[5].equalsIgnoreCase("NES")) {
                    this.parseGSEAFile(lines);
                } else {
                    this.parseGenericFile(lines);
                }
            } else if (tokens.length == 13) {
                if (tokens[5].equalsIgnoreCase("Genes") && tokens[11].equalsIgnoreCase("Benjamini")) {
                    this.parseDavidFile(lines);
                } else {
                    this.parseGenericFile(lines);
                }
            } else if (header_line.contains("File created with BiNGO")) {
                this.parseBingoFile(lines);
            } else if (header_line.contains("GREAT version")) {
                this.parseGreatFile(lines);
            } else {
                this.parseGenericFile(lines);
            }
        }
    }

    public void parseGSEAFile(String[] lines) {
        this.dataset.getMap().getParams().setFDR(true);
        int currentProgress = 0;
        int maxValue = lines.length;
        for (int i = 1; i < lines.length; ++i) {
            String line = lines[i];
            String[] tokens = line.split("\t");
            int size = 0;
            double ES = 0.0;
            double NES = 0.0;
            double pvalue = 1.0;
            double FDRqvalue = 1.0;
            double FWERqvalue = 1.0;
            int rankAtMax = -1;
            double scoreAtMax = DefaultScoreAtMax;
            String Name = tokens[0].toUpperCase().trim();
            if (!tokens[3].equalsIgnoreCase("")) {
                size = Integer.parseInt(tokens[3]);
            }
            if (!tokens[4].equalsIgnoreCase("")) {
                ES = Double.parseDouble(tokens[4]);
            }
            if (!tokens[5].equalsIgnoreCase("")) {
                NES = Double.parseDouble(tokens[5]);
            }
            if (!tokens[6].equalsIgnoreCase("")) {
                pvalue = Double.parseDouble(tokens[6]);
            }
            if (!tokens[7].equalsIgnoreCase("")) {
                FDRqvalue = Double.parseDouble(tokens[7]);
            }
            if (!tokens[8].equalsIgnoreCase("")) {
                FWERqvalue = Double.parseDouble(tokens[8]);
            }
            if (!tokens[8].equalsIgnoreCase("")) {
                rankAtMax = Integer.parseInt(tokens[9]);
            }
            GSEAResult result = new GSEAResult(Name, size, ES, NES, pvalue, FDRqvalue, FWERqvalue, rankAtMax, scoreAtMax);
            int percentComplete = (int)((double)currentProgress / (double)maxValue * 100.0);
            long timeRemaining = maxValue - currentProgress;
            if (this.taskMonitor != null) {
                this.taskMonitor.setProgress((double)percentComplete);
                this.taskMonitor.setStatusMessage("Parsing Enrichment Results file " + currentProgress + " of " + maxValue);
            }
            ++currentProgress;
            this.results.put(Name, result);
        }
    }

    public void parseGenericFile(String[] lines) {
        HashMap<String, GeneSet> genesets = this.dataset.getMap().getAllGenesets();
        int currentProgress = 0;
        int maxValue = lines.length;
        boolean FDR = false;
        boolean ignore_phenotype = false;
        String line = lines[0];
        String[] tokens = line.split("\t");
        int length = tokens.length;
        for (int i = 1; i < lines.length; ++i) {
            GenericResult result;
            line = lines[i];
            tokens = line.split("\t");
            double pvalue = 1.0;
            double FDRqvalue = 1.0;
            int gs_size = 0;
            double NES = 1.0;
            String name = tokens[0].toUpperCase().trim();
            if (genesets.containsKey(name)) {
                GeneSet current_set = genesets.get(name);
                gs_size = current_set.getGenes().size();
            }
            String description = tokens[1].toUpperCase();
            if (!tokens[2].equalsIgnoreCase("")) {
                pvalue = Double.parseDouble(tokens[2]);
            }
            if (length > 3) {
                if (!tokens[3].equalsIgnoreCase("")) {
                    FDRqvalue = Double.parseDouble(tokens[3]);
                    FDR = true;
                }
                if (length > 4 && !ignore_phenotype) {
                    if (!tokens[4].equalsIgnoreCase("")) {
                        if (tokens[4].equalsIgnoreCase(this.upPhenotype)) {
                            NES = 1.0;
                        } else if (tokens[4].equalsIgnoreCase(this.downPhenotype)) {
                            NES = -1.0;
                        } else {
                            try {
                                NES = Double.parseDouble(tokens[4]);
                            }
                            catch (NumberFormatException nfe) {
                                throw new IllegalThreadStateException(tokens[4] + " is not a valid phenotype.  Phenotype specified in generic enrichment results file must have the same phenotype as specified in advanced options or must be a positive or negative number.");
                            }
                        }
                    }
                    result = new GenericResult(name, description, pvalue, gs_size, FDRqvalue, NES);
                } else {
                    result = new GenericResult(name, description, pvalue, gs_size, FDRqvalue);
                }
            } else {
                result = new GenericResult(name, description, pvalue, gs_size);
            }
            int percentComplete = (int)((double)currentProgress / (double)maxValue * 100.0);
            long timeRemaining = maxValue - currentProgress;
            if (this.taskMonitor != null) {
                this.taskMonitor.setProgress((double)percentComplete);
                this.taskMonitor.setStatusMessage("Parsing Generic Results file " + currentProgress + " of " + maxValue);
            }
            ++currentProgress;
            GenericResult temp = (GenericResult)this.results.get(name);
            if (temp == null) {
                this.results.put(name, result);
                continue;
            }
            if (!(result.getPvalue() < temp.getPvalue())) continue;
            this.results.put(name, result);
        }
        if (FDR) {
            this.dataset.getMap().getParams().setFDR(FDR);
        }
    }

    public void parseDavidFile(String[] lines) {
        HashMap<String, GeneSet> genesets = this.dataset.getSetofgenesets().getGenesets();
        HashMap<String, Integer> genes = this.dataset.getMap().getGenes();
        HashMap<Integer, String> key2gene = this.dataset.getMap().getHashkey2gene();
        int currentProgress = 0;
        int maxValue = lines.length;
        boolean FDR = true;
        String line = lines[0];
        String[] tokens = line.split("\t");
        int length = tokens.length;
        if (length != 13) {
            throw new IllegalThreadStateException("David results file is missing data.");
        }
        for (int i = 1; i < lines.length; ++i) {
            line = lines[i];
            tokens = line.split("\t");
            double pvalue = 1.0;
            double FDRqvalue = 1.0;
            int gs_size = 0;
            double NES = 1.0;
            String name = tokens[1].toUpperCase().trim();
            String description = tokens[0].toUpperCase();
            GeneSet gs = genesets.containsKey(name) ? genesets.get(name) : new GeneSet(name, description);
            String[] gene_tokens = tokens[5].split(", ");
            for (int j = 0; j < gene_tokens.length; ++j) {
                String gene = gene_tokens[j].toUpperCase();
                if (genes.containsKey(gene)) {
                    gs.addGene(genes.get(gene));
                    continue;
                }
                if (gene.equalsIgnoreCase("")) continue;
                int value = this.dataset.getMap().getNumberOfGenes();
                genes.put(gene, value);
                key2gene.put(value, gene);
                this.dataset.getMap().setNumberOfGenes(value + 1);
                gs.addGene(genes.get(gene));
            }
            genesets.put(name, gs);
            if (!tokens[4].equalsIgnoreCase("")) {
                pvalue = Double.parseDouble(tokens[4]);
            }
            if (!tokens[2].equalsIgnoreCase("")) {
                gs_size = Integer.parseInt(tokens[2]);
            }
            if (!tokens[11].equalsIgnoreCase("")) {
                FDRqvalue = Double.parseDouble(tokens[11]);
            }
            GenericResult result = new GenericResult(name, description, pvalue, gs_size, FDRqvalue);
            int percentComplete = (int)((double)currentProgress / (double)maxValue * 100.0);
            long timeRemaining = maxValue - currentProgress;
            if (this.taskMonitor != null) {
                this.taskMonitor.setProgress((double)percentComplete);
                this.taskMonitor.setStatusMessage("Parsing Generic Results file " + currentProgress + " of " + maxValue);
            }
            ++currentProgress;
            GenericResult temp = (GenericResult)this.results.get(name);
            if (temp == null) {
                this.results.put(name, result);
                continue;
            }
            if (!(result.getPvalue() < temp.getPvalue())) continue;
            this.results.put(name, result);
        }
        if (FDR) {
            this.dataset.getMap().getParams().setFDR(FDR);
        }
    }

    public void parseBingoFile(String[] lines) {
        int length;
        int k;
        HashMap<String, GeneSet> genesets = this.dataset.getSetofgenesets().getGenesets();
        HashMap<String, Integer> genes = this.dataset.getMap().getGenes();
        HashMap<Integer, String> key2gene = this.dataset.getMap().getHashkey2gene();
        int currentProgress = 0;
        int maxValue = lines.length;
        boolean FDR = true;
        String line = lines[k];
        String[] tokens = line.split("\t");
        for (k = 0; !(k >= lines.length || (length = (tokens = (line = lines[k]).split("\t")).length) == 9 && tokens[0].equalsIgnoreCase("GO-ID") && tokens[8].equalsIgnoreCase("Genes in test set")); ++k) {
        }
        if (k == lines.length) {
            throw new IllegalThreadStateException("Bingo results file is missing data.");
        }
        for (int i = k + 1; i < lines.length; ++i) {
            line = lines[i];
            tokens = line.split("\t");
            double pvalue = 1.0;
            double FDRqvalue = 1.0;
            int gs_size = 0;
            double NES = 1.0;
            String name = tokens[7].toUpperCase().trim();
            String description = tokens[7].toUpperCase();
            GeneSet gs = genesets.containsKey(name) ? genesets.get(name) : new GeneSet(name, description);
            String[] gene_tokens = tokens[8].split("\\|");
            for (int j = 0; j < gene_tokens.length; ++j) {
                String gene = gene_tokens[j].toUpperCase();
                if (genes.containsKey(gene)) {
                    gs.addGene(genes.get(gene));
                    continue;
                }
                if (gene.equalsIgnoreCase("")) continue;
                int value = this.dataset.getMap().getNumberOfGenes();
                genes.put(gene, value);
                key2gene.put(value, gene);
                this.dataset.getMap().setNumberOfGenes(value + 1);
                gs.addGene(genes.get(gene));
            }
            genesets.put(name, gs);
            if (!tokens[1].equalsIgnoreCase("")) {
                pvalue = Double.parseDouble(tokens[1]);
            }
            if (!tokens[3].equalsIgnoreCase("")) {
                gs_size = Integer.parseInt(tokens[3]);
            }
            if (!tokens[2].equalsIgnoreCase("")) {
                FDRqvalue = Double.parseDouble(tokens[2]);
            }
            GenericResult result = new GenericResult(name, description, pvalue, gs_size, FDRqvalue);
            int percentComplete = (int)((double)currentProgress / (double)maxValue * 100.0);
            long timeRemaining = maxValue - currentProgress;
            if (this.taskMonitor != null) {
                this.taskMonitor.setProgress((double)percentComplete);
                this.taskMonitor.setStatusMessage("Parsing Generic Results file " + currentProgress + " of " + maxValue);
            }
            ++currentProgress;
            GenericResult temp = (GenericResult)this.results.get(name);
            if (temp == null) {
                this.results.put(name, result);
                continue;
            }
            if (!(result.getPvalue() < temp.getPvalue())) continue;
            this.results.put(name, result);
        }
        if (FDR) {
            this.dataset.getMap().getParams().setFDR(FDR);
        }
    }

    public void parseGreatFile(String[] lines) {
        int length;
        int k;
        HashMap<String, GeneSet> genesets = this.dataset.getSetofgenesets().getGenesets();
        HashMap<String, Integer> genes = this.dataset.getMap().getGenes();
        HashMap<Integer, String> key2gene = this.dataset.getMap().getHashkey2gene();
        int currentProgress = 0;
        int maxValue = lines.length;
        this.dataset.getMap().getParams().setFDR(true);
        String line = lines[k];
        String[] tokens = line.split("\t");
        for (k = 0; !(k >= lines.length || (length = (tokens = (line = lines[k]).split("\t")).length) == 24 && tokens[3].equalsIgnoreCase("BinomRank")); ++k) {
        }
        for (int i = k + 1; i < lines.length && (tokens = (line = lines[i]).split("\t")).length == 24; ++i) {
            double pvalue = 1.0;
            double FDRqvalue = 1.0;
            int gs_size = 0;
            double NES = 1.0;
            String name = tokens[1].trim() + "-" + tokens[2].trim();
            String description = tokens[2].trim();
            GeneSet gs = genesets.containsKey(name) ? genesets.get(name) : new GeneSet(name, description);
            String[] gene_tokens = tokens[23].split(",");
            for (int j = 0; j < gene_tokens.length; ++j) {
                String gene = gene_tokens[j].toUpperCase();
                if (genes.containsKey(gene)) {
                    gs.addGene(genes.get(gene));
                    continue;
                }
                if (gene.equalsIgnoreCase("")) continue;
                int value = this.dataset.getMap().getNumberOfGenes();
                genes.put(gene, value);
                key2gene.put(value, gene);
                this.dataset.getMap().setNumberOfGenes(value + 1);
                gs.addGene(genes.get(gene));
            }
            genesets.put(name, gs);
            if (!tokens[4].equalsIgnoreCase("")) {
                pvalue = Double.parseDouble(tokens[4]);
            }
            if (!tokens[19].equalsIgnoreCase("")) {
                gs_size = Integer.parseInt(tokens[19]);
            }
            if (!tokens[6].equalsIgnoreCase("")) {
                FDRqvalue = Double.parseDouble(tokens[6]);
            }
            GenericResult result = new GenericResult(name, description, pvalue, gs_size, FDRqvalue);
            int percentComplete = (int)((double)currentProgress / (double)maxValue * 100.0);
            long timeRemaining = maxValue - currentProgress;
            if (this.taskMonitor != null) {
                this.taskMonitor.setProgress((double)percentComplete);
                this.taskMonitor.setStatusMessage("Parsing Great Results file " + currentProgress + " of " + maxValue);
            }
            ++currentProgress;
            GenericResult temp = (GenericResult)this.results.get(name);
            if (temp == null) {
                this.results.put(name, result);
                continue;
            }
            if (!(result.getPvalue() < temp.getPvalue())) continue;
            this.results.put(name, result);
        }
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Parsing Enrichment Result file");
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.taskMonitor = taskMonitor;
        this.taskMonitor.setTitle("Parsing Enrichment Result file");
        this.parse();
    }
}

