/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.model;

public class GeneExpression {
    private String name;
    private String description;
    private Double[] expression;
    private String[] row;
    private String separator = "\t";

    public GeneExpression(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String toString() {
        StringBuffer GE_StrBuff = new StringBuffer();
        GE_StrBuff.append(this.name);
        GE_StrBuff.append(this.separator);
        GE_StrBuff.append(this.description);
        for (int i = 0; i < this.expression.length; ++i) {
            GE_StrBuff.append(this.separator);
            GE_StrBuff.append(this.expression[i]);
        }
        GE_StrBuff.append("\n");
        return GE_StrBuff.toString();
    }

    public void setExpression(String[] expres) {
        this.row = expres;
        int size = expres.length;
        if (size > 2) {
            this.expression = new Double[size - 2];
            for (int i = 2; i < size; ++i) {
                this.expression[i - 2] = Double.parseDouble(expres[i]);
            }
        } else {
            this.expression = new Double[1];
            try {
                this.expression[0] = Double.parseDouble(expres[1]);
            }
            catch (NumberFormatException e) {
                this.expression[0] = 0.0;
            }
        }
    }

    public double newMax(double currentMax) {
        double newMax = -100.0;
        boolean found_newmin = false;
        for (int i = 0; i < this.expression.length; ++i) {
            if (!(this.expression[i] > currentMax)) continue;
            if (found_newmin) {
                if (!(this.expression[i] > newMax)) continue;
                newMax = this.expression[i];
                continue;
            }
            newMax = this.expression[i];
            found_newmin = true;
        }
        return newMax;
    }

    public double newMin(double currentMin) {
        double newMin = -100.0;
        boolean found_newmin = false;
        for (int i = 0; i < this.expression.length; ++i) {
            if (!(this.expression[i] < currentMin)) continue;
            if (found_newmin) {
                if (!(this.expression[i] < newMin)) continue;
                newMin = this.expression[i];
                continue;
            }
            newMin = this.expression[i];
            found_newmin = true;
        }
        return newMin;
    }

    public double newclosesttoZero(double currentClosest) {
        double newClosest = -100.0;
        boolean found_newclosest = false;
        for (int i = 0; i < this.expression.length; ++i) {
            if (!(this.expression[i] < currentClosest) || !(this.expression[i] > 0.0)) continue;
            if (found_newclosest) {
                if (!(this.expression[i] < newClosest)) continue;
                newClosest = this.expression[i];
                continue;
            }
            newClosest = this.expression[i];
            found_newclosest = true;
        }
        return newClosest;
    }

    public Double[] rowNormalize() {
        Double[] normalize = new Double[this.expression.length];
        double mean = this.getMean();
        double std = this.getSTD(mean);
        for (int i = 0; i < this.expression.length; ++i) {
            normalize[i] = (this.expression[i] - mean) / std;
        }
        return normalize;
    }

    private double getMean() {
        double sum = 0.0;
        for (int i = 0; i < this.expression.length; ++i) {
            sum += this.expression[i].doubleValue();
        }
        return sum / (double)this.expression.length;
    }

    private double getSTD(double mean) {
        double sum = 0.0;
        for (int i = 0; i < this.expression.length; ++i) {
            sum += Math.pow(this.expression[i] - mean, 2.0);
        }
        return Math.sqrt(sum) / (double)this.expression.length;
    }

    public Double[] rowLogTransform() {
        Double[] logtransformed = new Double[this.expression.length];
        for (int i = 0; i < this.expression.length; ++i) {
            logtransformed[i] = Math.log1p(this.expression[i]);
        }
        return logtransformed;
    }

    public String[] getRow() {
        return this.row;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Double[] getExpression() {
        return this.expression;
    }

    public void setExpression(Double[] expression) {
        this.expression = expression;
    }
}

