/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.baderlab.csplugins.enrichmentmap.model.GeneSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetOfGeneSets {
    private String name = "";
    private HashMap<String, GeneSet> genesets;
    private String filename = "";
    private HashSet<String> GenesetTypes = new HashSet();

    public SetOfGeneSets() {
        this.genesets = new HashMap();
    }

    public SetOfGeneSets(String ds, HashMap<String, String> props) {
        this();
        if (props.containsKey(ds + "%" + this.getClass().getSimpleName() + "%name")) {
            this.name = props.get(ds + "%" + this.getClass().getSimpleName() + "%name");
        }
        if (props.containsKey(ds + "%" + this.getClass().getSimpleName() + "%filename")) {
            this.filename = props.get(ds + "%" + this.getClass().getSimpleName() + "%filename");
        }
        if (props.containsKey(ds + "%" + this.getClass().getSimpleName() + "%genesets")) {
            String genesettypes_set = props.get(ds + "%" + this.getClass().getSimpleName() + "%GenesetTypes");
            genesettypes_set.replace("[", "");
            genesettypes_set.replace("]", "");
            String[] tokens = genesettypes_set.split("\\,");
            for (int i = 0; i < tokens.length; ++i) {
                this.GenesetTypes.add(tokens[i]);
            }
        }
    }

    public void filterGenesets(HashSet<Integer> datasetGenes) {
        HashMap<String, GeneSet> filteredGenesets = new HashMap<String, GeneSet>();
        Iterator<String> j = this.genesets.keySet().iterator();
        while (j.hasNext()) {
            String geneset2_name = j.next().toString();
            GeneSet current_set = this.genesets.get(geneset2_name);
            HashSet<Integer> geneset_genes = current_set.getGenes();
            HashSet<Integer> intersection = new HashSet<Integer>(geneset_genes);
            intersection.retainAll(datasetGenes);
            HashSet<Integer> new_geneset = new HashSet<Integer>(intersection);
            GeneSet new_set = new GeneSet(geneset2_name, current_set.getDescription());
            new_set.setGenes(new_geneset);
            filteredGenesets.put(geneset2_name, new_set);
        }
        this.genesets.clear();
        this.genesets = filteredGenesets;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public HashMap<String, GeneSet> getGenesets() {
        return this.genesets;
    }

    public void setGenesets(HashMap<String, GeneSet> genesets) {
        this.genesets = genesets;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setGenesetTypes(HashSet<String> types) {
        this.GenesetTypes = types;
    }

    public HashSet<String> getGenesetTypes() {
        return this.GenesetTypes;
    }

    public void addGenesetType(String type) {
        if (!this.GenesetTypes.contains(type)) {
            this.GenesetTypes.add(type);
        }
    }

    public GeneSet getGeneSetByName(String name) {
        if (this.genesets != null && this.genesets.containsKey(name)) {
            return this.genesets.get(name);
        }
        return null;
    }

    public String toString(String ds) {
        StringBuffer paramVariables = new StringBuffer();
        paramVariables.append(ds + "%" + this.getClass().getSimpleName() + "%name\t" + this.name + "\n");
        paramVariables.append(ds + "%" + this.getClass().getSimpleName() + "%filename\t" + this.filename + "\n");
        paramVariables.append(ds + "%" + this.getClass().getSimpleName() + "%GenesetTypes\t" + this.GenesetTypes.toString() + "\n");
        return paramVariables.toString();
    }
}

