/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Scanner;
import org.baderlab.csplugins.enrichmentmap.model.DataSet;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentResult;
import org.baderlab.csplugins.enrichmentmap.model.SetOfEnrichmentResults;
import org.baderlab.csplugins.enrichmentmap.parsers.GREATWhichPvalueQuestionTask;
import org.baderlab.csplugins.enrichmentmap.parsers.ParseBingoEnrichmentResults;
import org.baderlab.csplugins.enrichmentmap.parsers.ParseDavidEnrichmentResults;
import org.baderlab.csplugins.enrichmentmap.parsers.ParseEDBEnrichmentResults;
import org.baderlab.csplugins.enrichmentmap.parsers.ParseGREATEnrichmentResults;
import org.baderlab.csplugins.enrichmentmap.parsers.ParseGSEAEnrichmentResults;
import org.baderlab.csplugins.enrichmentmap.parsers.ParseGenericEnrichmentResults;
import org.baderlab.csplugins.enrichmentmap.task.BuildGMTEnrichmentMapTask;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;

public class DetermineEnrichmentResultFileReader {
    public static final Double DefaultScoreAtMax = -1000000.0;
    private DataSet dataset;
    private String EnrichmentResultFileName1;
    private String EnrichmentResultFileName2;
    private SetOfEnrichmentResults enrichments;
    private HashMap<String, EnrichmentResult> results;
    private String upPhenotype;
    private String downPhenotype;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;
    private TaskIterator currentTasks;
    private StreamUtil streamUtil;

    public DetermineEnrichmentResultFileReader(DataSet dataset, StreamUtil streamUtil) {
        this.dataset = dataset;
        this.streamUtil = streamUtil;
        this.EnrichmentResultFileName1 = dataset.getEnrichments().getFilename1();
        this.EnrichmentResultFileName2 = dataset.getEnrichments().getFilename2();
        this.enrichments = dataset.getEnrichments();
        this.results = this.enrichments.getEnrichments();
        this.upPhenotype = this.enrichments.getPhenotype1();
        this.downPhenotype = this.enrichments.getPhenotype2();
        this.currentTasks = this.currentTasks;
    }

    public TaskIterator getParsers() {
        TaskIterator parserTasks = new TaskIterator(new Task[0]);
        AbstractTask current = null;
        try {
            if (this.EnrichmentResultFileName1 != null && !this.EnrichmentResultFileName1.isEmpty()) {
                current = this.readFile(this.EnrichmentResultFileName1);
                if (current instanceof ParseGREATEnrichmentResults) {
                    parserTasks.append((Task)new GREATWhichPvalueQuestionTask(this.dataset.getMap()));
                }
                parserTasks.append((Task)current);
            }
            if (this.EnrichmentResultFileName2 != null && !this.EnrichmentResultFileName2.isEmpty()) {
                parserTasks.append((Task)this.readFile(this.EnrichmentResultFileName2));
            }
            if ((this.EnrichmentResultFileName1 == null || this.EnrichmentResultFileName1.isEmpty()) && (this.EnrichmentResultFileName2 == null || this.EnrichmentResultFileName2.isEmpty())) {
                parserTasks.append((Task)new BuildGMTEnrichmentMapTask(this.dataset));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return parserTasks;
    }

    public AbstractTask readFile(String EnrichmentResultFileName) throws IOException {
        if (EnrichmentResultFileName.endsWith(".edb")) {
            return new ParseEDBEnrichmentResults(this.dataset, this.streamUtil);
        }
        InputStream reader = this.streamUtil.getInputStream(EnrichmentResultFileName);
        String fullText = new Scanner(reader, "UTF-8").useDelimiter("\\A").next();
        String[] lines = fullText.split("\r\n?|\n");
        String header_line = lines[0];
        String[] tokens = header_line.split("\t");
        if (tokens.length == 11) {
            if (tokens[4].equalsIgnoreCase("ES") && tokens[5].equalsIgnoreCase("NES")) {
                return new ParseGSEAEnrichmentResults(this.dataset, this.streamUtil);
            }
            return new ParseGenericEnrichmentResults(this.dataset, this.streamUtil);
        }
        if (tokens.length == 13) {
            if (tokens[5].equalsIgnoreCase("Genes") && tokens[11].equalsIgnoreCase("Benjamini")) {
                return new ParseDavidEnrichmentResults(this.dataset, this.streamUtil);
            }
            return new ParseGenericEnrichmentResults(this.dataset, this.streamUtil);
        }
        if (header_line.toLowerCase().contains("File created with BiNGO".toLowerCase())) {
            return new ParseBingoEnrichmentResults(this.dataset, this.streamUtil);
        }
        if (header_line.contains("GREAT version")) {
            return new ParseGREATEnrichmentResults(this.dataset, this.streamUtil);
        }
        return new ParseGenericEnrichmentResults(this.dataset, this.streamUtil);
    }
}

