/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.autoannotate.action;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationManager;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationParameters;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationUtils;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.AnnotationSet;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.Cluster;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.AutoAnnotationTaskFactory;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.Observer;
import org.baderlab.csplugins.enrichmentmap.heatmap.HeatMapParameters;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.command.CommandExecutorTaskFactory;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.SynchronousTaskManager;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskObserver;
import org.cytoscape.work.swing.DialogTaskManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoAnnotationActions {
    public static void annotateAction(CyNetworkView selectedView, boolean clusterMakerDefault, String nameColumnName, boolean layoutNodes, boolean useGroups, JComboBox<String> clusterAlgorithmDropdown, JComboBox<String> clusterColumnDropdown) {
        if (selectedView == null) {
            JOptionPane.showMessageDialog(null, "Load an Enrichment Map", "Error Message", 0);
        } else {
            AutoAnnotationParameters params;
            CyNetwork selectedNetwork = (CyNetwork)selectedView.getModel();
            AutoAnnotationManager autoAnnotationManager = AutoAnnotationManager.getInstance();
            if (autoAnnotationManager.getNetworkViewToAutoAnnotationParameters().containsKey(selectedView)) {
                params = autoAnnotationManager.getNetworkViewToAutoAnnotationParameters().get(selectedView);
            } else {
                params = new AutoAnnotationParameters();
                params.setNetworkView(selectedView);
                autoAnnotationManager.getNetworkViewToAutoAnnotationParameters().put(selectedView, params);
            }
            String clusterColumnName = null;
            String algorithm = null;
            if (clusterMakerDefault) {
                algorithm = (String)clusterAlgorithmDropdown.getSelectedItem();
                clusterColumnName = params.nextClusterColumnName((String)autoAnnotationManager.getAlgorithmToColumnName().get(algorithm), selectedNetwork.getDefaultNodeTable());
            } else {
                clusterColumnName = (String)clusterColumnDropdown.getSelectedItem();
            }
            String annotationSetName = params.nextAnnotationSetName(algorithm, clusterColumnName);
            AutoAnnotationTaskFactory autoAnnotatorTaskFactory = new AutoAnnotationTaskFactory(selectedView, clusterColumnName, nameColumnName, algorithm, layoutNodes, useGroups, annotationSetName);
            autoAnnotationManager.getDialogTaskManager().execute(autoAnnotatorTaskFactory.createTaskIterator());
        }
    }

    public static void deleteAction(AnnotationSet annotationSet, JTable clusterTable) {
        int[] selectedRows = clusterTable.getSelectedRows();
        if (selectedRows.length < 1) {
            JOptionPane.showMessageDialog(null, "Please select at least one cluster", "Error Message", 0);
        } else {
            AutoAnnotationManager autoAnnotationManager = AutoAnnotationManager.getInstance();
            ArrayList<Cluster> selectedClusters = new ArrayList<Cluster>();
            block0: for (int rowIndex = 0; rowIndex < clusterTable.getRowCount(); ++rowIndex) {
                Cluster cluster = (Cluster)clusterTable.getModel().getValueAt(clusterTable.convertRowIndexToModel(rowIndex), 0);
                for (int selectedRow : selectedRows) {
                    if (rowIndex != selectedRow) continue;
                    selectedClusters.add(cluster);
                    continue block0;
                }
            }
            CommandExecutorTaskFactory executor = autoAnnotationManager.getCommandExecutor();
            SynchronousTaskManager<?> syncTaskManager = autoAnnotationManager.getSyncTaskManager();
            for (Cluster cluster : selectedClusters) {
                AutoAnnotationUtils.destroyCluster(cluster, executor, syncTaskManager);
            }
            AutoAnnotationActions.updateAction(annotationSet);
            CytoPanel westPanel = autoAnnotationManager.getWestPanel();
            westPanel.setSelectedIndex(westPanel.indexOfComponent((Component)autoAnnotationManager.getAnnotationPanel()));
        }
    }

    public static void mergeAction(AnnotationSet annotationSet, JTable clusterTable) {
        CyNetworkView selectedView = annotationSet.getView();
        CyNetwork selectedNetwork = (CyNetwork)selectedView.getModel();
        AutoAnnotationManager autoAnnotationManager = AutoAnnotationManager.getInstance();
        int[] selectedRows = clusterTable.getSelectedRows();
        if (selectedRows.length < 2) {
            JOptionPane.showMessageDialog(null, "Please select at least two clusters", "Error Message", 0);
        } else {
            ArrayList<Cluster> selectedClusters = new ArrayList<Cluster>();
            block2: for (int rowIndex = 0; rowIndex < clusterTable.getRowCount(); ++rowIndex) {
                Cluster cluster = (Cluster)clusterTable.getModel().getValueAt(clusterTable.convertRowIndexToModel(rowIndex), 0);
                for (int selectedRow : selectedRows) {
                    if (rowIndex != selectedRow) continue;
                    selectedClusters.add(cluster);
                    continue block2;
                }
            }
            CommandExecutorTaskFactory executor = autoAnnotationManager.getCommandExecutor();
            SynchronousTaskManager<?> syncTaskManager = autoAnnotationManager.getSyncTaskManager();
            DialogTaskManager dialogTaskManager = autoAnnotationManager.getDialogTaskManager();
            Cluster firstCluster = (Cluster)selectedClusters.get(0);
            int clusterNumber = firstCluster.getClusterNumber();
            String clusterColumnName = annotationSet.getClusterColumnName();
            for (Cluster clusterToSwallow : selectedClusters.subList(1, selectedClusters.size())) {
                for (CyNode node : clusterToSwallow.getNodes()) {
                    selectedNetwork.getRow((CyIdentifiable)node).set(clusterColumnName, (Object)clusterNumber);
                }
                firstCluster.swallow(clusterToSwallow);
                AutoAnnotationUtils.destroyCluster(clusterToSwallow, executor, syncTaskManager);
            }
            AutoAnnotationUtils.destroyCloud(firstCluster, executor, syncTaskManager);
            for (CyNode node : selectedNetwork.getNodeList()) {
                selectedNetwork.getRow((CyIdentifiable)node).set("selected", (Object)false);
            }
            for (CyNode node : firstCluster.getNodesToCoordinates().keySet()) {
                selectedNetwork.getRow((CyIdentifiable)node).set("selected", (Object)true);
            }
            String nameColumnName = annotationSet.getNameColumnName();
            ArrayList<String> commands = new ArrayList<String>();
            String command = "wordcloud create wordColumnName=\"" + nameColumnName + "\"" + " nodesToUse=\"selected\" cloudName=\"" + firstCluster.getCloudName() + "\"" + " cloudGroupTableName=\"" + annotationSet.getName() + "\"";
            commands.add(command);
            Observer observer = new Observer();
            TaskIterator taskIterator = executor.createTaskIterator(commands, null);
            dialogTaskManager.execute(taskIterator, (TaskObserver)observer);
            while (!observer.isFinished()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
            for (CyNode node : firstCluster.getNodesToCoordinates().keySet()) {
                selectedNetwork.getRow((CyIdentifiable)node).set("selected", (Object)false);
            }
            firstCluster.setCoordinatesChanged(true);
            AutoAnnotationActions.updateAction(annotationSet);
            clusterTable.clearSelection();
            CytoPanel westPanel = autoAnnotationManager.getWestPanel();
            westPanel.setSelectedIndex(westPanel.indexOfComponent((Component)autoAnnotationManager.getAnnotationPanel()));
        }
    }

    public static void removeAction(JComboBox<AnnotationSet> clusterSetDropdown, HashMap<AnnotationSet, JTable> clustersToTables, AutoAnnotationParameters params) {
        AnnotationSet annotationSet = params.getSelectedAnnotationSet();
        CyNetwork selectedNetwork = (CyNetwork)annotationSet.getView().getModel();
        int confirmation = JOptionPane.showConfirmDialog(null, "Are you sure you want to remove this annotation set? This cannot be undone.", "Remove confirmation", 0);
        if (confirmation == 0) {
            AutoAnnotationManager autoAnnotationManager = AutoAnnotationManager.getInstance();
            EnrichmentMapManager emManager = EnrichmentMapManager.getInstance();
            JTable clusterTable = clustersToTables.get(annotationSet);
            clusterTable.getParent().getParent().getParent().remove(clusterTable.getParent().getParent());
            HeatMapParameters heatMapParameters = emManager.getMap(selectedNetwork.getSUID()).getParams().getHmParams();
            if (heatMapParameters != null) {
                heatMapParameters.setSort(HeatMapParameters.Sort.NONE);
            }
            Iterator<Cluster> clusterIterator = annotationSet.getClusterMap().values().iterator();
            ArrayList<Cluster> clusterSetCopy = new ArrayList<Cluster>();
            while (clusterIterator.hasNext()) {
                clusterSetCopy.add(clusterIterator.next());
            }
            for (Cluster cluster : clusterSetCopy) {
                AutoAnnotationUtils.destroyCluster(cluster, autoAnnotationManager.getCommandExecutor(), autoAnnotationManager.getSyncTaskManager());
            }
            params.removeAnnotationSet(annotationSet);
            clustersToTables.remove(annotationSet);
            clusterSetDropdown.removeItem(annotationSet);
        }
    }

    public static void updateAction(AnnotationSet annotationSet) {
        AutoAnnotationManager autoAnnotationManager = AutoAnnotationManager.getInstance();
        CyNetworkView selectedView = annotationSet.getView();
        CyNetwork selectedNetwork = (CyNetwork)selectedView.getModel();
        JTable clusterTable = autoAnnotationManager.getAnnotationPanel().getClusterTable(annotationSet);
        for (CyRow row : selectedNetwork.getDefaultNodeTable().getAllRows()) {
            row.set("selected", (Object)false);
        }
        annotationSet.updateCoordinates();
        String annotationSetName = annotationSet.getName();
        Long clusterTableSUID = (Long)selectedNetwork.getDefaultNetworkTable().getRow((Object)selectedNetwork.getSUID()).get(annotationSetName, Long.class);
        CyTable clusterSetTable = autoAnnotationManager.getTableManager().getTable(clusterTableSUID.longValue());
        for (Cluster cluster : annotationSet.getClusterMap().values()) {
            AutoAnnotationUtils.updateNodeCentralities(cluster);
            String previousLabel = cluster.getLabel();
            AutoAnnotationUtils.updateClusterLabel(cluster, clusterSetTable);
            if (previousLabel != cluster.getLabel()) {
                clusterTable.updateUI();
                cluster.eraseText();
                AutoAnnotationUtils.drawTextLabel(cluster);
            }
            if (!cluster.coordinatesChanged()) continue;
            cluster.erase();
            AutoAnnotationUtils.drawCluster(cluster);
            cluster.setCoordinatesChanged(false);
        }
        DefaultTableModel model = (DefaultTableModel)clusterTable.getModel();
        int i = 0;
        int numRows = model.getRowCount();
        for (Cluster cluster : annotationSet.getClusterMap().values()) {
            if (i >= numRows) {
                Object[] newRow = new Object[]{cluster, cluster.getSize()};
                model.addRow(newRow);
                continue;
            }
            if (!model.getValueAt(i, 0).equals(cluster)) {
                model.setValueAt(cluster, i, 0);
                model.setValueAt(cluster.getSize(), i, 1);
            } else if (!model.getValueAt(i, 1).equals(cluster.getSize())) {
                model.setValueAt(cluster.getSize(), i, 1);
            }
            ++i;
        }
        while (numRows > i) {
            model.removeRow(i);
            numRows = model.getRowCount();
        }
        clusterTable.clearSelection();
    }

    public static void extractAction(AnnotationSet annotationSet, JTable clusterTable) {
        CyNetworkView selectedView = annotationSet.getView();
        CyNetwork selectedNetwork = (CyNetwork)selectedView.getModel();
        AutoAnnotationManager autoAnnotationManager = AutoAnnotationManager.getInstance();
        ArrayList<CyNode> selectedNodes = new ArrayList<CyNode>();
        for (CyNode node : selectedNetwork.getNodeList()) {
            if (!((Boolean)selectedNetwork.getRow((CyIdentifiable)node).get("selected", Boolean.class)).booleanValue()) continue;
            selectedNodes.add(node);
        }
        for (CyNode node : selectedNodes) {
            selectedNetwork.getRow((CyIdentifiable)node).set("selected", (Object)false);
        }
        if (selectedNodes.size() < 1) {
            JOptionPane.showMessageDialog(null, "Please select at least one node", "Error Message", 0);
        } else {
            CommandExecutorTaskFactory executor = autoAnnotationManager.getCommandExecutor();
            DialogTaskManager dialogTaskManager = autoAnnotationManager.getDialogTaskManager();
            Class columnType = selectedNetwork.getDefaultNodeTable().getColumn(annotationSet.getClusterColumnName()).getType();
            String clusterColumnName = annotationSet.getClusterColumnName();
            String nameColumnName = annotationSet.getNameColumnName();
            int newClusterNumber = annotationSet.getNextClusterNumber();
            Cluster newCluster = null;
            if (columnType == Integer.class) {
                HashSet<Cluster> clustersChanged = new HashSet<Cluster>();
                for (Cluster cluster : annotationSet.getClusterMap().values()) {
                    for (CyNode node : selectedNodes) {
                        if (!cluster.getNodes().contains(node)) continue;
                        cluster.removeNode(node);
                        cluster.setCoordinatesChanged(true);
                        clustersChanged.add(cluster);
                    }
                }
                for (CyRow row : selectedNetwork.getDefaultNodeTable().getAllRows()) {
                    row.set(clusterColumnName, (Object)newClusterNumber);
                }
                for (Cluster modifiedCluster : clustersChanged) {
                    for (CyNode node : modifiedCluster.getNodesToCoordinates().keySet()) {
                        selectedNetwork.getRow((CyIdentifiable)node).set("selected", (Object)true);
                    }
                    ArrayList<String> commands = new ArrayList<String>();
                    String deleteCommand = "wordcloud delete cloudName=\"" + modifiedCluster.getCloudName() + "\"";
                    String createCommand = "wordcloud create wordColumnName=\"" + nameColumnName + "\"" + " nodesToUse=\"selected\" cloudName=\"" + modifiedCluster.getCloudName() + "\"" + " cloudGroupTableName=\"" + annotationSet.getName() + "\"";
                    commands.add(deleteCommand);
                    commands.add(createCommand);
                    Observer observer = new Observer();
                    TaskIterator taskIterator = executor.createTaskIterator(commands, null);
                    dialogTaskManager.execute(taskIterator, (TaskObserver)observer);
                    while (!observer.isFinished()) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                    }
                    for (CyNode node : modifiedCluster.getNodesToCoordinates().keySet()) {
                        selectedNetwork.getRow((CyIdentifiable)node).set("selected", (Object)false);
                    }
                    autoAnnotationManager.flushPayloadEvents();
                }
            }
            newCluster = new Cluster(newClusterNumber, annotationSet);
            annotationSet.addCluster(newCluster);
            for (CyNode node : selectedNodes) {
                View nodeView = selectedView.getNodeView(node);
                double x = (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_X_LOCATION);
                double y = (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_Y_LOCATION);
                double[] coordinates = new double[]{x, y};
                double nodeRadius = (Double)nodeView.getVisualProperty(BasicVisualLexicon.NODE_WIDTH);
                newCluster.addNodeCoordinates(node, coordinates);
                newCluster.addNodeRadius(node, nodeRadius);
                selectedNetwork.getRow((CyIdentifiable)node).set("selected", (Object)true);
            }
            for (CyNode node : newCluster.getNodesToCoordinates().keySet()) {
                selectedNetwork.getRow((CyIdentifiable)node).set("selected", (Object)true);
            }
            ArrayList<String> commands = new ArrayList<String>();
            String command = "wordcloud create wordColumnName=\"" + nameColumnName + "\"" + " nodesToUse=\"selected\" cloudName=\"" + newCluster.getCloudName() + "\"" + " cloudGroupTableName=\"" + annotationSet.getName() + "\"";
            commands.add(command);
            Observer observer = new Observer();
            TaskIterator taskIterator = executor.createTaskIterator(commands, null);
            dialogTaskManager.execute(taskIterator, (TaskObserver)observer);
            while (!observer.isFinished()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
            for (CyNode node : selectedNodes) {
                selectedNetwork.getRow((CyIdentifiable)node).set("selected", (Object)false);
            }
            CyTableManager tableManager = autoAnnotationManager.getTableManager();
            String annotationSetName = annotationSet.getName();
            Long clusterTableSUID = (Long)selectedNetwork.getDefaultNetworkTable().getRow((Object)selectedNetwork.getSUID()).get(annotationSetName, Long.class);
            CyTable clusterSetTable = tableManager.getTable(clusterTableSUID.longValue());
            AutoAnnotationUtils.updateClusterLabel(newCluster, clusterSetTable);
            AutoAnnotationUtils.drawCluster(newCluster);
            AutoAnnotationActions.updateAction(annotationSet);
            clusterTable.clearSelection();
            CytoPanel westPanel = autoAnnotationManager.getWestPanel();
            westPanel.setSelectedIndex(westPanel.indexOfComponent((Component)autoAnnotationManager.getAnnotationPanel()));
        }
    }
}

