/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.text.DecimalFormat;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.actions.SliderBarActionListener;
import org.cytoscape.application.CyApplicationManager;

public class SliderBarPanel
extends JPanel {
    private CyApplicationManager applicationManager;
    private final int DIM_HEIGHT = 72;
    private final int DIM_WIDTH = 150;
    private int min;
    private int max;
    private boolean smallNumber = false;
    private double precision = 1000.0;
    private int dec_precision = (int)Math.log10(this.precision);
    private JLabel label;
    private String sliderLabel;
    private boolean edgesOnly;
    private int initial_value;

    public SliderBarPanel(double min, double max, String sliderLabel, EnrichmentMapParameters params, String attrib1, String attrib2, int desired_width, boolean edgesOnly, double initial_value, CyApplicationManager applicationManager) {
        this.applicationManager = applicationManager;
        this.setPreferredSize(new Dimension(150, 72));
        this.setLayout(new BorderLayout(0, 0));
        this.setOpaque(false);
        if (min <= 1.0 && max <= 1.0) {
            if (max <= 1.0E-4) {
                DecimalFormat df = new DecimalFormat("#.##############################");
                String text = df.format(max);
                int integerPlaces = text.indexOf(46);
                int decimalPlaces = text.length() - integerPlaces - 1;
                this.precision = decimalPlaces;
                this.min = (int)(min * Math.pow(10.0, this.precision + (double)this.dec_precision));
                this.max = (int)(max * Math.pow(10.0, this.precision + (double)this.dec_precision));
                this.initial_value = (int)(initial_value * Math.pow(10.0, this.precision + (double)this.dec_precision));
                this.smallNumber = true;
            } else {
                this.min = (int)(min * this.precision);
                this.max = (int)(max * this.precision);
                this.initial_value = (int)(initial_value * this.precision);
            }
        } else {
            this.min = (int)min;
            this.max = (int)max;
            this.initial_value = (int)initial_value;
        }
        this.sliderLabel = sliderLabel;
        this.label = new JLabel(sliderLabel);
        Dimension currentsize = this.label.getPreferredSize();
        currentsize.height = 6;
        this.label.setPreferredSize(currentsize);
        this.edgesOnly = edgesOnly;
        this.initPanel(params, attrib1, attrib2, desired_width);
    }

    public void initPanel(EnrichmentMapParameters params, String attrib1, String attrib2, int desired_width) {
        JSlider slider = new JSlider(0, this.min, this.max, this.initial_value);
        slider.addChangeListener(new SliderBarActionListener(this, attrib1, attrib2, this.edgesOnly, this.applicationManager));
        slider.setMajorTickSpacing((this.max - this.min) / 5);
        slider.setPaintTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        if (this.smallNumber) {
            labelTable.put(new Integer(this.min), new JLabel("" + (double)this.min / Math.pow(10.0, this.dec_precision) + "E-" + (int)this.precision));
            labelTable.put(new Integer(this.max), new JLabel("" + (double)this.max / Math.pow(10.0, this.dec_precision) + "E-" + (int)this.precision));
        } else {
            labelTable.put(new Integer(this.min), new JLabel("" + (double)this.min / this.precision));
            labelTable.put(new Integer(this.max), new JLabel("" + (double)this.max / this.precision));
        }
        slider.setLabelTable(labelTable);
        slider.setPaintLabels(true);
        Dimension currentsize = slider.getPreferredSize();
        currentsize.width = desired_width;
        currentsize.height = 66;
        slider.setPreferredSize(currentsize);
        this.setLayout(new GridLayout(2, 1));
        this.add((Component)this.label, "North");
        this.add((Component)slider, "South");
        this.revalidate();
    }

    public void setLabel(int current_value) {
        if (this.smallNumber) {
            this.label.setText("<html>" + this.sliderLabel + " &#8594; " + "<font size=\"-2\"> " + (double)current_value / Math.pow(10.0, (double)this.dec_precision + this.precision) + " </font></html>");
        } else {
            this.label.setText(String.format("<html>" + this.sliderLabel + " &#8594; " + "<font size=\"-2\"> %." + this.dec_precision + "f </font></html>", (double)current_value / this.precision));
        }
        this.revalidate();
    }

    public double getPrecision() {
        if (this.smallNumber) {
            return Math.pow(10.0, this.precision + (double)this.dec_precision);
        }
        return this.precision;
    }
}

