/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapUtils;
import org.baderlab.csplugins.enrichmentmap.PostAnalysisParameters;
import org.baderlab.csplugins.enrichmentmap.actions.BuildPostAnalysisActionListener;
import org.baderlab.csplugins.enrichmentmap.actions.LoadSignatureSetsActionListener;
import org.baderlab.csplugins.enrichmentmap.actions.ShowAboutPanelAction;
import org.baderlab.csplugins.enrichmentmap.model.JMultiLineToolTip;
import org.baderlab.csplugins.enrichmentmap.view.CollapsiblePanel;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.CySessionManager;
import org.cytoscape.util.swing.FileChooserFilter;
import org.cytoscape.util.swing.FileUtil;
import org.cytoscape.util.swing.OpenBrowser;
import org.cytoscape.work.swing.DialogTaskManager;

public class PostAnalysisInputPanel
extends JPanel
implements CytoPanelComponent {
    private static final long serialVersionUID = 5472169142720323583L;
    private CyApplicationManager cyApplicationManager;
    private CySwingApplication application;
    private OpenBrowser browser;
    private FileUtil fileUtil;
    private CyServiceRegistrar registrar;
    private CySessionManager sessionManager;
    private StreamUtil streamUtil;
    private CyNetworkManager networkManager;
    private DialogTaskManager dialog;
    private CyEventHelper eventHelper;
    static final int RIGHT = 0;
    static final int DOWN = 1;
    static final int UP = 2;
    static final int LEFT = 3;
    CollapsiblePanel Parameters;
    CollapsiblePanel signature_genesets;
    CollapsiblePanel filters;
    private JRadioButton filter;
    private JRadioButton nofilter;
    private JFormattedTextField filterTextField;
    private JComboBox filterTypeCombo;
    CollapsiblePanel dataset1;
    CollapsiblePanel dataset2;
    JPanel signaturePanel;
    DecimalFormat decFormat;
    private PostAnalysisParameters paParams;
    private JRadioButton signatureHub;
    private JFormattedTextField GMTFileNameTextField;
    private JFormattedTextField signatureGMTFileNameTextField;
    private JLabel avail_sig_sets_counter_label;
    private int avail_sig_sets_count = 0;
    private JLabel selected_sig_sets_counter_label;
    private int sel_sig_sets_count = 0;
    private JList avail_sig_sets_field;
    private JList selected_sig_sets_field;
    private DefaultListModel avail_sig_sets;
    private DefaultListModel selected_sig_sets;
    private JComboBox sigCutoffCombo;
    private JFormattedTextField sigCutoffTextField;
    private int defaultColumns = 15;
    public static String gmt_instruction = "Please select the Gene Set file (.gmt)...";
    public static String siggmt_instruction = "Please select the Signature Gene Set file (.gmt)...";
    private static String gmtTip = "File specifying gene sets.\nFormat: geneset name <tab> description <tab> gene ...";

    public PostAnalysisInputPanel(CyApplicationManager cyApplicationManager, CySwingApplication application, OpenBrowser browser, FileUtil fileUtil, CySessionManager sessionManager, StreamUtil streamUtil, CyServiceRegistrar registrar, CyNetworkManager networkManager, DialogTaskManager dialog, CyEventHelper eventHelper) {
        this.cyApplicationManager = cyApplicationManager;
        this.application = application;
        this.browser = browser;
        this.fileUtil = fileUtil;
        this.registrar = registrar;
        this.sessionManager = sessionManager;
        this.streamUtil = streamUtil;
        this.networkManager = networkManager;
        this.dialog = dialog;
        this.eventHelper = eventHelper;
        this.paParams = new PostAnalysisParameters(sessionManager, streamUtil, cyApplicationManager);
        this.decFormat = new DecimalFormat();
        this.decFormat.setParseIntegerOnly(false);
        this.setLayout(new BorderLayout());
        JPanel AnalysisTypePanel = this.createAnalysisTypePanel();
        CollapsiblePanel OptionsPanel = this.createOptionsPanel();
        OptionsPanel.setCollapsed(false);
        JScrollPane scroll = new JScrollPane(OptionsPanel);
        JPanel bottomPanel = this.createBottomPanel();
        JPanel advancedOptionsContainer = new JPanel(new BorderLayout());
        advancedOptionsContainer.add((Component)scroll, "Center");
        this.add((Component)AnalysisTypePanel, "North");
        this.add((Component)advancedOptionsContainer, "Center");
        this.add((Component)bottomPanel, "South");
    }

    private JPanel createAnalysisTypePanel() {
        JPanel buttonsPanel = new JPanel();
        GridBagLayout gridbag_buttons = new GridBagLayout();
        GridBagConstraints c_buttons = new GridBagConstraints();
        buttonsPanel.setLayout(gridbag_buttons);
        buttonsPanel.setBorder(BorderFactory.createTitledBorder("Info:"));
        JButton help = new JButton("Online Manual");
        help.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PostAnalysisInputPanel.this.browser.openURL(EnrichmentMapUtils.userManualUrl);
            }
        });
        JButton about = new JButton("About");
        HashMap<String, String> serviceProperties = new HashMap<String, String>();
        serviceProperties.put("inMenuBar", "true");
        serviceProperties.put("preferredMenu", "Apps.EnrichmentMap");
        about.addActionListener((ActionListener)((Object)new ShowAboutPanelAction(serviceProperties, this.cyApplicationManager, null, this.application, this.browser)));
        c_buttons.weighty = 1.0;
        c_buttons.weightx = 1.0;
        c_buttons.insets = new Insets(0, 0, 0, 0);
        c_buttons.gridx = 0;
        c_buttons.gridwidth = 1;
        c_buttons.gridy = 0;
        c_buttons.fill = 2;
        c_buttons.gridy = 0;
        gridbag_buttons.setConstraints(about, c_buttons);
        buttonsPanel.add(about);
        c_buttons.gridy = 1;
        gridbag_buttons.setConstraints(help, c_buttons);
        buttonsPanel.add(help);
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(gridbag);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 2;
        panel.setBorder(BorderFactory.createTitledBorder("Post Analysis Type"));
        this.signatureHub = new JRadioButton("Signature Hubs", this.paParams.isSignatureHub());
        this.signatureHub.setActionCommand("Signature Hubs");
        this.signatureHub.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PostAnalysisInputPanel.this.selectAnalysisTypeActionPerformed(evt);
            }
        });
        this.signatureHub.setSelected(true);
        ButtonGroup analysisOptions = new ButtonGroup();
        analysisOptions.add(this.signatureHub);
        c.gridx = 0;
        c.gridwidth = 3;
        c.gridy = 0;
        gridbag.setConstraints(this.signatureHub, c);
        panel.add(this.signatureHub);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.add((Component)buttonsPanel, "East");
        topPanel.add((Component)panel, "Center");
        return topPanel;
    }

    private CollapsiblePanel createOptionsPanel() {
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("User Input");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        CollapsiblePanel GMTPanel = this.createGMTPanel();
        GMTPanel.setCollapsed(false);
        this.signature_genesets = new CollapsiblePanel("Signature Genesets");
        this.signature_genesets.setLayout(new BorderLayout());
        this.signature_genesets.setCollapsed(false);
        this.signaturePanel = new JPanel();
        this.signaturePanel.setLayout(new BoxLayout(this.signaturePanel, 1));
        this.signaturePanel.setAlignmentX(0.0f);
        this.avail_sig_sets = this.paParams.getSignatureSetNames();
        this.selected_sig_sets = this.paParams.getSelectedSignatureSetNames();
        JPanel availableLabel = new JPanel(new FlowLayout());
        availableLabel.add(new JLabel("Available Signature-Genesets:"));
        availableLabel.add(this.createAvSigCountLabel());
        this.signaturePanel.add(availableLabel);
        this.avail_sig_sets_field = new JList(this.avail_sig_sets);
        JScrollPane avail_sig_sets_scroll = new JScrollPane(this.avail_sig_sets_field, 22, 30);
        avail_sig_sets_scroll.setPreferredSize(new Dimension(250, 200));
        avail_sig_sets_scroll.setMinimumSize(new Dimension(250, 150));
        avail_sig_sets_scroll.setMaximumSize(new Dimension(290, 300));
        this.signaturePanel.add(avail_sig_sets_scroll);
        ImageIcon[] icons = this.createArrowIcons();
        JPanel selectButtonPanel = new JPanel();
        selectButtonPanel.add(new JPanel());
        selectButtonPanel.setLayout(new BoxLayout(selectButtonPanel, 0));
        JButton selectButton = new JButton(icons[1]);
        selectButton.getSize().width = 30;
        selectButtonPanel.add(selectButton);
        selectButtonPanel.add(new JPanel());
        JButton unselectButton = new JButton(icons[2]);
        unselectButton.getSize().width = 30;
        selectButtonPanel.add(unselectButton);
        selectButtonPanel.add(new JPanel());
        this.signaturePanel.add(selectButtonPanel);
        JPanel selectedLabel = new JPanel();
        selectedLabel.add(new JLabel("Selected Signature-Genesets:"));
        selectedLabel.add(this.createSelSigCountLabel());
        this.signaturePanel.add(selectedLabel);
        this.selected_sig_sets_field = new JList(this.selected_sig_sets);
        JScrollPane selected_sig_sets_scroll = new JScrollPane(this.selected_sig_sets_field, 22, 30);
        selected_sig_sets_scroll.setPreferredSize(new Dimension(250, 100));
        selected_sig_sets_scroll.setMinimumSize(new Dimension(250, 100));
        selected_sig_sets_scroll.setMaximumSize(new Dimension(290, 200));
        this.signaturePanel.add(selected_sig_sets_scroll);
        JPanel clearButtonPanel = new JPanel();
        clearButtonPanel.setLayout(new FlowLayout());
        JButton clearButton = new JButton("Clear Signature Genesets");
        clearButtonPanel.add(clearButton);
        this.signaturePanel.add(clearButtonPanel);
        clearButton.addActionListener(new PaPanelActionListener(this){

            public void actionPerformed(ActionEvent e) {
                this.paPanel.avail_sig_sets.clear();
                this.paPanel.avail_sig_sets_field.clearSelection();
                this.paPanel.setAvSigCount(0);
                this.paPanel.selected_sig_sets.clear();
                this.paPanel.selected_sig_sets_field.clearSelection();
                this.paPanel.setSelSigCount(0);
            }
        });
        selectButton.addActionListener(new PaPanelActionListener(this){

            public void actionPerformed(ActionEvent evt) {
                int[] selected = PostAnalysisInputPanel.this.avail_sig_sets_field.getSelectedIndices();
                for (int i = selected.length; i > 0; --i) {
                    PostAnalysisInputPanel.this.selected_sig_sets.addElement(PostAnalysisInputPanel.this.avail_sig_sets.get(selected[i - 1]));
                    PostAnalysisInputPanel.this.avail_sig_sets.remove(selected[i - 1]);
                }
                this.paPanel.setSelSigCount(PostAnalysisInputPanel.this.selected_sig_sets.size());
                this.paPanel.setAvSigCount(PostAnalysisInputPanel.this.avail_sig_sets.size());
            }
        });
        unselectButton.addActionListener(new PaPanelActionListener(this){

            public void actionPerformed(ActionEvent evt) {
                int[] selected = PostAnalysisInputPanel.this.selected_sig_sets_field.getSelectedIndices();
                for (int i = selected.length; i > 0; --i) {
                    PostAnalysisInputPanel.this.avail_sig_sets.addElement(PostAnalysisInputPanel.this.selected_sig_sets.get(selected[i - 1]));
                    PostAnalysisInputPanel.this.selected_sig_sets.remove(selected[i - 1]);
                }
                Object[] setNamesArray = PostAnalysisInputPanel.this.avail_sig_sets.toArray();
                Arrays.sort(setNamesArray);
                PostAnalysisInputPanel.this.avail_sig_sets.removeAllElements();
                for (int i = 0; i < setNamesArray.length; ++i) {
                    PostAnalysisInputPanel.this.avail_sig_sets.addElement(setNamesArray[i]);
                }
                this.paPanel.setAvSigCount(PostAnalysisInputPanel.this.avail_sig_sets.size());
                this.paPanel.setSelSigCount(PostAnalysisInputPanel.this.selected_sig_sets.size());
            }
        });
        this.signature_genesets.getContentPane().add((Component)this.signaturePanel, "North");
        CollapsiblePanel ParametersPanel2 = this.createParametersPanel();
        ParametersPanel2.setCollapsed(false);
        panel.add(GMTPanel);
        panel.add(this.signature_genesets);
        panel.add(ParametersPanel2);
        collapsiblePanel.getContentPane().add((Component)panel, "North");
        return collapsiblePanel;
    }

    private CollapsiblePanel createGMTPanel() {
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("Gene-Sets");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JLabel GMTLabel = new JLabel("GMT:"){
            private static final long serialVersionUID = 5799024396588991328L;

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        GMTLabel.setToolTipText(gmtTip);
        JButton selectGMTFileButton = new JButton();
        this.GMTFileNameTextField = new JFormattedTextField();
        this.GMTFileNameTextField.setColumns(this.defaultColumns);
        this.GMTFileNameTextField.setFont(new Font("Dialog", 1, 10));
        this.GMTFileNameTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        this.GMTFileNameTextField.setText(this.paParams.getGMTFileName());
        this.GMTFileNameTextField.setValue(this.paParams.getGMTFileName());
        if (!this.GMTFileNameTextField.getText().equals("")) {
            this.GMTFileNameTextField.setToolTipText(this.GMTFileNameTextField.getText());
        }
        selectGMTFileButton.setText("...");
        selectGMTFileButton.setMargin(new Insets(0, 0, 0, 0));
        selectGMTFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PostAnalysisInputPanel.this.selectGMTFileButtonActionPerformed(evt);
            }
        });
        JPanel GMTPanel = new JPanel();
        GMTPanel.setLayout(new BorderLayout());
        GMTPanel.add((Component)GMTLabel, "West");
        GMTPanel.add((Component)this.GMTFileNameTextField, "Center");
        GMTPanel.add((Component)selectGMTFileButton, "East");
        panel.add(GMTPanel);
        JLabel SigGMTLabel = new JLabel("SigGMT:"){
            private static final long serialVersionUID = 8826340546360207691L;

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        SigGMTLabel.setToolTipText(gmtTip);
        JButton selectSigGMTFileButton = new JButton();
        this.signatureGMTFileNameTextField = new JFormattedTextField();
        this.signatureGMTFileNameTextField.setColumns(this.defaultColumns);
        this.signatureGMTFileNameTextField.setFont(new Font("Dialog", 1, 10));
        this.signatureGMTFileNameTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        selectSigGMTFileButton.setText("...");
        selectSigGMTFileButton.setMargin(new Insets(0, 0, 0, 0));
        selectSigGMTFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PostAnalysisInputPanel.this.selectSignatureGMTFileButtonActionPerformed(evt);
            }
        });
        JPanel SigGMTPanel = new JPanel();
        SigGMTPanel.setLayout(new BorderLayout());
        SigGMTPanel.add((Component)SigGMTLabel, "West");
        SigGMTPanel.add((Component)this.signatureGMTFileNameTextField, "Center");
        SigGMTPanel.add((Component)selectSigGMTFileButton, "East");
        panel.add(SigGMTPanel);
        panel.add(this.createFilterPanel());
        JButton loadButton = new JButton();
        loadButton.setText("Load Gene-Sets");
        loadButton.addActionListener(new LoadSignatureSetsActionListener(this, this.cyApplicationManager, this.dialog, this.streamUtil));
        loadButton.setPreferredSize(new Dimension(100, 10));
        panel.add(loadButton);
        collapsiblePanel.getContentPane().add((Component)panel, "North");
        return collapsiblePanel;
    }

    private CollapsiblePanel createFilterPanel() {
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("Filters");
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 1));
        this.filter = new JRadioButton("Filter By");
        this.filter.setActionCommand("filter");
        this.filter.setSelected(true);
        this.nofilter = new JRadioButton("No filter");
        this.nofilter.setActionCommand("nofilter");
        this.nofilter.setSelected(false);
        ButtonGroup filters = new ButtonGroup();
        filters.add(this.filter);
        filters.add(this.nofilter);
        this.filter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PostAnalysisInputPanel.this.selectFilterActionPerformed(evt);
            }
        });
        this.nofilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PostAnalysisInputPanel.this.selectFilterActionPerformed(evt);
            }
        });
        JPanel filtersPanel = new JPanel();
        filtersPanel.setLayout(new BoxLayout(filtersPanel, 1));
        filtersPanel.add(this.nofilter);
        String[] filterItems = PostAnalysisParameters.filterItems;
        JPanel filterTypePanel = new JPanel();
        filterTypePanel.setLayout(new BorderLayout());
        this.filterTypeCombo = new JComboBox();
        this.filterTypeCombo.addItem(filterItems[0]);
        this.filterTypeCombo.addItem(filterItems[1]);
        this.filterTypeCombo.addItem(filterItems[2]);
        this.filterTypeCombo.setSelectedItem(this.paParams.getDefault_signature_filterMetric());
        this.filterTypeCombo.addActionListener(new ActionListener(){
            String[] filterItems = PostAnalysisParameters.filterItems;

            public void actionPerformed(ActionEvent e) {
                JComboBox selectedChoice = (JComboBox)e.getSource();
                if (this.filterItems[0].equals(selectedChoice.getSelectedItem())) {
                    PostAnalysisInputPanel.this.paParams.setSignature_filterMetric(0);
                } else if (this.filterItems[1].equals(selectedChoice.getSelectedItem())) {
                    PostAnalysisInputPanel.this.paParams.setSignature_filterMetric(1);
                } else if (this.filterItems[2].equals(selectedChoice.getSelectedItem())) {
                    PostAnalysisInputPanel.this.paParams.setSignature_filterMetric(2);
                }
            }
        });
        this.filterTextField = new JFormattedTextField();
        this.filterTextField.setColumns(4);
        this.filterTextField.setValue(this.paParams.getFilterValue());
        this.filterTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        filterTypePanel.add((Component)this.filter, "West");
        filterTypePanel.add((Component)this.filterTypeCombo, "Center");
        filterTypePanel.add((Component)this.filterTextField, "East");
        panel.add(filterTypePanel);
        panel.add(filtersPanel);
        collapsiblePanel.getContentPane().add(panel);
        return collapsiblePanel;
    }

    private void selectFilterActionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equalsIgnoreCase("filter")) {
            this.paParams.setFilter(true);
        } else if (evt.getActionCommand().equalsIgnoreCase("nofilter")) {
            this.paParams.setFilter(false);
        }
    }

    private CollapsiblePanel createParametersPanel() {
        String[] sigCutoffItems = PostAnalysisParameters.sigCutoffItems;
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("Parameters");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel cutoffLabel = new JPanel();
        cutoffLabel.add(new JLabel("Select Cutoff:"));
        panel.add(cutoffLabel);
        JPanel cutoffPanel = new JPanel();
        cutoffPanel.setLayout(new BoxLayout(cutoffPanel, 0));
        this.sigCutoffCombo = new JComboBox();
        this.sigCutoffCombo.addItem(sigCutoffItems[0]);
        this.sigCutoffCombo.addItem(sigCutoffItems[1]);
        this.sigCutoffCombo.addItem(sigCutoffItems[4]);
        this.sigCutoffCombo.setSelectedItem(sigCutoffItems[this.paParams.getDefault_signature_CutoffMetric()]);
        this.sigCutoffTextField = new JFormattedTextField(this.decFormat);
        this.sigCutoffTextField.setColumns(3);
        if (this.paParams.getDefault_signature_CutoffMetric() == 0) {
            this.sigCutoffTextField.setValue(this.paParams.getSignature_Hypergeom_Cutoff());
        } else if (this.paParams.getDefault_signature_CutoffMetric() == 1) {
            this.sigCutoffTextField.setValue(this.paParams.getSignature_absNumber_Cutoff());
        } else if (this.paParams.getDefault_signature_CutoffMetric() == 2) {
            this.sigCutoffTextField.setValue(this.paParams.getSignature_Jaccard_Cutoff());
        } else if (this.paParams.getDefault_signature_CutoffMetric() == 3) {
            this.sigCutoffTextField.setValue(this.paParams.getSignature_Overlap_Cutoff());
        } else if (this.paParams.getDefault_signature_CutoffMetric() == 4) {
            this.sigCutoffTextField.setValue(this.paParams.getSignature_DirOverlap_Cutoff());
        } else {
            String message = "This Cutoff metric is not supported.";
            JOptionPane.showMessageDialog(this.application.getJFrame(), message, "Parameter out of bounds", 2);
        }
        this.sigCutoffCombo.addActionListener(new ActionListener(){
            String[] sigCutoffItems = PostAnalysisParameters.sigCutoffItems;

            public void actionPerformed(ActionEvent e) {
                JComboBox selectedChoice = (JComboBox)e.getSource();
                if (this.sigCutoffItems[0].equals(selectedChoice.getSelectedItem())) {
                    PostAnalysisInputPanel.this.paParams.setSignature_CutoffMetric(0);
                    PostAnalysisInputPanel.this.sigCutoffTextField.setValue(PostAnalysisInputPanel.this.paParams.getSignature_Hypergeom_Cutoff());
                } else if (this.sigCutoffItems[1].equals(selectedChoice.getSelectedItem())) {
                    PostAnalysisInputPanel.this.paParams.setSignature_CutoffMetric(1);
                    PostAnalysisInputPanel.this.sigCutoffTextField.setValue(PostAnalysisInputPanel.this.paParams.getSignature_absNumber_Cutoff());
                } else if (this.sigCutoffItems[2].equals(selectedChoice.getSelectedItem())) {
                    PostAnalysisInputPanel.this.paParams.setSignature_CutoffMetric(2);
                    PostAnalysisInputPanel.this.sigCutoffTextField.setValue(PostAnalysisInputPanel.this.paParams.getSignature_Jaccard_Cutoff());
                } else if (this.sigCutoffItems[3].equals(selectedChoice.getSelectedItem())) {
                    PostAnalysisInputPanel.this.paParams.setSignature_CutoffMetric(3);
                    PostAnalysisInputPanel.this.sigCutoffTextField.setValue(PostAnalysisInputPanel.this.paParams.getSignature_Overlap_Cutoff());
                } else if (this.sigCutoffItems[4].equals(selectedChoice.getSelectedItem())) {
                    PostAnalysisInputPanel.this.paParams.setSignature_CutoffMetric(4);
                    PostAnalysisInputPanel.this.sigCutoffTextField.setValue(PostAnalysisInputPanel.this.paParams.getSignature_DirOverlap_Cutoff());
                }
            }
        });
        this.sigCutoffTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        cutoffPanel.add(this.sigCutoffCombo);
        cutoffPanel.add(this.sigCutoffTextField);
        panel.add(cutoffPanel);
        collapsiblePanel.getContentPane().add((Component)panel, "North");
        return collapsiblePanel;
    }

    private ImageIcon[] createArrowIcons() {
        ImageIcon[] iconArrow = new ImageIcon[4];
        URL iconURL = this.getClass().getResource("arrow_up.gif");
        if (iconURL != null) {
            iconArrow[2] = new ImageIcon(iconURL);
        }
        if ((iconURL = this.getClass().getResource("arrow_down.gif")) != null) {
            iconArrow[1] = new ImageIcon(iconURL);
        }
        if ((iconURL = this.getClass().getResource("arrow_left.gif")) != null) {
            iconArrow[3] = new ImageIcon(iconURL);
        }
        if ((iconURL = this.getClass().getResource("arrow_right.gif")) != null) {
            iconArrow[0] = new ImageIcon(iconURL);
        }
        return iconArrow;
    }

    private JPanel createBottomPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        JButton closeButton = new JButton();
        JButton importButton = new JButton();
        JButton resetButton = new JButton("Reset");
        resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PostAnalysisInputPanel.this.resetPanel();
            }
        });
        closeButton.setText("Close");
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PostAnalysisInputPanel.this.cancelButtonActionPerformed(evt);
            }
        });
        importButton.setText("Run");
        importButton.addActionListener(new BuildPostAnalysisActionListener(this, this.sessionManager, this.streamUtil, this.networkManager, this.cyApplicationManager, this.dialog, this.eventHelper));
        importButton.setEnabled(true);
        panel.add(resetButton);
        panel.add(closeButton);
        panel.add(importButton);
        return panel;
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.registrar.unregisterService((Object)this, CytoPanelComponent.class);
    }

    public void close() {
        this.registrar.unregisterService((Object)this, CytoPanelComponent.class);
    }

    public Color checkFile(String filename) {
        File tempfile;
        if (filename != null && !(tempfile = new File(filename)).canRead()) {
            return Color.RED;
        }
        return Color.BLACK;
    }

    private void selectAnalysisTypeActionPerformed(ActionEvent evt) {
        String analysisType = evt.getActionCommand();
        if (analysisType.equalsIgnoreCase("Signature Hubs")) {
            this.paParams.setSignatureHub(true);
        } else {
            this.paParams.setSignatureHub(false);
        }
        boolean datasets_collapsed = this.signature_genesets.isCollapsed();
        this.signature_genesets.remove(this.signaturePanel);
        this.signaturePanel.remove(this.dataset1);
        this.signaturePanel.remove(this.dataset2);
        this.signaturePanel.revalidate();
        this.signature_genesets.getContentPane().add((Component)this.signaturePanel, "North");
        this.signature_genesets.setCollapsed(datasets_collapsed);
        this.signature_genesets.revalidate();
    }

    private void selectGMTFileButtonActionPerformed(ActionEvent evt) {
        FileChooserFilter filter = new FileChooserFilter("All GMT Files", "gmt");
        ArrayList<FileChooserFilter> all_filters = new ArrayList<FileChooserFilter>();
        all_filters.add(filter);
        File file = this.fileUtil.getFile(EnrichmentMapUtils.getWindowInstance(this), "Import GMT File", 0, all_filters);
        if (file != null) {
            this.GMTFileNameTextField.setForeground(this.checkFile(file.getAbsolutePath()));
            this.GMTFileNameTextField.setText(file.getAbsolutePath());
            this.GMTFileNameTextField.setValue(file.getAbsolutePath());
            this.paParams.setGMTFileName(file.getAbsolutePath());
            this.GMTFileNameTextField.setToolTipText(file.getAbsolutePath());
        }
    }

    private void selectSignatureGMTFileButtonActionPerformed(ActionEvent evt) {
        FileChooserFilter filter = new FileChooserFilter("All GMT Files", "gmt");
        ArrayList<FileChooserFilter> all_filters = new ArrayList<FileChooserFilter>();
        all_filters.add(filter);
        File file = this.fileUtil.getFile(EnrichmentMapUtils.getWindowInstance(this), "Import Signature GMT File", 0, all_filters);
        if (file != null) {
            this.signatureGMTFileNameTextField.setForeground(this.checkFile(file.getAbsolutePath()));
            this.signatureGMTFileNameTextField.setText(file.getAbsolutePath());
            this.signatureGMTFileNameTextField.setValue(file.getAbsolutePath());
            this.paParams.setSignatureGMTFileName(file.getAbsolutePath());
            this.signatureGMTFileNameTextField.setToolTipText(file.getAbsolutePath());
        }
    }

    private void resetPanel() {
        this.paParams = new PostAnalysisParameters(EnrichmentMapManager.getInstance().getMap(this.cyApplicationManager.getCurrentNetwork().getSUID()));
        this.signatureHub.setSelected(true);
        this.GMTFileNameTextField.setText("");
        this.GMTFileNameTextField.setValue("");
        this.GMTFileNameTextField.setToolTipText(null);
        this.signatureGMTFileNameTextField.setText("");
        this.signatureGMTFileNameTextField.setValue("");
        this.signatureGMTFileNameTextField.setToolTipText(null);
        this.avail_sig_sets = this.paParams.getSignatureSetNames();
        this.avail_sig_sets_field.setModel(this.avail_sig_sets);
        this.avail_sig_sets_field.clearSelection();
        this.setAvSigCount(0);
        this.selected_sig_sets = this.paParams.getSelectedSignatureSetNames();
        this.selected_sig_sets_field.setModel(this.selected_sig_sets);
        this.selected_sig_sets_field.clearSelection();
        this.setSelSigCount(0);
        this.paParams.setSignature_CutoffMetric(this.paParams.getDefault_signature_CutoffMetric());
        this.sigCutoffCombo.setSelectedIndex(this.paParams.getSignature_CutoffMetric());
        switch (this.paParams.getSignature_CutoffMetric()) {
            case 0: {
                this.sigCutoffTextField.setValue(this.paParams.getSignature_Hypergeom_Cutoff());
                break;
            }
            case 1: {
                this.sigCutoffTextField.setValue(this.paParams.getSignature_absNumber_Cutoff());
                break;
            }
            case 2: {
                this.sigCutoffTextField.setValue(this.paParams.getSignature_Jaccard_Cutoff());
                break;
            }
            case 3: {
                this.sigCutoffTextField.setValue(this.paParams.getSignature_Overlap_Cutoff());
                break;
            }
            default: {
                String message = "This Cutoff metric is not supported.";
                JOptionPane.showMessageDialog(this.application.getJFrame(), message, "Parameter out of bounds", 2);
            }
        }
        this.filter.setSelected(true);
        this.nofilter.setSelected(false);
        this.paParams.setFilter(false);
        this.filterTextField.setValue(this.paParams.getFilterValue());
        this.paParams.setSignature_filterMetric(this.paParams.getDefault_signature_filterMetric());
        this.filterTypeCombo.setSelectedItem(this.paParams.getSignature_filterMetric());
    }

    public void updateContents(EnrichmentMapParameters current_params) {
        this.paParams = EnrichmentMapManager.getInstance().getMap(this.cyApplicationManager.getCurrentNetwork().getSUID()).getPaParams();
        this.paParams = EnrichmentMapManager.getInstance().getMap(this.cyApplicationManager.getCurrentNetwork().getSUID()).getPaParams();
        this.GMTFileNameTextField.setText(this.paParams.getGMTFileName());
        this.GMTFileNameTextField.setValue(this.paParams.getGMTFileName());
        this.signatureGMTFileNameTextField.setText(this.paParams.getSignatureGMTFileName());
        this.signatureGMTFileNameTextField.setValue(this.paParams.getSignatureGMTFileName());
        this.avail_sig_sets = this.paParams.getSignatureSetNames();
        this.avail_sig_sets_field.setModel(this.avail_sig_sets);
        this.selected_sig_sets = this.paParams.getSelectedSignatureSetNames();
        this.selected_sig_sets_field.setModel(this.selected_sig_sets);
        this.sigCutoffCombo.setSelectedIndex(this.paParams.getSignature_CutoffMetric());
        switch (this.paParams.getSignature_CutoffMetric()) {
            case 0: {
                this.sigCutoffTextField.setValue(this.paParams.getSignature_Hypergeom_Cutoff());
                break;
            }
            case 1: {
                this.sigCutoffTextField.setValue(this.paParams.getSignature_absNumber_Cutoff());
                break;
            }
            case 2: {
                this.sigCutoffTextField.setValue(this.paParams.getSignature_Jaccard_Cutoff());
                break;
            }
            case 3: {
                this.sigCutoffTextField.setValue(this.paParams.getSignature_Overlap_Cutoff());
                break;
            }
            default: {
                String message = "This Cutoff metric is not supported.";
                JOptionPane.showMessageDialog(this.application.getJFrame(), message, "Parameter out of bounds", 2);
            }
        }
    }

    public PostAnalysisParameters getPaParams() {
        return this.paParams;
    }

    public void setPaParams(PostAnalysisParameters paParams) {
        this.paParams = paParams;
    }

    public Component getComponent() {
        return this;
    }

    public CytoPanelName getCytoPanelName() {
        return CytoPanelName.WEST;
    }

    public Icon getIcon() {
        URL EMIconURL = this.getClass().getResource("enrichmentmap_logo_notext_small.png");
        ImageIcon EMIcon = null;
        if (EMIconURL != null) {
            EMIcon = new ImageIcon(EMIconURL);
        }
        return EMIcon;
    }

    public String getTitle() {
        return "Post Analysis Input Panel";
    }

    public JLabel createAvSigCountLabel() {
        if (this.avail_sig_sets_counter_label == null) {
            this.avail_sig_sets_counter_label = new JLabel("(0)");
        }
        return this.avail_sig_sets_counter_label;
    }

    public void setAvSigCount(int avSigCount) {
        this.avail_sig_sets_count = 0;
        this.avail_sig_sets_counter_label.setText("(" + Integer.toString(avSigCount) + ")");
    }

    public int getAvSigCount() {
        return this.avail_sig_sets_count;
    }

    public JLabel createSelSigCountLabel() {
        if (this.selected_sig_sets_counter_label == null) {
            this.selected_sig_sets_counter_label = new JLabel("(0)");
        }
        return this.selected_sig_sets_counter_label;
    }

    public void setSelSigCount(int num) {
        this.sel_sig_sets_count = num;
        this.selected_sig_sets_counter_label.setText("(" + Integer.toString(num) + ")");
    }

    public int getSelSigCount() {
        return this.sel_sig_sets_count;
    }

    private class PaPanelActionListener
    implements ActionListener {
        protected PostAnalysisInputPanel paPanel = null;

        public PaPanelActionListener(PostAnalysisInputPanel paPanel) {
            this.paPanel = paPanel;
        }

        public void actionPerformed(ActionEvent arg0) {
        }
    }

    private class FormattedTextFieldAction
    implements PropertyChangeListener {
        private FormattedTextFieldAction() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            JFormattedTextField source = (JFormattedTextField)e.getSource();
            String message = "The value you have entered is invalid.\n";
            boolean invalid = false;
            if (source == PostAnalysisInputPanel.this.GMTFileNameTextField) {
                String value = PostAnalysisInputPanel.this.GMTFileNameTextField.getText();
                if (value.equalsIgnoreCase("")) {
                    PostAnalysisInputPanel.this.paParams.setGMTFileName(value);
                } else if (!PostAnalysisInputPanel.this.GMTFileNameTextField.getText().equalsIgnoreCase((String)e.getOldValue())) {
                    if (PostAnalysisInputPanel.this.checkFile(value).equals(Color.RED)) {
                        JOptionPane.showMessageDialog(PostAnalysisInputPanel.this.application.getJFrame(), message, "File name change entered is not a valid file name", 2);
                        PostAnalysisInputPanel.this.GMTFileNameTextField.setForeground(PostAnalysisInputPanel.this.checkFile(value));
                    } else {
                        PostAnalysisInputPanel.this.paParams.setGMTFileName(value);
                    }
                }
            } else if (source == PostAnalysisInputPanel.this.signatureGMTFileNameTextField) {
                String value = PostAnalysisInputPanel.this.signatureGMTFileNameTextField.getText();
                if (value.equalsIgnoreCase("")) {
                    PostAnalysisInputPanel.this.paParams.setSignatureGMTFileName(value);
                } else if (!PostAnalysisInputPanel.this.signatureGMTFileNameTextField.getText().equalsIgnoreCase((String)e.getOldValue())) {
                    if (PostAnalysisInputPanel.this.checkFile(value).equals(Color.RED)) {
                        JOptionPane.showMessageDialog(PostAnalysisInputPanel.this.application.getJFrame(), message, "File name change entered is not a valid file name", 2);
                        PostAnalysisInputPanel.this.signatureGMTFileNameTextField.setForeground(PostAnalysisInputPanel.this.checkFile(value));
                    } else {
                        PostAnalysisInputPanel.this.paParams.setSignatureGMTFileName(value);
                    }
                }
            } else if (source == PostAnalysisInputPanel.this.sigCutoffTextField) {
                Number value = (Number)PostAnalysisInputPanel.this.sigCutoffTextField.getValue();
                if (PostAnalysisInputPanel.this.paParams.getSignature_CutoffMetric() == 0) {
                    if (value != null && value.doubleValue() >= 0.0 && value.doubleValue() <= 1.0) {
                        PostAnalysisInputPanel.this.paParams.setSignature_Hypergeom_Cutoff(value.doubleValue());
                    } else {
                        source.setValue(PostAnalysisInputPanel.this.paParams.getSignature_Hypergeom_Cutoff());
                        message = message + "The Hypergeometric-pValue cutoff must be greater or equal than 0.0 and less than or equal to 1.0.";
                        invalid = true;
                    }
                } else if (PostAnalysisInputPanel.this.paParams.getSignature_CutoffMetric() == 1) {
                    if (value != null && value.intValue() >= 0) {
                        PostAnalysisInputPanel.this.paParams.setSignature_absNumber_Cutoff(value.intValue());
                    } else {
                        source.setValue(PostAnalysisInputPanel.this.paParams.getSignature_absNumber_Cutoff());
                        message = message + "The \"Number of common genes\" cutoff must be a non-negative Integer (0 or larger).";
                        invalid = true;
                    }
                } else if (PostAnalysisInputPanel.this.paParams.getSignature_CutoffMetric() == 2) {
                    if (value != null && value.doubleValue() > 0.0 && value.doubleValue() <= 1.0) {
                        PostAnalysisInputPanel.this.paParams.setSignature_Jaccard_Cutoff(value.doubleValue());
                    } else {
                        source.setValue(PostAnalysisInputPanel.this.paParams.getSignature_Jaccard_Cutoff());
                        message = message + "The Jaccard Coefficient cutoff must be greater than 0.0 and less than or equal to 1.0.";
                        invalid = true;
                    }
                } else if (PostAnalysisInputPanel.this.paParams.getSignature_CutoffMetric() == 3) {
                    if (value != null && value.doubleValue() > 0.0 && value.doubleValue() <= 1.0) {
                        PostAnalysisInputPanel.this.paParams.setSignature_Overlap_Cutoff(value.doubleValue());
                    } else {
                        source.setValue(PostAnalysisInputPanel.this.paParams.getSignature_Overlap_Cutoff());
                        message = message + "The Overlap Coefficient cutoff must be greater than 0.0 and less than or equal to 1.0.";
                        invalid = true;
                    }
                } else if (PostAnalysisInputPanel.this.paParams.getSignature_CutoffMetric() == 4) {
                    if (value != null && value.doubleValue() > 0.0 && value.doubleValue() <= 1.0) {
                        PostAnalysisInputPanel.this.paParams.setSignature_DirOverlap_Cutoff(value.doubleValue());
                    } else {
                        source.setValue(PostAnalysisInputPanel.this.paParams.getSignature_DirOverlap_Cutoff());
                        message = message + "The Overlap Coefficient cutoff must be greater than 0.0 and less than or equal to 1.0.";
                        invalid = true;
                    }
                } else {
                    message = "This Cutoff metric is not supported.";
                    invalid = true;
                }
            } else if (source == PostAnalysisInputPanel.this.filterTextField) {
                Number value = (Number)PostAnalysisInputPanel.this.filterTextField.getValue();
                int n = PostAnalysisInputPanel.this.paParams.getSignature_filterMetric();
                PostAnalysisInputPanel.this.paParams;
                if (n == 0) {
                    if (value != null && value.intValue() >= 0 && value.intValue() <= 100) {
                        PostAnalysisInputPanel.this.paParams.setFilterValue(value.intValue());
                    } else {
                        source.setValue(PostAnalysisInputPanel.this.paParams.getFilterValue());
                        message = message + "The filter cutoff must be greater than or equal 0 and less than or equal to 100.";
                        invalid = true;
                    }
                } else {
                    int n2 = PostAnalysisInputPanel.this.paParams.getSignature_filterMetric();
                    PostAnalysisInputPanel.this.paParams;
                    if (n2 == 1) {
                        if (value != null && value.intValue() >= 0) {
                            PostAnalysisInputPanel.this.paParams.setFilterValue(value.intValue());
                        } else {
                            source.setValue(PostAnalysisInputPanel.this.paParams.getFilterValue());
                            message = message + "The filter cutoff must be greater than or equal 0.";
                            invalid = true;
                        }
                    }
                }
            }
            if (invalid) {
                JOptionPane.showMessageDialog(PostAnalysisInputPanel.this.application.getJFrame(), message, "Parameter out of bounds", 2);
            }
        }
    }
}

