/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.autoannotate.action;

import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationManager;
import org.baderlab.csplugins.enrichmentmap.autoannotate.action.TableCellListener;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.AnnotationSet;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.Cluster;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.cluster.DrawClusterLabelTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;

public class ClusterTableUpdateNameAction
extends AbstractAction {
    private static final long serialVersionUID = 3764130543697594367L;
    private AnnotationSet annotationSet;

    public ClusterTableUpdateNameAction(AnnotationSet annotationSet) {
        this.annotationSet = annotationSet;
    }

    public void actionPerformed(ActionEvent e) {
        TableCellListener tcl = (TableCellListener)e.getSource();
        String originalValue = (String)tcl.getOldValue();
        String newValue = (String)tcl.getNewValue();
        System.out.println("Row   : " + tcl.getRow());
        System.out.println("Column: " + tcl.getColumn());
        System.out.println("Old   : " + tcl.getOldValue());
        System.out.println("New   : " + tcl.getNewValue());
        TreeMap<Integer, Cluster> clusters = this.annotationSet.getClusterMap();
        for (Map.Entry<Integer, Cluster> entry : clusters.entrySet()) {
            Cluster currentCluster = entry.getValue();
            if (!currentCluster.getLabel().equals(originalValue)) continue;
            currentCluster.setLabel(newValue);
            currentCluster.eraseText();
            DrawClusterLabelTask drawlabel = new DrawClusterLabelTask(currentCluster);
            AutoAnnotationManager.getInstance().getDialogTaskManager().execute(new TaskIterator(new Task[]{drawlabel}));
        }
    }
}

