/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.autoannotate.task;

import java.util.List;
import javax.swing.JOptionPane;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapUtils;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationManager;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationParameters;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.AnnotationSet;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.CreateClustersTask;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.CreateGroupsTask;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.LayoutNetworkTask;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.Observer;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.RunClustermakerTaskFactory;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.RunWordCloudForClustersTaskFactory;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.UpdateAnnotationPanelTask;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.cluster.ComputeClusterLabelsTask;
import org.baderlab.csplugins.enrichmentmap.autoannotate.view.AutoAnnotationPanel;
import org.baderlab.csplugins.enrichmentmap.task.BuildEnrichmentMapDummyTask;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.TaskObserver;

public class AutoAnnotationTask
extends AbstractTask {
    private AutoAnnotationParameters params;
    private AutoAnnotationPanel autoAnnotationPanel;

    public AutoAnnotationTask(AutoAnnotationParameters params) {
        this.params = params;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.autoAnnotationPanel = AutoAnnotationManager.getInstance().getAnnotationPanel();
        CyNetworkView selectedView = this.autoAnnotationPanel.getCurrentView();
        if (selectedView == null) {
            JOptionPane.showMessageDialog(null, "Load an Enrichment Map", "Error Message", 0);
        } else {
            Observer observer;
            String clusterColumnName = null;
            String algorithm = null;
            if (this.autoAnnotationPanel.isClusterMaker()) {
                algorithm = this.autoAnnotationPanel.getAlgorithm();
                clusterColumnName = this.autoAnnotationPanel.getClusterColumnName(this.params);
            } else {
                clusterColumnName = this.autoAnnotationPanel.getClusterColumnName(this.params);
            }
            String annotationSetName = this.params.nextAnnotationSetName(algorithm, clusterColumnName);
            if (algorithm != null) {
                this.params.setAlgorithm(algorithm);
            }
            this.params.setName(annotationSetName);
            this.params.setClusterColumnName(clusterColumnName);
            this.params.setGroups(this.autoAnnotationPanel.isGroupsSelected());
            this.params.setAnnotateColumnName(this.autoAnnotationPanel.getAnnotationColumnName());
            this.autoAnnotationPanel.setAnnotating(true);
            EnrichmentMapUtils.setOverrideHeatmapRevalidation(true);
            AnnotationSet annotationSet = new AnnotationSet(this.params.getName(), this.params.getNetworkView(), this.params.getClusterColumnName(), this.params.getAnnotateColumnName());
            this.params.addAnnotationSet(annotationSet);
            TaskIterator currentTasks = new TaskIterator(new Task[0]);
            new BuildEnrichmentMapDummyTask("Annotating Enrichment Map").run(taskMonitor);
            taskMonitor.setTitle("Annotating Enrichment Map");
            if (this.params.getAlgorithm() != null) {
                taskMonitor.setTitle("Clustering Nodes...");
                observer = new Observer();
                AutoAnnotationManager.getInstance().getDialogTaskManager().execute(new RunClustermakerTaskFactory(this.params).createTaskIterator(), (TaskObserver)observer);
                this.waitTilTaskIsDone(observer);
            }
            taskMonitor.setTitle("Creating Clusters...");
            observer = new Observer();
            AutoAnnotationManager.getInstance().getDialogTaskManager().execute(new TaskIterator(new Task[]{new CreateClustersTask(annotationSet, this.params)}), (TaskObserver)observer);
            this.waitTilTaskIsDone(observer);
            taskMonitor.setTitle("Calculating annotations...");
            observer = new Observer();
            AutoAnnotationManager.getInstance().getDialogTaskManager().execute(new RunWordCloudForClustersTaskFactory(annotationSet, this.params).createTaskIterator(), (TaskObserver)observer);
            this.waitTilTaskIsDone(observer);
            if (this.autoAnnotationPanel.isLayoutNodeSelected() && this.params.getNetwork().getDefaultNodeTable().getColumn(this.params.getClusterColumnName()).getType() != List.class) {
                taskMonitor.setTitle("Laying Out Network...");
                LayoutNetworkTask layouttask = new LayoutNetworkTask(annotationSet, this.params);
                currentTasks.append((Task)layouttask);
            }
            ComputeClusterLabelsTask computeLabels = new ComputeClusterLabelsTask(annotationSet, this.params);
            currentTasks.append((Task)computeLabels);
            if (annotationSet.usingGroups()) {
                taskMonitor.setTitle("Creating Groups...");
                currentTasks.append((Task)new CreateGroupsTask(annotationSet, this.params));
            }
            taskMonitor.setTitle("Cleaning Up...");
            currentTasks.append((Task)new UpdateAnnotationPanelTask(annotationSet, this.params));
            AutoAnnotationManager.getInstance().getDialogTaskManager().execute(currentTasks);
        }
    }

    private void waitTilTaskIsDone(Observer observer) {
        while (!observer.isFinished()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

