/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.list.AbstractList;
import cern.colt.list.ByteArrayList;
import java.util.ArrayList;

public abstract class AbstractByteList
extends AbstractList {
    protected int size;

    protected AbstractByteList() {
    }

    public void addAllOfFromTo(AbstractByteList abstractByteList, int n, int n2) {
        this.beforeInsertAllOfFromTo(this.size, abstractByteList, n, n2);
    }

    public void beforeInsertAllOfFromTo(int n, AbstractByteList abstractByteList, int n2, int n3) {
        int n4 = n3 - n2 + 1;
        this.beforeInsertDummies(n, n4);
        this.replaceFromToWithFrom(n, n + n4 - 1, abstractByteList, n2);
    }

    protected void beforeInsertDummies(int n, int n2) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        if (n2 > 0) {
            this.ensureCapacity(this.size + n2);
            this.setSizeRaw(this.size + n2);
            this.replaceFromToWithFrom(n + n2, this.size - 1, this, n);
        }
    }

    public Object clone() {
        return this.partFromTo(0, this.size - 1);
    }

    public byte[] elements() {
        byte[] byArray = new byte[this.size];
        int n = this.size;
        while (--n >= 0) {
            byArray[n] = this.getQuick(n);
        }
        return byArray;
    }

    public AbstractByteList elements(byte[] byArray) {
        this.clear();
        this.addAllOfFromTo(new ByteArrayList(byArray), 0, byArray.length - 1);
        return this;
    }

    public abstract void ensureCapacity(int var1);

    public boolean equals(Object object) {
        if (!(object instanceof AbstractByteList)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        AbstractByteList abstractByteList = (AbstractByteList)object;
        if (this.size() != abstractByteList.size()) {
            return false;
        }
        int n = this.size();
        while (--n >= 0) {
            if (this.getQuick(n) == abstractByteList.getQuick(n)) continue;
            return false;
        }
        return true;
    }

    public byte get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.getQuick(n);
    }

    protected abstract byte getQuick(int var1);

    public AbstractByteList partFromTo(int n, int n2) {
        AbstractByteList.checkRangeFromTo(n, n2, this.size);
        int n3 = n2 - n + 1;
        ByteArrayList byteArrayList = new ByteArrayList(n3);
        byteArrayList.addAllOfFromTo(this, n, n2);
        return byteArrayList;
    }

    public void removeFromTo(int n, int n2) {
        int n3;
        AbstractByteList.checkRangeFromTo(n, n2, this.size);
        int n4 = this.size - n2 - 1;
        if (n4 > 0) {
            this.replaceFromToWithFrom(n, n - 1 + n4, this, n2 + 1);
        }
        if ((n3 = n2 - n + 1) > 0) {
            this.setSizeRaw(this.size - n3);
        }
    }

    public void replaceFromToWithFrom(int n, int n2, AbstractByteList abstractByteList, int n3) {
        block4: {
            int n4 = n2 - n + 1;
            if (n4 <= 0) break block4;
            AbstractByteList.checkRangeFromTo(n, n2, this.size());
            AbstractByteList.checkRangeFromTo(n3, n3 + n4 - 1, abstractByteList.size());
            if (n <= n3) {
                while (--n4 >= 0) {
                    this.setQuick(n++, abstractByteList.getQuick(n3++));
                }
            } else {
                int n5 = n3 + n4 - 1;
                while (--n4 >= 0) {
                    this.setQuick(n2--, abstractByteList.getQuick(n5--));
                }
            }
        }
    }

    protected abstract void setQuick(int var1, byte var2);

    protected void setSizeRaw(int n) {
        this.size = n;
    }

    public int size() {
        return this.size;
    }

    public ArrayList toList() {
        int n = this.size();
        ArrayList<Byte> arrayList = new ArrayList<Byte>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new Byte(this.get(i)));
        }
        return arrayList;
    }

    public String toString() {
        return Arrays.toString(this.partFromTo(0, this.size() - 1).elements());
    }
}

