/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.list.AbstractList;
import cern.colt.list.FloatArrayList;
import java.util.ArrayList;

public abstract class AbstractFloatList
extends AbstractList {
    protected int size;

    protected AbstractFloatList() {
    }

    public void addAllOfFromTo(AbstractFloatList abstractFloatList, int n, int n2) {
        this.beforeInsertAllOfFromTo(this.size, abstractFloatList, n, n2);
    }

    public void beforeInsertAllOfFromTo(int n, AbstractFloatList abstractFloatList, int n2, int n3) {
        int n4 = n3 - n2 + 1;
        this.beforeInsertDummies(n, n4);
        this.replaceFromToWithFrom(n, n + n4 - 1, abstractFloatList, n2);
    }

    protected void beforeInsertDummies(int n, int n2) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        if (n2 > 0) {
            this.ensureCapacity(this.size + n2);
            this.setSizeRaw(this.size + n2);
            this.replaceFromToWithFrom(n + n2, this.size - 1, this, n);
        }
    }

    public Object clone() {
        return this.partFromTo(0, this.size - 1);
    }

    public float[] elements() {
        float[] fArray = new float[this.size];
        int n = this.size;
        while (--n >= 0) {
            fArray[n] = this.getQuick(n);
        }
        return fArray;
    }

    public AbstractFloatList elements(float[] fArray) {
        this.clear();
        this.addAllOfFromTo(new FloatArrayList(fArray), 0, fArray.length - 1);
        return this;
    }

    public abstract void ensureCapacity(int var1);

    public boolean equals(Object object) {
        if (!(object instanceof AbstractFloatList)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        AbstractFloatList abstractFloatList = (AbstractFloatList)object;
        if (this.size() != abstractFloatList.size()) {
            return false;
        }
        int n = this.size();
        while (--n >= 0) {
            if (this.getQuick(n) == abstractFloatList.getQuick(n)) continue;
            return false;
        }
        return true;
    }

    public float get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.getQuick(n);
    }

    protected abstract float getQuick(int var1);

    public AbstractFloatList partFromTo(int n, int n2) {
        AbstractFloatList.checkRangeFromTo(n, n2, this.size);
        int n3 = n2 - n + 1;
        FloatArrayList floatArrayList = new FloatArrayList(n3);
        floatArrayList.addAllOfFromTo(this, n, n2);
        return floatArrayList;
    }

    public void removeFromTo(int n, int n2) {
        int n3;
        AbstractFloatList.checkRangeFromTo(n, n2, this.size);
        int n4 = this.size - n2 - 1;
        if (n4 > 0) {
            this.replaceFromToWithFrom(n, n - 1 + n4, this, n2 + 1);
        }
        if ((n3 = n2 - n + 1) > 0) {
            this.setSizeRaw(this.size - n3);
        }
    }

    public void replaceFromToWithFrom(int n, int n2, AbstractFloatList abstractFloatList, int n3) {
        block4: {
            int n4 = n2 - n + 1;
            if (n4 <= 0) break block4;
            AbstractFloatList.checkRangeFromTo(n, n2, this.size());
            AbstractFloatList.checkRangeFromTo(n3, n3 + n4 - 1, abstractFloatList.size());
            if (n <= n3) {
                while (--n4 >= 0) {
                    this.setQuick(n++, abstractFloatList.getQuick(n3++));
                }
            } else {
                int n5 = n3 + n4 - 1;
                while (--n4 >= 0) {
                    this.setQuick(n2--, abstractFloatList.getQuick(n5--));
                }
            }
        }
    }

    protected abstract void setQuick(int var1, float var2);

    protected void setSizeRaw(int n) {
        this.size = n;
    }

    public int size() {
        return this.size;
    }

    public ArrayList toList() {
        int n = this.size();
        ArrayList<Float> arrayList = new ArrayList<Float>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new Float(this.get(i)));
        }
        return arrayList;
    }

    public String toString() {
        return Arrays.toString(this.partFromTo(0, this.size() - 1).elements());
    }
}

