/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.list.AbstractList;
import cern.colt.list.IntArrayList;
import java.util.ArrayList;

public abstract class AbstractIntList
extends AbstractList {
    protected int size;

    protected AbstractIntList() {
    }

    public void addAllOfFromTo(AbstractIntList abstractIntList, int n, int n2) {
        this.beforeInsertAllOfFromTo(this.size, abstractIntList, n, n2);
    }

    public void beforeInsertAllOfFromTo(int n, AbstractIntList abstractIntList, int n2, int n3) {
        int n4 = n3 - n2 + 1;
        this.beforeInsertDummies(n, n4);
        this.replaceFromToWithFrom(n, n + n4 - 1, abstractIntList, n2);
    }

    protected void beforeInsertDummies(int n, int n2) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        if (n2 > 0) {
            this.ensureCapacity(this.size + n2);
            this.setSizeRaw(this.size + n2);
            this.replaceFromToWithFrom(n + n2, this.size - 1, this, n);
        }
    }

    public Object clone() {
        return this.partFromTo(0, this.size - 1);
    }

    public int[] elements() {
        int[] nArray = new int[this.size];
        int n = this.size;
        while (--n >= 0) {
            nArray[n] = this.getQuick(n);
        }
        return nArray;
    }

    public AbstractIntList elements(int[] nArray) {
        this.clear();
        this.addAllOfFromTo(new IntArrayList(nArray), 0, nArray.length - 1);
        return this;
    }

    public abstract void ensureCapacity(int var1);

    public boolean equals(Object object) {
        if (!(object instanceof AbstractIntList)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        AbstractIntList abstractIntList = (AbstractIntList)object;
        if (this.size() != abstractIntList.size()) {
            return false;
        }
        int n = this.size();
        while (--n >= 0) {
            if (this.getQuick(n) == abstractIntList.getQuick(n)) continue;
            return false;
        }
        return true;
    }

    public int get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.getQuick(n);
    }

    protected abstract int getQuick(int var1);

    public AbstractIntList partFromTo(int n, int n2) {
        AbstractIntList.checkRangeFromTo(n, n2, this.size);
        int n3 = n2 - n + 1;
        IntArrayList intArrayList = new IntArrayList(n3);
        intArrayList.addAllOfFromTo(this, n, n2);
        return intArrayList;
    }

    public void removeFromTo(int n, int n2) {
        int n3;
        AbstractIntList.checkRangeFromTo(n, n2, this.size);
        int n4 = this.size - n2 - 1;
        if (n4 > 0) {
            this.replaceFromToWithFrom(n, n - 1 + n4, this, n2 + 1);
        }
        if ((n3 = n2 - n + 1) > 0) {
            this.setSizeRaw(this.size - n3);
        }
    }

    public void replaceFromToWithFrom(int n, int n2, AbstractIntList abstractIntList, int n3) {
        block4: {
            int n4 = n2 - n + 1;
            if (n4 <= 0) break block4;
            AbstractIntList.checkRangeFromTo(n, n2, this.size());
            AbstractIntList.checkRangeFromTo(n3, n3 + n4 - 1, abstractIntList.size());
            if (n <= n3) {
                while (--n4 >= 0) {
                    this.setQuick(n++, abstractIntList.getQuick(n3++));
                }
            } else {
                int n5 = n3 + n4 - 1;
                while (--n4 >= 0) {
                    this.setQuick(n2--, abstractIntList.getQuick(n5--));
                }
            }
        }
    }

    protected abstract void setQuick(int var1, int var2);

    protected void setSizeRaw(int n) {
        this.size = n;
    }

    public int size() {
        return this.size;
    }

    public ArrayList toList() {
        int n = this.size();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new Integer(this.get(i)));
        }
        return arrayList;
    }

    public String toString() {
        return Arrays.toString(this.partFromTo(0, this.size() - 1).elements());
    }
}

