/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.list.AbstractIntList;

public class IntArrayList
extends AbstractIntList {
    protected int[] elements;

    public IntArrayList() {
        this(10);
    }

    public IntArrayList(int[] nArray) {
        this.elements(nArray);
    }

    public IntArrayList(int n) {
        this(new int[n]);
        this.setSizeRaw(0);
    }

    public Object clone() {
        IntArrayList intArrayList = new IntArrayList((int[])this.elements.clone());
        intArrayList.setSizeRaw(this.size);
        return intArrayList;
    }

    public int[] elements() {
        return this.elements;
    }

    public AbstractIntList elements(int[] nArray) {
        this.elements = nArray;
        this.size = nArray.length;
        return this;
    }

    public void ensureCapacity(int n) {
        this.elements = Arrays.ensureCapacity(this.elements, n);
    }

    public boolean equals(Object object) {
        if (!(object instanceof IntArrayList)) {
            return super.equals(object);
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        IntArrayList intArrayList = (IntArrayList)object;
        if (this.size() != intArrayList.size()) {
            return false;
        }
        int[] nArray = this.elements();
        int[] nArray2 = intArrayList.elements();
        int n = this.size();
        while (--n >= 0) {
            if (nArray[n] == nArray2[n]) continue;
            return false;
        }
        return true;
    }

    public int get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.elements[n];
    }

    public int getQuick(int n) {
        return this.elements[n];
    }

    public AbstractIntList partFromTo(int n, int n2) {
        if (this.size == 0) {
            return new IntArrayList(0);
        }
        IntArrayList.checkRangeFromTo(n, n2, this.size);
        int[] nArray = new int[n2 - n + 1];
        System.arraycopy(this.elements, n, nArray, 0, n2 - n + 1);
        return new IntArrayList(nArray);
    }

    public void replaceFromToWithFrom(int n, int n2, AbstractIntList abstractIntList, int n3) {
        if (!(abstractIntList instanceof IntArrayList)) {
            super.replaceFromToWithFrom(n, n2, abstractIntList, n3);
            return;
        }
        int n4 = n2 - n + 1;
        if (n4 > 0) {
            IntArrayList.checkRangeFromTo(n, n2, this.size());
            IntArrayList.checkRangeFromTo(n3, n3 + n4 - 1, abstractIntList.size());
            System.arraycopy(((IntArrayList)abstractIntList).elements, n3, this.elements, n, n4);
        }
    }

    public void setQuick(int n, int n2) {
        this.elements[n] = n2;
    }
}

