/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.list.AbstractShortList;

public class ShortArrayList
extends AbstractShortList {
    protected short[] elements;

    public ShortArrayList() {
        this(10);
    }

    public ShortArrayList(short[] sArray) {
        this.elements(sArray);
    }

    public ShortArrayList(int n) {
        this(new short[n]);
        this.setSizeRaw(0);
    }

    public Object clone() {
        ShortArrayList shortArrayList = new ShortArrayList((short[])this.elements.clone());
        shortArrayList.setSizeRaw(this.size);
        return shortArrayList;
    }

    public short[] elements() {
        return this.elements;
    }

    public AbstractShortList elements(short[] sArray) {
        this.elements = sArray;
        this.size = sArray.length;
        return this;
    }

    public void ensureCapacity(int n) {
        this.elements = Arrays.ensureCapacity(this.elements, n);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ShortArrayList)) {
            return super.equals(object);
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        ShortArrayList shortArrayList = (ShortArrayList)object;
        if (this.size() != shortArrayList.size()) {
            return false;
        }
        short[] sArray = this.elements();
        short[] sArray2 = shortArrayList.elements();
        int n = this.size();
        while (--n >= 0) {
            if (sArray[n] == sArray2[n]) continue;
            return false;
        }
        return true;
    }

    public short get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.elements[n];
    }

    public short getQuick(int n) {
        return this.elements[n];
    }

    public AbstractShortList partFromTo(int n, int n2) {
        if (this.size == 0) {
            return new ShortArrayList(0);
        }
        ShortArrayList.checkRangeFromTo(n, n2, this.size);
        short[] sArray = new short[n2 - n + 1];
        System.arraycopy(this.elements, n, sArray, 0, n2 - n + 1);
        return new ShortArrayList(sArray);
    }

    public void replaceFromToWithFrom(int n, int n2, AbstractShortList abstractShortList, int n3) {
        if (!(abstractShortList instanceof ShortArrayList)) {
            super.replaceFromToWithFrom(n, n2, abstractShortList, n3);
            return;
        }
        int n4 = n2 - n + 1;
        if (n4 > 0) {
            ShortArrayList.checkRangeFromTo(n, n2, this.size());
            ShortArrayList.checkRangeFromTo(n3, n3 + n4 - 1, abstractShortList.size());
            System.arraycopy(((ShortArrayList)abstractShortList).elements, n3, this.elements, n, n4);
        }
    }

    public void setQuick(int n, short s) {
        this.elements[n] = s;
    }
}

