/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.quantile;

import cern.jet.stat.quantile.BufferSet;
import cern.jet.stat.quantile.DoubleBuffer;

class DoubleBufferSet
extends BufferSet {
    protected DoubleBuffer[] buffers;

    public DoubleBuffer[] _getFullOrPartialBuffers() {
        int n = 0;
        int n2 = this.buffers.length;
        while (--n2 >= 0) {
            if (this.buffers[n2].isEmpty()) continue;
            ++n;
        }
        DoubleBuffer[] doubleBufferArray = new DoubleBuffer[n];
        int n3 = 0;
        int n4 = this.buffers.length;
        while (--n4 >= 0) {
            if (this.buffers[n4].isEmpty()) continue;
            doubleBufferArray[n3++] = this.buffers[n4];
        }
        return doubleBufferArray;
    }

    public int b() {
        return this.buffers.length;
    }

    public Object clone() {
        DoubleBufferSet doubleBufferSet = (DoubleBufferSet)super.clone();
        doubleBufferSet.buffers = (DoubleBuffer[])doubleBufferSet.buffers.clone();
        int n = this.buffers.length;
        while (--n >= 0) {
            doubleBufferSet.buffers[n] = (DoubleBuffer)doubleBufferSet.buffers[n].clone();
        }
        return doubleBufferSet;
    }

    public int k() {
        return this.buffers[0].k;
    }

    public long memory() {
        long l = 0L;
        int n = this.buffers.length;
        while (--n >= 0) {
            l += (long)this.buffers[n].memory();
        }
        return l;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.b(); ++i) {
            if (this.buffers[i].isEmpty()) continue;
            stringBuffer.append("buffer#" + i + " = ");
            stringBuffer.append(this.buffers[i].toString() + "\n");
        }
        return stringBuffer.toString();
    }

    public long totalSize() {
        DoubleBuffer[] doubleBufferArray = this._getFullOrPartialBuffers();
        long l = 0L;
        int n = doubleBufferArray.length;
        while (--n >= 0) {
            l += (long)(doubleBufferArray[n].size() * doubleBufferArray[n].weight());
        }
        return l;
    }
}

