/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.random;

import java.io.Serializable;
import java.security.SecureRandom;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;

public class RandomDataGenerator
implements Serializable {
    private RandomGenerator rand = null;
    private SecureRandom secRand = null;

    public long nextLong(long lower, long upper) throws NumberIsTooLargeException {
        if (lower >= upper) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)lower, upper, false);
        }
        long max = upper - lower + 1L;
        if (max <= 0L) {
            long r;
            RandomGenerator rng = this.getRandomGenerator();
            while ((r = rng.nextLong()) < lower || r > upper) {
            }
            return r;
        }
        if (max < Integer.MAX_VALUE) {
            return lower + (long)this.getRandomGenerator().nextInt((int)max);
        }
        return lower + RandomDataGenerator.nextLong(this.getRandomGenerator(), max);
    }

    private static long nextLong(RandomGenerator rng, long n) throws IllegalArgumentException {
        if (n > 0L) {
            long bits;
            long val;
            byte[] byteArray = new byte[8];
            do {
                rng.nextBytes(byteArray);
                bits = 0L;
                for (byte b : byteArray) {
                    bits = bits << 8 | (long)b & 0xFFL;
                }
            } while ((bits &= Long.MAX_VALUE) - (val = bits % n) + (n - 1L) < 0L);
            return val;
        }
        throw new NotStrictlyPositiveException(n);
    }

    public RandomGenerator getRandomGenerator() {
        if (this.rand == null) {
            this.initRan();
        }
        return this.rand;
    }

    private void initRan() {
        this.rand = new Well19937c(System.currentTimeMillis() + (long)System.identityHashCode(this));
    }
}

