/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class EnrichmentMapBuildProperties {
    public static final String APP_VERSION;
    public static final String APP_NAME;
    public static final String APP_URL;
    public static final String USER_MANUAL_URL;
    public static final String BUILD_ID;

    private EnrichmentMapBuildProperties() {
    }

    private static Properties getPropertiesFromClasspath(String propFileName, boolean inMaindir) throws IOException {
        InputStream inputStream = inMaindir ? EnrichmentMapBuildProperties.class.getClassLoader().getResourceAsStream(propFileName) : EnrichmentMapBuildProperties.class.getResourceAsStream(propFileName);
        if (inputStream == null) {
            throw new FileNotFoundException("property file '" + propFileName + "' not found in the classpath");
        }
        Properties props = new Properties();
        props.load(inputStream);
        return props;
    }

    static {
        Properties build_props;
        Properties plugin_props;
        APP_URL = "http://www.baderlab.org/Software/EnrichmentMap";
        USER_MANUAL_URL = APP_URL + "/UserManual";
        try {
            plugin_props = EnrichmentMapBuildProperties.getPropertiesFromClasspath("app.props", false);
        }
        catch (IOException e) {
            e.printStackTrace();
            plugin_props = new Properties();
        }
        APP_VERSION = plugin_props.getProperty("appVersion", "unknown");
        APP_NAME = plugin_props.getProperty("appName", "EnrichmentMap");
        try {
            build_props = EnrichmentMapBuildProperties.getPropertiesFromClasspath("revision.props", false);
        }
        catch (IOException e) {
            e.printStackTrace();
            build_props = new Properties();
        }
        String build_number = build_props.getProperty("build.number", "0");
        String build_user = build_props.getProperty("build.user", "user");
        String git_commit_id = build_props.getProperty("git.commit.id", "0");
        BUILD_ID = String.format("Build: %s from GIT: %s by: %s", build_number, git_commit_id, build_user);
    }
}

