/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import java.util.EnumMap;

public class FilterParameters {
    private FilterType type = FilterType.NO_FILTER;
    private final EnumMap<FilterType, Double> values;

    public FilterParameters() {
        this.values = new EnumMap(FilterType.class);
        for (FilterType type : FilterType.values()) {
            this.values.put(type, type.defaultValue);
        }
    }

    public FilterParameters(FilterParameters source) {
        this.type = source.type;
        this.values = new EnumMap<FilterType, Double>(source.values);
    }

    public FilterType getType() {
        return this.type;
    }

    public void setType(FilterType type) {
        this.type = type;
    }

    public double getValue(FilterType type) {
        return this.values.get((Object)type);
    }

    public void setValue(FilterType type, double value) {
        this.values.put(type, value);
    }

    public static final class FilterType
    extends Enum<FilterType> {
        public static final /* enum */ FilterType NO_FILTER = new FilterType("-- no filter --", 0.0);
        public static final /* enum */ FilterType HYPERGEOM = new FilterType("Hypergeometric Test", 0.05);
        public static final /* enum */ FilterType MANN_WHIT = new FilterType("Mann-Whitney", 0.05);
        public static final /* enum */ FilterType NUMBER = new FilterType("Overlap has at least X genes", 5.0);
        public static final /* enum */ FilterType PERCENT = new FilterType("Overlap is X percent of EM gs", 25.0);
        public static final /* enum */ FilterType SPECIFIC = new FilterType("Overlap is X percent of Signature gs", 25.0);
        public final String display;
        public final double defaultValue;
        private static final /* synthetic */ FilterType[] $VALUES;

        public static FilterType[] values() {
            return (FilterType[])$VALUES.clone();
        }

        private FilterType(String display, double defaultValue) {
            this.display = display;
            this.defaultValue = defaultValue;
        }

        public String toString() {
            return this.display;
        }

        public static FilterType fromDisplayString(String val) {
            for (FilterType metric : FilterType.values()) {
                if (!metric.display.equals(val)) continue;
                return metric;
            }
            return null;
        }

        static {
            $VALUES = new FilterType[]{NO_FILTER, HYPERGEOM, MANN_WHIT, NUMBER, PERCENT, SPECIFIC};
        }
    }
}

