/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.JOptionPane;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.FilterParameters;
import org.baderlab.csplugins.enrichmentmap.PostAnalysisParameters;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.task.BuildDiseaseSignatureTask;
import org.baderlab.csplugins.enrichmentmap.task.BuildDiseaseSignatureTaskResult;
import org.baderlab.csplugins.enrichmentmap.task.CreatePostAnalysisVisualStyleTask;
import org.baderlab.csplugins.enrichmentmap.task.ShowPanelTask;
import org.baderlab.csplugins.enrichmentmap.view.ParametersPanel;
import org.baderlab.csplugins.enrichmentmap.view.PostAnalysisInputPanel;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.equations.EquationCompiler;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.session.CySessionManager;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualMappingManager;
import org.cytoscape.view.vizmap.VisualStyleFactory;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskObserver;
import org.cytoscape.work.swing.DialogTaskManager;

public class BuildPostAnalysisActionListener
implements ActionListener {
    private final PostAnalysisInputPanel inputPanel;
    private final CyApplicationManager applicationManager;
    private final CySwingApplication swingApplication;
    private final CySessionManager sessionManager;
    private final StreamUtil streamUtil;
    private final DialogTaskManager dialog;
    private final CyEventHelper eventHelper;
    private final VisualMappingManager visualMappingManager;
    private final VisualStyleFactory visualStyleFactory;
    private final EquationCompiler equationCompiler;
    private final VisualMappingFunctionFactory vmfFactoryContinuous;
    private final VisualMappingFunctionFactory vmfFactoryDiscrete;
    private final VisualMappingFunctionFactory vmfFactoryPassthrough;

    public BuildPostAnalysisActionListener(PostAnalysisInputPanel panel, CySessionManager sessionManager, StreamUtil streamUtil, CySwingApplication swingApplication, CyApplicationManager applicationManager, DialogTaskManager dialog, CyEventHelper eventHelper, EquationCompiler equationCompiler, VisualMappingManager visualMappingManager, VisualStyleFactory visualStyleFactory, VisualMappingFunctionFactory vmfFactoryContinuous, VisualMappingFunctionFactory vmfFactoryDiscrete, VisualMappingFunctionFactory vmfFactoryPassthrough) {
        this.inputPanel = panel;
        this.sessionManager = sessionManager;
        this.streamUtil = streamUtil;
        this.applicationManager = applicationManager;
        this.swingApplication = swingApplication;
        this.dialog = dialog;
        this.eventHelper = eventHelper;
        this.visualMappingManager = visualMappingManager;
        this.visualStyleFactory = visualStyleFactory;
        this.equationCompiler = equationCompiler;
        this.vmfFactoryContinuous = vmfFactoryContinuous;
        this.vmfFactoryDiscrete = vmfFactoryDiscrete;
        this.vmfFactoryPassthrough = vmfFactoryPassthrough;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.runPostAnalysis();
    }

    public void runPostAnalysis() {
        String errors;
        PostAnalysisParameters paParams = this.inputPanel.getPaParams();
        EnrichmentMap map = EnrichmentMapManager.getInstance().getMap(this.applicationManager.getCurrentNetwork().getSUID());
        if (map != null) {
            paParams.setAttributePrefix(map.getParams().getAttributePrefix());
        }
        StringBuilder errorBuilder = new StringBuilder();
        paParams.checkMinimalRequirements(errorBuilder);
        if (paParams.getRankTestParameters().getType() == FilterParameters.FilterType.MANN_WHIT && map.getAllRanks().isEmpty()) {
            errorBuilder.append(FilterParameters.FilterType.MANN_WHIT.display + " requires ranks. \n");
        }
        if ((errors = errorBuilder.toString()).isEmpty()) {
            if (paParams.isSignatureDiscovery() || paParams.isKnownSignature()) {
                TaskIterator currentTasks = new TaskIterator(new Task[0]);
                BuildDiseaseSignatureTask new_signature = new BuildDiseaseSignatureTask(map, paParams, this.sessionManager, this.streamUtil, this.applicationManager, this.eventHelper, this.swingApplication);
                currentTasks.append((Task)new_signature);
                CreatePostAnalysisVisualStyleTask visualStyleTask = new CreatePostAnalysisVisualStyleTask(map, this.applicationManager, this.visualMappingManager, this.visualStyleFactory, this.equationCompiler, this.eventHelper, this.vmfFactoryContinuous, this.vmfFactoryDiscrete, this.vmfFactoryPassthrough);
                currentTasks.append((Task)visualStyleTask);
                ParametersPanel paramsPanel = EnrichmentMapManager.getInstance().getParameterPanel();
                ShowPanelTask show_parameters_panel = new ShowPanelTask(this.swingApplication, paramsPanel);
                currentTasks.append((Task)show_parameters_panel);
                DialogObserver dialogObserver = new DialogObserver(visualStyleTask);
                this.dialog.execute(currentTasks, (TaskObserver)dialogObserver);
            } else {
                JOptionPane.showMessageDialog(this.inputPanel, errors, "No such Post-Analysis", 2);
            }
        } else {
            JOptionPane.showMessageDialog(this.inputPanel, errors, "Invalid Input", 2);
        }
    }

    private class DialogObserver
    implements TaskObserver {
        private CreatePostAnalysisVisualStyleTask visualStyleTask;
        private BuildDiseaseSignatureTaskResult result;

        private DialogObserver(CreatePostAnalysisVisualStyleTask visualStyleTask) {
            this.visualStyleTask = visualStyleTask;
        }

        public void taskFinished(ObservableTask task) {
            if (task instanceof BuildDiseaseSignatureTask) {
                this.result = (BuildDiseaseSignatureTaskResult)task.getResults(BuildDiseaseSignatureTaskResult.class);
                this.visualStyleTask.setBuildDiseaseSignatureTaskResult(this.result);
            }
        }

        public void allFinished(FinishStatus status) {
            if (this.result == null || this.result.isCancelled()) {
                return;
            }
            this.result.getNetworkView().updateView();
            if (this.result.getPassedCutoffCount() == 0) {
                JOptionPane.showMessageDialog(BuildPostAnalysisActionListener.this.swingApplication.getJFrame(), "No edges were found passing the cutoff value for the signature set(s)", "Post Analysis", 2);
            }
            if (!this.result.getExistingEdgesFailingCutoff().isEmpty()) {
                Object[] options = new String[]{"Delete Edges From Previous Run", "Keep All Edges"};
                int dialogResult = JOptionPane.showOptionDialog(BuildPostAnalysisActionListener.this.swingApplication.getJFrame(), "There are edges from a previous run of post-analysis that do not pass the current cutoff value.\nKeep these edges or delete them?", "Existing post-analysis edges", 0, 3, null, options, options[1]);
                if (dialogResult == 0) {
                    Set<CyEdge> edgesToDelete = this.result.getExistingEdgesFailingCutoff();
                    CyNetwork network = this.result.getNetwork();
                    network.removeEdges(edgesToDelete);
                    this.result.getNetworkView().updateView();
                }
            }
        }
    }
}

