/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.autoannotate.task;

import javax.swing.JTable;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationManager;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationUtils;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.AnnotationSet;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.Cluster;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.VisualizeClusterAnnotationTaskFactory;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.cluster.DrawClusterLabelTask;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.cluster.UpdateClusterLabelTask;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.TaskIterator;

public class UpdateAnnotationsTaskFactory
implements TaskFactory {
    private AnnotationSet annotationSet;

    public UpdateAnnotationsTaskFactory(AnnotationSet annotationSet) {
        this.annotationSet = annotationSet;
    }

    public TaskIterator createTaskIterator() {
        AutoAnnotationManager autoAnnotationManager = AutoAnnotationManager.getInstance();
        CyNetworkView selectedView = this.annotationSet.getView();
        CyNetwork selectedNetwork = (CyNetwork)selectedView.getModel();
        JTable clusterTable = autoAnnotationManager.getAnnotationPanel().getClusterTable(this.annotationSet);
        for (CyRow row : selectedNetwork.getDefaultNodeTable().getAllRows()) {
            row.set("selected", (Object)false);
        }
        this.annotationSet.updateCoordinates();
        String annotationSetName = this.annotationSet.getName();
        Long clusterTableSUID = (Long)selectedNetwork.getDefaultNetworkTable().getRow((Object)selectedNetwork.getSUID()).get(annotationSetName, Long.class);
        CyTable clusterSetTable = autoAnnotationManager.getTableManager().getTable(clusterTableSUID.longValue());
        TaskIterator currentTasks = new TaskIterator(new Task[0]);
        for (Cluster cluster : this.annotationSet.getClusterMap().values()) {
            AutoAnnotationUtils.updateNodeCentralities(cluster);
            String previousLabel = cluster.getLabel();
            currentTasks.append((Task)new UpdateClusterLabelTask(cluster, clusterSetTable));
            if (previousLabel != cluster.getLabel()) {
                clusterTable.updateUI();
                cluster.eraseText();
                DrawClusterLabelTask drawlabel = new DrawClusterLabelTask(cluster);
                currentTasks.append((Task)drawlabel);
            }
            if (!cluster.coordinatesChanged()) continue;
            cluster.erase();
            VisualizeClusterAnnotationTaskFactory visualizeCluster = new VisualizeClusterAnnotationTaskFactory(cluster);
            currentTasks.append(visualizeCluster.createTaskIterator());
        }
        clusterTable.addNotify();
        clusterTable.getParent().repaint();
        clusterTable.clearSelection();
        return currentTasks;
    }

    public boolean isReady() {
        return false;
    }
}

