/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.model;

import java.util.HashSet;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.model.DataSetFiles;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.model.GeneExpressionMatrix;
import org.baderlab.csplugins.enrichmentmap.model.SetOfEnrichmentResults;
import org.baderlab.csplugins.enrichmentmap.model.SetOfGeneSets;

public class DataSet {
    private String name;
    private SetOfEnrichmentResults enrichments;
    private GeneExpressionMatrix expressionSets;
    private SetOfGeneSets setofgenesets;
    private SetOfGeneSets genesetsOfInterest;
    private HashSet<Integer> datasetGenes;
    private EnrichmentMap map;
    private DataSetFiles datasetFiles;

    public DataSet(EnrichmentMap map, String name, DataSetFiles files) {
        this.map = map;
        this.name = name;
        this.datasetGenes = new HashSet();
        this.setofgenesets = new SetOfGeneSets();
        this.genesetsOfInterest = new SetOfGeneSets();
        this.enrichments = new SetOfEnrichmentResults();
        this.expressionSets = new GeneExpressionMatrix();
        EnrichmentMapParameters params = map.getParams();
        if (name != null) {
            this.datasetFiles = files;
            this.setofgenesets.setFilename(files.getGMTFileName());
            this.enrichments.setFilename1(files.getEnrichmentFileName1());
            this.enrichments.setFilename2(files.getEnrichmentFileName2());
            this.enrichments.setPhenotype1(files.getPhenotype1());
            this.enrichments.setPhenotype2(files.getPhenotype2());
            this.expressionSets.setPhenotypes(files.getTemp_class1());
            this.expressionSets.setFilename(files.getExpressionFileName());
        } else {
            System.out.println("There are no files initialized for this Dataset, named:" + name + "\n");
        }
    }

    public String getName() {
        return this.name;
    }

    public SetOfEnrichmentResults getEnrichments() {
        return this.enrichments;
    }

    public void setEnrichments(SetOfEnrichmentResults enrichments) {
        this.enrichments = enrichments;
    }

    public GeneExpressionMatrix getExpressionSets() {
        return this.expressionSets;
    }

    public EnrichmentMap getMap() {
        return this.map;
    }

    public SetOfGeneSets getSetofgenesets() {
        return this.setofgenesets;
    }

    public void setSetofgenesets(SetOfGeneSets setofgenesets) {
        this.setofgenesets = setofgenesets;
    }

    public SetOfGeneSets getGenesetsOfInterest() {
        return this.genesetsOfInterest;
    }

    public void setGenesetsOfInterest(SetOfGeneSets genesetsOfInterest) {
        this.genesetsOfInterest = genesetsOfInterest;
    }

    public HashSet<Integer> getDatasetGenes() {
        return this.datasetGenes;
    }

    public void setDatasetGenes(HashSet<Integer> datasetGenes) {
        this.datasetGenes = datasetGenes;
    }

    public DataSetFiles getDatasetFiles() {
        return this.datasetFiles;
    }
}

