/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import org.baderlab.csplugins.enrichmentmap.PostAnalysisParameters;
import org.baderlab.csplugins.enrichmentmap.actions.LoadSignatureSetsActionListener;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.model.JMultiLineToolTip;
import org.baderlab.csplugins.enrichmentmap.model.SetOfGeneSets;
import org.baderlab.csplugins.enrichmentmap.view.CollapsiblePanel;
import org.baderlab.csplugins.enrichmentmap.view.PostAnalysisInputPanel;
import org.baderlab.csplugins.enrichmentmap.view.PostAnalysisWeightPanel;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.work.SynchronousTaskManager;
import org.cytoscape.work.TaskManager;

public class PostAnalysisKnownSignaturePanel
extends JPanel {
    private final PostAnalysisInputPanel parentPanel;
    private final CyApplicationManager cyApplicationManager;
    private final CySwingApplication application;
    private final StreamUtil streamUtil;
    private final SynchronousTaskManager syncTaskManager;
    private EnrichmentMap map;
    private PostAnalysisParameters paParams;
    private PostAnalysisWeightPanel weightPanel;
    private JFormattedTextField knownSignatureGMTFileNameTextField;

    public PostAnalysisKnownSignaturePanel(PostAnalysisInputPanel parentPanel, CyApplicationManager cyApplicationManager, CySwingApplication application, StreamUtil streamUtil, SynchronousTaskManager syncTaskManager) {
        this.parentPanel = parentPanel;
        this.cyApplicationManager = cyApplicationManager;
        this.application = application;
        this.streamUtil = streamUtil;
        this.syncTaskManager = syncTaskManager;
        this.createKnownSignatureOptionsPanel();
    }

    private void createKnownSignatureOptionsPanel() {
        this.setLayout(new BorderLayout());
        CollapsiblePanel gmtPanel = this.createKnownSignatureGMTPanel();
        gmtPanel.setCollapsed(false);
        this.weightPanel = new PostAnalysisWeightPanel(this.application);
        this.weightPanel.setCollapsed(false);
        this.add((Component)gmtPanel, "North");
        this.add((Component)this.weightPanel, "Center");
    }

    private CollapsiblePanel createKnownSignatureGMTPanel() {
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("Gene-Sets");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JLabel SigGMTLabel = new JLabel("SigGMT:"){

            @Override
            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        SigGMTLabel.setToolTipText("File specifying gene sets.\nFormat: geneset name <tab> description <tab> gene ...");
        JButton selectSigGMTFileButton = new JButton();
        this.knownSignatureGMTFileNameTextField = new JFormattedTextField();
        this.knownSignatureGMTFileNameTextField.setColumns(15);
        final Color textFieldForeground = this.knownSignatureGMTFileNameTextField.getForeground();
        this.knownSignatureGMTFileNameTextField.setFont(new Font("Dialog", 1, 10));
        this.knownSignatureGMTFileNameTextField.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                PostAnalysisKnownSignaturePanel.this.knownSignatureGMTFileNameTextField.setForeground(textFieldForeground);
            }
        });
        selectSigGMTFileButton.setText("...");
        selectSigGMTFileButton.setMargin(new Insets(0, 0, 0, 0));
        selectSigGMTFileButton.setActionCommand("Known Signature");
        selectSigGMTFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PostAnalysisKnownSignaturePanel.this.parentPanel.chooseGMTFile(PostAnalysisKnownSignaturePanel.this.knownSignatureGMTFileNameTextField);
            }
        });
        JPanel SigGMTPanel = new JPanel();
        SigGMTPanel.setLayout(new BorderLayout());
        SigGMTPanel.add((Component)SigGMTLabel, "West");
        SigGMTPanel.add((Component)this.knownSignatureGMTFileNameTextField, "Center");
        SigGMTPanel.add((Component)selectSigGMTFileButton, "East");
        panel.add(SigGMTPanel);
        collapsiblePanel.getContentPane().add((Component)panel, "North");
        return collapsiblePanel;
    }

    public boolean beforeRun() {
        String filePath = (String)this.knownSignatureGMTFileNameTextField.getValue();
        if (filePath == null || PostAnalysisInputPanel.checkFile(filePath).equals(Color.RED)) {
            String message = "SigGMT file name not valid.\n";
            this.knownSignatureGMTFileNameTextField.setForeground(Color.RED);
            JOptionPane.showMessageDialog(this.application.getJFrame(), message, "Post Analysis Known Signature", 2);
            return false;
        }
        this.paParams.setSignatureGMTFileName(filePath);
        LoadSignatureSetsActionListener loadAction = new LoadSignatureSetsActionListener(this.parentPanel, this.application, this.cyApplicationManager, (TaskManager<?, ?>)this.syncTaskManager, this.streamUtil);
        loadAction.setSelectAll(true);
        loadAction.actionPerformed(null);
        return true;
    }

    void resetPanel() {
        this.paParams.setSignatureGenesets(new SetOfGeneSets());
        this.knownSignatureGMTFileNameTextField.setText("");
        this.knownSignatureGMTFileNameTextField.setValue("");
        this.knownSignatureGMTFileNameTextField.setToolTipText(null);
        this.weightPanel.resetPanel();
    }

    void initialize(EnrichmentMap currentMap, PostAnalysisParameters paParams) {
        this.map = currentMap;
        this.paParams = paParams;
        this.weightPanel.initialize(currentMap, paParams);
    }
}

