/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.model;

import org.baderlab.csplugins.brainlib.DistanceMetric;

public class CosineDistance
extends DistanceMetric {
    @Override
    public double calc(Object expr1, Object expr2) {
        double magnitudeB;
        double magnitudeA;
        Double[] vectorA = (Double[])expr1;
        Double[] vectorB = (Double[])expr2;
        double result = 0.0;
        double numerator = 0.0;
        double denominator = 0.0;
        if (vectorA.length == vectorB.length && vectorA.length > 0) {
            magnitudeA = 0.0;
            magnitudeB = 0.0;
            for (int i = 0; i < vectorA.length; ++i) {
                numerator += vectorA[i] * vectorB[i];
                magnitudeA += vectorA[i] * vectorA[i];
                magnitudeB += vectorB[i] * vectorB[i];
            }
        } else {
            throw new RuntimeException("vectors are not the same length. Can not compute cosine distance");
        }
        denominator = Math.sqrt(magnitudeA) * Math.sqrt(magnitudeB);
        if (denominator == 0.0) {
            throw new RuntimeException("Can not divided by zero.  Can not computer cosine distance");
        }
        result = numerator / denominator;
        return 1.0 - result;
    }
}

