/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentResult;
import org.baderlab.csplugins.enrichmentmap.model.GSEAResult;
import org.baderlab.csplugins.enrichmentmap.model.GeneSet;
import org.baderlab.csplugins.enrichmentmap.model.GenericResult;
import org.baderlab.csplugins.enrichmentmap.model.GenesetSimilarity;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkFactory;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableFactory;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.task.edit.MapTableToNetworkTablesTaskFactory;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class CreateEnrichmentMapNetworkTask
extends AbstractTask {
    private EnrichmentMap map;
    private CyApplicationManager applicationManager;
    private CyNetworkManager networkManager;
    private CyNetworkFactory networkFactory;
    private CyTableFactory tableFactory;
    private CyTableManager tableManager;
    private MapTableToNetworkTablesTaskFactory mapTableToNetworkTable;
    private HashMap<String, GenesetSimilarity> geneset_similarities;
    private String mapName;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;
    public static String node_table_suffix = "node_attribs";
    public static String edge_table_suffix = "edge_attribs";

    public CreateEnrichmentMapNetworkTask(EnrichmentMap map, CyNetworkFactory networkFactory, CyApplicationManager applicationManager, CyNetworkManager networkManager, CyTableFactory tableFactory, CyTableManager tableManager, MapTableToNetworkTablesTaskFactory maptabletonetworktable) {
        this(map);
        this.networkFactory = networkFactory;
        this.applicationManager = applicationManager;
        this.networkManager = networkManager;
        this.tableFactory = tableFactory;
        this.tableManager = tableManager;
        this.mapTableToNetworkTable = maptabletonetworktable;
    }

    public CreateEnrichmentMapNetworkTask(EnrichmentMap map) {
        this.map = map;
        this.geneset_similarities = map.getGenesetSimilarity();
        this.mapName = "Enrichment Map";
    }

    public boolean computeMap() {
        String gene;
        CyRow current_row;
        GeneSet gs2;
        GeneSet gs;
        CyNode node;
        this.map.getParams().setAttributePrefix();
        String prefix = this.map.getParams().getAttributePrefix();
        CyNetwork network = this.networkFactory.createNetwork();
        if (this.map.getName() == null) {
            this.map.setName(prefix + this.mapName);
        }
        network.getRow((CyIdentifiable)network).set("name", (Object)this.map.getName());
        this.map.getParams().setNetworkID(network.getSUID());
        CyTable nodeTable = this.createNodeAttributes(network, this.map.getName().trim(), prefix);
        CyTable edgeTable = this.createEdgeAttributes(network, this.map.getName().trim(), prefix);
        CyTable edgeTableDef = network.getDefaultEdgeTable();
        if (this.map.getParams().getMethod().equalsIgnoreCase("GSEA")) {
            CyTable network_table = this.createNetworkAttributes(network, this.map.getName().trim(), prefix);
            CyRow network_row = network_table.getRow((Object)network.getSUID());
            if (this.map.getParams().getFiles().containsKey("Dataset 1") && this.map.getParams().getFiles().get("Dataset 1").getGseaHtmlReportFile() != null) {
                String report1Path = this.map.getParams().getFiles().get("Dataset 1").getGseaHtmlReportFile();
                report1Path = report1Path.replaceAll("\\\\", "/");
                report1Path = report1Path.substring(0, report1Path.lastIndexOf(47));
                network_row.set("GSEA_Report_Dataset1_folder", (Object)report1Path);
            }
            if (this.map.getParams().getFiles().containsKey("Dataset 2") && this.map.getParams().getFiles().get("Dataset 2").getGseaHtmlReportFile() != null) {
                String report2Path = this.map.getParams().getFiles().get("Dataset 2").getGseaHtmlReportFile();
                report2Path = report2Path.replaceAll("\\\\", "/");
                report2Path = report2Path.substring(0, report2Path.lastIndexOf(47));
                network_row.set("GSEA_Report_Dataset2_folder", (Object)report2Path);
            }
        }
        HashMap<String, EnrichmentResult> enrichmentResults1 = null;
        HashMap<String, EnrichmentResult> enrichmentResults2 = null;
        Set<String> dataset_names = this.map.getDatasets().keySet();
        for (String current_dataset : dataset_names) {
            if (current_dataset.equalsIgnoreCase("Dataset 1")) {
                enrichmentResults1 = this.map.getDataset(current_dataset).getEnrichments().getEnrichments();
                continue;
            }
            enrichmentResults2 = this.map.getDataset(current_dataset).getEnrichments().getEnrichments();
        }
        HashMap<String, GeneSet> genesetsOfInterest = this.map.getDataset("Dataset 1").getGenesetsOfInterest().getGenesets();
        HashMap<String, GeneSet> genesetsOfInterest_set2 = null;
        if (this.map.getParams().isTwoDatasets()) {
            genesetsOfInterest_set2 = this.map.getDataset("Dataset 2").getGenesetsOfInterest().getGenesets();
        }
        int currentProgress = 0;
        int maxValue = genesetsOfInterest.size();
        for (String current_name : genesetsOfInterest.keySet()) {
            EnrichmentResult current_result;
            node = network.addNode();
            network.getRow((CyIdentifiable)node).set("name", (Object)current_name);
            gs = null;
            gs2 = null;
            if (!this.map.getParams().isTwoDatasets()) {
                gs = genesetsOfInterest.get(current_name);
            } else {
                if (genesetsOfInterest.containsKey(current_name)) {
                    gs = genesetsOfInterest.get(current_name);
                }
                if (genesetsOfInterest_set2.containsKey(current_name)) {
                    gs2 = genesetsOfInterest_set2.get(current_name);
                }
                if (gs == null && gs2 != null) {
                    gs = gs2;
                }
            }
            current_row = nodeTable.getRow((Object)node.getSUID());
            current_row.set(prefix + "GS_DESCR", (Object)gs.getDescription());
            if (this.map.getHashkey2gene() != null) {
                ArrayList<String> gene_list = new ArrayList<String>();
                HashSet<Integer> genes_hash = new HashSet<Integer>();
                genes_hash.addAll(gs.getGenes());
                if (gs2 != null) {
                    genes_hash.addAll(gs2.getGenes());
                }
                for (Integer current : genes_hash) {
                    gene = this.map.getGeneFromHashKey(current);
                    if (gene_list == null) continue;
                    gene_list.add(gene);
                }
                current_row.set(prefix + "Genes", gene_list);
            }
            if (this.map.getParams().getMethod().equalsIgnoreCase("GSEA")) {
                current_result = (GSEAResult)enrichmentResults1.get(current_name);
                this.setGSEAResultDataset1Attributes(current_row, (GSEAResult)current_result, prefix);
            } else {
                current_result = (GenericResult)enrichmentResults1.get(current_name);
                this.setGenericResultDataset1Attributes(current_row, (GenericResult)current_result, prefix);
            }
            if (this.map.getParams().isTwoDatasets()) {
                EnrichmentResult second_result;
                if (this.map.getParams().getMethod().equalsIgnoreCase("GSEA")) {
                    if (enrichmentResults2.containsKey(current_name)) {
                        second_result = (GSEAResult)enrichmentResults2.get(current_name);
                        this.setGSEAResultDataset2Attributes(current_row, (GSEAResult)second_result, prefix);
                    }
                } else if (enrichmentResults2.containsKey(current_name)) {
                    second_result = (GenericResult)enrichmentResults2.get(current_name);
                    this.setGenericResultDataset2Attributes(current_row, (GenericResult)second_result, prefix);
                }
            }
            int percentComplete = (int)((double)currentProgress / (double)maxValue * 100.0);
            long timeRemaining = maxValue - currentProgress;
            if (this.taskMonitor != null) {
                this.taskMonitor.setProgress((double)percentComplete);
                this.taskMonitor.setStatusMessage("Building Enrichment Map " + currentProgress + " of " + maxValue);
            }
            ++currentProgress;
        }
        if (this.map.getParams().isTwoDatasets()) {
            for (String current_name : genesetsOfInterest_set2.keySet()) {
                EnrichmentResult second_result;
                EnrichmentResult result;
                if (genesetsOfInterest.containsKey(current_name)) continue;
                node = network.addNode();
                network.getRow((CyIdentifiable)node).set("name", (Object)current_name);
                gs = null;
                gs2 = null;
                if (!this.map.getParams().isTwoDatasets()) {
                    gs = genesetsOfInterest.get(current_name);
                } else {
                    if (genesetsOfInterest.containsKey(current_name)) {
                        gs = genesetsOfInterest.get(current_name);
                    }
                    if (genesetsOfInterest_set2.containsKey(current_name)) {
                        gs2 = genesetsOfInterest_set2.get(current_name);
                    }
                    if (gs == null && gs2 != null) {
                        gs = gs2;
                    }
                }
                current_row = nodeTable.getRow((Object)node.getSUID());
                current_row.set(prefix + "GS_DESCR", (Object)gs.getDescription());
                if (this.map.getHashkey2gene() != null) {
                    ArrayList<String> gene_list = new ArrayList<String>();
                    HashSet<Integer> genes_hash = new HashSet<Integer>();
                    genes_hash.addAll(gs.getGenes());
                    if (gs2 != null) {
                        genes_hash.addAll(gs2.getGenes());
                    }
                    for (Integer current : genes_hash) {
                        gene = this.map.getGeneFromHashKey(current);
                        if (gene_list == null) continue;
                        gene_list.add(gene);
                    }
                    current_row.set(prefix + "Genes", gene_list);
                }
                if (this.map.getParams().getMethod().equalsIgnoreCase("GSEA")) {
                    if (enrichmentResults1.containsKey(current_name)) {
                        result = (GSEAResult)enrichmentResults1.get(current_name);
                        this.setGSEAResultDataset1Attributes(current_row, (GSEAResult)result, prefix);
                    }
                    second_result = (GSEAResult)enrichmentResults2.get(current_name);
                    this.setGSEAResultDataset2Attributes(current_row, (GSEAResult)second_result, prefix);
                    continue;
                }
                if (enrichmentResults1.containsKey(current_name)) {
                    result = (GenericResult)enrichmentResults1.get(current_name);
                    this.setGenericResultDataset1Attributes(current_row, (GenericResult)result, prefix);
                }
                second_result = (GenericResult)enrichmentResults2.get(current_name);
                this.setGenericResultDataset2Attributes(current_row, (GenericResult)second_result, prefix);
            }
        }
        boolean k = false;
        Iterator<String> j = this.geneset_similarities.keySet().iterator();
        while (j.hasNext()) {
            String current_name = j.next().toString();
            GenesetSimilarity current_result = this.geneset_similarities.get(current_name);
            double similarity_coeffecient = current_result.getSimilarity_coeffecient();
            if (!(similarity_coeffecient >= this.map.getParams().getSimilarityCutOff()) || CreateEnrichmentMapNetworkTask.getNodesWithValue(network, network.getDefaultNodeTable(), "name", current_result.getGeneset1_Name()).isEmpty() || CreateEnrichmentMapNetworkTask.getNodesWithValue(network, network.getDefaultNodeTable(), "name", current_result.getGeneset2_Name()).isEmpty()) continue;
            CyNode node1 = CreateEnrichmentMapNetworkTask.getUniqueNodeWithValue(network, network.getDefaultNodeTable(), "name", current_result.getGeneset1_Name());
            CyNode node2 = CreateEnrichmentMapNetworkTask.getUniqueNodeWithValue(network, network.getDefaultNodeTable(), "name", current_result.getGeneset2_Name());
            CyEdge edge = network.addEdge(node1, node2, false);
            String edge_type = current_result.getEnrichment_set() == 1 ? "Geneset_Overlap_set1" : (current_result.getEnrichment_set() == 2 ? "Geneset_Overlap_set2" : "Geneset_Overlap");
            CyRow current_edgerow = edgeTable.getRow((Object)edge.getSUID());
            current_edgerow.set("name", (Object)current_name);
            current_edgerow.set("interaction", (Object)current_result.getInteractionType());
            current_edgerow.set(prefix + "similarity_coefficient", (Object)similarity_coeffecient);
            current_edgerow.set(prefix + "Overlap_size", (Object)current_result.getSizeOfOverlap());
            current_edgerow.set(prefix + "ENRICHMENT_SET", (Object)current_result.getEnrichment_set());
            if (this.map.getHashkey2gene() == null) continue;
            ArrayList<String> gene_list = new ArrayList<String>();
            Set<Integer> genes_hash = current_result.getOverlapping_genes();
            for (Integer current : genes_hash) {
                String gene2 = this.map.getGeneFromHashKey(current);
                if (gene_list == null) continue;
                gene_list.add(gene2);
            }
            current_edgerow.set(prefix + "Overlap_genes", gene_list);
        }
        this.networkManager.addNetwork(network);
        EnrichmentMapManager EMmanager = EnrichmentMapManager.getInstance();
        EMmanager.registerNetwork(network, this.map);
        this.map.getParams().setNetworkID(network.getSUID());
        return true;
    }

    private void setGenericResultDataset1Attributes(CyRow current_row, GenericResult result, String prefix) {
        if (result == null) {
            return;
        }
        String formattedName = CreateEnrichmentMapNetworkTask.formatLabel(result.getName());
        current_row.set(prefix + "Formatted_name", (Object)formattedName);
        current_row.set(prefix + "Name", (Object)result.getName());
        current_row.set(prefix + "pvalue_dataset1", (Object)result.getPvalue());
        current_row.set(prefix + "fdr_qvalue_dataset1", (Object)result.getFdrqvalue());
        current_row.set(prefix + "gs_size_dataset1", (Object)result.getGsSize());
        current_row.set(prefix + "GS_Type", (Object)"ENR");
        current_row.set(prefix + "GS_Source", (Object)result.getSource());
        if (result.getNES() >= 0.0) {
            current_row.set(prefix + "Colouring_dataset1", (Object)(1.0 - result.getPvalue()));
        } else {
            current_row.set(prefix + "Colouring_dataset1", (Object)(-1.0 * (1.0 - result.getPvalue())));
        }
    }

    private void setGenericResultDataset2Attributes(CyRow current_row, GenericResult result, String prefix) {
        if (result == null) {
            return;
        }
        String formattedName = CreateEnrichmentMapNetworkTask.formatLabel(result.getName());
        current_row.set(prefix + "Formatted_name", (Object)formattedName);
        current_row.set(prefix + "Name", (Object)result.getName());
        current_row.set(prefix + "pvalue_dataset2", (Object)result.getPvalue());
        current_row.set(prefix + "fdr_qvalue_dataset2", (Object)result.getFdrqvalue());
        current_row.set(prefix + "gs_size_dataset2", (Object)result.getGsSize());
        current_row.set(prefix + "GS_Type", (Object)"ENR");
        current_row.set(prefix + "GS_Source", (Object)result.getSource());
        if (result.getNES() >= 0.0) {
            current_row.set(prefix + "Colouring_dataset2", (Object)(1.0 - result.getPvalue()));
        } else {
            current_row.set(prefix + "Colouring_dataset2", (Object)(-1.0 * (1.0 - result.getPvalue())));
        }
    }

    private void setGSEAResultDataset1Attributes(CyRow current_row, GSEAResult result, String prefix) {
        if (result == null) {
            return;
        }
        String formattedName = CreateEnrichmentMapNetworkTask.formatLabel(result.getName());
        current_row.set(prefix + "Formatted_name", (Object)formattedName);
        current_row.set(prefix + "Name", (Object)result.getName());
        current_row.set(prefix + "pvalue_dataset1", (Object)result.getPvalue());
        current_row.set(prefix + "fdr_qvalue_dataset1", (Object)result.getFdrqvalue());
        current_row.set(prefix + "fwer_qvalue_dataset1", (Object)result.getFwerqvalue());
        current_row.set(prefix + "gs_size_dataset1", (Object)result.getGsSize());
        current_row.set(prefix + "ES_dataset1", (Object)result.getES());
        current_row.set(prefix + "NES_dataset1", (Object)result.getNES());
        current_row.set(prefix + "GS_Type", (Object)"ENR");
        current_row.set(prefix + "GS_Source", (Object)result.getSource());
        if (result.getNES() >= 0.0) {
            double current_pvalue = result.getPvalue();
            current_row.set(prefix + "Colouring_dataset1", (Object)(1.0 - current_pvalue));
        } else {
            current_row.set(prefix + "Colouring_dataset1", (Object)(-1.0 * (1.0 - result.getPvalue())));
        }
    }

    private void setGSEAResultDataset2Attributes(CyRow current_row, GSEAResult result, String prefix) {
        if (result == null) {
            return;
        }
        String formattedName = CreateEnrichmentMapNetworkTask.formatLabel(result.getName());
        current_row.set(prefix + "Formatted_name", (Object)formattedName);
        current_row.set(prefix + "Name", (Object)result.getName());
        current_row.set(prefix + "pvalue_dataset2", (Object)result.getPvalue());
        current_row.set(prefix + "fdr_qvalue_dataset2", (Object)result.getFdrqvalue());
        current_row.set(prefix + "fwer_qvalue_dataset2", (Object)result.getFwerqvalue());
        current_row.set(prefix + "gs_size_dataset2", (Object)result.getGsSize());
        current_row.set(prefix + "ES_dataset2", (Object)result.getES());
        current_row.set(prefix + "NES_dataset2", (Object)result.getNES());
        current_row.set(prefix + "GS_Type", (Object)"ENR");
        current_row.set(prefix + "GS_Source", (Object)result.getSource());
        if (result.getNES() >= 0.0) {
            double current_pvalue = result.getPvalue();
            current_row.set(prefix + "Colouring_dataset2", (Object)(1.0 - current_pvalue));
        } else {
            current_row.set(prefix + "Colouring_dataset2", (Object)(-1.0 * (1.0 - result.getPvalue())));
        }
    }

    static String formatLabel(String label) {
        String formattedLabel;
        block7: {
            String[] tokens;
            int k;
            int i;
            block8: {
                block6: {
                    formattedLabel = "";
                    i = 0;
                    k = 1;
                    tokens = label.split(" ");
                    if (tokens.length <= 1) break block6;
                    int current_count = 0;
                    for (int j = 0; j < tokens.length; ++j) {
                        if (current_count + tokens[j].length() <= 15) {
                            formattedLabel = formattedLabel + tokens[j] + " ";
                            current_count += tokens[j].length();
                            continue;
                        }
                        if (current_count + tokens[j].length() <= 15) continue;
                        formattedLabel = formattedLabel + "\n" + tokens[j] + " ";
                        current_count = tokens[j].length();
                    }
                    break block7;
                }
                tokens = label.split("_");
                if (tokens.length <= 1) break block8;
                int current_count = 0;
                for (int j = 0; j < tokens.length; ++j) {
                    if (j != 0) {
                        formattedLabel = formattedLabel + "_";
                    }
                    if (current_count + tokens[j].length() <= 15) {
                        formattedLabel = formattedLabel + tokens[j];
                        current_count += tokens[j].length();
                        continue;
                    }
                    if (current_count + tokens[j].length() <= 15) continue;
                    formattedLabel = formattedLabel + "\n" + tokens[j];
                    current_count = tokens[j].length();
                }
                break block7;
            }
            if (tokens.length != 1) break block7;
            while (i <= label.length()) {
                formattedLabel = i + 15 > label.length() ? formattedLabel + label.substring(i, label.length()) + "\n" : formattedLabel + label.substring(i, k * 15) + "\n";
                i = k * 15;
                ++k;
            }
        }
        return formattedLabel;
    }

    public CyTable createNetworkAttributes(CyNetwork network, String name, String prefix) {
        CyTable networkTable = network.getDefaultNetworkTable();
        networkTable.createColumn("GSEA_Report_Dataset1_folder", String.class, false);
        if (this.map.getParams().getFiles().containsKey("Dataset 2") && this.map.getParams().getFiles().get("Dataset 2").getGseaHtmlReportFile() != null) {
            networkTable.createColumn("GSEA_Report_Dataset2_folder", String.class, false);
        }
        return networkTable;
    }

    public CyTable createNodeAttributes(CyNetwork network, String name, String prefix) {
        CyTable nodeTable = network.getDefaultNodeTable();
        nodeTable.createColumn(prefix + "GS_DESCR", String.class, false);
        nodeTable.createColumn(prefix + "Formatted_name", String.class, false);
        nodeTable.createColumn(prefix + "Name", String.class, false);
        nodeTable.createColumn(prefix + "GS_Source", String.class, false);
        nodeTable.createColumn(prefix + "GS_Type", String.class, false);
        nodeTable.createListColumn(prefix + "Genes", String.class, false);
        nodeTable.createColumn(prefix + "pvalue_dataset1", Double.class, false);
        nodeTable.createColumn(prefix + "Colouring_dataset1", Double.class, false);
        nodeTable.createColumn(prefix + "ES_dataset1", Double.class, false);
        nodeTable.createColumn(prefix + "NES_dataset1", Double.class, false);
        nodeTable.createColumn(prefix + "fdr_qvalue_dataset1", Double.class, false);
        nodeTable.createColumn(prefix + "fwer_qvalue_dataset1", Double.class, false);
        nodeTable.createColumn(prefix + "gs_size_dataset1", Integer.class, false);
        if (this.map.getDatasets().size() > 1) {
            nodeTable.createColumn(prefix + "pvalue_dataset2", Double.class, false);
            nodeTable.createColumn(prefix + "Colouring_dataset2", Double.class, false);
            nodeTable.createColumn(prefix + "ES_dataset2", Double.class, false);
            nodeTable.createColumn(prefix + "NES_dataset2", Double.class, false);
            nodeTable.createColumn(prefix + "fdr_qvalue_dataset2", Double.class, false);
            nodeTable.createColumn(prefix + "fwer_qvalue_dataset2", Double.class, false);
            nodeTable.createColumn(prefix + "gs_size_dataset2", Integer.class, false);
        }
        return nodeTable;
    }

    public CyTable createEdgeAttributes(CyNetwork network, String name, String prefix) {
        CyTable edgeTable = network.getDefaultEdgeTable();
        edgeTable.createColumn(prefix + "similarity_coefficient", Double.class, false);
        edgeTable.createColumn(prefix + "Overlap_size", Integer.class, false);
        edgeTable.createListColumn(prefix + "Overlap_genes", String.class, false);
        edgeTable.createColumn(prefix + "ENRICHMENT_SET", Integer.class, false);
        return edgeTable;
    }

    private static Set<CyNode> getNodesWithValue(CyNetwork net, CyTable table, String colname, Object value) {
        Collection matchingRows = table.getMatchingRows(colname, value);
        HashSet<CyNode> nodes = new HashSet<CyNode>();
        String primaryKeyColname = table.getPrimaryKey().getName();
        for (CyRow row : matchingRows) {
            CyNode node;
            Long nodeId = (Long)row.get(primaryKeyColname, Long.class);
            if (nodeId == null || (node = net.getNode(nodeId.longValue())) == null) continue;
            nodes.add(node);
        }
        return nodes;
    }

    private static CyNode getUniqueNodeWithValue(CyNetwork net, CyTable table, String colname, Object value) {
        Collection matchingRows = table.getMatchingRows(colname, value);
        if (matchingRows.size() > 1 || matchingRows.size() <= 0) {
            return null;
        }
        String primaryKeyColname = table.getPrimaryKey().getName();
        for (CyRow row : matchingRows) {
            CyNode node;
            Long nodeId = (Long)row.get(primaryKeyColname, Long.class);
            if (nodeId == null || (node = net.getNode(nodeId.longValue())) == null) continue;
            return node;
        }
        return null;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.taskMonitor = taskMonitor;
        this.computeMap();
    }
}

