/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapVisualStyle;
import org.baderlab.csplugins.enrichmentmap.task.BuildDiseaseSignatureTaskResult;
import org.cytoscape.equations.Equation;
import org.cytoscape.equations.EquationCompiler;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.LineTypeVisualProperty;
import org.cytoscape.view.presentation.property.NodeShapeVisualProperty;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.mappings.DiscreteMapping;
import org.cytoscape.view.vizmap.mappings.PassthroughMapping;

public class PostAnalysisVisualStyle {
    private final VisualMappingFunctionFactory vmfFactoryContinuous;
    private final VisualMappingFunctionFactory vmfFactoryDiscrete;
    private final VisualMappingFunctionFactory vmfFactoryPassthrough;
    private final EquationCompiler equationCompiler;
    private final EnrichmentMapVisualStyle delegateStyle;
    private static final Color PINK = new Color(255, 0, 200);
    private static final Color YELLOW = new Color(255, 255, 0);

    public PostAnalysisVisualStyle(EnrichmentMapParameters emParsms, EquationCompiler equationCompiler, VisualMappingFunctionFactory vmfFactoryContinuous, VisualMappingFunctionFactory vmfFactoryDiscrete, VisualMappingFunctionFactory vmfFactoryPassthrough) {
        this.delegateStyle = new EnrichmentMapVisualStyle(emParsms, vmfFactoryContinuous, vmfFactoryDiscrete, vmfFactoryPassthrough);
        this.vmfFactoryContinuous = vmfFactoryContinuous;
        this.vmfFactoryDiscrete = vmfFactoryDiscrete;
        this.vmfFactoryPassthrough = vmfFactoryPassthrough;
        this.equationCompiler = equationCompiler;
    }

    public void createVisualStyle(VisualStyle vs, String prefix) {
        this.delegateStyle.applyVisualStyle(vs, prefix);
        this.createPostAnalysisAppearance(vs, prefix);
    }

    public void applyNetworkSpeficifProperties(BuildDiseaseSignatureTaskResult taskResult, String prefix) {
        this.createNodeBypassForColor(taskResult);
        CyNetwork network = taskResult.getNetwork();
        CyTable networkTable = network.getDefaultNetworkTable();
        if (networkTable.getColumn("EM_Edge_width_parameters") == null) {
            networkTable.createColumn("EM_Edge_width_parameters", String.class, false);
        }
        PostAnalysisVisualStyle.applyWidthEquation(this.equationCompiler, prefix, network);
    }

    private void createPostAnalysisAppearance(VisualStyle vs, String prefix) {
        DiscreteMapping lineType = (DiscreteMapping)this.vmfFactoryDiscrete.createVisualMappingFunction("interaction", String.class, BasicVisualLexicon.EDGE_LINE_TYPE);
        lineType.putMapValue((Object)"sig_set2", (Object)LineTypeVisualProperty.LONG_DASH);
        vs.addVisualMappingFunction((VisualMappingFunction)lineType);
        DiscreteMapping disMapping_edge2 = (DiscreteMapping)vs.getVisualMappingFunction(BasicVisualLexicon.EDGE_UNSELECTED_PAINT);
        disMapping_edge2.putMapValue((Object)4, (Object)PINK);
        DiscreteMapping disMapping_edge4 = (DiscreteMapping)vs.getVisualMappingFunction(BasicVisualLexicon.EDGE_STROKE_UNSELECTED_PAINT);
        disMapping_edge4.putMapValue((Object)4, (Object)PINK);
        DiscreteMapping disMapping_nodeShape = (DiscreteMapping)this.vmfFactoryDiscrete.createVisualMappingFunction(prefix + "GS_Type", String.class, BasicVisualLexicon.NODE_SHAPE);
        disMapping_nodeShape.putMapValue((Object)"ENR", (Object)NodeShapeVisualProperty.ELLIPSE);
        disMapping_nodeShape.putMapValue((Object)"SIG", (Object)NodeShapeVisualProperty.TRIANGLE);
        vs.addVisualMappingFunction((VisualMappingFunction)disMapping_nodeShape);
        String widthAttribute = prefix + "Edge_width_formula";
        PassthroughMapping edgeWidthMapping = (PassthroughMapping)this.vmfFactoryPassthrough.createVisualMappingFunction(widthAttribute, Double.class, BasicVisualLexicon.EDGE_WIDTH);
        vs.addVisualMappingFunction((VisualMappingFunction)edgeWidthMapping);
    }

    private void createNodeBypassForColor(BuildDiseaseSignatureTaskResult taskResult) {
        for (CyNode node : taskResult.getNewNodes()) {
            View hubNodeView = taskResult.getNetworkView().getNodeView(node);
            if (hubNodeView == null) continue;
            hubNodeView.setLockedValue(BasicVisualLexicon.NODE_FILL_COLOR, (Object)YELLOW);
            hubNodeView.setLockedValue(BasicVisualLexicon.NODE_BORDER_PAINT, (Object)YELLOW);
        }
    }

    public static void applyWidthEquation(EquationCompiler equationCompiler, String prefix, CyNetwork network) {
        String widthAttribute = prefix + "Edge_width_formula";
        CyTable edgeTable = network.getDefaultEdgeTable();
        if (edgeTable.getColumn(widthAttribute) == null) {
            edgeTable.createColumn(widthAttribute, Double.class, false);
        }
        String formula = "=EM_width($SUID)";
        Equation equation = PostAnalysisVisualStyle.compileEquation(equationCompiler, edgeTable, formula);
        for (CyRow row : edgeTable.getAllRows()) {
            row.set(widthAttribute, (Object)equation);
        }
    }

    private static Equation compileEquation(EquationCompiler equationCompiler, CyTable edgeTable, String formula) {
        Map<String, Class<?>> attribNameToType = PostAnalysisVisualStyle.attributeToTypeMap(edgeTable);
        if (equationCompiler.compile(formula, attribNameToType)) {
            return equationCompiler.getEquation();
        }
        throw new RuntimeException(equationCompiler.getLastErrorMsg());
    }

    private static Map<String, Class<?>> attributeToTypeMap(CyTable table) {
        HashMap map = new HashMap();
        for (CyColumn column : table.getColumns()) {
            map.put(column.getName(), column.getType());
        }
        return map;
    }

    public static boolean appliesTo(CyNetwork network) {
        CyTable networkTable = network.getDefaultNetworkTable();
        return networkTable.getColumn("EM_Edge_width_parameters") != null;
    }

    public static class EdgeWidthParams {
        public final double em_lower;
        public final double em_upper;
        public final double pa_lessThan100;
        public final double pa_lessThan10;
        public final double pa_greater;

        public EdgeWidthParams(double em_lower, double em_upper, double pa_lessThan100, double pa_lessThan10, double pa_greater) {
            this.em_lower = em_lower;
            this.em_upper = em_upper;
            this.pa_lessThan100 = pa_lessThan100;
            this.pa_lessThan10 = pa_lessThan10;
            this.pa_greater = pa_greater;
        }

        public static EdgeWidthParams defaultValues() {
            return new EdgeWidthParams(1.0, 5.0, 8.0, 4.5, 1.0);
        }

        public static EdgeWidthParams restore(CyNetwork network) {
            try {
                String val = (String)network.getRow((CyIdentifiable)network).get("EM_Edge_width_parameters", String.class);
                String[] params = val.split(",");
                double em_lower = Double.parseDouble(params[0]);
                double em_upper = Double.parseDouble(params[1]);
                double pa_lessThan100 = Double.parseDouble(params[2]);
                double pa_lessThan10 = Double.parseDouble(params[3]);
                double pa_greater = Double.parseDouble(params[4]);
                return new EdgeWidthParams(em_lower, em_upper, pa_lessThan100, pa_lessThan10, pa_greater);
            }
            catch (ArrayIndexOutOfBoundsException | IllegalArgumentException | NullPointerException e) {
                return EdgeWidthParams.defaultValues();
            }
        }

        public void save(CyNetwork network) {
            CyRow row = network.getRow((CyIdentifiable)network);
            String val = String.format("%f,%f,%f,%f,%f", this.em_lower, this.em_upper, this.pa_lessThan100, this.pa_lessThan10, this.pa_greater);
            row.set("EM_Edge_width_parameters", (Object)val);
        }
    }
}

