/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.autoannotate.task.cluster;

import java.awt.Color;
import java.awt.Paint;
import java.util.HashMap;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationManager;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.AnnotationSet;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.Cluster;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.presentation.annotations.Annotation;
import org.cytoscape.view.presentation.annotations.AnnotationFactory;
import org.cytoscape.view.presentation.annotations.AnnotationManager;
import org.cytoscape.view.presentation.annotations.ShapeAnnotation;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class DrawClusterEllipseTask
extends AbstractTask {
    private int min_size = 50;
    private Color fillColor = Color.getHSBColor(0.19f, 1.25f, 0.95f);
    private Cluster cluster;
    private TaskMonitor taskMonitor = null;

    public DrawClusterEllipseTask(Cluster cluster) {
        this.cluster = cluster;
    }

    public void drawEllipse() {
        AutoAnnotationManager autoAnnotationManager = AutoAnnotationManager.getInstance();
        AnnotationSet parent = this.cluster.getParent();
        CyNetworkView view = parent.getView();
        String shapeType = parent.getShapeType();
        int ellipseBorderWidth = parent.getEllipseWidth();
        boolean showEllipses = parent.isShowEllipses();
        int ellipseOpacity = parent.getEllipseOpacity();
        AnnotationFactory<ShapeAnnotation> shapeFactory = autoAnnotationManager.getShapeFactory();
        AnnotationManager annotationManager = autoAnnotationManager.getAnnotationManager();
        double zoom = (Double)view.getVisualProperty(BasicVisualLexicon.NETWORK_SCALE_FACTOR);
        double[] bounds = this.cluster.getBounds();
        double xmin = bounds[0];
        double xmax = bounds[1];
        double ymin = bounds[2];
        double ymax = bounds[3];
        double centreX = (xmin + xmax) / 2.0;
        double centreY = (ymin + ymax) / 2.0;
        double width = xmax - xmin;
        width = width > (double)this.min_size ? width : (double)this.min_size;
        double height = ymax - ymin;
        height = height > (double)this.min_size ? height : (double)this.min_size;
        HashMap<CyNode, double[]> nodesToCoordinates = this.cluster.getNodesToCoordinates();
        HashMap<CyNode, Double> nodesToRadii = this.cluster.getNodesToRadii();
        if (shapeType.equals("ELLIPSE")) {
            while (this.nodesOutOfCluster(nodesToCoordinates, nodesToRadii, width, height, centreX, centreY, ellipseBorderWidth)) {
                width *= 1.1;
                height *= 1.1;
            }
            width += 40.0;
            height += 40.0;
        } else {
            width += 50.0;
            height += 50.0;
        }
        Integer xPos = (int)Math.round(centreX - width / 2.0);
        Integer yPos = (int)Math.round(centreY - height / 2.0);
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("x", String.valueOf(xPos));
        arguments.put("y", String.valueOf(yPos));
        arguments.put("zoom", String.valueOf(zoom));
        arguments.put("canvas", "background");
        arguments.put("shapeType", shapeType);
        ShapeAnnotation ellipse = (ShapeAnnotation)shapeFactory.createAnnotation(ShapeAnnotation.class, view, arguments);
        ellipse.setSize(width * zoom, height * zoom);
        ellipse.setBorderWidth((double)ellipseBorderWidth);
        ellipse.setBorderColor((Paint)Color.DARK_GRAY);
        ellipse.setFillColor((Paint)this.fillColor);
        ellipse.setFillOpacity((double)ellipseOpacity);
        this.cluster.setEllipse(ellipse);
        if (showEllipses) {
            annotationManager.addAnnotation((Annotation)ellipse);
        }
    }

    private boolean nodesOutOfCluster(HashMap<CyNode, double[]> nodesToCoordinates, HashMap<CyNode, Double> nodesToRadii, double width, double height, double centreX, double centreY, int ellipseWidth) {
        double semimajor_axis = width / 2.0;
        double semiminor_axis = height / 2.0;
        for (CyNode node : nodesToCoordinates.keySet()) {
            double[] coordinates = nodesToCoordinates.get(node);
            double nodeSize = nodesToRadii.get(node);
            if (!(Math.pow((coordinates[0] - centreX - (double)ellipseWidth) / semimajor_axis, 2.0) + Math.pow(nodeSize / semimajor_axis, 2.0) + Math.pow((coordinates[1] - centreY - (double)ellipseWidth) / semiminor_axis, 2.0) + Math.pow(nodeSize / semiminor_axis, 2.0) >= 1.0)) continue;
            return true;
        }
        return false;
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.taskMonitor = taskMonitor;
        this.taskMonitor.setTitle("Drawing bounding ellipse/box around cluster");
        this.drawEllipse();
    }
}

