/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.FilterParameters;
import org.baderlab.csplugins.enrichmentmap.PostAnalysisVisualStyle;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyRow;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.mappings.BoundaryRangeValues;
import org.cytoscape.view.vizmap.mappings.ContinuousMapping;

public class WidthFunction
extends AbstractFunction {
    private final CyNetworkManager networkManager;
    private final EnrichmentMapManager enrichmentMapManager;
    private final VisualMappingFunctionFactory vmfFactoryContinuous;

    public WidthFunction(CyNetworkManager networkManager, VisualMappingFunctionFactory vmfFactoryContinuous, EnrichmentMapManager enrichmentMapManager) {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.INT, "SUID", "The SUID for the current edge row.")});
        this.networkManager = networkManager;
        this.vmfFactoryContinuous = vmfFactoryContinuous;
        this.enrichmentMapManager = enrichmentMapManager;
    }

    public String getName() {
        return "EM_width";
    }

    public String getFunctionSummary() {
        return "Calculate edge width for EnrichmentMap networks. (Automatically created)";
    }

    public Class<Double> getReturnType() {
        return Double.class;
    }

    private CyNetwork getNetwork(long edgeSUID) {
        for (CyNetwork network : this.networkManager.getNetworkSet()) {
            if (network.getEdge(edgeSUID) == null) continue;
            return network;
        }
        return null;
    }

    private static boolean isSignature(String interaction) {
        return "sig".equals(interaction) || "sig_set1".equals(interaction) || "sig_set2".equals(interaction);
    }

    public Double evaluateFunction(Object[] args) {
        long edgeSuid = (Long)args[0];
        CyNetwork network = this.getNetwork(edgeSuid);
        if (network == null) {
            return 1.0;
        }
        PostAnalysisVisualStyle.EdgeWidthParams edgeWidthParams = PostAnalysisVisualStyle.EdgeWidthParams.restore(network);
        CyRow row = network.getDefaultEdgeTable().getRow((Object)edgeSuid);
        EnrichmentMap map = this.enrichmentMapManager.getMap(network.getSUID());
        String prefix = map.getParams().getAttributePrefix();
        String interaction = (String)row.get("interaction", String.class);
        if (WidthFunction.isSignature(interaction)) {
            Double cutoff;
            Double pvalue;
            String cutoffType = (String)row.get(prefix + "Overlap_cutoff", String.class);
            FilterParameters.FilterType filterType = FilterParameters.FilterType.fromDisplayString(cutoffType);
            if (filterType == null) {
                return 1.0;
            }
            if (filterType == FilterParameters.FilterType.MANN_WHIT) {
                pvalue = (Double)row.get(prefix + "Overlap_Mann_Whit_pVal", Double.class);
                cutoff = (Double)row.get(prefix + "Overlap_Mann_Whit_cutoff", Double.class);
            } else {
                pvalue = (Double)row.get(prefix + "Overlap_Hypergeom_pVal", Double.class);
                cutoff = (Double)row.get(prefix + "Overlap_Hypergeom_cutoff", Double.class);
            }
            if (pvalue == null || cutoff == null) {
                return 1.0;
            }
            if (pvalue <= cutoff / 100.0) {
                return edgeWidthParams.pa_lessThan100;
            }
            if (pvalue <= cutoff / 10.0) {
                return edgeWidthParams.pa_lessThan10;
            }
            return edgeWidthParams.pa_greater;
        }
        ContinuousMapping conmapping_edgewidth = (ContinuousMapping)this.vmfFactoryContinuous.createVisualMappingFunction(prefix + "similarity_coefficient", Double.class, BasicVisualLexicon.EDGE_WIDTH);
        Double under_width = 0.5;
        Double min_width = edgeWidthParams.em_lower;
        Double max_width = edgeWidthParams.em_upper;
        Double over_width = 6.0;
        BoundaryRangeValues bv4 = new BoundaryRangeValues((Object)under_width, (Object)min_width, (Object)min_width);
        BoundaryRangeValues bv5 = new BoundaryRangeValues((Object)max_width, (Object)max_width, (Object)over_width);
        conmapping_edgewidth.addPoint((Object)map.getParams().getSimilarityCutOff(), bv4);
        conmapping_edgewidth.addPoint((Object)1.0, bv5);
        return (Double)conmapping_edgewidth.getMappedValue(row);
    }
}

