/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import java.awt.Color;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapVisualStyle;
import org.baderlab.csplugins.enrichmentmap.WidthFunction;
import org.baderlab.csplugins.enrichmentmap.task.BuildDiseaseSignatureTaskResult;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.view.presentation.property.LineTypeVisualProperty;
import org.cytoscape.view.presentation.property.NodeShapeVisualProperty;
import org.cytoscape.view.vizmap.VisualMappingFunction;
import org.cytoscape.view.vizmap.VisualMappingFunctionFactory;
import org.cytoscape.view.vizmap.VisualStyle;
import org.cytoscape.view.vizmap.mappings.DiscreteMapping;
import org.cytoscape.view.vizmap.mappings.PassthroughMapping;
import org.cytoscape.work.TaskMonitor;

public class PostAnalysisVisualStyle {
    public static final String NAME = "Post_analysis_style";
    private final VisualMappingFunctionFactory vmfFactoryContinuous;
    private final VisualMappingFunctionFactory vmfFactoryDiscrete;
    private final VisualMappingFunctionFactory vmfFactoryPassthrough;
    private final EnrichmentMapVisualStyle delegateStyle;
    private static final Color PINK = new Color(255, 0, 200);
    private static final Color YELLOW = new Color(255, 255, 0);

    public PostAnalysisVisualStyle(EnrichmentMapParameters emParsms, VisualMappingFunctionFactory vmfFactoryContinuous, VisualMappingFunctionFactory vmfFactoryDiscrete, VisualMappingFunctionFactory vmfFactoryPassthrough) {
        this.delegateStyle = new EnrichmentMapVisualStyle(emParsms, vmfFactoryContinuous, vmfFactoryDiscrete, vmfFactoryPassthrough);
        this.vmfFactoryContinuous = vmfFactoryContinuous;
        this.vmfFactoryDiscrete = vmfFactoryDiscrete;
        this.vmfFactoryPassthrough = vmfFactoryPassthrough;
    }

    public void createVisualStyle(VisualStyle vs, String prefix) {
        this.delegateStyle.applyVisualStyle(vs, prefix);
        this.createPostAnalysisAppearance(vs, prefix);
    }

    public void applyNetworkSpeficifProperties(BuildDiseaseSignatureTaskResult taskResult, String prefix, TaskMonitor taskMonitor) {
        this.createNodeBypassForColor(taskResult);
        CyNetwork network = taskResult.getNetwork();
        WidthFunction widthFunction = new WidthFunction(this.vmfFactoryContinuous);
        widthFunction.setEdgeWidths(network, prefix, taskMonitor);
    }

    private void createPostAnalysisAppearance(VisualStyle vs, String prefix) {
        DiscreteMapping lineType = (DiscreteMapping)this.vmfFactoryDiscrete.createVisualMappingFunction("interaction", String.class, BasicVisualLexicon.EDGE_LINE_TYPE);
        lineType.putMapValue((Object)"sig_set2", (Object)LineTypeVisualProperty.LONG_DASH);
        vs.addVisualMappingFunction((VisualMappingFunction)lineType);
        DiscreteMapping disMapping_edge2 = (DiscreteMapping)vs.getVisualMappingFunction(BasicVisualLexicon.EDGE_UNSELECTED_PAINT);
        disMapping_edge2.putMapValue((Object)4, (Object)PINK);
        DiscreteMapping disMapping_edge4 = (DiscreteMapping)vs.getVisualMappingFunction(BasicVisualLexicon.EDGE_STROKE_UNSELECTED_PAINT);
        disMapping_edge4.putMapValue((Object)4, (Object)PINK);
        DiscreteMapping disMapping_nodeShape = (DiscreteMapping)this.vmfFactoryDiscrete.createVisualMappingFunction(prefix + "GS_Type", String.class, BasicVisualLexicon.NODE_SHAPE);
        disMapping_nodeShape.putMapValue((Object)"ENR", (Object)NodeShapeVisualProperty.ELLIPSE);
        disMapping_nodeShape.putMapValue((Object)"SIG", (Object)NodeShapeVisualProperty.TRIANGLE);
        vs.addVisualMappingFunction((VisualMappingFunction)disMapping_nodeShape);
        String widthAttribute = prefix + "Edge_width_formula";
        PassthroughMapping edgeWidthMapping = (PassthroughMapping)this.vmfFactoryPassthrough.createVisualMappingFunction(widthAttribute, Double.class, BasicVisualLexicon.EDGE_WIDTH);
        vs.addVisualMappingFunction((VisualMappingFunction)edgeWidthMapping);
    }

    private void createNodeBypassForColor(BuildDiseaseSignatureTaskResult taskResult) {
        for (CyNode node : taskResult.getNewNodes()) {
            View hubNodeView = taskResult.getNetworkView().getNodeView(node);
            if (hubNodeView == null) continue;
            hubNodeView.setLockedValue(BasicVisualLexicon.NODE_FILL_COLOR, (Object)YELLOW);
            hubNodeView.setLockedValue(BasicVisualLexicon.NODE_BORDER_PAINT, (Object)YELLOW);
        }
    }
}

