/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.heatmap;

import org.baderlab.csplugins.enrichmentmap.model.GeneExpressionMatrix;
import org.baderlab.csplugins.enrichmentmap.view.HeatMapPanel;
import org.mskcc.colorgradient.ColorGradientRange;
import org.mskcc.colorgradient.ColorGradientTheme;

public class HeatMapParameters {
    private ColorGradientRange range_ds1;
    private ColorGradientTheme theme_ds1;
    Sort sort;
    public Transformation transformation;
    private String sortbycolumnName;
    private boolean sortbycolumn_event_triggered = false;
    private int sortIndex = -1;
    private String rankFileIndex = "none";
    private boolean[] ascending;
    private boolean showValues = false;
    private double minExpression_ds1;
    private double maxExpression_ds1;
    private double closestToZeroExpression_ds1;
    private double minExpression_rownorm_ds1;
    private double maxExpression_rownorm_ds1;
    private ColorGradientRange range_ds2;
    private ColorGradientTheme theme_ds2;
    private double minExpression_ds2;
    private double maxExpression_ds2;
    private double closestToZeroExpression_ds2;
    private double minExpression_rownorm_ds2;
    private double maxExpression_rownorm_ds2;
    private HeatMapPanel edgeOverlapPanel;
    private HeatMapPanel nodeOverlapPanel;
    public static String sort_hierarchical_cluster = "Hierarchical Cluster";
    public static String sort_rank = "Ranks";
    public static String sort_column = "Columns";
    public static String sort_none = "No Sort";
    public static String pearson_correlation = "Pearson Correlation";
    public static String cosine = "Cosine Distance";
    public static String euclidean = "Euclidean Distance";
    public static String asis = "Data As Is";
    public static String rownorm = "Row Normalize Data";
    public static String logtrans = "Log Transform Data";

    public HeatMapParameters(HeatMapPanel edgeOverlapPanel, HeatMapPanel nodeOverlapPanel) {
        this.edgeOverlapPanel = edgeOverlapPanel;
        this.nodeOverlapPanel = nodeOverlapPanel;
        this.sort = Sort.DEFAULT;
        this.transformation = Transformation.ASIS;
    }

    public void initColorGradients(GeneExpressionMatrix expression) {
        this.minExpression_ds1 = expression.getMinExpression();
        this.maxExpression_ds1 = expression.getMaxExpression();
        this.closestToZeroExpression_ds1 = expression.getClosesttoZero();
        this.minExpression_rownorm_ds1 = expression.getMinExpression(expression.getExpressionMatrix_rowNormalized());
        this.maxExpression_rownorm_ds1 = expression.getMaxExpression(expression.getExpressionMatrix_rowNormalized());
        double max = Math.max(Math.abs(this.minExpression_ds1), this.maxExpression_ds1);
        double median = 0.0;
        if (this.minExpression_ds1 >= 0.0) {
            this.range_ds1 = ColorGradientRange.getInstance(0.0, max / 2.0, max / 2.0, max, 0.0, max / 2.0, max / 2.0, max);
            this.theme_ds1 = ColorGradientTheme.GREEN_ONECOLOR_GRADIENT_THEME;
        } else {
            this.range_ds1 = ColorGradientRange.getInstance(-max, median, median, max, -max, median, median, max);
            this.theme_ds1 = ColorGradientTheme.GREEN_MAGENTA_GRADIENT_THEME;
        }
    }

    public void initColorGradients(GeneExpressionMatrix expression_ds1, GeneExpressionMatrix expression_ds2) {
        this.minExpression_ds1 = expression_ds1.getMinExpression();
        this.maxExpression_ds1 = expression_ds1.getMaxExpression();
        this.closestToZeroExpression_ds1 = expression_ds1.getClosesttoZero();
        this.minExpression_rownorm_ds1 = expression_ds1.getMinExpression(expression_ds1.getExpressionMatrix_rowNormalized());
        this.maxExpression_rownorm_ds1 = expression_ds1.getMaxExpression(expression_ds1.getExpressionMatrix_rowNormalized());
        double max = Math.max(Math.abs(this.minExpression_ds1), this.maxExpression_ds1);
        double median = 0.0;
        if (this.minExpression_ds1 >= 0.0) {
            this.range_ds1 = ColorGradientRange.getInstance(0.0, max / 2.0, max / 2.0, max, 0.0, max / 2.0, max / 2.0, max);
            this.theme_ds1 = ColorGradientTheme.GREEN_ONECOLOR_GRADIENT_THEME;
        } else {
            this.range_ds1 = ColorGradientRange.getInstance(-max, median, median, max, -max, median, median, max);
            this.theme_ds1 = ColorGradientTheme.GREEN_MAGENTA_GRADIENT_THEME;
        }
        this.minExpression_ds2 = expression_ds2.getMinExpression();
        this.maxExpression_ds2 = expression_ds2.getMaxExpression();
        this.closestToZeroExpression_ds2 = expression_ds2.getClosesttoZero();
        this.minExpression_rownorm_ds2 = expression_ds2.getMinExpression(expression_ds2.getExpressionMatrix_rowNormalized());
        this.maxExpression_rownorm_ds2 = expression_ds2.getMaxExpression(expression_ds2.getExpressionMatrix_rowNormalized());
        max = Math.max(Math.abs(this.minExpression_ds2), this.maxExpression_ds2);
        median = 0.0;
        if (this.minExpression_ds2 >= 0.0) {
            this.range_ds2 = ColorGradientRange.getInstance(0.0, max / 2.0, max / 2.0, max, 0.0, max / 2.0, max / 2.0, max);
            this.theme_ds2 = ColorGradientTheme.GREEN_ONECOLOR_GRADIENT_THEME;
        } else {
            this.range_ds2 = ColorGradientRange.getInstance(-max, median, median, max, -max, median, median, max);
            this.theme_ds2 = ColorGradientTheme.GREEN_MAGENTA_GRADIENT_THEME;
        }
    }

    public void ResetColorGradient_ds1() {
        double max;
        double min;
        switch (this.transformation) {
            case ROWNORM: {
                min = this.minExpression_rownorm_ds1;
                max = this.maxExpression_rownorm_ds1;
                if (min != 0.0 || max == 0.0) {
                    // empty if block
                }
                max = Math.max(Math.abs(min), max);
                break;
            }
            case LOGTRANSFORM: {
                if (this.minExpression_ds1 <= 0.0 && this.maxExpression_ds1 <= 0.0) {
                    min = 0.0;
                    max = 0.0;
                    break;
                }
                if (this.minExpression_ds1 <= 0.0) {
                    min = Math.min(Math.log(this.closestToZeroExpression_ds1), Math.log1p(this.maxExpression_ds1));
                    max = Math.max(Math.log(this.closestToZeroExpression_ds1), Math.log1p(this.maxExpression_ds1));
                    break;
                }
                if (this.maxExpression_ds1 <= 0.0) {
                    min = 0.0;
                    max = Math.log1p(this.minExpression_ds1);
                    break;
                }
                min = Math.log1p(this.minExpression_ds1);
                max = Math.log1p(this.maxExpression_ds1);
                max = Math.max(Math.abs(min), max);
                break;
            }
            default: {
                min = this.minExpression_ds1;
                max = Math.max(Math.abs(this.minExpression_ds1), this.maxExpression_ds1);
            }
        }
        double median = max / 2.0;
        if (min >= 0.0) {
            median = max / 2.0;
            this.range_ds1 = ColorGradientRange.getInstance(0.0, median, median, max, 0.0, median, median, max);
            this.theme_ds1 = ColorGradientTheme.GREEN_ONECOLOR_GRADIENT_THEME;
        } else {
            median = 0.0;
            this.range_ds1 = ColorGradientRange.getInstance(-max, 0.0, 0.0, max, -max, 0.0, 0.0, max);
            this.theme_ds1 = ColorGradientTheme.GREEN_MAGENTA_GRADIENT_THEME;
        }
    }

    public void ResetColorGradient_ds2() {
        double max;
        double min;
        switch (this.transformation) {
            case ROWNORM: {
                min = this.minExpression_rownorm_ds2;
                max = this.maxExpression_rownorm_ds2;
                if (min != 0.0 || max == 0.0) {
                    // empty if block
                }
                max = Math.max(Math.abs(min), max);
                break;
            }
            case LOGTRANSFORM: {
                if (this.minExpression_ds2 <= 0.0 && this.maxExpression_ds2 <= 0.0) {
                    min = 0.0;
                    max = 0.0;
                    break;
                }
                if (this.minExpression_ds2 <= 0.0) {
                    min = Math.min(Math.log(this.closestToZeroExpression_ds2), Math.log1p(this.maxExpression_ds2));
                    max = Math.max(Math.log(this.closestToZeroExpression_ds2), Math.log1p(this.maxExpression_ds2));
                    break;
                }
                if (this.maxExpression_ds2 <= 0.0) {
                    min = 0.0;
                    max = Math.log1p(this.minExpression_ds2);
                    break;
                }
                min = Math.log1p(this.minExpression_ds2);
                max = Math.log1p(this.maxExpression_ds2);
                max = Math.max(Math.abs(min), max);
                break;
            }
            default: {
                min = this.minExpression_ds2;
                max = Math.max(Math.abs(this.minExpression_ds2), this.maxExpression_ds2);
            }
        }
        double median = max / 2.0;
        if (min >= 0.0) {
            median = max / 2.0;
            this.range_ds2 = ColorGradientRange.getInstance(0.0, median, median, max, 0.0, median, median, max);
            this.theme_ds2 = ColorGradientTheme.GREEN_ONECOLOR_GRADIENT_THEME;
        } else {
            median = 0.0;
            this.range_ds2 = ColorGradientRange.getInstance(-max, 0.0, 0.0, max, -max, 0.0, 0.0, max);
            this.theme_ds2 = ColorGradientTheme.GREEN_MAGENTA_GRADIENT_THEME;
        }
    }

    public HeatMapPanel getEdgeOverlapPanel() {
        return this.edgeOverlapPanel;
    }

    public HeatMapPanel getNodeOverlapPanel() {
        return this.nodeOverlapPanel;
    }

    public ColorGradientRange getRange_ds1() {
        return this.range_ds1;
    }

    public void setRange_ds1(ColorGradientRange range) {
        this.range_ds1 = range;
    }

    public ColorGradientTheme getTheme_ds1() {
        return this.theme_ds1;
    }

    public void setTheme_ds1(ColorGradientTheme theme) {
        this.theme_ds1 = theme;
    }

    public ColorGradientRange getRange_ds2() {
        return this.range_ds2;
    }

    public void setRange_ds2(ColorGradientRange range) {
        this.range_ds2 = range;
    }

    public ColorGradientTheme getTheme_ds2() {
        return this.theme_ds2;
    }

    public void setTheme_ds2(ColorGradientTheme theme) {
        this.theme_ds2 = theme;
    }

    public Transformation getTransformation() {
        return this.transformation;
    }

    public void setTransformation(Transformation transformation) {
        this.transformation = transformation;
    }

    public Sort getSort() {
        return this.sort;
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    public boolean isSortbycolumn_event_triggered() {
        return this.sortbycolumn_event_triggered;
    }

    public void setSortbycolumn_event_triggered(boolean sortbycolumn_event_triggered) {
        this.sortbycolumn_event_triggered = sortbycolumn_event_triggered;
    }

    public String getSortbycolumnName() {
        return this.sortbycolumnName;
    }

    public void setSortbycolumnName(String sortbycolumnName) {
        this.sortbycolumnName = sortbycolumnName;
    }

    public String getRankFileIndex() {
        return this.rankFileIndex;
    }

    public void setRankFileIndex(String rankFileIndex) {
        this.rankFileIndex = rankFileIndex;
    }

    public boolean[] getAscending() {
        return this.ascending;
    }

    public void setAscending(boolean[] ascending) {
        this.ascending = ascending;
    }

    public boolean isAscending(int index) {
        if (index == -1) {
            return true;
        }
        return this.ascending[index];
    }

    public void flipAscending(int index) {
        this.ascending[index] = !this.ascending[index];
    }

    public void changeAscendingValue(int index) {
        if (index != -1) {
            this.ascending[index] = !this.ascending[index];
        }
    }

    public boolean isShowValues() {
        return this.showValues;
    }

    public void setShowValues(boolean showvalues) {
        this.showValues = showvalues;
    }

    public static enum Sort {
        RANK,
        COLUMN,
        CLUSTER,
        NONE,
        DEFAULT;

    }

    public static enum Transformation {
        ROWNORM,
        ASIS,
        LOGTRANSFORM;

    }
}

