/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.baderlab.csplugins.enrichmentmap.model.Rank;

public class Ranking {
    public static final String GSEARanking = "GSEARanking";
    public static final String RankingLOADED = "RankingLOADED";
    private HashMap<Integer, Rank> ranking = new HashMap();
    private HashMap<Integer, Integer> gene2rank = new HashMap();
    private HashMap<Integer, Integer> rank2gene = new HashMap();
    private Map<Integer, Double> gene2score = null;
    private double[] scores = null;
    private String filename;

    public HashMap<Integer, Rank> getRanking() {
        return this.ranking;
    }

    public void setRanking(HashMap<Integer, Rank> ranking) {
        this.ranking = ranking;
        for (Integer cur : ranking.keySet()) {
            this.gene2rank.put(cur, ranking.get(cur).getRank());
            this.rank2gene.put(ranking.get(cur).getRank(), cur);
        }
        this.invalidateLazyValues();
    }

    public HashMap<Integer, Integer> getGene2rank() {
        return this.gene2rank;
    }

    public void setGene2rank(HashMap<Integer, Integer> gene2rank) {
        this.gene2rank = gene2rank;
        if (this.rank2gene == null || this.rank2gene.isEmpty()) {
            for (Integer cur : gene2rank.keySet()) {
                this.rank2gene.put(gene2rank.get(cur), cur);
                this.ranking.put(cur, new Rank(cur.toString(), 0.0, gene2rank.get(cur)));
            }
        }
        this.invalidateLazyValues();
    }

    public HashMap<Integer, Integer> getRank2gene() {
        return this.rank2gene;
    }

    public void setRank2gene(HashMap<Integer, Integer> rank2gene) {
        this.rank2gene = rank2gene;
        if (this.gene2rank == null || this.gene2rank.isEmpty()) {
            for (Integer cur : rank2gene.keySet()) {
                this.gene2rank.put(rank2gene.get(cur), cur);
                this.ranking.put(rank2gene.get(cur), new Rank(rank2gene.get(cur).toString(), 0.0, cur));
            }
        }
        this.invalidateLazyValues();
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void addRank(Integer gene, Rank rank) {
        this.ranking.put(gene, rank);
        this.gene2rank.put(gene, rank.getRank());
        this.rank2gene.put(rank.getRank(), gene);
        this.invalidateLazyValues();
    }

    public int getMaxRank() {
        return Collections.max(this.rank2gene.keySet());
    }

    public String toString() {
        StringBuffer paramVariables = new StringBuffer();
        paramVariables.append(this.filename + "%fileName\t" + this.filename + "\n");
        return paramVariables.toString();
    }

    public Map<Integer, Double> getGene2Score() {
        if (this.gene2score == null) {
            this.gene2score = new HashMap<Integer, Double>();
            for (Map.Entry<Integer, Rank> entry : this.ranking.entrySet()) {
                this.gene2score.put(entry.getKey(), entry.getValue().getScore());
            }
        }
        return this.gene2score;
    }

    public double[] getScores() {
        if (this.scores == null) {
            Map<Integer, Double> gene2score = this.getGene2Score();
            this.scores = new double[gene2score.size()];
            int i = 0;
            for (Double score : gene2score.values()) {
                this.scores[i++] = score;
            }
        }
        return this.scores;
    }

    private void invalidateLazyValues() {
        this.gene2score = null;
        this.scores = null;
    }
}

