/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Scanner;
import org.baderlab.csplugins.enrichmentmap.model.DataSet;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentResult;
import org.baderlab.csplugins.enrichmentmap.model.GeneSet;
import org.baderlab.csplugins.enrichmentmap.model.GenericResult;
import org.baderlab.csplugins.enrichmentmap.model.SetOfEnrichmentResults;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class ParseDavidEnrichmentResults
extends AbstractTask {
    public static final Double DefaultScoreAtMax = -1000000.0;
    private DataSet dataset;
    private String EnrichmentResultFileName1;
    private String EnrichmentResultFileName2;
    private SetOfEnrichmentResults enrichments;
    private HashMap<String, EnrichmentResult> results;
    private String upPhenotype;
    private String downPhenotype;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;
    private StreamUtil streamUtil;

    public ParseDavidEnrichmentResults(DataSet dataset, StreamUtil streamUtil) {
        this.dataset = dataset;
        this.streamUtil = streamUtil;
        this.EnrichmentResultFileName1 = dataset.getEnrichments().getFilename1();
        this.EnrichmentResultFileName2 = dataset.getEnrichments().getFilename2();
        this.enrichments = dataset.getEnrichments();
        this.results = this.enrichments.getEnrichments();
        this.upPhenotype = this.enrichments.getPhenotype1();
        this.downPhenotype = this.enrichments.getPhenotype2();
    }

    public void parse() throws IOException {
        if (this.EnrichmentResultFileName1 != null && !this.EnrichmentResultFileName1.isEmpty()) {
            this.readFile(this.EnrichmentResultFileName1);
        }
        if (this.EnrichmentResultFileName2 != null && !this.EnrichmentResultFileName2.isEmpty()) {
            this.readFile(this.EnrichmentResultFileName2);
        }
    }

    public void readFile(String EnrichmentResultFileName) throws IOException {
        InputStream reader = this.streamUtil.getInputStream(EnrichmentResultFileName);
        String fullText = new Scanner(reader, "UTF-8").useDelimiter("\\A").next();
        String[] lines = fullText.split("\r\n?|\n");
        String header_line = lines[0];
        String[] tokens = header_line.split("\t");
        this.parseDavidFile(lines);
    }

    public void parseDavidFile(String[] lines) {
        HashMap<String, GeneSet> genesets = this.dataset.getSetofgenesets().getGenesets();
        HashMap<String, Integer> genes = this.dataset.getMap().getGenes();
        HashMap<Integer, String> key2gene = this.dataset.getMap().getHashkey2gene();
        int currentProgress = 0;
        int maxValue = lines.length;
        if (this.taskMonitor != null) {
            this.taskMonitor.setStatusMessage("Parsing Generic Results file - " + maxValue + " rows");
        }
        boolean FDR = true;
        String line = lines[0];
        String[] tokens = line.split("\t");
        int length = tokens.length;
        if (length != 13) {
            throw new IllegalThreadStateException("David results file is missing data.");
        }
        for (int i = 1; i < lines.length; ++i) {
            line = lines[i];
            tokens = line.split("\t");
            double pvalue = 1.0;
            double FDRqvalue = 1.0;
            int gs_size = 0;
            double NES = 1.0;
            String name = tokens[1].toUpperCase().trim();
            String description = tokens[0].toUpperCase();
            GeneSet gs = genesets.containsKey(name) ? genesets.get(name) : new GeneSet(name, description);
            String[] gene_tokens = tokens[5].split(", ");
            for (int j = 0; j < gene_tokens.length; ++j) {
                String gene = gene_tokens[j].toUpperCase();
                if (genes.containsKey(gene)) {
                    gs.addGene(genes.get(gene));
                    continue;
                }
                if (gene.equalsIgnoreCase("")) continue;
                int value = this.dataset.getMap().getNumberOfGenes();
                genes.put(gene, value);
                key2gene.put(value, gene);
                this.dataset.getMap().setNumberOfGenes(value + 1);
                gs.addGene(genes.get(gene));
            }
            genesets.put(name, gs);
            if (!tokens[4].equalsIgnoreCase("")) {
                pvalue = Double.parseDouble(tokens[4]);
            }
            if (!tokens[2].equalsIgnoreCase("")) {
                gs_size = Integer.parseInt(tokens[2]);
            }
            if (!tokens[11].equalsIgnoreCase("")) {
                FDRqvalue = Double.parseDouble(tokens[11]);
            }
            GenericResult result = new GenericResult(name, description, pvalue, gs_size, FDRqvalue);
            int percentComplete = (int)((double)currentProgress / (double)maxValue * 100.0);
            long timeRemaining = maxValue - currentProgress;
            if (this.taskMonitor != null) {
                this.taskMonitor.setProgress((double)percentComplete);
            }
            ++currentProgress;
            GenericResult temp = (GenericResult)this.results.get(name);
            if (temp == null) {
                this.results.put(name, result);
                continue;
            }
            if (!(result.getPvalue() < temp.getPvalue())) continue;
            this.results.put(name, result);
        }
        if (FDR) {
            this.dataset.getMap().getParams().setFDR(FDR);
        }
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Parsing Enrichment Result file");
    }

    public void run(TaskMonitor taskMonitor) throws Exception {
        this.taskMonitor = taskMonitor;
        this.taskMonitor.setTitle("Parsing David Enrichment Result file");
        this.parse();
    }
}

