/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.model;

import java.util.HashSet;
import java.util.Iterator;

public class GeneSet {
    private String Name;
    private String Description;
    private HashSet<Integer> genes = null;
    private String source = "none";

    public GeneSet(String name, String descrip) {
        this.Name = name;
        this.Description = descrip;
        this.genes = new HashSet();
        String[] name_tokens = name.split("%");
        if (name_tokens.length > 1) {
            this.source = name_tokens[1];
        }
    }

    public GeneSet(String[] tokens) {
        this(tokens[1], tokens[2]);
        if (tokens.length < 3) {
            return;
        }
        for (int i = 3; i < tokens.length; ++i) {
            this.genes.add(Integer.parseInt(tokens[i]));
        }
    }

    public boolean addGene(int gene_hashkey) {
        if (this.genes != null) {
            return this.genes.add(gene_hashkey);
        }
        return false;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        this.Name = name;
    }

    public String getDescription() {
        return this.Description;
    }

    public void setDescription(String description) {
        this.Description = description;
    }

    public HashSet<Integer> getGenes() {
        return this.genes;
    }

    public void setGenes(HashSet<Integer> genes) {
        this.genes = genes;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String type) {
        this.source = type;
    }

    public String toString() {
        StringBuffer geneset = new StringBuffer();
        geneset.append(this.Name + "\t" + this.Description + "\t");
        Iterator<Integer> i = this.genes.iterator();
        while (i.hasNext()) {
            geneset.append(((Object)i.next()).toString() + "\t");
        }
        return geneset.toString();
    }

    public boolean equals(GeneSet current) {
        return this.Name.equals(current.getName()) && this.source.equals(current.getSource()) && this.Description.equals(current.getDescription()) && this.genes.equals(current.getGenes());
    }
}

