/*
 * Decompiled with CFR 0.152.
 */
package org.mskcc.colorgradient;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.mskcc.colorgradient.ColorGradientRange;
import org.mskcc.colorgradient.ColorGradientTheme;

public class ColorGradientWidget
extends JComponent {
    private static final int POSITION_LEGEND_WIDTH = 15;
    private static final int HSPACER = 5;
    private static final int VSPACER = 3;
    private Image img;
    private String title;
    private String cookedTitle;
    private Dimension cookedTitleDimension;
    private int widgetWidth;
    private int widgetHeight;
    private Color borderColor;
    private final boolean variableWidth;
    private final boolean variableHeight;
    private final int verticalMargin;
    private final int horizontalMargin;
    private ColorGradientTheme colorGradientTheme;
    private ColorGradientRange colorGradientRange;
    private Rectangle minimumConditionGradientRectangle;
    private Rectangle centerConditionGradientRectangle;
    private Rectangle maximumConditionGradientRectangle;
    private final boolean isLegend;
    private final LEGEND_POSITION legendPosition;
    private final boolean renderPositionLegend;
    private Dimension minimumConditionValueDimension;
    private Dimension averageValueDimension;
    private Dimension maximumConditionValueDimension;
    private String minimumConditionValueString;
    private String averageValueString;
    private String maximumConditionValueString;
    private int maxStringHeight;
    private int gradientHeight;
    private int gradientWidth;
    private int positionLegendWidth;
    private int positionLegendHeight;

    public static ColorGradientWidget getInstance(String title, int widgetWidth, int widgetHeight, int hMargin, int vMargin, ColorGradientTheme colorGradientTheme, ColorGradientRange colorGradientRange, boolean isLegend, LEGEND_POSITION legendPosition) {
        return new ColorGradientWidget(title, widgetWidth, widgetHeight, hMargin, vMargin, colorGradientTheme, colorGradientRange, isLegend, legendPosition);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (width > 0 && height > 0) {
            this.widgetWidth = width;
            this.widgetHeight = height;
            this.img = new BufferedImage(width, height, 2);
        }
    }

    public ColorGradientTheme getColorGradientTheme() {
        return this.colorGradientTheme;
    }

    public ColorGradientRange getColorGradientRange() {
        return this.colorGradientRange;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.minimumConditionValueDimension != null) {
            int legendWidth = this.isLegend && this.legendPosition != LEGEND_POSITION.NA ? 20 : 0;
            int minWidth = this.horizontalMargin * 2 + legendWidth + (int)this.minimumConditionValueDimension.getWidth() + 5 + (int)this.averageValueDimension.getWidth() + 5 + (int)this.maximumConditionValueDimension.getWidth();
            return new Dimension(minWidth, this.variableHeight ? 0 : this.widgetHeight);
        }
        return new Dimension(this.variableWidth ? 0 : this.widgetWidth, this.variableHeight ? 0 : this.widgetHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void export(Graphics g, boolean renderStrings) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(Color.WHITE);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.renderComponent(g, renderStrings);
    }

    @Override
    public void paintComponent(Graphics g) {
        this.renderComponent(g, true);
    }

    public String getTitle() {
        return this.cookedTitle;
    }

    public List<String> getConditionValueStrings() {
        ArrayList<String> toReturn = new ArrayList<String>();
        toReturn.add(this.minimumConditionValueString);
        toReturn.add(this.averageValueString);
        toReturn.add(this.maximumConditionValueString);
        return toReturn;
    }

    private ColorGradientWidget(String title, int widgetWidth, int widgetHeight, int hMargin, int vMargin, ColorGradientTheme colorGradientTheme, ColorGradientRange colorGradientRange, boolean isLegend, LEGEND_POSITION legendPosition) {
        this.title = title;
        this.widgetHeight = widgetHeight;
        this.widgetWidth = widgetWidth;
        this.verticalMargin = vMargin;
        this.horizontalMargin = hMargin;
        this.borderColor = Color.BLACK;
        this.colorGradientTheme = colorGradientTheme;
        this.colorGradientRange = colorGradientRange;
        this.isLegend = isLegend;
        this.legendPosition = legendPosition;
        this.renderPositionLegend = legendPosition != LEGEND_POSITION.NA;
        this.variableWidth = widgetWidth == 0;
        boolean bl = this.variableHeight = widgetHeight == 0;
        if (!isLegend) {
            this.attachMouseListener();
        }
        this.setConditionValueStrings();
    }

    private void attachMouseListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ColorGradientWidget.this.borderColor = Color.GREEN;
                ColorGradientWidget.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ColorGradientWidget.this.borderColor = Color.BLACK;
                ColorGradientWidget.this.repaint();
            }
        });
    }

    private void setMaxStringHeight() {
        this.maxStringHeight = (int)Math.max(this.minimumConditionValueDimension.getHeight(), (double)((int)Math.max(this.averageValueDimension.getHeight(), this.maximumConditionValueDimension.getHeight())));
        this.maxStringHeight = (int)Math.max((double)this.maxStringHeight, this.cookedTitleDimension.getHeight());
    }

    private void setPositionLegendDimensions() {
        if (this.renderPositionLegend) {
            int width = this.variableWidth ? this.getSize().width : this.widgetWidth;
            width -= this.horizontalMargin * 2;
            this.positionLegendWidth = 20;
        } else {
            this.positionLegendWidth = 0;
        }
    }

    private void setCookedTitleString(Graphics2D g2d) {
        int width = this.variableWidth ? this.getSize().width : this.widgetWidth;
        width -= this.horizontalMargin * 2 + this.positionLegendWidth;
        FontMetrics fontMetrics = g2d.getFontMetrics();
        String tmpStr = "";
        for (int lc = 0; lc <= this.title.length(); ++lc) {
            tmpStr = this.title.substring(0, lc);
            if (fontMetrics.stringWidth(tmpStr) > width) {
                this.cookedTitle = tmpStr.substring(0, lc - 4);
                this.cookedTitle = this.cookedTitle + "...";
                break;
            }
            this.cookedTitle = tmpStr;
        }
    }

    private void setCookedTitleStringDimension(Graphics2D g2d) {
        FontMetrics fontMetrics = g2d.getFontMetrics();
        Rectangle2D rect = fontMetrics.getStringBounds(this.cookedTitle, g2d);
        this.cookedTitleDimension = new Dimension((int)rect.getWidth(), (int)rect.getHeight());
    }

    private void setConditionValueStrings() {
        DecimalFormat formatter = new DecimalFormat("#,###,###.##");
        this.minimumConditionValueString = formatter.format(this.colorGradientRange.getMinValue());
        this.averageValueString = formatter.format(this.colorGradientRange.getCenterLowValue() + (this.colorGradientRange.getCenterHighValue() - this.colorGradientRange.getCenterLowValue()) / 2.0);
        this.maximumConditionValueString = formatter.format(this.colorGradientRange.getMaxValue());
    }

    private void setConditionValueStringDimensions(Graphics2D g2d) {
        FontMetrics fontMetrics = g2d.getFontMetrics();
        Rectangle2D rect = fontMetrics.getStringBounds(this.minimumConditionValueString, g2d);
        this.minimumConditionValueDimension = new Dimension((int)rect.getWidth(), (int)rect.getHeight());
        rect = fontMetrics.getStringBounds(this.averageValueString, g2d);
        this.averageValueDimension = new Dimension((int)rect.getWidth(), (int)rect.getHeight());
        rect = fontMetrics.getStringBounds(this.maximumConditionValueString, g2d);
        this.maximumConditionValueDimension = new Dimension((int)rect.getWidth(), (int)rect.getHeight());
    }

    private void computeGradientRectangles() {
        this.widgetWidth = this.variableWidth ? this.getSize().width : this.widgetWidth;
        this.widgetHeight = this.variableHeight ? this.getSize().height : this.widgetHeight;
        this.gradientHeight = this.widgetHeight - this.verticalMargin * 2;
        this.gradientWidth = this.widgetWidth - this.horizontalMargin * 2;
        this.minimumConditionGradientRectangle = new Rectangle(this.horizontalMargin, this.verticalMargin, this.widgetWidth / 2 - this.horizontalMargin, this.gradientHeight);
        this.maximumConditionGradientRectangle = new Rectangle(this.widgetWidth / 2, this.verticalMargin, this.widgetWidth / 2 - this.horizontalMargin, this.gradientHeight);
    }

    private void computeLegendGradientRectangles() {
        this.widgetWidth = this.variableWidth ? this.getSize().width : this.widgetWidth;
        this.widgetHeight = this.variableHeight ? this.getSize().height : this.widgetHeight;
        this.gradientWidth = this.widgetWidth - this.horizontalMargin * 2 - this.positionLegendWidth;
        this.gradientHeight = this.widgetHeight - this.verticalMargin * 2 - this.maxStringHeight - 3;
        if (this.cookedTitle != null && this.cookedTitle.length() > 0) {
            this.gradientHeight -= this.maxStringHeight + 3;
        }
        int rectYPos = this.verticalMargin + 3;
        if (this.cookedTitle != null && this.cookedTitle.length() > 0) {
            rectYPos += this.maxStringHeight + 3;
        }
        double centerLowNormal = (this.colorGradientRange.getCenterLowValue() - this.colorGradientRange.getMinValue()) / (this.colorGradientRange.getMaxValue() - this.colorGradientRange.getMinValue());
        double centerHighNormal = (this.colorGradientRange.getCenterHighValue() - this.colorGradientRange.getMinValue()) / (this.colorGradientRange.getMaxValue() - this.colorGradientRange.getMinValue());
        int minRectXPos = this.horizontalMargin + this.positionLegendWidth;
        int minRectWidth = (int)(centerLowNormal * (double)this.gradientWidth);
        this.minimumConditionGradientRectangle = new Rectangle(minRectXPos, rectYPos, minRectWidth, this.gradientHeight);
        int centerRectXPos = minRectXPos + minRectWidth;
        int centerRectWidth = (int)(centerHighNormal * (double)this.gradientWidth - (double)minRectWidth);
        this.centerConditionGradientRectangle = new Rectangle(centerRectXPos, rectYPos, centerRectWidth, this.gradientHeight);
        int maxRectXPos = centerRectXPos + centerRectWidth;
        this.maximumConditionGradientRectangle = new Rectangle(maxRectXPos, rectYPos, this.gradientWidth - centerRectWidth - minRectWidth, this.gradientHeight);
    }

    private void renderComponent(Graphics g, boolean renderStrings) {
        if (this.img != null) {
            Graphics2D g2d = ((BufferedImage)this.img).createGraphics();
            this.clearImage(g2d);
            Font savedFont = g2d.getFont();
            g2d.setFont(new Font("Default", 1, 10));
            if (this.isLegend) {
                this.setPositionLegendDimensions();
                this.setCookedTitleString(g2d);
                this.setCookedTitleStringDimension(g2d);
                this.setConditionValueStringDimensions(g2d);
                this.setMaxStringHeight();
                this.computeLegendGradientRectangles();
                if (this.renderPositionLegend) {
                    this.renderPositionLegend(g2d);
                }
                this.renderLegendGradient(g2d);
                if (renderStrings) {
                    this.renderCookedTitleString(g2d);
                    this.renderConditionValueStrings(g2d);
                }
            } else {
                this.computeGradientRectangles();
                this.renderGradient(g2d);
            }
            g2d.setFont(savedFont);
            g.drawImage(this.img, 0, 0, null);
        }
    }

    private void renderPositionLegend(Graphics2D g2d) {
        int renderWidth;
        int renderHeight = renderWidth = this.positionLegendWidth - 5;
        int xPos = this.horizontalMargin;
        int gradientCenter = this.verticalMargin + 3;
        if (this.cookedTitle != null && this.cookedTitle.length() > 0) {
            gradientCenter += this.maxStringHeight + 3;
        }
        int yPos = (gradientCenter += this.gradientHeight / 2) - renderHeight / 2;
    }

    private void renderGradient(Graphics2D g2d) {
        GradientPaint gradientLow = new GradientPaint((float)this.minimumConditionGradientRectangle.getX(), (float)this.minimumConditionGradientRectangle.getY(), this.colorGradientTheme.getMinColor(), (float)this.maximumConditionGradientRectangle.getX(), (float)this.minimumConditionGradientRectangle.getY(), this.colorGradientTheme.getCenterColor());
        g2d.setPaint(gradientLow);
        g2d.fillRect((int)this.minimumConditionGradientRectangle.getX(), (int)this.minimumConditionGradientRectangle.getY(), (int)this.minimumConditionGradientRectangle.getWidth(), (int)this.minimumConditionGradientRectangle.getHeight());
        GradientPaint gradientHigh = new GradientPaint((float)this.maximumConditionGradientRectangle.getX(), (float)this.maximumConditionGradientRectangle.getY(), this.colorGradientTheme.getCenterColor(), (float)(this.maximumConditionGradientRectangle.getX() + this.maximumConditionGradientRectangle.getWidth()), (float)this.maximumConditionGradientRectangle.getY(), this.colorGradientTheme.getMaxColor());
        g2d.setPaint(gradientHigh);
        g2d.fillRect((int)this.maximumConditionGradientRectangle.getX(), (int)this.maximumConditionGradientRectangle.getY(), (int)this.maximumConditionGradientRectangle.getWidth(), (int)this.maximumConditionGradientRectangle.getHeight());
        Rectangle rect = new Rectangle(this.horizontalMargin, this.verticalMargin, this.gradientWidth - 1, this.gradientHeight - 1);
        g2d.setPaint(this.borderColor);
        g2d.draw(rect);
    }

    private void renderLegendGradient(Graphics2D g2d) {
        GradientPaint gradientLow = new GradientPaint((float)this.minimumConditionGradientRectangle.getX(), (float)this.minimumConditionGradientRectangle.getY(), this.colorGradientTheme.getMinColor(), (float)this.centerConditionGradientRectangle.getX(), (float)this.centerConditionGradientRectangle.getY(), this.colorGradientTheme.getCenterColor());
        g2d.setPaint(gradientLow);
        g2d.fillRect((int)this.minimumConditionGradientRectangle.getX(), (int)this.minimumConditionGradientRectangle.getY(), (int)this.minimumConditionGradientRectangle.getWidth(), (int)this.minimumConditionGradientRectangle.getHeight());
        g2d.setPaint(this.colorGradientTheme.getCenterColor());
        g2d.fillRect((int)this.centerConditionGradientRectangle.getX(), (int)this.centerConditionGradientRectangle.getY(), (int)this.centerConditionGradientRectangle.getWidth(), (int)this.centerConditionGradientRectangle.getHeight());
        GradientPaint gradientHigh = new GradientPaint((float)this.centerConditionGradientRectangle.getX(), (float)this.centerConditionGradientRectangle.getY(), this.colorGradientTheme.getCenterColor(), (float)(this.maximumConditionGradientRectangle.getX() + this.maximumConditionGradientRectangle.getWidth()), (float)this.maximumConditionGradientRectangle.getY(), this.colorGradientTheme.getMaxColor());
        g2d.setPaint(gradientHigh);
        g2d.fillRect((int)this.maximumConditionGradientRectangle.getX(), (int)this.maximumConditionGradientRectangle.getY(), (int)this.maximumConditionGradientRectangle.getWidth(), (int)this.maximumConditionGradientRectangle.getHeight());
        Rectangle rect = new Rectangle(this.horizontalMargin + this.positionLegendWidth, (int)this.minimumConditionGradientRectangle.getY(), this.gradientWidth - 1, this.gradientHeight - 1);
        g2d.setPaint(this.borderColor);
        g2d.draw(rect);
    }

    private void renderCookedTitleString(Graphics2D g2d) {
        g2d.setPaint(Color.BLACK);
        int startingPos = this.horizontalMargin + this.positionLegendWidth;
        int width = this.variableWidth ? this.getSize().width : this.widgetWidth;
        int xPos = startingPos + (width -= this.horizontalMargin * 2 + this.positionLegendWidth) / 2 - (int)this.cookedTitleDimension.getWidth() / 2;
        int yPos = this.verticalMargin + this.maxStringHeight;
        g2d.drawString(this.cookedTitle, xPos, yPos);
    }

    private void renderConditionValueStrings(Graphics2D g2d) {
        g2d.setPaint(Color.BLACK);
        int yPos = this.verticalMargin + 3 + this.gradientHeight + this.maxStringHeight;
        if (this.cookedTitle != null && this.cookedTitle.length() > 0) {
            yPos += 3 + this.maxStringHeight;
        }
        g2d.drawString(this.minimumConditionValueString, this.horizontalMargin + this.positionLegendWidth, yPos);
        g2d.drawString(this.averageValueString, this.horizontalMargin + this.positionLegendWidth + this.gradientWidth / 2 - (int)this.averageValueDimension.getWidth() / 2, yPos);
        g2d.drawString(this.maximumConditionValueString, this.widgetWidth - this.horizontalMargin - (int)this.maximumConditionValueDimension.getWidth(), yPos);
    }

    private void clearImage(Graphics2D image2D) {
        Composite origComposite = image2D.getComposite();
        image2D.setComposite(AlphaComposite.getInstance(2));
        image2D.setPaint(this.getBackground());
        image2D.fillRect(0, 0, this.img.getWidth(null), this.img.getHeight(null));
        image2D.setComposite(origComposite);
    }

    public static enum LEGEND_POSITION {
        TOP("Top"),
        RIGHT("Right"),
        BOTTOM("Bottom"),
        LEFT("Left"),
        NA("NA");

        private String type;

        private LEGEND_POSITION(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

