/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.autoannotate.task.cluster;

import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationManager;
import org.baderlab.csplugins.enrichmentmap.autoannotate.AutoAnnotationParameters;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.AnnotationSet;
import org.baderlab.csplugins.enrichmentmap.autoannotate.model.Cluster;
import org.baderlab.csplugins.enrichmentmap.autoannotate.task.cluster.UpdateClusterLabelTask;
import org.cytoscape.model.CyTable;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;

public class ComputeClusterLabelsTask
extends AbstractTask {
    private AnnotationSet annotationSet;
    private AutoAnnotationParameters params;

    public ComputeClusterLabelsTask(AnnotationSet annotationSet, AutoAnnotationParameters params) {
        this.annotationSet = annotationSet;
        this.params = params;
    }

    public void run(TaskMonitor arg0) throws Exception {
        Long clusterTableSUID = (Long)this.params.getNetwork().getDefaultNetworkTable().getRow((Object)this.params.getNetwork().getSUID()).get(this.params.getName(), Long.class);
        CyTable clusterSetTable = AutoAnnotationManager.getInstance().getTableManager().getTable(clusterTableSUID.longValue());
        TaskIterator currentTasks = new TaskIterator(new Task[0]);
        for (Cluster cluster : this.annotationSet.getClusterMap().values()) {
            currentTasks.append((Task)new UpdateClusterLabelTask(cluster, clusterSetTable));
        }
        AutoAnnotationManager.getInstance().getDialogTaskManager().execute(currentTasks);
    }
}

