/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.JOptionPane;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.PostAnalysisParameters;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.task.BuildDiseaseSignatureTask;
import org.baderlab.csplugins.enrichmentmap.task.BuildDiseaseSignatureTaskResult;
import org.baderlab.csplugins.enrichmentmap.view.PostAnalysisInputPanel;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.io.util.StreamUtil;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.session.CySessionManager;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskObserver;
import org.cytoscape.work.swing.DialogTaskManager;

public class BuildPostAnalysisActionListener
implements ActionListener {
    private PostAnalysisInputPanel inputPanel;
    private CyApplicationManager applicationManager;
    private CySwingApplication swingApplication;
    private CySessionManager sessionManager;
    private StreamUtil streamUtil;
    private DialogTaskManager dialog;
    private CyEventHelper eventHelper;

    public BuildPostAnalysisActionListener(PostAnalysisInputPanel panel, CySessionManager sessionManager, StreamUtil streamUtil, CySwingApplication swingApplication, CyApplicationManager applicationManager, DialogTaskManager dialog, CyEventHelper eventHelper) {
        this.inputPanel = panel;
        this.sessionManager = sessionManager;
        this.streamUtil = streamUtil;
        this.applicationManager = applicationManager;
        this.swingApplication = swingApplication;
        this.dialog = dialog;
        this.eventHelper = eventHelper;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        PostAnalysisParameters paParams = this.inputPanel.getPaParams();
        EnrichmentMap current_map = EnrichmentMapManager.getInstance().getMap(this.applicationManager.getCurrentNetwork().getSUID());
        if (current_map != null) {
            paParams.setAttributePrefix(current_map.getParams().getAttributePrefix());
        }
        String errors = paParams.checkMinimalRequirements();
        TaskIterator currentTasks = new TaskIterator(new Task[0]);
        if (errors.isEmpty()) {
            if (paParams.isSignatureDiscovery() || paParams.isKnownSignature()) {
                BuildDiseaseSignatureTask new_signature = new BuildDiseaseSignatureTask(current_map, paParams, this.sessionManager, this.streamUtil, this.applicationManager, this.eventHelper, this.swingApplication);
                currentTasks.append((Task)new_signature);
                DialogObserver dialogObserver = new DialogObserver();
                this.dialog.execute(currentTasks, (TaskObserver)dialogObserver);
            } else {
                JOptionPane.showMessageDialog(this.inputPanel, errors, "No such Post-Analysis", 2);
            }
        } else {
            JOptionPane.showMessageDialog(this.inputPanel, errors, "Invalid Input", 2);
        }
    }

    private class DialogObserver
    implements TaskObserver {
        private BuildDiseaseSignatureTaskResult result;

        private DialogObserver() {
        }

        public void taskFinished(ObservableTask task) {
            if (task instanceof BuildDiseaseSignatureTask) {
                this.result = (BuildDiseaseSignatureTaskResult)task.getResults(BuildDiseaseSignatureTaskResult.class);
            }
        }

        public void allFinished(FinishStatus status) {
            if (this.result == null || this.result.isCancelled()) {
                return;
            }
            if (this.result.getPassedCutoffCount() == 0) {
                JOptionPane.showMessageDialog(BuildPostAnalysisActionListener.this.swingApplication.getJFrame(), "No edges were found passing the cutoff value for the signature set(s)", "Post Analysis", 2);
            }
            if (!this.result.getExistingEdgesFailingCutoff().isEmpty()) {
                Object[] options = new String[]{"Delete Edges From Previous Run", "Keep All Edges"};
                int dialogResult = JOptionPane.showOptionDialog(BuildPostAnalysisActionListener.this.swingApplication.getJFrame(), "There are edges from a previous run of post-analysis that do not pass the current cutoff value.\nKeep these edges or delete them?", "Existing post-analysis edges", 0, 3, null, options, options[1]);
                if (dialogResult == 0) {
                    Set<CyEdge> edgesToDelete = this.result.getExistingEdgesFailingCutoff();
                    CyNetwork network = this.result.getNetwork();
                    network.removeEdges(edgesToDelete);
                    this.result.getNetworkView().updateView();
                }
            }
            if (this.result.isWarnUserBypassStyle()) {
                JOptionPane.showMessageDialog(BuildPostAnalysisActionListener.this.swingApplication.getJFrame(), "The graph was created with an older version of EnrichmentMap.\nThe Visual Properties used for Post Analysis nodes and edges have been set to bypass.\n\nIf you would like your visual style to be upgraded so that it does not use bypass then \nplease rebuild your Enrichment Map graph and then re-run Post Analysis.", "Visual Property Bypass Used", 2);
            }
        }
    }
}

